/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class CountedBufferedReader
extends BufferedReader {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private long position;
    private Reader stream;
    private char[] buffer;
    private int buffPos;
    private int buffFill;
    private boolean reachedEOF = false;
    private int mark = -1;
    private int markLimit = -1;

    public long getFilePointer() {
        return this.position;
    }

    public CountedBufferedReader(Reader stream) {
        super(new Reader(){

            public void close() {
            }

            public int read(char[] cbuf, int off, int len) {
                return 0;
            }
        });
        this.stream = stream;
        this.buffer = new char[16384];
        this.position = 0L;
        this.buffPos = 0;
        this.buffFill = 0;
    }

    public void close() throws IOException {
        this.stream.close();
        this.stream = null;
    }

    public int read() throws IOException {
        if (this.buffPos >= this.buffFill) {
            this.fillBuffer();
        }
        if (this.reachedEOF) {
            return -1;
        }
        ++this.position;
        return this.buffer[this.buffPos++];
    }

    private int peek() throws IOException {
        if (this.buffPos >= this.buffFill) {
            this.fillBuffer();
        }
        if (this.reachedEOF) {
            return -1;
        }
        return this.buffer[this.buffPos];
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.buffPos >= this.buffFill) {
            this.fillBuffer();
        }
        if (this.reachedEOF) {
            return -1;
        }
        int toReturn = Math.min(len, this.buffFill - this.buffPos);
        System.arraycopy(this.buffer, this.buffPos, cbuf, off, toReturn);
        this.buffPos += toReturn;
        this.position += (long)toReturn;
        return toReturn;
    }

    public boolean ready() throws IOException {
        if (this.buffPos < this.buffFill) {
            return true;
        }
        return this.stream.ready();
    }

    public long skip(long n) throws IOException {
        int skipInBuffer = n < (long)this.buffer.length ? Math.min((int)n, this.buffFill - this.buffPos) : this.buffFill - this.buffPos;
        this.position += (long)skipInBuffer;
        this.buffPos += skipInBuffer;
        if (n > (long)skipInBuffer) {
            long skippedInStream;
            if (this.mark >= 0) {
                char[] dummy = new char[(int)(n - (long)skipInBuffer)];
                skippedInStream = this.read(dummy);
            } else {
                skippedInStream = this.stream.skip(n - (long)skipInBuffer);
            }
            this.position += skippedInStream;
            return skippedInStream + (long)skipInBuffer;
        }
        return skipInBuffer;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int limit) throws IOException {
        if (limit + 1 > this.buffer.length) {
            char[] newBuffer = new char[limit + 1];
            System.arraycopy(this.buffer, this.buffPos, newBuffer, 0, this.buffFill - this.buffPos);
            this.buffer = newBuffer;
            this.buffFill -= this.buffPos;
            this.buffPos = 0;
        } else if (this.buffPos + limit > this.buffer.length) {
            System.arraycopy(this.buffer, this.buffPos, this.buffer, 0, this.buffFill - this.buffPos);
            this.buffFill -= this.buffPos;
            this.buffPos = 0;
        }
        this.mark = this.buffPos;
        this.markLimit = limit;
    }

    public void reset() throws IOException {
        if (this.mark < 0) {
            throw new IOException("The mark is not currently in scope");
        }
        this.position = this.position - (long)this.buffPos + (long)this.mark;
        this.buffPos = this.mark;
    }

    public String readLine() throws IOException {
        String line = null;
        while (!this.reachedEOF) {
            for (int i = this.buffPos; i < this.buffFill; ++i) {
                char c = this.buffer[i];
                if (c != '\n' && c != '\r') continue;
                int len = i - this.buffPos;
                String bit = new String(this.buffer, this.buffPos, len);
                this.position += (long)len;
                line = line == null ? bit : line + bit;
                this.buffPos = i;
                this.read();
                char d = (char)this.peek();
                if (c == '\r' && d == '\n') {
                    this.read();
                }
                return line;
            }
            int len = this.buffFill - this.buffPos;
            String bit = new String(this.buffer, this.buffPos, len);
            this.position += (long)len;
            this.buffPos = this.buffFill;
            line = line == null ? bit : line + bit;
            this.fillBuffer();
        }
        return line;
    }

    private void fillBuffer() throws IOException {
        if (this.mark < 0) {
            this.buffFill = this.stream.read(this.buffer);
            if (this.buffFill == -1) {
                this.buffFill = 0;
                this.reachedEOF = true;
            }
            this.buffPos = 0;
        } else {
            if (this.buffPos >= this.markLimit + this.mark) {
                this.mark = -1;
                this.markLimit = -1;
                this.fillBuffer();
                return;
            }
            System.arraycopy(this.buffer, this.mark, this.buffer, 0, this.buffFill - this.mark);
            this.buffFill -= this.mark;
            this.mark = 0;
            this.buffPos = this.buffFill;
            int newChars = this.stream.read(this.buffer, this.buffFill, this.buffer.length - this.buffFill);
            if (newChars == -1) {
                this.reachedEOF = true;
            } else {
                this.buffFill += newChars;
            }
        }
    }
}

