/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.integration;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.integration.BulirschStoerIntegrator;
import de.jtem.numericalMethods.calculus.integration.ExtrapIntegrator;
import de.jtem.numericalMethods.calculus.integration.RungeKuttaFehlbergIntegrator;

public class ExampleIntegration {
    public static void main(String[] stringArray) {
        double d;
        RealFunctionOfOneVariable realFunctionOfOneVariable = new RealFunctionOfOneVariable(){

            public double eval(double d) {
                return Math.sin(d);
            }
        };
        System.out.println("integrating f(t) = sin(t) on interval [0,PI]; result is 2");
        for (int i = 3; i < 15; ++i) {
            double d2 = Math.pow(10.0, -i);
            System.out.println("setting accuracy to " + d2);
            d = ExtrapIntegrator.integrate(realFunctionOfOneVariable, 0.0, Math.PI, d2);
            double d3 = BulirschStoerIntegrator.integrate(realFunctionOfOneVariable, 0.0, Math.PI, d2);
            double d4 = RungeKuttaFehlbergIntegrator.integrate(realFunctionOfOneVariable, 0.0, Math.PI, d2);
            System.out.println("result of Extrap:             " + d);
            System.out.println("result of BulirschStoer:      " + d3);
            System.out.println("result of RungeKuttaFehlberg: " + d4);
            System.out.println("___");
        }
        RealVectorValuedFunctionOfOneVariable realVectorValuedFunctionOfOneVariable = new RealVectorValuedFunctionOfOneVariable(){

            public int getDimensionOfTargetSpace() {
                return 2;
            }

            public void eval(double d, double[] dArray) {
                dArray[0] = Math.sin(d);
                dArray[1] = Math.cos(d);
            }
        };
        System.out.println("integrating g(t) = (sin(t),cos(t) on interval [0,PI]; result is (2,0)");
        double[][] dArray = new double[3][2];
        for (int i = 3; i < 15; ++i) {
            d = Math.pow(10.0, -i);
            System.out.println("setting accuracy to " + d);
            ExtrapIntegrator.integrate(dArray[0], realVectorValuedFunctionOfOneVariable, 0.0, Math.PI, d);
            BulirschStoerIntegrator.integrate(realVectorValuedFunctionOfOneVariable, 0.0, Math.PI, dArray[1], d);
            RungeKuttaFehlbergIntegrator.integrate(realVectorValuedFunctionOfOneVariable, 0.0, Math.PI, dArray[2], d);
            System.out.println("result of Extrap:             ( " + dArray[0][0] + " , " + dArray[0][1] + " ) ");
            System.out.println("result of BulirschStoer:      ( " + dArray[1][0] + " , " + dArray[1][1] + " ) ");
            System.out.println("result of RungeKuttaFehlberg: ( " + dArray[2][0] + " , " + dArray[2][1] + " ) ");
            System.out.println("___");
        }
    }
}

