/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.polynomial;

import de.jtem.numericalMethods.algebra.polynomial.ComplexPolynomial;

public final class ComplexLaurentPolynomial {
    private static final double EPS = 1.0E-14;

    public static void eval(double[] dArray, double[] dArray2, int n, int n2, double d, double d2, double[] dArray3) {
        ComplexPolynomial.eval(dArray, dArray2, -n, n2, d, d2, dArray3);
        if (n >= 0) {
            return;
        }
        double d3 = d / (d * d + d2 * d2);
        double d4 = -d2 / (d * d + d2 * d2);
        double d5 = dArray[0];
        double d6 = dArray2[0];
        int n3 = n + 1;
        if (n < -1) {
            int n4 = 1;
            while (n3 < 0 && n3 <= n2) {
                double d7 = d5;
                double d8 = d6;
                d5 = d7 * d3 - d8 * d4 + dArray[n4];
                d6 = d7 * d4 + d8 * d3 + dArray2[n4];
                ++n3;
                ++n4;
            }
        }
        while (n3 <= 0) {
            double d9 = d5;
            double d10 = d6;
            d5 = d9 * d3 - d10 * d4;
            d6 = d9 * d4 + d10 * d3;
            ++n3;
        }
        dArray3[0] = dArray3[0] + d5;
        dArray3[1] = dArray3[1] + d6;
    }

    public static void evalDerivative(double[] dArray, double[] dArray2, int n, int n2, int n3, double d, double d2, double[] dArray3) {
        ComplexPolynomial.evalDerivative(dArray, dArray2, -n, n2, n3, d, d2, dArray3);
        if (n >= 0) {
            return;
        }
        double d3 = d / (d * d + d2 * d2);
        double d4 = -d2 / (d * d + d2 * d2);
        double d5 = 1.0;
        int n4 = 0;
        int n5 = n;
        while (n4 < n3) {
            d5 *= (double)n5;
            ++n4;
            --n5;
        }
        double d6 = d5 * dArray[0];
        double d7 = d5 * dArray2[0];
        int n6 = n + 1;
        if (n < -1) {
            int n7 = 1;
            while (n6 < 0 && n6 <= n2) {
                d5 /= (double)(n6 - n3);
                double d8 = d6;
                double d9 = d7;
                d6 = d8 * d3 - d9 * d4 + (d5 *= (double)n6) * dArray[n7];
                d7 = d8 * d4 + d9 * d3 + d5 * dArray2[n7];
                ++n6;
                ++n7;
            }
        }
        while (n6 <= n3) {
            double d10 = d6;
            double d11 = d7;
            d6 = d10 * d3 - d11 * d4;
            d7 = d10 * d4 + d11 * d3;
            ++n6;
        }
        dArray3[0] = dArray3[0] + d6;
        dArray3[1] = dArray3[1] + d7;
    }

    public static void derivative(double[] dArray, double[] dArray2, int n, int n2, int n3, double[] dArray3, double[] dArray4) {
        int n4;
        int n5;
        double d;
        if (n < 0) {
            d = 1.0;
            n5 = 0;
            n4 = n;
            while (n5 < n3) {
                d *= (double)n4;
                ++n5;
                --n4;
            }
            dArray3[0] = dArray[0] * d;
            dArray4[0] = dArray2[0] * d;
            n5 = 1;
            n4 = n + 1;
            while (n4 < 0 && n4 <= n2) {
                d *= (double)n4;
                dArray3[n5] = dArray[n5] * (d /= (double)(n4 - n3));
                dArray4[n5] = dArray2[n5] * d;
                ++n4;
                ++n5;
            }
            while (n5 < n3 - n && n5 < n2 - n) {
                dArray3[n5] = 0.0;
                dArray4[n5] = 0.0;
                ++n5;
            }
        }
        if (n2 >= n3) {
            d = 1.0;
            for (n5 = n2; n5 > n2 - n3; --n5) {
                d *= (double)n5;
            }
            n5 = n2 - n;
            dArray3[n5] = dArray[n5] * d;
            dArray4[n5] = dArray2[n5] * d;
            --n5;
            for (n4 = n2 - 1; n4 >= n3 && n5 >= 0; --n4, --n5) {
                d *= (double)(n4 + 1 - n3);
                dArray3[n5] = dArray[n5] * (d /= (double)(n4 + 1));
                dArray4[n5] = dArray2[n5] * d;
            }
        }
    }

    public static String toString(double[] dArray, double[] dArray2, int n, int n2) {
        return ComplexLaurentPolynomial.toString(dArray, dArray2, 0, n2, 1.0E-14);
    }

    public static String toString(double[] dArray, double[] dArray2, int n, int n2, double d) {
        return ComplexPolynomial.toString(dArray, dArray2, n, n2, d);
    }
}

