/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results.savers;

import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.results.DataSetResult;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DataSetResultSaver
implements ResultSaver<DataSetResult> {
    public static void register() {
        ResultSaverLibrary.register(DataSetResult.class, new DataSetResultSaver());
    }

    private DataSetResultSaver() {
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public String[] getFileExtensions(DataSetResult result) {
        return new String[]{"fa"};
    }

    @Override
    public boolean writeOutput(DataSetResult result, File path) {
        try {
            FileOutputStream fos = new FileOutputStream(path);
            if (result.getParser() == null) {
                result.getValue().save(fos, '>', new SplitSequenceAnnotationParser(":", ";"));
            } else {
                result.getValue().save(fos, '>', result.getParser());
            }
            fos.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean writeOutput(DataSetResult result, StringBuffer buf) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (result.getParser() == null) {
                result.getValue().save(baos, '>', new SplitSequenceAnnotationParser(":", ";"));
            } else {
                result.getValue().save(baos, '>', result.getParser());
            }
            buf.append(baos.toString());
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

