/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery.history;

import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.history.History;

public class CappedHistory
implements History {
    private int threshold;
    private int number;
    private History h;

    public CappedHistory(int t, History h) throws CloneNotSupportedException {
        if (t < 0) {
            throw new IllegalArgumentException("The threshold has to be non-negative.");
        }
        this.threshold = t;
        this.h = h.clone();
        this.clear();
    }

    public CappedHistory(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getXMLTag());
        this.threshold = (Integer)XMLParser.extractObjectForTags(xml, "threshold");
        this.number = (Integer)XMLParser.extractObjectForTags(xml, "number");
        this.h = (History)XMLParser.extractObjectForTags(xml, "history");
    }

    private String getXMLTag() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.threshold, "threshold");
        XMLParser.appendObjectWithTags(xml, this.number, "number");
        XMLParser.appendObjectWithTags(xml, this.h, "history");
        XMLParser.addTags(xml, this.getXMLTag());
        return xml;
    }

    @Override
    public CappedHistory clone() throws CloneNotSupportedException {
        CappedHistory clone = (CappedHistory)super.clone();
        clone.h = this.h.clone();
        return clone;
    }

    @Override
    public void clear() {
        this.number = 0;
        this.h.clear();
    }

    @Override
    public boolean operationAllowed(int ... op) {
        if (this.number < this.threshold) {
            return this.h.operationAllowed(op);
        }
        return false;
    }

    @Override
    public void operationPerfomed(int ... op) {
        ++this.number;
        if (this.number <= this.threshold) {
            this.h.operationPerfomed(op);
        }
    }
}

