/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.ToolBox;

public abstract class AbstractTwoClassPerformanceMeasure
extends AbstractPerformanceMeasure {
    protected AbstractTwoClassPerformanceMeasure() {
    }

    protected AbstractTwoClassPerformanceMeasure(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public ResultSet compute(double[][][] classSpecificScores, double[][] weights) {
        if (classSpecificScores.length != 2) {
            throw new RuntimeException("Only two classes possible for " + this.getName());
        }
        double[][] classificationScores = new double[2][];
        int i = 0;
        while (i < classSpecificScores.length) {
            classificationScores[i] = new double[classSpecificScores[i].length];
            int j = 0;
            while (j < classSpecificScores[i].length) {
                if (classSpecificScores[i][j].length != 2) {
                    throw new RuntimeException("Only two classes possible for " + this.getName());
                }
                classificationScores[i][j] = classSpecificScores[i][j][0] - classSpecificScores[i][j][1];
                ++j;
            }
            ToolBox.sortAlongWith(classificationScores[i], new double[][]{weights == null ? null : weights[i]});
            ++i;
        }
        if (weights != null) {
            return this.compute(classificationScores[0], weights[0], classificationScores[1], weights[1]);
        }
        return this.compute(classificationScores[0], null, classificationScores[1], null);
    }

    @Override
    public final int getAllowedNumberOfClasses() {
        return 2;
    }
}

