/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.assessment;

import de.jstacs.DataType;
import de.jstacs.classifiers.assessment.ClassifierAssessmentAssessParameterSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class RepeatedSubSamplingAssessParameterSet
extends ClassifierAssessmentAssessParameterSet {
    public RepeatedSubSamplingAssessParameterSet() throws UnsupportedOperationException, CloneNotSupportedException, SimpleParameter.IllegalValueException {
        this.addParameters();
    }

    public RepeatedSubSamplingAssessParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public RepeatedSubSamplingAssessParameterSet(int elementLength, boolean exceptionIfMPNotComputable, int repeats, double[] trainNumbers, double[] testNumbers) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
        super(elementLength, exceptionIfMPNotComputable);
        this.addParameters();
        ((Parameter)this.parameters.get("repeats")).setValue(repeats);
        ParameterSet[] tempPSA = new ParameterSet[trainNumbers.length];
        int i = 0;
        while (i < tempPSA.length) {
            tempPSA[i] = this.getParameterSetContainingASingleDoubleValue(trainNumbers[i++], "training");
        }
        ((ExpandableParameterSet)((ParameterSetContainer)this.parameters.get("trainDataNumbers")).getValue()).replaceContentWith(tempPSA);
        ParameterSet[] tempPSA2 = new ParameterSet[testNumbers.length];
        int i2 = 0;
        while (i2 < tempPSA2.length) {
            tempPSA2[i2] = this.getParameterSetContainingASingleDoubleValue(testNumbers[i2++], "testing");
        }
        ((ExpandableParameterSet)((ParameterSetContainer)this.parameters.get("testDataNumbers")).getValue()).replaceContentWith(tempPSA2);
    }

    private ParameterSet getParameterSetContainingASingleDoubleValue(double num, String train_test) throws SimpleParameter.IllegalValueException {
        SimpleParameterSet ret;
        try {
            ret = new SimpleParameterSet(new SimpleParameter(DataType.DOUBLE, "number", "Defines a number of elements of data used as " + train_test + " items (class-specific) during a SubSamplingAssessment", true, new NumberValidator<Double>(0.0, (Double)Double.MAX_VALUE)));
        }
        catch (SimpleParameter.DatatypeNotValidException doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
        ret.getParameterAt(0).setValue(num);
        return ret;
    }

    private void addParameters() throws CloneNotSupportedException, SimpleParameter.IllegalValueException {
        try {
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "repeats", "Determines how often the procedure of train/test classifers with random created train- and test-data should be repeated.", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE))});
        }
        catch (SimpleParameter.DatatypeNotValidException doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
        this.parameters.add(new Parameter[]{new ParameterSetContainer("trainDataNumbers", "A RepeatedSubSamplingExperiment subsamples the used train- and test-datasets from the given data (for each class) in each iteration. This ParameterSetcontainer contains an ExpandableParameterSet that contains for each class the number of the items (for each class), that should be subsampled and used as training-data.", new ExpandableParameterSet(this.getParameterSetContainingASingleDoubleValue(1.0, "training"), "number", "At pos i in this Expandable ParameterSet defines the number of subsampled items, that should be used as train-data for class i in a RepeatedSubSamplingExperiment."))});
        this.parameters.add(new Parameter[]{new ParameterSetContainer("testDataNumbers", "A RepeatedSubSamplingExperiment subsamples the used train and test datasets from the given data (for each class) in each iteration. This ParameterSetcontainer contains an ExpandableParameterSet that contains for each class the number of the items (for each class), that should be subsampled and used as test-data.", new ExpandableParameterSet(this.getParameterSetContainingASingleDoubleValue(1.0, "testing"), "number", "At pos i in this Expandable ParameterSet defines the number of subsampled items, that should be used as test-data for class i in a RepeatedSubSamplingExperiment."))});
    }

    public int getRepeats() {
        return (Integer)this.getParameterForName("repeats").getValue();
    }

    public double[] getTrain_TestNumbers(boolean train_case) {
        String pos = train_case ? "trainDataNumbers" : "testDataNumbers";
        ExpandableParameterSet tempEPS = (ExpandableParameterSet)this.getParameterForName(pos).getValue();
        double[] ret = new double[tempEPS.getNumberOfParameters()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (Double)((ParameterSet)tempEPS.getParameterAt(i).getValue()).getParameterAt(0).getValue();
            ++i;
        }
        return ret;
    }

    @Override
    public Collection<Result> getAnnotation() {
        ArrayList<Result> l = new ArrayList<Result>(3);
        l.add(new NumericalResult("repeats", "The number of iterations", this.getRepeats()));
        l.add(new CategoricalResult("number of elements for train", "The number of the items (for each class), that was subsampled and used as training-data.", Arrays.toString(this.getTrain_TestNumbers(true))));
        l.add(new CategoricalResult("number of elements for assessment", "The number of the items (for each class), that should be subsampled and used as assessment-data.", Arrays.toString(this.getTrain_TestNumbers(false))));
        return l;
    }
}

