/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.alignment.cost;

import de.jstacs.algorithms.alignment.cost.Costs;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;

public class MatrixCosts
implements Costs {
    private double[][] matrix;
    private double gap;

    public MatrixCosts(double[][] matrix, double gap) throws CloneNotSupportedException {
        this.matrix = (double[][])ArrayHandler.clone((Cloneable[])matrix);
        this.gap = gap;
    }

    public MatrixCosts(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "MatrixCosts");
        this.matrix = (double[][])XMLParser.extractObjectForTags(xml, "matrix");
        this.gap = (Double)XMLParser.extractObjectForTags(xml, "gap");
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.matrix, "matrix");
        XMLParser.appendObjectWithTags(xml, this.gap, "gap");
        XMLParser.addTags(xml, "MatrixCosts");
        return xml;
    }

    @Override
    public double getCostFor(Sequence s1, Sequence s2, int i, int j) {
        return this.matrix[s1.discreteVal(i - 1)][s2.discreteVal(j - 1)];
    }

    @Override
    public double getGapCosts() {
        return this.gap;
    }
}

