/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import umontreal.iro.lecuyer.util.ArithmeticMod;

public class Num {
    protected static final double XBIG = 40.0;
    private static final double SQPI_2 = 0.886226925452758;
    private static final double LOG_SQPI_2 = -0.1207822376352453;
    private static final double LOG4 = 1.3862943611198906;
    private static final double LOG_PI = 1.1447298858494002;
    public static final double DBL_EPSILON = 2.220446049250313E-16;
    public static final int DBL_MAX_EXP = 1024;
    public static final int DBL_MIN_EXP = -1021;
    public static final int DBL_MAX_10_EXP = 308;
    public static final double DBL_MIN = Double.MIN_NORMAL;
    public static final double LN_DBL_MIN = -708.3964185322641;
    public static final int DBL_DIG = 15;
    public static final double EBASE = Math.E;
    public static final double EULER = 0.5772156649015329;
    public static final double RAC2 = 1.4142135623730951;
    public static final double IRAC2 = 0.7071067811865476;
    public static final double LN2 = 0.6931471805599453;
    public static final double ILN2 = 1.4426950408889634;
    public static final double MAXINTDOUBLE = 9.007199254740992E15;
    public static final double MAXTWOEXP = 64.0;
    public static final double[] TWOEXP = new double[]{1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0, 256.0, 512.0, 1024.0, 2048.0, 4096.0, 8192.0, 16384.0, 32768.0, 65536.0, 131072.0, 262144.0, 524288.0, 1048576.0, 2097152.0, 4194304.0, 8388608.0, 1.6777216E7, 3.3554432E7, 6.7108864E7, 1.34217728E8, 2.68435456E8, 5.36870912E8, 1.073741824E9, 2.147483648E9, 4.294967296E9, 8.589934592E9, 1.7179869184E10, 3.4359738368E10, 6.8719476736E10, 1.37438953472E11, 2.74877906944E11, 5.49755813888E11, 1.099511627776E12, 2.199023255552E12, 4.398046511104E12, 8.796093022208E12, 1.7592186044416E13, 3.5184372088832E13, 7.0368744177664E13, 1.40737488355328E14, 2.81474976710656E14, 5.62949953421312E14, 1.125899906842624E15, 2.251799813685248E15, 4.503599627370496E15, 9.007199254740992E15, 1.8014398509481984E16, 3.602879701896397E16, 7.205759403792794E16, 1.4411518807585587E17, 2.8823037615171174E17, 5.764607523034235E17, 1.152921504606847E18, 2.305843009213694E18, 4.611686018427388E18, 9.223372036854776E18, 1.8446744073709552E19};
    public static final double[] TEN_NEG_POW = new double[]{1.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10, 1.0E-11, 1.0E-12, 1.0E-13, 1.0E-14, 1.0E-15, 1.0E-16};

    private Num() {
    }

    public static double log2(double x) {
        return 1.4426950408889634 * Math.log(x);
    }

    @Deprecated
    public static double log1p(double x) {
        return Math.log1p(x);
    }

    public static double factorial(int n) {
        double T = 1.0;
        for (int j = 1; j <= n; ++j) {
            T *= (double)j;
        }
        return T;
    }

    public static double lnFactorial(int n) {
        int NLIM = 14;
        if (n < 0) {
            throw new IllegalArgumentException("LnFactorialle: n negative");
        }
        if (n == 0 || n == 1) {
            return 0.0;
        }
        if (n <= 14) {
            long z = 1L;
            long x = 1L;
            for (int i = 2; i <= n; ++i) {
                z *= ++x;
            }
            return Math.log(z);
        }
        double x = n + 1;
        double y = 1.0 / (x * x);
        double z = ((-(5.95238095238E-4 * y) + 7.936500793651E-4) * y - 0.0027777777777778) * y + 0.083333333333333;
        z = (x - 0.5) * Math.log(x) - x + 0.91893853320467 + z / x;
        return z;
    }

    public static double lnGamma(double x) {
        double y;
        double z;
        if (x <= 0.0) {
            throw new IllegalArgumentException("lnGamma:   x <= 0");
        }
        double XLIMBIG = 4.503599627370496E15;
        double XLIM1 = 18.0;
        double DK2 = 0.9189385332046728;
        double DK1 = 0.9574186990510627;
        int N = 15;
        double[] C = new double[]{0.5285430369822346, 0.5498764461214141, 0.02073980061613665, -5.691677042154384E-4, 2.324587210400169E-5, -1.13060758570393E-6, 6.065653098948E-8, -3.4628435777E-9, 2.0624998806E-10, -1.266351116E-11, 7.9531007E-13, -5.082077E-14, 3.29187E-15, -2.1556E-16, 1.424E-17, -9.5E-19};
        if (x > 18.0) {
            double y2 = x > 4.503599627370496E15 ? 0.0 : 1.0 / (x * x);
            double z2 = ((-(5.95238095238E-4 * y2) + 7.936500793651E-4) * y2 - 0.0027777777777778) * y2 + 0.083333333333333;
            z2 = (x - 0.5) * Math.log(x) - x + 0.9189385332046728 + z2 / x;
            return z2;
        }
        if (x > 4.0) {
            int k = (int)x;
            z = x - (double)k;
            y = 1.0;
            for (int i = 3; i < k; ++i) {
                y *= z + (double)i;
            }
            y = Math.log(y);
        } else {
            if (x <= 0.0) {
                return Double.MAX_VALUE;
            }
            if (x < 3.0) {
                int k = (int)x;
                z = x - (double)k;
                y = 1.0;
                for (int i = 2; i >= k; --i) {
                    y *= z + (double)i;
                }
                y = -Math.log(y);
            } else {
                z = x - 3.0;
                y = 0.0;
            }
        }
        z = Num.evalCheby(C, 15, 2.0 * z - 1.0);
        return z + 0.9574186990510627 + y;
    }

    public static double digamma(double x) {
        double[][] C7 = new double[][]{{13524.999667726346, 45285.60169954729, 45135.168469736665, 18529.01181858261, 3329.1525149406934, 240.68032474357202, 5.157789200013909, 0.006228350691898475}, {6.938911175376345E-7, 19768.574263046736, 41255.16083535383, 29390.287119932684, 9081.966607485518, 1244.7477785670856, 67.4291295163786, 1.0}};
        double[][] C4 = new double[][]{{-2.7281757513152966E-15, -0.6481571237661965, -4.486165439180193, -7.016772277667586, -2.1294044513101054}, {7.777885485229616, 54.61177381032151, 89.29207004818613, 32.270349379114336, 1.0}};
        double prodPj = 0.0;
        double prodQj = 0.0;
        double digX = 0.0;
        if (x >= 3.0) {
            double x2 = 1.0 / (x * x);
            for (int j = 4; j >= 0; --j) {
                prodPj = prodPj * x2 + C4[0][j];
                prodQj = prodQj * x2 + C4[1][j];
            }
            digX = Math.log(x) - 0.5 / x + prodPj / prodQj;
        } else if (x >= 0.5) {
            double X0 = 1.4616321449683622;
            for (int j = 7; j >= 0; --j) {
                prodPj = x * prodPj + C7[0][j];
                prodQj = x * prodQj + C7[1][j];
            }
            digX = (x - 1.4616321449683622) * (prodPj / prodQj);
        } else {
            double f = 1.0 - x - Math.floor(1.0 - x);
            digX = Num.digamma(1.0 - x) + Math.PI / Math.tan(Math.PI * f);
        }
        return digX;
    }

    public static double trigamma(double x) {
        if (x < 0.5) {
            double y = 1.0 - x - Math.floor(1.0 - x);
            double sum = Math.PI / Math.sin(Math.PI * y);
            return sum * sum - Num.trigamma(1.0 - x);
        }
        if (x >= 40.0) {
            double y = 1.0 / (x * x);
            double sum = 1.0 + y * (0.16666666666666666 - y * (0.03333333333333333 - y * (0.023809523809523808 - 0.03333333333333333 * y)));
            return (sum += 0.5 / x) / x;
        }
        int p = (int)x;
        double y = x - (double)p;
        double sum = 0.0;
        if (p > 3) {
            for (int i = 3; i < p; ++i) {
                sum -= 1.0 / ((y + (double)i) * (y + (double)i));
            }
        } else if (p < 3) {
            for (int i = 2; i >= p; --i) {
                sum += 1.0 / ((y + (double)i) * (y + (double)i));
            }
        }
        int N = 15;
        double[] A = new double[]{0.6696773958218988, -0.05518748204873009, 0.004510190736011502, -3.657058883037208E-4, 2.943462746822336E-5, -2.35277681515061E-6, 1.8685317663281E-7, -1.475072018379E-8, 1.15799333714E-9, -9.043917904E-11, 7.029627E-12, -5.4398873E-13, 4.192525E-14, -3.21903E-15, 2.463E-16, -1.878E-17, 0.0, 0.0};
        return sum + Num.evalChebyStar(A, 15, y);
    }

    public static double tetragamma(double x) {
        if (x < 0.5) {
            double y = 1.0 - x - Math.floor(1.0 - x);
            double sum = Math.PI / Math.sin(Math.PI * y);
            return 2.0 * Math.cos(Math.PI * y) * sum * sum * sum + Num.tetragamma(1.0 - x);
        }
        if (x >= 20.0) {
            double y = 1.0 / (x * x);
            double sum = y * (0.5 - y * (0.16666666666666666 - y * (0.16666666666666666 - y * (0.3 - 0.8333333333333334 * y))));
            return -(sum += 1.0 + 1.0 / x) * y;
        }
        int p = (int)x;
        double y = x - (double)p;
        double sum = 0.0;
        if (p > 3) {
            for (int i = 3; i < p; ++i) {
                sum += 1.0 / ((y + (double)i) * (y + (double)i) * (y + (double)i));
            }
        } else if (p < 3) {
            for (int i = 2; i >= p; --i) {
                sum -= 1.0 / ((y + (double)i) * (y + (double)i) * (y + (double)i));
            }
        }
        int N = 16;
        double[] A = new double[]{-0.22518587069094767, 0.03655700174282094, -0.004435942496027283, 4.7547585472892647E-4, -4.747183638263232E-5, 4.52181523735268E-6, -4.1630007962011E-7, 3.733899816535E-8, -3.2799144741E-9, 2.8321137682E-10, -2.410402848E-11, 2.0262969E-12, -1.6852418E-13, 1.388481E-14, -1.13451E-15, 9.201E-17, -7.41E-18, 5.9E-19, -5.0E-20};
        return 2.0 * sum + Num.evalChebyStar(A, 16, y);
    }

    public static double gammaRatioHalf(double x) {
        if (x <= 0.0) {
            throw new IllegalArgumentException("gammaRatioHalf:   x <= 0");
        }
        if (x <= 10.0) {
            double y = Num.lnGamma(x + 0.5) - Num.lnGamma(x);
            return Math.exp(y);
        }
        if (x <= 300.0) {
            double EPSILON = 1.0E-15;
            double term = 1.0;
            double sum = 1.0;
            int i = 1;
            while (term > 1.0E-15 * sum) {
                sum += (term *= ((double)i - 1.5) * ((double)i - 1.5) / ((double)i * (x + (double)i - 1.5)));
                ++i;
            }
            return Math.sqrt((x - 0.5) * sum);
        }
        double y = 1.0 / (8.0 * x);
        double sum = 1.0 + y * (-1.0 + y * (0.5 + y * (2.5 - y * (2.625 + 49.875 * y))));
        return sum * Math.sqrt(x);
    }

    public static double combination(int n, int s) {
        int SLIM = 100;
        if (s == 0 || s == n) {
            return 1.0;
        }
        if (s < 0) {
            System.err.println("combination:   s < 0");
            return 0.0;
        }
        if (s > n) {
            System.err.println("combination:   s > n");
            return 0.0;
        }
        if (s > n / 2) {
            s = n - s;
        }
        if (n <= 100) {
            double Res = 1.0;
            int Diff = n - s;
            for (int i = 1; i <= s; ++i) {
                Res *= (double)(Diff + i) / (double)i;
            }
            return Res;
        }
        double Res = Num.lnFactorial(n) - Num.lnFactorial(s) - Num.lnFactorial(n - s);
        return Math.exp(Res);
    }

    public static double[][] calcMatStirling(int m, int n) {
        int j;
        int i;
        double[][] M = new double[m + 1][n + 1];
        for (i = 0; i <= m; ++i) {
            for (j = 0; j <= n; ++j) {
                M[i][j] = 0.0;
            }
        }
        M[0][0] = 1.0;
        for (j = 1; j <= n; ++j) {
            int k;
            M[0][j] = 0.0;
            if (j <= m) {
                k = j - 1;
                M[j][j] = 1.0;
            } else {
                k = m;
            }
            for (i = 1; i <= k; ++i) {
                M[i][j] = (double)i * M[i][j - 1] + M[i - 1][j - 1];
            }
        }
        return M;
    }

    public static double volumeSphere(double p, int t) {
        double EPS = 4.440892098500626E-16;
        int pLR = (int)p;
        double kLR = t;
        if (p < 0.0) {
            throw new IllegalArgumentException("volumeSphere:   p < 0");
        }
        if (Math.abs(p - (double)pLR) <= 4.440892098500626E-16) {
            switch (pLR) {
                case 0: {
                    return TWOEXP[t];
                }
                case 1: {
                    return TWOEXP[t] / Num.factorial(t);
                }
                case 2: {
                    if (t % 2 == 0) {
                        return Math.pow(Math.PI, kLR / 2.0) / Num.factorial(t / 2);
                    }
                    int s = (t + 1) / 2;
                    return Math.pow(Math.PI, (double)s - 1.0) * Num.factorial(s) * TWOEXP[2 * s] / Num.factorial(2 * s);
                }
            }
        }
        double Vol = kLR * (0.6931471805599453 + Num.lnGamma(1.0 + 1.0 / p)) - Num.lnGamma(1.0 + kLR / p);
        return Math.exp(Vol);
    }

    public static double evalCheby(double[] a, int N, double x) {
        if (Math.abs(x) > 1.0) {
            System.err.println("Chebychev polynomial evaluated at x outside [-1, 1]");
        }
        double xx = 2.0 * x;
        double b0 = 0.0;
        double b1 = 0.0;
        double b2 = 0.0;
        for (int j = N; j >= 0; --j) {
            b2 = b1;
            b1 = b0;
            b0 = xx * b1 - b2 + a[j];
        }
        return (b0 - b2) / 2.0;
    }

    public static double evalChebyStar(double[] a, int N, double x) {
        if (x > 1.0 || x < 0.0) {
            System.err.println("Shifted Chebychev polynomial evaluated at x outside [0, 1]");
        }
        double xx = 2.0 * (2.0 * x - 1.0);
        double b0 = 0.0;
        double b1 = 0.0;
        double b2 = 0.0;
        for (int j = N; j >= 0; --j) {
            b2 = b1;
            b1 = b0;
            b0 = xx * b1 - b2 + a[j];
        }
        return (b0 - b2) / 2.0;
    }

    public static double besselK025(double x) {
        int DEG = 6;
        double[] c = new double[]{3.2177591145E10, 2.09933633952E12, 1.6281990144E13, 3.461195759616E13, 2.664028962816E13, 7.901666082816E12, 7.55914244096E11};
        double[] b = new double[]{7.5293843625E10, 2.8912835952E12, 1.8691126272E13, 3.68071409664E13, 2.7348959232E13, 7.9725330432E12, 7.55914244096E11};
        if (x < 1.0E-300) {
            return Double.MIN_VALUE;
        }
        if (x >= 0.6) {
            double B = b[6];
            double C = c[6];
            for (int j = 6; j >= 1; --j) {
                B = B * x + b[j - 1];
                C = C * x + c[j - 1];
            }
            double Res = Math.sqrt(Math.PI / (2.0 * x)) * Math.exp(-x) * (C / B);
            return Res;
        }
        double xx = x * x;
        double rac = Math.pow(x / 2.0, 0.25);
        double Res = (((xx / 1386.0 + 0.023809523809523808) * xx + 0.3333333333333333) * xx + 1.0) / (1.225416702465177 * rac);
        double temp = (((xx / 3510.0 + 0.011111111111111112) * xx + 0.2) * xx + 1.0) * rac / 0.906402477055477;
        Res = Math.PI * (Res - temp) / 1.4142135623730951;
        return Res;
    }

    public static double erf(double x) {
        if (x >= 40.0) {
            return 1.0;
        }
        if (x <= -40.0) {
            return -1.0;
        }
        if (x < 0.0) {
            return -Num.erf(-x);
        }
        if (x >= 2.0) {
            return 1.0 - Num.erfc(x);
        }
        double[] A = new double[]{1.4831105640848037, -0.30107107338659495, 0.06899483068983156, -0.013916271264722188, 0.0024207995224334636, -3.658639685848086E-4, 4.862098443231905E-5, -5.749256558035685E-6, 6.113243578434765E-7, -5.8991015312958435E-8, 5.2070090920686485E-9, -4.2329758799655433E-10, 3.188113506649175E-11, -2.2361550188326843E-12, 1.467329847991085E-13, -9.044001985381747E-15, 5.25481371547092E-16};
        double t = 0.5 * x * x - 1.0;
        double y = Num.evalCheby(A, 16, t);
        return x * y;
    }

    public static double erfc(double x) {
        if (x >= 40.0) {
            return 0.0;
        }
        if (x <= -40.0) {
            return 2.0;
        }
        if (x < 0.0) {
            return 2.0 - Num.erfc(-x);
        }
        double[] A = new double[]{0.6101430819232004, -0.4348412727125775, 0.1763511936436055, -0.06071079560924941, 0.017712068995694115, -0.004321119385567294, 8.542166768870987E-4, -1.2715509060916275E-4, 1.1248167243671189E-5, 3.1306388542182096E-7, -2.70988068537762E-7, 3.073762270140769E-8, 2.515620384817623E-9, -1.0289299213203192E-9, 2.994405211994994E-11, 2.6051789687266936E-11, -2.6348399241719693E-12, -6.434045098906365E-13, 1.1245740180166345E-13, 1.7281533389986097E-14, -4.2641016949424E-15, -5.4537197788E-16, 1.5869760776E-16, 2.08998378E-17, -5.9E-18};
        double t = (x - 3.75) / (x + 3.75);
        double y = Num.evalCheby(A, 24, t);
        return y *= Math.exp(-x * x);
    }

    public static int multMod(int a, int s, int c, int m) {
        long x = a;
        long m1 = m;
        x = (x * (long)s + (long)c) % m1;
        return (int)x;
    }

    public static long multMod(long a, long s, long c, long m) {
        return ArithmeticMod.multModM(a, s, c, m);
    }

    public static double multMod(double a, double s, double c, double m) {
        int k;
        double DEUX53 = 9.007199254740992E15;
        double DEUX17 = 131072.0;
        double UNDEUX17 = 7.62939453125E-6;
        double V = a * s + c;
        if (V >= 9.007199254740992E15 || -V >= 9.007199254740992E15) {
            k = (int)(a * 7.62939453125E-6);
            a -= (double)k * 131072.0;
            V = (double)k * s;
            k = (int)(V / m);
            V -= (double)k * m;
            V = V * 131072.0 + a * s + c;
        }
        k = (int)(V / m);
        return V -= (double)k * m;
    }
}

