/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.utils;

import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.utils.graphics.GraphicsAdaptor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.TreeSet;
import projects.inmode.models.variableStructure.parsimonious.inhomogeneous.InhomogeneousPMM;
import projects.inmode.utils.CustomizedSeqLogoPlotter;

public class CSLPlotter {
    private static boolean PLOTGRID;
    private static boolean PLOTYLABELS;
    private static boolean PLOTPOSITIONS;
    private static boolean PLOTCONTEXTLABELS;
    private static boolean PLOTMARGINALS;
    private static boolean PLOTTRIVIALPCTS;
    private static boolean PLOTIUPAC;
    private static boolean PLOTPSEUDONODES;
    private static boolean PLOTSTACKSCALED;
    private static int PLOTWIDTH;
    private static int PLOTHEIGHT;
    private static int NODELABELFONTSIZE;
    private static int LABELFONTSIZE;
    private static int PCTDEPTH;
    private static int MAXPCTDEPTH;
    private static int NUMBEROFLEAVES;
    private static int STACKHEIGHT;
    private static int MARGINALSTACKHEIGHT;
    private static int STACKWIDTH;
    private static int LEFTLEGENDSPACE;
    private static int TOPLEGENDSPACE;
    private static int SPACEBETWEEN;
    private static int LAYERDISTANCE;
    private static float STROKE;
    private static int NODEHEIGHT;
    private static double[][] PROB;
    private static String[] CONTEXTS;
    private static int[][] LEAVESBELOW;
    private static String[][] NODELABELS;
    private static String[][] PARENTS;
    private static int TOTALNUMBEROFLEAVES;
    private static double[][] PWMMARGINALS;
    private static int POS;
    private static String[] ALLSTRUCTPARAMS;
    private static int[] numbers;
    private static String[] letters;

    static {
        NODELABELFONTSIZE = 16;
        LABELFONTSIZE = 16;
        PCTDEPTH = 2;
        MAXPCTDEPTH = 2;
        NUMBEROFLEAVES = 4;
        STACKHEIGHT = 140;
        MARGINALSTACKHEIGHT = 140;
        STACKWIDTH = 90;
        LEFTLEGENDSPACE = 0;
        TOPLEGENDSPACE = 40;
        SPACEBETWEEN = 10;
        LAYERDISTANCE = 20;
        STROKE = 1.5f;
        NODEHEIGHT = NODELABELFONTSIZE + 10;
        TOTALNUMBEROFLEAVES = 1;
        POS = 0;
        numbers = new int[]{100, 90, 50, 40, 10, 9, 5, 4, 1};
        letters = new String[]{"C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    }

    private static void initialComputations(int pos) {
        POS = pos;
        CONTEXTS = ALLSTRUCTPARAMS[pos].split("%");
        PROB = new double[CONTEXTS.length][];
        NUMBEROFLEAVES = CONTEXTS.length;
        int c = 0;
        while (c < CONTEXTS.length) {
            String[] contextElements = CONTEXTS[c].split("\t");
            CSLPlotter.PROB[c] = new double[contextElements.length];
            int i = 1;
            while (i < contextElements.length) {
                CSLPlotter.PROB[c][i - 1] = Double.parseDouble(contextElements[i]);
                ++i;
            }
            if (contextElements[0].length() > 0) {
                CSLPlotter.CONTEXTS[c] = contextElements[0].substring(1, contextElements[0].length() - 1);
                CSLPlotter.CONTEXTS[c] = CONTEXTS[c].replace("][", " ");
            } else {
                CSLPlotter.CONTEXTS[c] = "";
            }
            ++c;
        }
        PCTDEPTH = CONTEXTS[0].split(" ").length;
        String[][] labels = new String[NUMBEROFLEAVES][];
        int c2 = 0;
        while (c2 < NUMBEROFLEAVES) {
            labels[c2] = CONTEXTS[c2].split(" ");
            ++c2;
        }
        NODELABELS = new String[PCTDEPTH][];
        PARENTS = new String[PCTDEPTH][];
        int d = 0;
        while (d < PCTDEPTH) {
            TreeSet<String> seenStrings = new TreeSet<String>();
            TreeSet<String> seenParentStrings = new TreeSet<String>();
            String existingNodes = "";
            String parentIndices = "";
            int currentParentIndex = -1;
            int c3 = 0;
            while (c3 < NUMBEROFLEAVES) {
                String current = "";
                String currentP = "";
                int f = d;
                while (f < PCTDEPTH) {
                    current = String.valueOf(current) + labels[c3][f] + " ";
                    ++f;
                }
                f = d + 1;
                while (f < PCTDEPTH) {
                    currentP = String.valueOf(currentP) + labels[c3][f] + " ";
                    ++f;
                }
                boolean notSeen = seenStrings.add(current);
                boolean notSeenP = seenParentStrings.add(currentP);
                if (notSeen) {
                    existingNodes = String.valueOf(existingNodes) + labels[c3][d] + " ";
                }
                if (notSeenP) {
                    ++currentParentIndex;
                }
                if (notSeen) {
                    parentIndices = String.valueOf(parentIndices) + currentParentIndex + " ";
                }
                ++c3;
            }
            CSLPlotter.NODELABELS[d] = existingNodes.split(" ");
            CSLPlotter.PARENTS[d] = parentIndices.split(" ");
            ++d;
        }
        LEAVESBELOW = new int[NODELABELS.length][];
        d = 0;
        while (d < LEAVESBELOW.length) {
            CSLPlotter.LEAVESBELOW[d] = new int[NODELABELS[d].length];
            ++d;
        }
        Arrays.fill(LEAVESBELOW[0], 1);
        d = 0;
        while (d < LEAVESBELOW.length - 1) {
            int c4 = 0;
            while (c4 < NODELABELS[d].length) {
                int[] nArray = LEAVESBELOW[d + 1];
                int n = Integer.parseInt(PARENTS[d][c4]);
                nArray[n] = nArray[n] + LEAVESBELOW[d][c4];
                ++c4;
            }
            ++d;
        }
    }

    protected static void plotLogo(Graphics2D g, int width, int height) {
        g = (Graphics2D)g.create();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(STROKE));
        g.setFont(new Font(g.getFont().getName(), 0, LABELFONTSIZE));
        int takenXspace = 0;
        if (PLOTYLABELS) {
            if (PLOTPOSITIONS) {
                g.drawString("Sequence position j:", 5, 10 + LABELFONTSIZE);
            }
            g.setFont(new Font(g.getFont().getName(), 0, NODELABELFONTSIZE));
            if (PLOTMARGINALS) {
                g.drawString("Marginal", 5, TOPLEGENDSPACE + STACKHEIGHT / 2 - LABELFONTSIZE * 3);
                g.drawString("nucleotide", 5, (int)((double)(TOPLEGENDSPACE + STACKHEIGHT / 2) - (double)LABELFONTSIZE * 1.5));
                g.drawString("probabilities", 5, TOPLEGENDSPACE + STACKHEIGHT / 2 + LABELFONTSIZE * 0);
                g.drawString("at position j:", 5, (int)((double)(TOPLEGENDSPACE + STACKHEIGHT / 2) + (double)LABELFONTSIZE * 1.5));
            }
            g.drawString("Conditional", 5, PLOTHEIGHT - STACKHEIGHT / 2 - LABELFONTSIZE * 3);
            g.drawString("nucleotide", 5, (int)((double)(PLOTHEIGHT - STACKHEIGHT / 2) - (double)LABELFONTSIZE * 1.5));
            g.drawString("probabilities", 5, PLOTHEIGHT - STACKHEIGHT / 2);
            g.drawString("at position j:", 5, (int)((double)(PLOTHEIGHT - STACKHEIGHT / 2) + (double)LABELFONTSIZE * 1.5));
            int d = 1;
            while (d <= MAXPCTDEPTH) {
                if (PLOTMARGINALS) {
                    g.drawString("Nucleotide(s) at position j-" + d + ":", 5, TOPLEGENDSPACE + MARGINALSTACKHEIGHT + LAYERDISTANCE / 2 + d * (LAYERDISTANCE + NODEHEIGHT) + NODELABELFONTSIZE / 2);
                } else {
                    g.drawString("Nucleotide(s) at position j-" + d + ":", 5, TOPLEGENDSPACE + 3 * LAYERDISTANCE / 2 + d * (LAYERDISTANCE + NODEHEIGHT) + NODELABELFONTSIZE / 2);
                }
                ++d;
            }
            if (PLOTSTACKSCALED) {
                if (PLOTMARGINALS) {
                    CustomizedSeqLogoPlotter.plotYAxis(g, LEFTLEGENDSPACE - 50, STACKHEIGHT + TOPLEGENDSPACE, STACKHEIGHT);
                }
                CustomizedSeqLogoPlotter.plotYAxis(g, LEFTLEGENDSPACE - 50, PLOTHEIGHT, STACKHEIGHT);
            }
            takenXspace = LEFTLEGENDSPACE;
        }
        int i = 0;
        while (i < ALLSTRUCTPARAMS.length) {
            CSLPlotter.initialComputations(i);
            CSLPlotter.plotSingleCSL(g, takenXspace, 0);
            takenXspace += STACKWIDTH * NUMBEROFLEAVES + SPACEBETWEEN;
            ++i;
        }
        if (PLOTGRID) {
            g.setColor(Color.lightGray);
            BasicStroke dashed = new BasicStroke(STROKE, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
            g.setStroke(dashed);
            if (PLOTMARGINALS) {
                g.drawLine(LEFTLEGENDSPACE, TOPLEGENDSPACE, PLOTWIDTH, TOPLEGENDSPACE);
                g.drawLine(LEFTLEGENDSPACE, TOPLEGENDSPACE + MARGINALSTACKHEIGHT - 25, PLOTWIDTH, TOPLEGENDSPACE + MARGINALSTACKHEIGHT - 25);
            } else {
                g.drawLine(LEFTLEGENDSPACE, TOPLEGENDSPACE, PLOTWIDTH, TOPLEGENDSPACE);
            }
            g.drawLine(LEFTLEGENDSPACE, PLOTHEIGHT - 25, PLOTWIDTH, PLOTHEIGHT - 25);
            g.drawLine(LEFTLEGENDSPACE, PLOTHEIGHT - STACKHEIGHT, PLOTWIDTH, PLOTHEIGHT - STACKHEIGHT);
            g.setColor(Color.BLACK);
            g.setStroke(new BasicStroke(STROKE));
        }
    }

    private static void plotSingleCSL(Graphics2D g, int x, int y) {
        int usedHorizontalSpace = 0;
        g.setColor(Color.BLACK);
        if (PLOTPOSITIONS) {
            g.setFont(new Font(g.getFont().getName(), 0, 18));
            String label = String.valueOf(POS + 1);
            g.drawString(label, x + STACKWIDTH * NUMBEROFLEAVES / 2 - (int)(g.getFontMetrics().getStringBounds(label, g).getWidth() / 2.0), y + 10 + LABELFONTSIZE);
            g.setFont(new Font(g.getFont().getName(), 0, LABELFONTSIZE));
        }
        if (PLOTMARGINALS) {
            CustomizedSeqLogoPlotter.plotStack(g, x + STACKWIDTH * (NUMBEROFLEAVES - 1) / 2, y + STACKHEIGHT + TOPLEGENDSPACE, STACKWIDTH, MARGINALSTACKHEIGHT, PWMMARGINALS[POS], "", PLOTSTACKSCALED);
        }
        int s = 1;
        if (PLOTTRIVIALPCTS) {
            s = 0;
        }
        if (CONTEXTS.length > s) {
            int c = 0;
            while (c < CONTEXTS.length) {
                g.setFont(new Font(g.getFont().getName(), 0, 18));
                String label = "";
                if (PLOTCONTEXTLABELS) {
                    label = CSLPlotter.getRoman(c + 1);
                }
                CustomizedSeqLogoPlotter.plotStack(g, x + usedHorizontalSpace, y + PLOTHEIGHT, STACKWIDTH, STACKHEIGHT, PROB[c], label, PLOTSTACKSCALED);
                g.setFont(new Font(g.getFont().getName(), 0, LABELFONTSIZE));
                usedHorizontalSpace += STACKWIDTH;
                ++c;
            }
            if (PLOTMARGINALS) {
                CSLPlotter.plotPCT(g, x, y + MARGINALSTACKHEIGHT + TOPLEGENDSPACE - LAYERDISTANCE / 2);
            } else {
                CSLPlotter.plotPCT(g, x, y + TOPLEGENDSPACE + LAYERDISTANCE / 2);
            }
        }
        if (PLOTGRID && POS > 0) {
            g.setColor(Color.lightGray);
            BasicStroke dashed = new BasicStroke(STROKE, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
            g.setStroke(dashed);
            g.drawLine(x - SPACEBETWEEN / 2, 0, x - SPACEBETWEEN / 2, PLOTWIDTH);
            g.setColor(Color.BLACK);
            g.setStroke(new BasicStroke(STROKE));
        }
    }

    private static void plotPCT(Graphics2D g, int x, int y) {
        int f;
        int[][] xOfNode = new int[PCTDEPTH][];
        int d = 0;
        while (d < xOfNode.length) {
            xOfNode[d] = new int[LEAVESBELOW[d].length];
            int usedSpace = 0;
            int f2 = 0;
            while (f2 < xOfNode[d].length) {
                xOfNode[d][f2] = x + usedSpace + STACKWIDTH * LEAVESBELOW[d][f2] / 2;
                usedSpace += STACKWIDTH * LEAVESBELOW[d][f2];
                ++f2;
            }
            ++d;
        }
        d = 0;
        while (d < xOfNode.length) {
            f = 0;
            while (f < xOfNode[d].length) {
                if (!NODELABELS[d][f].equals("ACGT") || PLOTPSEUDONODES || LEAVESBELOW[d][f] > 1) {
                    if (d < xOfNode.length - 1) {
                        g.drawLine(xOfNode[d][f], y + (PCTDEPTH - d + 1) * LAYERDISTANCE + (PCTDEPTH - d) * NODEHEIGHT, xOfNode[d + 1][Integer.parseInt(PARENTS[d][f])], y + (PCTDEPTH - d) * LAYERDISTANCE + (PCTDEPTH - d - 1) * NODEHEIGHT);
                    } else {
                        g.drawLine(xOfNode[d][f], y + (PCTDEPTH - d + 1) * LAYERDISTANCE + (PCTDEPTH - d) * NODEHEIGHT, x + NUMBEROFLEAVES * STACKWIDTH / 2, y + LAYERDISTANCE);
                    }
                }
                ++f;
            }
            ++d;
        }
        d = 0;
        while (d < xOfNode.length) {
            f = 0;
            while (f < xOfNode[d].length) {
                if (!NODELABELS[d][f].equals("ACGT") || PLOTPSEUDONODES || LEAVESBELOW[d][f] > 1) {
                    if (PLOTIUPAC) {
                        CSLPlotter.plotPCTNode(g, xOfNode[d][f], y + (PCTDEPTH - d + 1) * LAYERDISTANCE + (PCTDEPTH - d) * NODEHEIGHT, CSLPlotter.getIUPAC(NODELABELS[d][f]));
                    } else {
                        CSLPlotter.plotPCTNode(g, xOfNode[d][f], y + (PCTDEPTH - d + 1) * LAYERDISTANCE + (PCTDEPTH - d) * NODEHEIGHT, NODELABELS[d][f]);
                    }
                }
                ++f;
            }
            ++d;
        }
        CSLPlotter.plotPCTRootNode(g, x + NUMBEROFLEAVES * STACKWIDTH / 2, y + LAYERDISTANCE);
    }

    private static void plotPCTNode(Graphics2D g, int x, int y, String label) {
        g.setColor(Color.BLACK);
        String text = "";
        int i = 0;
        while (i < label.length()) {
            text = String.valueOf(text) + label.charAt(i);
            if (i < label.length() - 1) {
                text = String.valueOf(text) + ",";
            }
            ++i;
        }
        int width = (int)g.getFontMetrics().getStringBounds(text, g).getWidth() + 16;
        Font font = new Font(g.getFont().getName(), 0, NODELABELFONTSIZE);
        g.setFont(font);
        g.setColor(Color.WHITE);
        g.fillOval(x - width / 2, y - NODEHEIGHT / 2, width, NODEHEIGHT);
        g.setColor(Color.BLACK);
        g.drawOval(x - width / 2, y - NODEHEIGHT / 2, width, NODEHEIGHT);
        g.drawString(text, x - (int)(g.getFontMetrics().getStringBounds(text, g).getWidth() / 2.0), y + NODEHEIGHT / 4);
    }

    private static void plotPCTRootNode(Graphics2D g, int x, int y) {
        g.setColor(Color.BLACK);
        int width = NODEHEIGHT;
        Font font = new Font(g.getFont().getName(), 0, NODELABELFONTSIZE);
        g.setFont(font);
        g.setColor(Color.WHITE);
        g.fillOval(x - width / 2, y - NODEHEIGHT / 2, width, NODEHEIGHT);
        g.setColor(Color.BLACK);
        g.drawOval(x - width / 2, y - NODEHEIGHT / 2, width, NODEHEIGHT);
    }

    /*
     * Unable to fully structure code
     */
    private static String getRoman(int number) {
        res = "";
        rest = number;
        i = 0;
        ** GOTO lbl10
        {
            res = String.valueOf(res) + CSLPlotter.letters[i];
            rest -= CSLPlotter.numbers[i];
            do {
                if (rest >= CSLPlotter.numbers[i]) continue block0;
                ++i;
lbl10:
                // 2 sources

            } while (i < CSLPlotter.numbers.length);
        }
        return res;
    }

    private static String getIUPAC(String label) {
        switch (label) {
            case "ACGT": {
                return "N";
            }
            case "ACG": {
                return "V";
            }
            case "ACT": {
                return "T";
            }
            case "AGT": {
                return "D";
            }
            case "CGT": {
                return "B";
            }
            case "AC": {
                return "M";
            }
            case "GT": {
                return "K";
            }
            case "AT": {
                return "W";
            }
            case "CG": {
                return "S";
            }
            case "CT": {
                return "Y";
            }
            case "AG": {
                return "R";
            }
        }
        return label;
    }

    public static class CSLPlotGenerator
    implements PlotGeneratorResult.PlotGenerator {
        String[] allStructParams;
        double[][] pwmMarginals;
        byte maxDepth;
        int totalNumberOfLeaves;
        boolean plotgrid = true;
        boolean plotylabels = false;
        boolean plotpositions = true;
        boolean plotcontextlabels = true;
        boolean plotmarginals = true;
        boolean plotiupac = false;
        boolean plottrivialpcts = false;
        boolean plotpseudonodes = false;
        boolean plotstackscaled = true;

        public CSLPlotGenerator(StringBuffer sb) throws NonParsableException {
            this.allStructParams = (String[])XMLParser.extractObjectForTags(sb, "allStructParams");
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer xml = new StringBuffer();
            XMLParser.appendObjectWithTags(xml, this.allStructParams, "allStructParams");
            return xml;
        }

        public CSLPlotGenerator(InhomogeneousPMM model) {
            this.totalNumberOfLeaves = model.getNumberOfLeaves();
            this.allStructParams = model.getSparseParameterRepresentation().split("&");
            this.pwmMarginals = model.getPositionSpecificMononucleotideMarginals();
            this.maxDepth = model.getOrder();
        }

        public CSLPlotGenerator(InhomogeneousPMM model, boolean grid, boolean ylabels, boolean positions, boolean contextlabels, boolean marginals, boolean trivialpcts, boolean iupac, boolean pseudonodes, boolean stackscaled) {
            this.totalNumberOfLeaves = model.getNumberOfLeaves();
            this.allStructParams = model.getSparseParameterRepresentation().split("&");
            if (this.plotmarginals) {
                this.pwmMarginals = model.getPositionSpecificMononucleotideMarginals();
            }
            this.maxDepth = model.getOrder();
            this.plotylabels = ylabels;
            this.plotgrid = grid;
            this.plotpositions = positions;
            this.plotmarginals = marginals;
            this.plotiupac = iupac;
            this.plotcontextlabels = contextlabels;
            this.plottrivialpcts = trivialpcts;
            this.plotpseudonodes = pseudonodes;
            this.plotstackscaled = stackscaled;
        }

        private void initialComputations() {
            TOTALNUMBEROFLEAVES = this.totalNumberOfLeaves;
            ALLSTRUCTPARAMS = this.allStructParams;
            MAXPCTDEPTH = this.maxDepth;
            PLOTGRID = this.plotgrid;
            PLOTYLABELS = this.plotylabels;
            if (PLOTYLABELS) {
                LEFTLEGENDSPACE = 170;
            } else {
                LEFTLEGENDSPACE = 0;
            }
            PLOTPOSITIONS = this.plotpositions;
            if (PLOTPOSITIONS) {
                TOPLEGENDSPACE = 40;
            } else {
                TOPLEGENDSPACE = 10;
            }
            PLOTCONTEXTLABELS = this.plotcontextlabels;
            PLOTMARGINALS = this.plotmarginals;
            if (PLOTMARGINALS) {
                PWMMARGINALS = this.pwmMarginals;
                MARGINALSTACKHEIGHT = STACKHEIGHT;
            } else {
                MARGINALSTACKHEIGHT = 0;
            }
            PLOTWIDTH = LEFTLEGENDSPACE + TOTALNUMBEROFLEAVES * STACKWIDTH + (ALLSTRUCTPARAMS.length - 1) * SPACEBETWEEN;
            PLOTHEIGHT = TOPLEGENDSPACE + MARGINALSTACKHEIGHT + (NODEHEIGHT + LAYERDISTANCE) * (MAXPCTDEPTH + 1) + STACKHEIGHT;
            if (!PLOTMARGINALS) {
                PLOTHEIGHT = PLOTHEIGHT + LAYERDISTANCE;
            }
            PLOTTRIVIALPCTS = this.plottrivialpcts;
            PLOTIUPAC = this.plotiupac;
            PLOTPSEUDONODES = this.plotpseudonodes;
            PLOTSTACKSCALED = this.plotstackscaled;
        }

        @Override
        public void generatePlot(GraphicsAdaptor ga) throws Exception {
            this.initialComputations();
            CSLPlotter.plotLogo(ga.getGraphics(PLOTWIDTH, PLOTHEIGHT), PLOTWIDTH, PLOTHEIGHT);
        }
    }
}

