/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.tools;

import de.jstacs.DataType;
import de.jstacs.io.FileManager;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.results.ResultSet;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.graphics.RasterizedAdaptor;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import projects.inmode.models.variableStructure.parsimonious.inhomogeneous.InhomogeneousPMM;
import projects.inmode.utils.CSLPlotter;

public class VisualizationApp
implements JstacsTool {
    @Override
    public ParameterSet getToolParameters() {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        try {
            parameters.add(new FileParameter("Input model", "The file with the XML representation of a learned iPMM.", "xml", true));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "IUPAC", "Plot node labels in IUPAC code.", true, null, false));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Marginals", "Plot traditional PWM-corresponding nucleotide stacks.", true, null, true));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Trivial", "Plot trivial PCTs and corresponding nucleotide stacks.", true, null, false));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Pseudonodes", "Plot pseudonodes (full nodes with trivial subtree below).", true, null, false));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "IC scaled", "Scales the nucleotide stacks according to the information content.", true, null, true));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Y labels", "Show detailed descriptions of plot elements on the Y-axis.", true, null, false));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Grid", "Plot grid.", true, null, true));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Positions", "Plot sequence position numbers.", true, null, true));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Context labels", "Plot context labels.", true, null, true));
            parameters.add(new SimpleParameter(DataType.STRING, "Name", "An arbitrary name that can make the output identifiable.", false, null, null));
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return new SimpleParameterSet(parameters.toArray(new Parameter[0]));
    }

    @Override
    public ToolResult run(ParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        String outputName = (String)parameters.getParameterForName("Name").getValue();
        if (outputName == null || outputName.equals("")) {
            outputName = "CSL";
        }
        StringBuffer sbIn = new StringBuffer();
        sbIn.append(((FileParameter)parameters.getParameterForName("Input model")).getFileContents().getContent());
        InhomogeneousPMM model = new InhomogeneousPMM(sbIn);
        RasterizedAdaptor ra = new RasterizedAdaptor("png");
        CSLPlotter.CSLPlotGenerator slpg = new CSLPlotter.CSLPlotGenerator(model, (Boolean)parameters.getParameterForName("Grid").getValue(), (Boolean)parameters.getParameterForName("Y labels").getValue(), (Boolean)parameters.getParameterForName("Positions").getValue(), (Boolean)parameters.getParameterForName("Context labels").getValue(), (Boolean)parameters.getParameterForName("Marginals").getValue(), (Boolean)parameters.getParameterForName("Trivial").getValue(), (Boolean)parameters.getParameterForName("IUPAC").getValue(), (Boolean)parameters.getParameterForName("Pseudonodes").getValue(), (Boolean)parameters.getParameterForName("IC scaled").getValue());
        slpg.generatePlot(ra);
        PlotGeneratorResult pnr = new PlotGeneratorResult(outputName, outputName, slpg, true);
        ToolResult res = new ToolResult("Result of " + outputName, "All results of the scan " + outputName, null, new ResultSet(pnr), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
        return res;
    }

    @Override
    public String getToolName() {
        return "VisualizationApp";
    }

    @Override
    public String getToolVersion() {
        return "1.0";
    }

    @Override
    public String getShortName() {
        return "visualize";
    }

    @Override
    public String getDescription() {
        return "plots a conditional sequence logo with user-specified appearance.";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(VisualizationApp.class.getClassLoader().getResourceAsStream("projects/inmode/tools/helpVisualizationApp.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }
}

