/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.tools;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.io.FileManager;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.StorableResult;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.SeqLogoPlotter;
import de.jstacs.utils.graphics.RasterizedAdaptor;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import projects.inmode.models.variableStructure.parsimonious.inhomogeneous.InhPMMParameterSet;
import projects.inmode.models.variableStructure.parsimonious.inhomogeneous.InhomogeneousPMM;
import projects.inmode.utils.CSLPlotter;
import projects.inmode.utils.DataReader;

public class SimpleMoDe
implements JstacsTool {
    @Override
    public ParameterSet getToolParameters() {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        try {
            parameters.add(new FileParameter("Input data", "The file containing the input data.", "*", true));
            parameters.add(new SimpleParameter(DataType.BYTE, "Order", "The maximal order of the iPMM.", true, new NumberValidator<Byte>((byte)0, (byte)8), (byte)2));
            parameters.add(new SimpleParameter(DataType.STRING, "Name", "An arbitrary name that can make the output identifiable.", false, null, null));
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return new SimpleParameterSet(parameters.toArray(new Parameter[0]));
    }

    @Override
    public ToolResult run(ParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        DataSet data;
        String outputName = (String)parameters.getParameterForName("Name").getValue();
        if (outputName == null || outputName.equals("")) {
            outputName = "iPMM(" + parameters.getParameterForName("Order").getValue() + ")";
        }
        AlphabetContainer con = new AlphabetContainer((Alphabet)DNAAlphabet.SINGLETON);
        protocol.append("Reading data... ");
        File f = new File((String)parameters.getParameterForName("Input data").getValue());
        char ignore = '#';
        if (FileManager.readFile(f).toString().charAt(0) == '>') {
            ignore = '>';
        }
        try {
            data = new DataSet(con, new SparseStringExtractor(f, ignore));
        }
        catch (WrongAlphabetException wae) {
            protocol.append("replace IUPAC symbols... ");
            data = DataReader.replaceIUPACSymbols(new SparseStringExtractor(f, ignore));
        }
        if (data.getElementLength() == 0) {
            throw new Exception("Input sequences are not of equal length.");
        }
        protocol.append("completed.\n");
        protocol.append("Initializing algorithm... ");
        double[] w = null;
        InhomogeneousPMM model = new InhomogeneousPMM(new InhPMMParameterSet(con, data.getElementLength(), (Byte)parameters.getParameterForName("Order").getValue()));
        model.setRuntimeImprovements(false, true);
        progress.setLast(model.getLength());
        progress.setCurrent(0.0);
        model.setProgressUpdater(progress);
        protocol.append("completed.\n");
        protocol.append("Learning... ");
        model.train(data, w);
        protocol.append("completed.\n");
        LinkedList<Result> result = new LinkedList<Result>();
        result.add(new TextResult("Parameters of " + outputName, "Conditional probability parameters for all PCTs leaves of " + outputName, new FileParameter.FileRepresentation("", model.getParameterRepresentation()), "txt", null, null, true));
        result.add(new StorableResult("XML of " + outputName, "XML representation of " + outputName, model));
        double[][] pwm = model.getPositionSpecificMononucleotideMarginals();
        double[][] pwmrc = new double[pwm.length][pwm[0].length];
        int i = 0;
        while (i < pwm.length) {
            int a = 0;
            while (a < pwm[i].length) {
                pwmrc[pwm.length - 1 - i][pwm[i].length - 1 - a] = pwm[i][a];
                ++a;
            }
            ++i;
        }
        RasterizedAdaptor ra = new RasterizedAdaptor("png");
        PlotGeneratorResult.PlotGenerator slpg = new SeqLogoPlotter.SeqLogoPlotGenerator(pwm, 500);
        ((SeqLogoPlotter.SeqLogoPlotGenerator)slpg).generatePlot(ra);
        PlotGeneratorResult pnr = new PlotGeneratorResult("SL of " + outputName, "The sequence logo of the position-specific mononucleotide marginal distribution of " + outputName, slpg, true);
        result.add(pnr);
        ra = new RasterizedAdaptor("png");
        slpg = new SeqLogoPlotter.SeqLogoPlotGenerator(pwmrc, 500);
        ((SeqLogoPlotter.SeqLogoPlotGenerator)slpg).generatePlot(ra);
        pnr = new PlotGeneratorResult("SL(rc) of " + outputName, "The reverse complement sequence logo of the position-specific mononucleotide marginal distribution of " + outputName, slpg, true);
        result.add(pnr);
        if ((Byte)parameters.getParameterForName("Order").getValue() > 0) {
            ra = new RasterizedAdaptor("png");
            slpg = new CSLPlotter.CSLPlotGenerator(model);
            ((CSLPlotter.CSLPlotGenerator)slpg).generatePlot(ra);
            pnr = new PlotGeneratorResult("CSL of " + outputName, "Conditional Sequence logo of " + outputName, slpg, true);
            result.add(pnr);
        }
        ToolResult res = new ToolResult("Learned " + outputName, "All results from learning " + outputName, null, new ResultSet(result), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
        return res;
    }

    @Override
    public String getToolName() {
        return "SimpleMoDe";
    }

    @Override
    public String getToolVersion() {
        return "1.0";
    }

    @Override
    public String getShortName() {
        return "simple";
    }

    @Override
    public String getDescription() {
        return "learns a single iPMM from pre-aligned sequences.";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(SimpleMoDe.class.getClassLoader().getResourceAsStream("projects/inmode/tools/helpSimpleMoDe.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }
}

