/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.tools;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.FileManager;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.parameters.HomMMParameterSet;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.TreeSet;
import projects.inmode.models.variableStructure.parsimonious.inhomogeneous.InhomogeneousPMM;
import projects.inmode.utils.DataReader;

public class ScanApp
implements JstacsTool {
    @Override
    public ParameterSet getToolParameters() {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        try {
            parameters.add(new FileParameter("Input model", "The file with the XML representation of a learned iPMM.", "xml", true));
            parameters.add(new FileParameter("Input data", "The input data file in which a sequence scan is to be performed.", "*", true));
            SimpleParameterSet p0 = new SimpleParameterSet(new SimpleParameter(DataType.BYTE, "Order", "Order of the Markov chain for generating background data.", true, new NumberValidator<Byte>((byte)0, (byte)10), (byte)3), new SimpleParameter(DataType.INT, "Size factor", "Size of the generated background data set as a factor of the foreground data set size.", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE), 1));
            SimpleParameterSet p1 = new SimpleParameterSet(new FileParameter("Data file", "A negative data file for computing the prediction threshold based on a given FPR.", "*", true));
            SelectionParameter sel = new SelectionParameter(DataType.PARAMETERSET, new String[]{"Generating", "From file"}, new ParameterSet[]{p0, p1}, "Background", "The type of background that is used.", true);
            parameters.add(sel);
            parameters.add(new SimpleParameter(DataType.DOUBLE, "FPR", "False positive rate on background data.", true, new NumberValidator<Double>(1.0E-99, 1.0), 1.0E-4));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Both strands", "Whether the input data is scanned on both strands.", false, null, true));
            parameters.add(new SimpleParameter(DataType.STRING, "Name", "An arbitrary name that can make the output identifiable.", false, null, null));
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return new SimpleParameterSet(parameters.toArray(new Parameter[0]));
    }

    @Override
    public ToolResult run(ParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        DataSet data;
        String outputName = (String)parameters.getParameterForName("Name").getValue();
        if (outputName == null || outputName.equals("")) {
            outputName = "SequenceScan(" + parameters.getParameterForName("FPR").getValue() + ")";
        }
        double prog = 0.0;
        progress.setLast(Double.MAX_VALUE);
        progress.setCurrent(prog);
        protocol.append("Reading data... ");
        AlphabetContainer con = new AlphabetContainer((Alphabet)DNAAlphabet.SINGLETON);
        StringBuffer sbIn = new StringBuffer();
        sbIn.append(((FileParameter)parameters.getParameterForName("Input model")).getFileContents().getContent());
        InhomogeneousPMM model = new InhomogeneousPMM(sbIn);
        File f = new File((String)parameters.getParameterForName("Input data").getValue());
        char ignore = '#';
        if (FileManager.readFile(f).toString().charAt(0) == '>') {
            ignore = '>';
        }
        try {
            data = new DataSet(con, new SparseStringExtractor(f, ignore));
        }
        catch (WrongAlphabetException wae) {
            protocol.append("replace IUPAC symbols... \n");
            data = DataReader.replaceIUPACSymbols(new SparseStringExtractor(f, ignore));
        }
        protocol.append("completed.\n");
        ArrayList<Double> al = new ArrayList<Double>();
        int fac = 1;
        protocol.append("Computing background likelihood... ");
        SelectionParameter sel = (SelectionParameter)parameters.getParameterForName("Background");
        if (sel.getSelected() == 1) {
            fac = 1;
        } else {
            fac = (Integer)((SimpleParameterSet)sel.getValue()).getParameterForName("Size factor").getValue();
            if (((Boolean)parameters.getParameterForName("Both strands").getValue()).booleanValue()) {
                progress.setLast(fac * 2 * data.getNumberOfElements());
            } else {
                progress.setLast(fac * data.getNumberOfElements());
            }
        }
        int fa = 0;
        while (fa < fac) {
            DataSet bg;
            if (sel.getSelected() == 1) {
                File fbg = new File((String)((SimpleParameterSet)sel.getValue()).getParameterForName("Data file").getValue());
                char ignorebg = '#';
                if (FileManager.readFile(f).toString().charAt(0) == '>') {
                    ignorebg = '>';
                }
                try {
                    bg = new DataSet(con, new SparseStringExtractor(fbg, ignorebg));
                }
                catch (WrongAlphabetException wae) {
                    protocol.append("replace IUPAC symbols... \n");
                    bg = DataReader.replaceIUPACSymbols(new SparseStringExtractor(fbg, ignorebg));
                }
            } else {
                HomogeneousMM bgModel = new HomogeneousMM(new HomMMParameterSet(con, 1.0, "", (Byte)((SimpleParameterSet)sel.getValue()).getParameterForName("Order").getValue()));
                bgModel.train(data);
                int[] lengths = new int[data.getNumberOfElements()];
                int i = 0;
                while (i < data.getNumberOfElements()) {
                    lengths[i] = data.getElementAt(i).getLength();
                    ++i;
                }
                bg = bgModel.emitDataSet(data.getNumberOfElements(), lengths);
            }
            int i = 0;
            while (i < bg.getNumberOfElements()) {
                int j = 0;
                while (j < bg.getElementAt(i).getLength() - model.getLength() + 1) {
                    al.add(model.getLogProbFor(bg.getElementAt(i), j, j + model.getLength() - 1));
                    ++j;
                }
                progress.setCurrent(prog += 1.0);
                ++i;
            }
            if (((Boolean)parameters.getParameterForName("Both strands").getValue()).booleanValue()) {
                DataSet bgRC = bg.getReverseComplementaryDataSet();
                int i2 = 0;
                while (i2 < bgRC.getNumberOfElements()) {
                    int j = 0;
                    while (j < bgRC.getElementAt(i2).getLength() - model.getLength() + 1) {
                        al.add(model.getLogProbFor(bgRC.getElementAt(i2), j, j + model.getLength() - 1));
                        ++j;
                    }
                    progress.setCurrent(prog += 1.0);
                    ++i2;
                }
            }
            ++fa;
        }
        protocol.append("completed.\n");
        protocol.append("Sorting likelihood values... ");
        al.sort(null);
        protocol.append("completed.\n");
        double cutoff = (Double)al.get((int)Math.floor((1.0 - (Double)parameters.getParameterForName("FPR").getValue()) * (double)al.size()));
        protocol.append("Scan foreground data... ");
        StringBuffer sbLoc = new StringBuffer();
        StringBuffer sbBS = new StringBuffer();
        int nF = 0;
        int nR = 0;
        TreeSet<Integer> ts = new TreeSet<Integer>();
        LinkedList<String> llLoc = new LinkedList<String>();
        LinkedList<String> llBS = new LinkedList<String>();
        int i = 0;
        while (i < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(i);
            int j = 0;
            while (j < seq.getLength() - model.getLength() + 1) {
                double LLR;
                double LLF = model.getLogProbFor(seq.getSubSequence(j, model.getLength()));
                if (LLF > cutoff) {
                    llLoc.add(String.valueOf(i) + "\t" + j + "\t" + (j + model.getLength()) + "\t+\t" + Math.exp(LLF));
                    llBS.add(seq.getSubSequence(j, model.getLength()).toString());
                    ++nF;
                    ts.add(i);
                    progress.setCurrent(prog += 1.0);
                }
                if (((Boolean)parameters.getParameterForName("Both strands").getValue()).booleanValue() && (LLR = model.getLogProbFor(seq.getSubSequence(j, model.getLength()).reverseComplement())) > cutoff) {
                    llLoc.add(String.valueOf(i) + "\t" + j + "\t" + (j + model.getLength()) + "\t-\t" + Math.exp(LLR));
                    llBS.add(seq.getSubSequence(j, model.getLength()).reverseComplement().toString());
                    ++nR;
                    ts.add(i);
                    progress.setCurrent(prog += 1.0);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nF + nR) {
            sbLoc.append((String)llLoc.removeFirst());
            sbBS.append((String)llBS.removeFirst());
            if (i < nF + nR - 1) {
                sbLoc.append("\n");
                sbBS.append("\n");
            }
            ++i;
        }
        protocol.append("completed.\n");
        protocol.append("# hits = " + (nF + nR) + " (" + nF + " on + strand)\n");
        protocol.append("# sequences with at least one hit = " + ts.size() + " (of " + data.getNumberOfElements() + ")\n");
        LinkedList<TextResult> result = new LinkedList<TextResult>();
        TextResult tr1 = new TextResult("Motif hits from " + outputName, "All motif hits from " + outputName + " with a likelihood over a threshold corresponding to a given or generated background data set.", new FileParameter.FileRepresentation("", sbLoc.toString()), "BED", null, null, true);
        TextResult tr2 = new TextResult("Binding sites from " + outputName, "Extracted binding sites corresponding to the hits of " + outputName, new FileParameter.FileRepresentation("", sbBS.toString()), "txt", null, null, true);
        result.add(tr1);
        result.add(tr2);
        ToolResult res = new ToolResult("Result of " + outputName, "All results of the scan " + outputName, null, new ResultSet(result), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
        return res;
    }

    @Override
    public String getToolName() {
        return "ScanApp";
    }

    @Override
    public String getToolVersion() {
        return "1.0";
    }

    @Override
    public String getShortName() {
        return "scan";
    }

    @Override
    public String getDescription() {
        return "finds occurrences of an iPMM motif in given sequences.";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(ScanApp.class.getClassLoader().getResourceAsStream("projects/inmode/tools/helpScanApp.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }
}

