/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.tools;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.io.FileManager;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.ResultSetResult;
import de.jstacs.results.StorableResult;
import de.jstacs.results.TextResult;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.parameters.HomMMParameterSet;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.SeqLogoPlotter;
import de.jstacs.utils.graphics.RasterizedAdaptor;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import projects.inmode.models.latentVariables.MultiComponentOOPSModel;
import projects.inmode.models.variableStructure.AbstractVariableStructureModel;
import projects.inmode.models.variableStructure.parsimonious.inhomogeneous.InhPMMParameterSet;
import projects.inmode.models.variableStructure.parsimonious.inhomogeneous.InhomogeneousPMM;
import projects.inmode.utils.CSLPlotter;
import projects.inmode.utils.DataReader;

public class MixtureMoDe
implements JstacsTool {
    @Override
    public ParameterSet getToolParameters() {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        try {
            parameters.add(new FileParameter("Input data", "The file containing the input data.", "*", true));
            parameters.add(new SimpleParameter(DataType.BYTE, "Number of mixture components", "The number of possible mixture components.", true, new NumberValidator<Byte>((byte)1, (byte)100), (byte)2));
            parameters.add(new SimpleParameter(DataType.BYTE, "Component order", "The maximal order of the iPMM component models.", true, new NumberValidator<Byte>((byte)0, (byte)8), (byte)2));
            parameters.add(new SimpleParameter(DataType.INT, "Initial iterations", "The number of initial iteration steps in the stochastic search.", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE), 50));
            parameters.add(new SimpleParameter(DataType.INT, "Additional iterations", "The number of additional iteration steps that need to pass since the last optimal iteration step before termination.", true, new NumberValidator<Integer>(0, Integer.MAX_VALUE), 10));
            parameters.add(new SimpleParameter(DataType.INT, "Number of restarts", "The number of restarts of the stochastic search for reducing the risk of finding local optima.", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE), 3));
            parameters.add(new SimpleParameter(DataType.STRING, "Name", "An arbitrary name that can make the output identifiable.", false, null, null));
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return new SimpleParameterSet(parameters.toArray(new Parameter[0]));
    }

    @Override
    public ToolResult run(ParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        DataSet data;
        String outputName = (String)parameters.getParameterForName("Name").getValue();
        if (outputName == null || outputName.equals("")) {
            outputName = "Mixture(" + parameters.getParameterForName("Number of mixture components").getValue() + "," + (Byte)parameters.getParameterForName("Component order").getValue() + ")";
        }
        AlphabetContainer con = new AlphabetContainer((Alphabet)DNAAlphabet.SINGLETON);
        protocol.append("Reading data... ");
        File f = new File((String)parameters.getParameterForName("Input data").getValue());
        char ignore = '#';
        if (FileManager.readFile(f).toString().charAt(0) == '>') {
            ignore = '>';
        }
        try {
            data = new DataSet(con, new SparseStringExtractor(f, ignore));
        }
        catch (WrongAlphabetException wae) {
            protocol.append("replace IUPAC symbols... \n");
            data = DataReader.replaceIUPACSymbols(new SparseStringExtractor(f, ignore));
        }
        if (data.getElementLength() == 0) {
            throw new Exception("For this tool, all input sequences need to be of same length.");
        }
        protocol.append("completed.\n");
        protocol.append("Initializing algorithm... ");
        int K = ((Byte)parameters.getParameterForName("Number of mixture components").getValue()).byteValue();
        AbstractVariableStructureModel[] component = new InhomogeneousPMM[K];
        int k = 0;
        while (k < K) {
            component[k] = new InhomogeneousPMM(new InhPMMParameterSet(con, data.getElementLength(), (Byte)parameters.getParameterForName("Component order").getValue()));
            component[k].setRuntimeImprovements(false, true);
            ++k;
        }
        HomogeneousMM flanking = new HomogeneousMM(new HomMMParameterSet(con, 1.0, "", 0));
        MultiComponentOOPSModel model = new MultiComponentOOPSModel(component, flanking, false, (Integer)parameters.getParameterForName("Initial iterations").getValue(), (Integer)parameters.getParameterForName("Additional iterations").getValue(), (Integer)parameters.getParameterForName("Number of restarts").getValue());
        model.setProtocol(protocol);
        progress.setLast((Integer)parameters.getParameterForName("Number of restarts").getValue() * (Integer)parameters.getParameterForName("Initial iterations").getValue());
        progress.setCurrent(0.0);
        model.setProgressUpdater(progress);
        protocol.append("completed.\n");
        protocol.append("Learning:\n");
        model.train(data);
        LinkedList<Result> result = new LinkedList<Result>();
        result.add(new TextResult("Logfile of " + outputName, "Logfile for the stochastic search of " + outputName, new FileParameter.FileRepresentation("", model.getLog()), "txt", null, null, true));
        int k2 = 0;
        while (k2 < K) {
            if (model.checkComponentActivity(k2)) {
                LinkedList<Result> resultLocal = new LinkedList<Result>();
                InhomogeneousPMM local = (InhomogeneousPMM)model.getMotifModels()[k2];
                resultLocal.add(new StorableResult("XML of " + outputName + " component " + k2, "XML representation of the of " + outputName + ", component " + k2, local));
                resultLocal.add(new TextResult("Parameters of " + outputName + " component " + k2, "Conditional probability parameters for all PCTs leaves of " + outputName + ", component " + k2, new FileParameter.FileRepresentation("", local.getParameterRepresentation()), "txt", null, null, true));
                double[][] pwm = local.getPositionSpecificMononucleotideMarginals();
                double[][] pwmrc = new double[pwm.length][pwm[0].length];
                int i = 0;
                while (i < pwm.length) {
                    int a = 0;
                    while (a < pwm[i].length) {
                        pwmrc[pwm.length - 1 - i][pwm[i].length - 1 - a] = pwm[i][a];
                        ++a;
                    }
                    ++i;
                }
                RasterizedAdaptor ra = new RasterizedAdaptor("png");
                PlotGeneratorResult.PlotGenerator slpg = new SeqLogoPlotter.SeqLogoPlotGenerator(pwm, 500);
                ((SeqLogoPlotter.SeqLogoPlotGenerator)slpg).generatePlot(ra);
                PlotGeneratorResult pnr = new PlotGeneratorResult("SL of " + outputName + " component " + k2, "The sequence logo of the position-specific mononucleotide marginal distribution of " + outputName + ", component " + k2, slpg, true);
                resultLocal.add(pnr);
                ra = new RasterizedAdaptor("png");
                slpg = new SeqLogoPlotter.SeqLogoPlotGenerator(pwmrc, 500);
                ((SeqLogoPlotter.SeqLogoPlotGenerator)slpg).generatePlot(ra);
                pnr = new PlotGeneratorResult("SL(rc) of " + outputName + " component " + k2, "The reverse complement sequence logo of the position-specific mononucleotide marginal distribution of " + outputName + ", component " + k2, slpg, true);
                resultLocal.add(pnr);
                if ((Byte)parameters.getParameterForName("Component order").getValue() > 0) {
                    ra = new RasterizedAdaptor("png");
                    slpg = new CSLPlotter.CSLPlotGenerator((InhomogeneousPMM)model.getMotifModels()[k2]);
                    ((CSLPlotter.CSLPlotGenerator)slpg).generatePlot(ra);
                    pnr = new PlotGeneratorResult("CSL of " + outputName + " component " + k2, "Conditional Sequence logo of " + outputName + " component " + k2, slpg, true);
                    resultLocal.add(pnr);
                }
                ResultSet rs = new ResultSet(resultLocal);
                ResultSetResult rsr = new ResultSetResult("Learned " + outputName + " component " + k2, String.valueOf(outputName) + " component " + k2, null, rs);
                result.add(rsr);
            }
            ++k2;
        }
        ToolResult res = new ToolResult("Learned " + outputName, "All output of the mixture model", null, new ResultSet(result), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
        return res;
    }

    @Override
    public String getToolName() {
        return "MixtureMoDe";
    }

    @Override
    public String getToolVersion() {
        return "1.0";
    }

    @Override
    public String getShortName() {
        return "mixture";
    }

    @Override
    public String getDescription() {
        return "learns a mixture model with iPMM components.";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(MixtureMoDe.class.getClassLoader().getResourceAsStream("projects/inmode/tools/helpMixtureMoDe.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }
}

