/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.tools;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.io.FileManager;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.parameters.validation.RegExpValidator;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.ResultSetResult;
import de.jstacs.results.StorableResult;
import de.jstacs.results.TextResult;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.parameters.HomMMParameterSet;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.SeqLogoPlotter;
import de.jstacs.utils.graphics.RasterizedAdaptor;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import projects.inmode.models.latentVariables.MultiComponentOOPSModel;
import projects.inmode.models.variableStructure.AbstractVariableStructureModel;
import projects.inmode.models.variableStructure.parsimonious.inhomogeneous.InhPMMParameterSet;
import projects.inmode.models.variableStructure.parsimonious.inhomogeneous.InhomogeneousPMM;
import projects.inmode.utils.CSLPlotter;
import projects.inmode.utils.DataReader;

public class FlexibleMoDe
implements JstacsTool {
    @Override
    public ParameterSet getToolParameters() {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        try {
            parameters.add(new FileParameter("Input data", "The file containing the input data.", "*", true));
            parameters.add(new FileParameter("Weights", "A file containing weights associated with the input sequences in the input data.", "*", false));
            parameters.add(new SimpleParameter(DataType.INT, "Motif width", "The width of the motif.", true, new NumberValidator<Integer>(4, 100), 15));
            parameters.add(new SimpleParameter(DataType.STRING, "Motif order(s)", "The maximal order(s) of the iPMM motif/component models (comma separated).", true, new RegExpValidator("[0-8](,[0-8]){0,99}"), "2,2"));
            parameters.add(new SimpleParameter(DataType.BYTE, "Flanking order", "The order of the model for the flanking sequences.", true, new NumberValidator<Byte>((byte)0, (byte)3), (byte)2));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Both strands", "Take into account both strands in the input.", true, null, true));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Update motif type parameters", "Estimates the motif type probability during the stochastic search.", true, null, false));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Memoization", "Use memoization technique for speeding up structure learning. Might cause substantially increased memory consumption.", true, null, false));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Pruning", "Use pruning techniques for speeding up structure learning.", true, null, true));
            parameters.add(new SimpleParameter(DataType.INT, "Initial iterations", "The number of initial iteration steps in the stochastic search.", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE), 50));
            parameters.add(new SimpleParameter(DataType.INT, "Additional iterations", "The number of additional iteration steps that need to pass since the last optimal iteration step before termination.", true, new NumberValidator<Integer>(0, Integer.MAX_VALUE), 10));
            parameters.add(new SimpleParameter(DataType.INT, "Number of restarts", "The number of restarts of the stochastic search for reducing the risk of finding local optima.", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE), 3));
            parameters.add(new SimpleParameter(DataType.STRING, "Name", "An arbitrary name that can make the output identifiable.", false, null, null));
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return new SimpleParameterSet(parameters.toArray(new Parameter[0]));
    }

    @Override
    public ToolResult run(ParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        DataSet data;
        AlphabetContainer con = new AlphabetContainer((Alphabet)DNAAlphabet.SINGLETON);
        String outputName = (String)parameters.getParameterForName("Name").getValue();
        if (outputName == null || outputName.equals("")) {
            outputName = "FlexibleMode";
        }
        protocol.append("Reading data... ");
        File f = new File((String)parameters.getParameterForName("Input data").getValue());
        char ignore = '#';
        if (FileManager.readFile(f).toString().charAt(0) == '>') {
            ignore = '>';
        }
        try {
            data = new DataSet(con, new SparseStringExtractor(f, ignore));
        }
        catch (WrongAlphabetException wae) {
            protocol.append("replace IUPAC symbols... \n");
            data = DataReader.replaceIUPACSymbols(new SparseStringExtractor(f, ignore));
        }
        double[] w = null;
        if (parameters.getParameterForName("Weights").hasDefaultOrIsSet()) {
            try {
                w = DataReader.readDoubleArray(new File((String)parameters.getParameterForName("Weights").getValue()));
            }
            catch (NumberFormatException e) {
                throw new Exception("The file does contain not only real numbers. At least one input string cannot be parsed. Check documentation for file format requirements.");
            }
            if (w.length != data.getNumberOfElements()) {
                w = null;
                throw new Exception("The number of specified weights does not equal the number of sequences in the input data.");
            }
        }
        protocol.append("completed.\n");
        protocol.append("Initializing algorithm... ");
        HomogeneousMM flanking = new HomogeneousMM(new HomMMParameterSet(con, 1.0, "Flanking model", (Byte)parameters.getParameterForName("Flanking order").getValue()));
        String[] motifOrders = ((String)parameters.getParameterForName("Motif order(s)").getValue()).split(",");
        int K = motifOrders.length;
        byte[] localOrder = new byte[K];
        int k = 0;
        while (k < K) {
            localOrder[k] = Byte.parseByte(motifOrders[k]);
            ++k;
        }
        AbstractVariableStructureModel[] motif = new InhomogeneousPMM[K];
        int k2 = 0;
        while (k2 < K) {
            motif[k2] = new InhomogeneousPMM(new InhPMMParameterSet(con, (Integer)parameters.getParameterForName("Motif width").getValue(), localOrder[k2]));
            motif[k2].setRuntimeImprovements((Boolean)parameters.getParameterForName("Memoization").getValue(), (Boolean)parameters.getParameterForName("Pruning").getValue());
            ++k2;
        }
        MultiComponentOOPSModel model = new MultiComponentOOPSModel(motif, flanking, (Boolean)parameters.getParameterForName("Both strands").getValue(), (Integer)parameters.getParameterForName("Initial iterations").getValue(), (Integer)parameters.getParameterForName("Additional iterations").getValue(), (Integer)parameters.getParameterForName("Number of restarts").getValue());
        model.updateLVParam((Boolean)parameters.getParameterForName("Update motif type parameters").getValue());
        model.setProtocol(protocol);
        progress.setLast((Integer)parameters.getParameterForName("Number of restarts").getValue() * (Integer)parameters.getParameterForName("Initial iterations").getValue());
        progress.setCurrent(0.0);
        model.setProgressUpdater(progress);
        protocol.append("completed.\n");
        protocol.append("Learning:\n");
        model.train(data, w);
        LinkedList<Result> result = new LinkedList<Result>();
        result.add(new TextResult("Logfile of " + outputName, "Logfile for the stochastic search of " + outputName, new FileParameter.FileRepresentation("", model.getLog()), "txt", null, null, true));
        int k3 = 0;
        while (k3 < K) {
            if (model.checkComponentActivity(k3)) {
                LinkedList<Result> resultLocal = new LinkedList<Result>();
                InhomogeneousPMM local = (InhomogeneousPMM)model.getMotifModels()[k3];
                resultLocal.add(new StorableResult("XML of " + outputName + " motif/component " + k3, "XML representation of the of " + outputName + ", motif/component " + k3, local));
                resultLocal.add(new TextResult("Parameters of " + outputName + " motif/component " + k3, "Conditional probability parameters for all PCTs leaves of " + outputName + ", motif/component " + k3, new FileParameter.FileRepresentation("", local.getParameterRepresentation()), "txt", null, null, true));
                double[][] pwm = local.getPositionSpecificMononucleotideMarginals();
                double[][] pwmrc = local.getPositionSpecificMononucleotideMarginals();
                int i = 0;
                while (i < pwm.length) {
                    int a = 0;
                    while (a < pwm[i].length) {
                        pwmrc[pwm.length - 1 - i][pwm[i].length - 1 - a] = pwm[i][a];
                        ++a;
                    }
                    ++i;
                }
                RasterizedAdaptor ra = new RasterizedAdaptor("png");
                PlotGeneratorResult.PlotGenerator slpg = new SeqLogoPlotter.SeqLogoPlotGenerator(pwm, 500);
                ((SeqLogoPlotter.SeqLogoPlotGenerator)slpg).generatePlot(ra);
                PlotGeneratorResult pnr = new PlotGeneratorResult("SL of " + outputName + " motif/component " + k3, "The sequence logo of the position-specific mononucleotide marginal distribution of " + outputName + ", motif/component " + k3, slpg, true);
                resultLocal.add(pnr);
                ra = new RasterizedAdaptor("png");
                slpg = new SeqLogoPlotter.SeqLogoPlotGenerator(pwmrc, 500);
                ((SeqLogoPlotter.SeqLogoPlotGenerator)slpg).generatePlot(ra);
                pnr = new PlotGeneratorResult("SL(rc) of " + outputName + " motif/component " + k3, "The reverse complement sequence logo of the position-specific mononucleotide marginal distribution of " + outputName + ", motif/component " + k3, slpg, true);
                resultLocal.add(pnr);
                if (localOrder[k3] > 0) {
                    ra = new RasterizedAdaptor("png");
                    slpg = new CSLPlotter.CSLPlotGenerator((InhomogeneousPMM)model.getMotifModels()[k3]);
                    ((CSLPlotter.CSLPlotGenerator)slpg).generatePlot(ra);
                    pnr = new PlotGeneratorResult("CSL of " + outputName + " motif/component " + k3, "Conditional Sequence logo of " + outputName + " motif/component " + k3, slpg, true);
                    resultLocal.add(pnr);
                }
                ResultSet rs = new ResultSet(resultLocal);
                ResultSetResult rsr = new ResultSetResult("Learned " + outputName + " motif/component " + k3, String.valueOf(outputName) + " motif/component " + k3, null, rs);
                result.add(rsr);
            }
            ++k3;
        }
        ToolResult res = new ToolResult("Learned " + outputName, "All results of " + outputName, null, new ResultSet(result), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
        return res;
    }

    @Override
    public String getToolName() {
        return "FlexibleMoDe";
    }

    @Override
    public String getToolVersion() {
        return "1.0";
    }

    @Override
    public String getShortName() {
        return "flexible";
    }

    @Override
    public String getDescription() {
        return "allows to learns iPMM(s) in various scenarios.";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(FlexibleMoDe.class.getClassLoader().getResourceAsStream("projects/inmode/tools/helpFlexibleMoDe.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }
}

