/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.models.variableStructure.parsimonious.dataStructures;

import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import java.util.Iterator;
import java.util.TreeSet;

public class SymbolSet
implements Comparable<SymbolSet>,
Cloneable {
    private DiscreteAlphabet alph;
    private TreeSet<String> ts;
    private double score;
    boolean isActiveChild = true;
    public int ID = 0;
    public TreeSet<Integer> optimalSubSetIDs;

    public SymbolSet(DiscreteAlphabet alph, String ... strings) {
        if (alph.getClass() == DNAAlphabet.class) {
            try {
                this.alph = new DiscreteAlphabet(true, "A", "C", "G", "T");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.alph = alph;
        }
        this.ts = new TreeSet();
        int i = 0;
        while (i < strings.length) {
            this.ts.add(strings[i]);
            ++i;
        }
        this.optimalSubSetIDs = new TreeSet();
    }

    public SymbolSet(DiscreteAlphabet alph, boolean filled) {
        if (alph.getClass() == DNAAlphabet.class) {
            try {
                this.alph = new DiscreteAlphabet(true, "A", "C", "G", "T");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.alph = alph;
        }
        this.ts = new TreeSet();
        if (filled) {
            int i = 0;
            while ((double)i < alph.length()) {
                this.ts.add(alph.getSymbolAt(i));
                ++i;
            }
        }
    }

    protected boolean isSubsetOf(SymbolSet t) {
        if (this.getNumberOfElements() > t.getNumberOfElements()) {
            return false;
        }
        return t.ts.containsAll(this.ts);
    }

    protected String getSetDifferenceAsString(SymbolSet t) {
        if (!t.isSubsetOf(this)) {
            return "";
        }
        String res = "";
        for (String s : this.ts) {
            if (t.contains(s)) continue;
            res = String.valueOf(res) + s;
        }
        return res;
    }

    protected boolean equals(SymbolSet t) {
        if (this.alph.equals(t.getAlphabet())) {
            return this.ts.equals(t.ts);
        }
        return false;
    }

    protected String[] getElements() {
        Object[] oarr = this.ts.toArray();
        String[] strarr = new String[oarr.length];
        int i = 0;
        while (i < strarr.length) {
            strarr[i] = (String)oarr[i];
            ++i;
        }
        return strarr;
    }

    protected void add(String str) {
        this.ts.add(str);
    }

    protected void add(String[] strarr) {
        int i = 0;
        while (i < strarr.length) {
            this.ts.add(strarr[i]);
            ++i;
        }
    }

    protected void remove(String str) {
        this.ts.remove(str);
    }

    public SymbolSet union(SymbolSet ... t) throws Exception {
        SymbolSet res = new SymbolSet(this.alph, this.getElements());
        int i = 0;
        while (i < t.length) {
            if (!this.alph.checkConsistency(t[i].getAlphabet())) {
                throw new Exception("Union impossible as alphabets do not match");
            }
            res.add(t[i].getElements());
            ++i;
        }
        return res;
    }

    protected DiscreteAlphabet getAlphabet() {
        return this.alph;
    }

    public String toString() {
        return this.ts.toString();
    }

    protected int getNumberOfElements() {
        return this.ts.size();
    }

    @Override
    public int compareTo(SymbolSet s) {
        if ((int)Math.signum(this.getNumberOfElements() - s.getNumberOfElements()) != 0) {
            return (int)Math.signum(this.getNumberOfElements() - s.getNumberOfElements());
        }
        int i = 0;
        while (i < Math.min(s.getNumberOfElements(), this.getNumberOfElements())) {
            if (s.getElements()[i].compareTo(this.getElements()[i]) != 0) {
                return this.getElements()[i].compareTo(s.getElements()[i]);
            }
            ++i;
        }
        return 0;
    }

    protected boolean containsAtLeastOneElementOf(SymbolSet t) {
        try {
            return this.union(t).getNumberOfElements() < this.getNumberOfElements() + t.getNumberOfElements();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    protected boolean contains(String str) {
        return this.ts.contains(str);
    }

    public static TreeSet<SymbolSet> createSymbolSets(DiscreteAlphabet alph) throws Exception {
        SymbolSet[] symbolsetarr = new SymbolSet[(int)Math.pow(2.0, alph.length()) - 1];
        int counter = 0;
        int i = 0;
        while ((double)i < alph.length()) {
            int countAtStartOfIteration = counter;
            int j = 0;
            while (j < countAtStartOfIteration) {
                symbolsetarr[counter] = symbolsetarr[j].union(new SymbolSet(alph, alph.getSymbolAt(i)));
                ++counter;
                ++j;
            }
            symbolsetarr[counter] = new SymbolSet(alph, alph.getSymbolAt(i));
            ++counter;
            ++i;
        }
        TreeSet<SymbolSet> symbolset = new TreeSet<SymbolSet>();
        i = 0;
        while (i < symbolsetarr.length) {
            symbolset.add(symbolsetarr[i]);
            ++i;
        }
        return symbolset;
    }

    public TreeSet<SymbolSet> createSymbolSubSets() throws Exception {
        String[] d = new String[1];
        d = this.ts.toArray(d);
        SymbolSet[] symbolsetarr = new SymbolSet[(int)Math.pow(2.0, this.ts.size()) - 1];
        int counter = 0;
        int i = 0;
        while (i < this.ts.size()) {
            int countAtStartOfIteration = counter;
            int j = 0;
            while (j < countAtStartOfIteration) {
                symbolsetarr[counter] = symbolsetarr[j].union(new SymbolSet(this.alph, d[i]));
                ++counter;
                ++j;
            }
            symbolsetarr[counter] = new SymbolSet(this.alph, d[i]);
            ++counter;
            ++i;
        }
        TreeSet<SymbolSet> symbolset = new TreeSet<SymbolSet>();
        i = 0;
        while (i < symbolsetarr.length) {
            symbolset.add(symbolsetarr[i]);
            ++i;
        }
        return symbolset;
    }

    public TreeSet<SymbolSet> createSymbolMinimalSubSets() throws Exception {
        String[] d = new String[1];
        d = this.ts.toArray(d);
        SymbolSet[] symbolsetarr = new SymbolSet[(int)Math.pow(2.0, this.ts.size()) - 1];
        int counter = 0;
        int i = 0;
        while (i < this.ts.size()) {
            int countAtStartOfIteration = counter;
            int j = 0;
            while (j < countAtStartOfIteration) {
                symbolsetarr[counter] = symbolsetarr[j].union(new SymbolSet(this.alph, d[i]));
                ++counter;
                ++j;
            }
            symbolsetarr[counter] = new SymbolSet(this.alph, d[i]);
            ++counter;
            ++i;
        }
        TreeSet<SymbolSet> symbolset = new TreeSet<SymbolSet>();
        i = 0;
        while (i < symbolsetarr.length) {
            if (symbolsetarr[i].getElements()[0].equals(this.getElements()[0])) {
                symbolset.add(symbolsetarr[i]);
            }
            ++i;
        }
        return symbolset;
    }

    public TreeSet<String> createSymbolMinimalSubSetsAsStrings() throws Exception {
        String[] d = new String[1];
        d = this.ts.toArray(d);
        SymbolSet[] symbolsetarr = new SymbolSet[(int)Math.pow(2.0, this.ts.size()) - 1];
        int counter = 0;
        int i = 0;
        while (i < this.ts.size()) {
            int countAtStartOfIteration = counter;
            int j = 0;
            while (j < countAtStartOfIteration) {
                symbolsetarr[counter] = symbolsetarr[j].union(new SymbolSet(this.alph, d[i]));
                ++counter;
                ++j;
            }
            symbolsetarr[counter] = new SymbolSet(this.alph, d[i]);
            ++counter;
            ++i;
        }
        TreeSet<String> symbolset = new TreeSet<String>();
        i = 0;
        while (i < symbolsetarr.length) {
            if (symbolsetarr[i].getElements()[0].equals(this.getElements()[0])) {
                symbolset.add(symbolsetarr[i].toSparseString());
            }
            ++i;
        }
        return symbolset;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public String toSparseString() {
        String res = "";
        Iterator<String> it = this.ts.iterator();
        while (it.hasNext()) {
            res = String.valueOf(res) + it.next();
        }
        return res;
    }

    public int size() {
        return this.ts.size();
    }

    public TreeSet<String> getSymbolsAsSet() {
        return this.ts;
    }

    public void disable() {
        this.isActiveChild = false;
        this.score = Double.NEGATIVE_INFINITY;
    }

    public boolean isActiveChild() {
        return this.isActiveChild;
    }

    protected int[] getCode() {
        int[] res = new int[this.ts.size()];
        Iterator<String> it = this.ts.iterator();
        int i = 0;
        while (it.hasNext()) {
            try {
                res[i] = this.alph.getCode(it.next());
            }
            catch (WrongAlphabetException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return res;
    }
}

