/*
 * Decompiled with CFR 0.152.
 */
package projects.inmode.models.variableStructure.parsimonious;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.io.NonParsableException;
import projects.inmode.models.variableStructure.AbstractVariableStructureModel;
import projects.inmode.models.variableStructure.parsimonious.dataStructures.ParsimoniousContextTree;

public abstract class AbstractParsimoniousModel
extends AbstractVariableStructureModel {
    protected ParsimoniousContextTree[] tree;
    protected String[] parameterSamples;

    public AbstractParsimoniousModel(AlphabetContainer alphabets, int length) {
        super(alphabets, length);
    }

    public AbstractParsimoniousModel(StringBuffer sb) throws NonParsableException {
        super(sb);
    }

    public String getGraphViz() {
        StringBuffer out = new StringBuffer();
        out.append("digraph{\n");
        out.append("edge [arrowsize=0.8 headport=n labelangle=0];\n");
        out.append("node  [label=\"\" width=1.2 height=0.55 color=black,fixedsize=true,fontsize=14];\n");
        int i = 0;
        while (i < this.tree.length) {
            out.append("/* PCT representation of position " + i + "*/\n");
            out.append(this.tree[i].getGraphviz());
            ++i;
        }
        out.append("}");
        return out.toString();
    }

    public String getSparseParameterRepresentation() {
        String res = "";
        int i = 0;
        while (i < this.tree.length) {
            res = String.valueOf(res) + this.tree[i].getSparseParameterRepresentation() + "&";
            ++i;
        }
        return res;
    }

    @Override
    protected abstract void fromXML(StringBuffer var1) throws NonParsableException;

    public String getParameterRepresentation() {
        String res = "";
        int i = 0;
        while (i < this.tree.length) {
            res = String.valueOf(res) + "Position " + (i + 1) + "\n";
            String[] str = this.tree[i].getSparseParameterRepresentation().split("%");
            int r = 0;
            while (r < str.length) {
                res = String.valueOf(res) + str[r] + "\n";
                ++r;
            }
            ++i;
        }
        return res;
    }
}

