/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.utils.IntList;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class GenomeIndex {
    public GenomeIndex(String chromFile, int length) throws IOException {
        BufferedReader read = new BufferedReader(new FileReader(chromFile));
        String str = null;
        String chrom = null;
        HashMap<String, Integer> chromMap = new HashMap<String, Integer>();
        int idx = 0;
        while ((str = read.readLine()) != null) {
            if (!str.startsWith(">")) continue;
            chrom = str.substring(1).trim();
            System.out.println(chrom);
            chromMap.put(chrom, idx);
            ++idx;
        }
        read.close();
        read = new BufferedReader(new FileReader(chromFile));
        int[] charMap = new int[256];
        Arrays.fill(charMap, -1);
        charMap[97] = 0;
        charMap[65] = 0;
        charMap[99] = 1;
        charMap[67] = 1;
        charMap[103] = 2;
        charMap[71] = 2;
        charMap[116] = 3;
        charMap[84] = 3;
        charMap[110] = 4;
        charMap[78] = 4;
        int alphaSize = 5;
        int[] pows = new int[length];
        pows[pows.length - 1] = 1;
        int i = 1;
        while (i < pows.length) {
            pows[length - i - 1] = pows[length - i] * alphaSize;
            ++i;
        }
        IntList[][] maps = new IntList[idx][];
        int currStrIdx = -1;
        int currPos = 0;
        while ((str = read.readLine()) != null) {
            if (str.startsWith(">")) {
                System.out.println(str);
                idx = (Integer)chromMap.get(str.substring(1).trim());
                if (maps[idx] == null) {
                    maps[idx] = new IntList[pows[0] * alphaSize];
                }
                currStrIdx = -1;
                currPos = 0;
                continue;
            }
            int off = 0;
            if (currStrIdx < 0) {
                currStrIdx = 0;
                int i2 = 0;
                while (i2 < length) {
                    currStrIdx += charMap[str.charAt(i2)] * pows[i2];
                    ++i2;
                    ++off;
                }
                if (maps[idx][currStrIdx] == null) {
                    maps[idx][currStrIdx] = new IntList();
                }
                maps[idx][currStrIdx].add(currPos);
                ++currPos;
            }
            while (off < str.length()) {
                char last = str.charAt(off);
                if (maps[idx][currStrIdx = currStrIdx % pows[0] * alphaSize + charMap[last]] == null) {
                    maps[idx][currStrIdx] = new IntList();
                }
                maps[idx][currStrIdx].add(currPos);
                ++off;
            }
        }
    }
}

