/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.classifiers.performanceMeasures.AucPR;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

public class Aggregation {
    public static void main(String[] args) throws IOException {
        Aggregate[] aggregateArray;
        String line;
        Integer index;
        File f;
        ArrayList<BufferedReader> reader = new ArrayList<BufferedReader>();
        int i = 0;
        while ((f = new File(args[i])).exists()) {
            reader.add(new BufferedReader(new FileReader(f)));
            ++i;
        }
        int m = reader.size();
        double[] values = new double[m];
        System.out.println(String.valueOf(m) + " gws");
        System.out.println();
        try {
            index = new Integer(args[m]);
        }
        catch (NumberFormatException e) {
            index = null;
            args[m] = args[m].toUpperCase();
        }
        ArrayList<String> chrs = new ArrayList<String>();
        HashMap<String, ArrayList<int[]>> hash = new HashMap<String, ArrayList<int[]>>();
        BufferedReader r = new BufferedReader(new FileReader(args[++m + 1]));
        System.out.println(args[m + 1]);
        while ((line = r.readLine()) != null) {
            String[] split = line.split("\t");
            ArrayList<int[]> current = (ArrayList<int[]>)hash.get(split[0]);
            if (current == null) {
                current = new ArrayList<int[]>();
                hash.put(split[0], current);
                chrs.add(split[0]);
            }
            current.add(new int[]{Integer.parseInt(split[1]), Integer.parseInt(split[2])});
        }
        r.close();
        System.out.println(chrs);
        System.out.println();
        int wi = Integer.parseInt(args[m]);
        int windows = 2 * wi;
        int offset = (wi - 2) * 50;
        String chr = null;
        ArrayList intervals = null;
        int[] inter = null;
        HashMap<String, ArrayList> predictions = new HashMap<String, ArrayList>();
        ArrayList currentPred = null;
        double[] p = null;
        int idx = -1;
        int h = -1;
        String[] li = new String[m];
        while ((li[0] = ((BufferedReader)reader.get(0)).readLine()) != null) {
            block71: {
                block74: {
                    block72: {
                        int start;
                        String[] split = li[0].split("\t");
                        String prefix = String.valueOf(split[0]) + "\t" + split[1] + "\t";
                        i = 1;
                        while (i < m - 1) {
                            li[i] = ((BufferedReader)reader.get(i)).readLine();
                            if (!li[i].startsWith(prefix)) {
                                throw new RuntimeException("Mismatch:\nFile 0: " + args[0] + "\nLine: " + li[0] + "\nFile " + f + ": " + args[i] + "\nLine: " + li[i]);
                            }
                            li[i] = li[i].substring(prefix.length());
                            ++i;
                        }
                        if (chr == null || !chr.equals(split[0])) {
                            if (chr != null && intervals != null) {
                                Aggregation.out(idx, chr, inter, h, p, windows);
                            }
                            if ((intervals = (ArrayList)hash.get(chr = split[0])) != null) {
                                currentPred = new ArrayList();
                                predictions.put(chr, currentPred);
                                idx = 0;
                                inter = (int[])intervals.get(idx);
                                p = new double[(inter[1] - inter[0]) / 50 + 1 + 2 * (wi - 2)];
                                currentPred.add(p);
                                h = 0;
                            } else {
                                inter = null;
                                idx = -1;
                                p = null;
                            }
                        }
                        if (intervals == null || (start = Integer.parseInt(split[1])) < inter[0] - offset) continue;
                        if (start > inter[1] + offset) break block71;
                        values[0] = Double.parseDouble(split[2]);
                        i = 1;
                        while (i < m - 1) {
                            values[i] = Double.parseDouble(li[i]);
                            ++i;
                        }
                        if (index != null) break block72;
                        switch (args[m - 1]) {
                            case "MEAN": {
                                p[h] = ToolBox.mean(0, values.length, values);
                                break block74;
                            }
                            case "MAX": {
                                p[h] = ToolBox.max(0, values.length, values);
                                break block74;
                            }
                            case "MIN": {
                                p[h] = ToolBox.min(0, values.length, values);
                                break block74;
                            }
                            case "PROD": {
                                p[h] = 1.0;
                                int k = 0;
                                while (k < values.length) {
                                    int n = h;
                                    p[n] = p[n] * (1.0 - values[k]);
                                    ++k;
                                }
                                p[h] = 1.0 - p[h];
                                break block74;
                            }
                            case "W1": {
                                Arrays.sort(values);
                                double norm = 0.0;
                                p[h] = 0.0;
                                int k = 0;
                                while (k < values.length) {
                                    int n = h;
                                    p[n] = p[n] + (double)(k + 1) * values[k];
                                    norm += (double)(k + 1);
                                    ++k;
                                }
                                int n = h;
                                p[n] = p[n] / norm;
                                break block74;
                            }
                            case "W2": {
                                Arrays.sort(values);
                                double norm = 0.0;
                                p[h] = 0.0;
                                int k = 0;
                                while (k < values.length) {
                                    int n = h;
                                    p[n] = p[n] + Math.pow(2.0, k) * values[k];
                                    norm += Math.pow(2.0, k);
                                    ++k;
                                }
                                int n = h;
                                p[n] = p[n] / norm;
                                break block74;
                            }
                            default: {
                                throw new IllegalArgumentException("unknown:" + args[m - 1]);
                            }
                        }
                    }
                    p[h] = values[index];
                }
                ++h;
                continue;
            }
            if (idx + 1 >= intervals.size()) continue;
            Aggregation.out(idx, chr, inter, h, p, windows);
            if (++idx < intervals.size()) {
                inter = (int[])intervals.get(idx);
                p = new double[(inter[1] - inter[0]) / 50 + 1 + 2 * (wi - 2)];
                currentPred.add(p);
                h = 0;
                continue;
            }
            h = -1;
        }
        i = 0;
        while (i < values.length) {
            ((BufferedReader)reader.get(i)).close();
            ++i;
        }
        Aggregation.out(idx, chr, inter, h, p, windows);
        Aggregate b = null;
        try {
            b = Aggregate.valueOf(args[m + 2]);
        }
        catch (Exception e) {
            System.out.println("Test all Aggregate variants.");
        }
        if (b != null) {
            Aggregate[] aggregateArray2 = new Aggregate[1];
            aggregateArray = aggregateArray2;
            aggregateArray2[0] = b;
        } else {
            aggregateArray = Aggregate.values();
        }
        Aggregate[] val = aggregateArray;
        double[] weight = new double[windows];
        i = 0;
        while (i < wi) {
            double d = 1 + i;
            weight[weight.length - i - 1] = d;
            weight[i] = d;
            ++i;
        }
        Normalisation.sumNormalisation(weight);
        Aggregate[] aggregateArray3 = val;
        int n = val.length;
        int n2 = 0;
        while (n2 < n) {
            int col;
            Aggregate a = aggregateArray3[n2];
            SafeOutputStream o = SafeOutputStream.getSafeOutputStream(args.length == m + 3 ? new FileOutputStream(String.valueOf(args[0]) + "-" + args[m] + "-" + (Object)((Object)a) + ".tab") : null);
            DoubleList pos = new DoubleList();
            DoubleList neg = new DoubleList();
            if (args.length == m + 5) {
                col = Integer.parseInt(args[m + 4]);
                GZIPInputStream stream = new GZIPInputStream(new FileInputStream(args[m + 3]));
                r = new BufferedReader(new InputStreamReader(stream));
                String first = r.readLine();
                if (a == val[0]) {
                    System.out.println("Compute performance for cell type: " + first.split("\t")[col]);
                }
            } else {
                r = null;
                col = -1;
            }
            int c = 0;
            while (c < chrs.size()) {
                chr = (String)chrs.get(c);
                currentPred = (ArrayList)predictions.get(chr);
                if (currentPred != null) {
                    intervals = (ArrayList)hash.get(chr);
                    i = 0;
                    while (i < currentPred.size()) {
                        inter = (int[])intervals.get(i);
                        p = (double[])currentPred.get(i);
                        int start = inter[0];
                        int j = 0;
                        while (j < p.length - windows) {
                            double ag = -1.0;
                            switch (a) {
                                case Max: {
                                    ag = ToolBox.max(j, j + windows, p);
                                    break;
                                }
                                case Mean: {
                                    ag = ToolBox.mean(j, j + windows, p);
                                    break;
                                }
                                case Prod: {
                                    ag = 1.0;
                                    int k = j;
                                    while (k < j + windows) {
                                        ag *= 1.0 - p[k];
                                        ++k;
                                    }
                                    ag = 1.0 - ag;
                                    break;
                                }
                                case Weight: {
                                    ag = 0.0;
                                    int k = j;
                                    while (k < j + windows) {
                                        ag += weight[k - j] * p[k];
                                        ++k;
                                    }
                                    break;
                                }
                                case Median: {
                                    ag = ToolBox.median(j, j + windows, p);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("not implemented: " + (Object)((Object)a));
                                }
                            }
                            o.writeln(String.valueOf(chr) + "\t" + start + "\t" + (start + 200) + "\t" + ag);
                            if (r != null) {
                                String s = r.readLine();
                                String[] split = s.split("\t");
                                if (!(j != 0 || chr.equals(split[0]) && split[1].equals("" + start))) {
                                    System.out.println();
                                    System.out.println(s);
                                    System.out.println(Arrays.toString(inter));
                                    System.out.println(String.valueOf(chr) + "\t" + start + "\t" + (start + 200));
                                    System.exit(1);
                                }
                                switch (split[col].charAt(0)) {
                                    case 'B': 
                                    case 'b': {
                                        pos.add(ag);
                                        break;
                                    }
                                    case 'U': 
                                    case 'u': {
                                        neg.add(ag);
                                    }
                                }
                            }
                            start += 50;
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    System.out.println("WARNING: Did not find predictions for " + chr);
                }
                ++c;
            }
            o.close();
            if (r != null) {
                double[] po = pos.toArray();
                double[] ne = neg.toArray();
                Arrays.sort(po);
                Arrays.sort(ne);
                if (a == val[0]) {
                    System.out.println("#positives: " + po.length);
                    System.out.println("#negatives: " + ne.length);
                    System.out.println("random: " + (double)po.length / (double)(po.length + ne.length));
                }
                System.out.println();
                System.out.println(String.valueOf(windows) + "\t" + (Object)((Object)a) + "\t" + (a == Aggregate.Weight ? Arrays.toString(weight) : ""));
                System.out.println(new AucROC().compute(po, ne));
                System.out.println(new AucPR().compute(po, ne));
                r.close();
            }
            ++n2;
        }
    }

    static void out(int idx, String chr, int[] interval, int last, double[] p, int windows) {
        if (chr != null && interval != null && p != null && p.length != last) {
            System.out.println(String.valueOf(chr) + "\t" + idx + "\t" + Arrays.toString(interval) + "\t" + last + "\t" + p.length + "\t" + (last != p.length ? "WARNING" : ""));
        }
    }

    static String toString(ArrayList<int[]> list) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            sb.append(String.valueOf(sb.length() == 0 ? "" : ", ") + Arrays.toString(list.get(i)));
            ++i;
        }
        return sb.toString();
    }

    static String toString(int start, int end, double[] p) {
        StringBuffer sb = new StringBuffer();
        while (start < end) {
            sb.append(String.valueOf(sb.length() == 0 ? "" : ", ") + p[start++]);
        }
        return sb.toString();
    }

    static enum Aggregate {
        Mean,
        Median,
        Max,
        Prod,
        Weight;

    }

    static class ArrayComparator
    implements Comparator<int[]> {
        ArrayComparator() {
        }

        @Override
        public int compare(int[] o1, int[] o2) {
            return o1[0] - o2[0];
        }
    }
}

