/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.CrossProductTokenization;
import org.biojava.bio.seq.io.NameTokenization;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractAlphabet
extends AbstractChangeable
implements FiniteAlphabet,
Serializable {
    private final Map tokenizationsByName = new HashMap();
    private final Map ambCache = new HashMap();
    public static final long serialVersionUID = -3043128839927615753L;
    private boolean registered = false;

    void setRegistered(boolean value) {
        this.registered = value;
    }

    boolean getRegsitered() {
        return this.registered;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (AlphabetManager.registered(this.getName())) {
            return AlphabetManager.alphabetForName(this.getName());
        }
        if (this.registered) {
            AlphabetManager.registerAlphabet(this.getName(), (Alphabet)this);
        }
        return this;
    }

    public void putTokenization(String name, SymbolTokenization parser) {
        this.tokenizationsByName.put(name, parser);
    }

    public SymbolTokenization getTokenization(String name) throws NoSuchElementException, BioException {
        SymbolTokenization toke = (SymbolTokenization)this.tokenizationsByName.get(name);
        if (toke == null) {
            if (name.equals("name")) {
                toke = this.getAlphabets().size() == 1 ? new NameTokenization(this) : new CrossProductTokenization(this);
                this.putTokenization(name, toke);
            } else if (name.equals("default")) {
                toke = this.tokenizationsByName.containsKey("token") ? (SymbolTokenization)this.tokenizationsByName.get("token") : this.getTokenization("name");
                this.putTokenization(name, toke);
            } else {
                throw new NoSuchElementException("There is no tokenization '" + name + "' defined in alphabet " + this.getName());
            }
        }
        return toke;
    }

    public final Symbol getAmbiguity(Set syms) throws IllegalSymbolException {
        if (syms.size() == 0) {
            return this.getGapSymbol();
        }
        if (syms.size() == 1) {
            Symbol sym = (Symbol)syms.iterator().next();
            this.validate(sym);
            return sym;
        }
        Symbol s = (Symbol)this.ambCache.get(syms);
        if (s == null) {
            Iterator i = syms.iterator();
            while (i.hasNext()) {
                this.validate((Symbol)i.next());
            }
            s = this.getAmbiguityImpl(syms);
            this.ambCache.put(new HashSet(syms), s);
        }
        return s;
    }

    protected Symbol getAmbiguityImpl(Set syms) throws IllegalSymbolException {
        return AlphabetManager.createSymbol(Annotation.EMPTY_ANNOTATION, syms, (Alphabet)this);
    }

    public final Symbol getSymbol(List syms) throws IllegalSymbolException {
        if (syms.size() == 1) {
            Symbol s = (Symbol)syms.get(0);
            this.validate(s);
            return s;
        }
        List<Alphabet> alphas = this.getAlphabets();
        if (alphas.size() != syms.size()) {
            throw new IllegalSymbolException("Can't retrieve symbol as symbol list is the wrong length " + syms.size() + ":" + alphas.size());
        }
        Iterator si = syms.iterator();
        int atomic = 0;
        while (si.hasNext()) {
            Symbol s = (Symbol)si.next();
            if (!(s instanceof AtomicSymbol)) continue;
            ++atomic;
        }
        if (atomic == syms.size()) {
            return this.getSymbolImpl(syms);
        }
        return AlphabetManager.createSymbol(Annotation.EMPTY_ANNOTATION, syms, (Alphabet)this);
    }

    protected abstract AtomicSymbol getSymbolImpl(List var1) throws IllegalSymbolException;

    protected abstract void addSymbolImpl(AtomicSymbol var1) throws IllegalSymbolException, ChangeVetoException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSymbol(Symbol s) throws IllegalSymbolException, ChangeVetoException {
        if (s == null) {
            throw new IllegalSymbolException("You can not add null as a symbol to alphabet " + this.getName());
        }
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(Alphabet.SYMBOLS);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, Alphabet.SYMBOLS, s, null);
                cs.firePreChangeEvent(ce);
                this.doAddSymbol(s);
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.doAddSymbol(s);
        }
    }

    private void doAddSymbol(Symbol s) throws IllegalSymbolException, ChangeVetoException {
        Alphabet sa = s.getMatches();
        if (!(sa instanceof FiniteAlphabet)) {
            throw new IllegalSymbolException("Can't add symbol " + s.getName() + " as it matches an infinite number of symbols.");
        }
        Iterator<Symbol> si = ((FiniteAlphabet)sa).iterator();
        while (si.hasNext()) {
            this.addSymbolImpl((AtomicSymbol)si.next());
        }
    }

    public final boolean contains(Symbol sym) {
        if (sym instanceof AtomicSymbol) {
            return this.containsImpl((AtomicSymbol)sym);
        }
        if (sym == null) {
            throw new NullPointerException("Symbols can't be null");
        }
        FiniteAlphabet matches = (FiniteAlphabet)sym.getMatches();
        if (matches.size() == 0) {
            if (sym.equals(AlphabetManager.getGapSymbol())) {
                return true;
            }
            if (sym instanceof BasisSymbol && ((BasisSymbol)sym).getSymbols().size() == this.getAlphabets().size()) {
                return true;
            }
            return true;
        }
        Iterator<Symbol> i = matches.iterator();
        while (i.hasNext()) {
            AtomicSymbol s = (AtomicSymbol)i.next();
            if (this.containsImpl(s)) continue;
            return false;
        }
        return true;
    }

    public final Symbol getGapSymbol() {
        return AlphabetManager.getGapSymbol(this.getAlphabets());
    }

    public final void validate(Symbol sym) throws IllegalSymbolException {
        if (!this.contains(sym)) {
            throw new IllegalSymbolException("Symbol " + sym.getName() + " not found in alphabet " + this.getName());
        }
    }

    protected abstract boolean containsImpl(AtomicSymbol var1);

    public String toString() {
        return this.getName();
    }

    protected AbstractAlphabet() {
    }
}

