/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.OverlayAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.MergeFeatureHolder;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.impl.FeatureImpl;
import org.biojava.bio.seq.projection.ProjectedFeatureHolder;
import org.biojava.bio.seq.projection.ReparentContext;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;

public class ViewSequence
extends Unchangeable
implements Sequence,
RealizingFeatureHolder,
Serializable {
    private static final long serialVersionUID = 9866447L;
    private Sequence seqDelegate;
    private MergeFeatureHolder exposedFeatures;
    private SimpleFeatureHolder addedFeatures;
    private String name;
    private String urn;
    private Annotation anno;
    private transient FeatureRealizer featureRealizer;

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.featureRealizer = FeatureImpl.DEFAULT;
    }

    public ViewSequence(Sequence seq, String name) {
        this.name = name;
        this.seqDelegate = seq;
        this.addedFeatures = new SimpleFeatureHolder();
        this.exposedFeatures = new MergeFeatureHolder();
        try {
            this.exposedFeatures.addFeatureHolder(new ProjectedFeatureHolder(new ReparentContext(this, this.seqDelegate)));
            this.exposedFeatures.addFeatureHolder(this.addedFeatures);
        }
        catch (ChangeVetoException cve) {
            throw new BioError("Modification of hidden featureholder vetoed!", cve);
        }
        this.urn = this.seqDelegate.getURN();
        this.urn = this.urn.indexOf(63) >= 0 ? this.urn + "&view=" + this.hashCode() : this.urn + "?view=" + this.hashCode();
        this.anno = new OverlayAnnotation(this.seqDelegate.getAnnotation());
        this.featureRealizer = FeatureImpl.DEFAULT;
    }

    public ViewSequence(Sequence seq) {
        this(seq, seq.getName());
    }

    public ViewSequence(Sequence seq, FeatureRealizer fr) {
        this(seq);
        this.featureRealizer = fr;
    }

    public Alphabet getAlphabet() {
        return this.seqDelegate.getAlphabet();
    }

    public Iterator iterator() {
        return this.seqDelegate.iterator();
    }

    public int length() {
        return this.seqDelegate.length();
    }

    public String seqString() {
        return this.seqDelegate.seqString();
    }

    public String subStr(int start, int end) {
        return this.seqDelegate.subStr(start, end);
    }

    public SymbolList subList(int start, int end) {
        return this.seqDelegate.subList(start, end);
    }

    public Symbol symbolAt(int indx) {
        return this.seqDelegate.symbolAt(indx);
    }

    public List toList() {
        return this.seqDelegate.toList();
    }

    public String getURN() {
        return this.urn;
    }

    public String getName() {
        return this.name;
    }

    public int countFeatures() {
        return this.exposedFeatures.countFeatures();
    }

    public Iterator features() {
        return this.exposedFeatures.features();
    }

    public FeatureHolder filter(FeatureFilter fc, boolean recurse) {
        return this.exposedFeatures.filter(fc, recurse);
    }

    public FeatureHolder filter(FeatureFilter fc) {
        return this.exposedFeatures.filter(fc);
    }

    public FeatureFilter getSchema() {
        return this.exposedFeatures.getSchema();
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        this.addedFeatures.removeFeature(f);
    }

    public boolean containsFeature(Feature f) {
        return this.exposedFeatures.containsFeature(f);
    }

    public Annotation getAnnotation() {
        return this.anno;
    }

    public Feature realizeFeature(FeatureHolder parent, Feature.Template template) throws BioException {
        return this.featureRealizer.realizeFeature(this, parent, template);
    }

    public Feature createFeature(Feature.Template template) throws BioException, ChangeVetoException {
        Location loc = template.location;
        if (loc.getMin() < 1 || loc.getMax() > this.length()) {
            throw new BioException("Failed to create a feature with a location " + loc + " outside the sequence: name '" + this.getName() + "', URN '" + this.getURN() + "' length " + this.length());
        }
        Feature f = this.realizeFeature(this, template);
        this.addedFeatures.addFeature(f);
        return f;
    }

    public FeatureHolder getAddedFeatures() {
        return this.addedFeatures;
    }

    public void edit(Edit edit) throws ChangeVetoException {
        throw new ChangeVetoException("ViewSequence is immutable");
    }
}

