/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.geodesic;

public final class IntList {
    int[] data;
    int size;

    public IntList(int n) {
        this.data = new int[n];
        this.size = 0;
    }

    public IntList() {
        this(100);
    }

    public IntList(int[] nArray) {
        this.data = new int[nArray.length + (nArray.length + 10) / 2];
        this.size = nArray.length;
        System.arraycopy(nArray, 0, this.data, 0, this.size);
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.data.length;
    }

    public int get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        return this.data[n];
    }

    public void set(int n, int n2) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        if (this.size == n) {
            if (this.size == this.data.length) {
                this.setCapacity(this.data.length + (this.data.length + 10) / 2);
            }
            this.data[this.size++] = n2;
        }
        this.data[n] = n2;
    }

    public void add(int n) {
        if (this.size == this.data.length) {
            this.setCapacity(this.data.length + (this.data.length + 10) / 2);
        }
        this.data[this.size++] = n;
    }

    public void remove(int n) {
        if (n < 0 || n >= this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        System.arraycopy(this.data, n + 1, this.data, n, this.size - n - 1);
        --this.size;
    }

    public void insert(int n, int n2) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        if (this.size == this.data.length) {
            this.setCapacity(this.data.length + (this.data.length + 10) / 2);
        }
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = n2;
        ++this.size;
    }

    public void setCapacity(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException("capacity must exeed size of list");
        }
        int[] nArray = new int[n];
        System.arraycopy(this.data, 0, nArray, 0, this.size);
        this.data = nArray;
    }

    public void removeAll() {
        this.size = 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("(");
        if (this.size > 0) {
            stringBuffer.append(this.data[0]);
            for (int i = 1; i < this.size; ++i) {
                stringBuffer.append(", ");
                stringBuffer.append(this.data[i]);
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

