/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.minimizing.Info;
import java.io.Serializable;

public final class Braket
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final double GOLD = 1.618034;
    static final double GLIMIT = 100.0;
    static final double TINY = 1.0E-20;

    private static final double sign(double d, double d2) {
        return d2 > 0.0 ? Math.abs(d) : -Math.abs(d);
    }

    public static void search(double[] dArray, double[] dArray2, RealFunctionOfOneVariable realFunctionOfOneVariable) {
        Braket.search(dArray, dArray2, realFunctionOfOneVariable, null);
    }

    public static void search(double[] dArray, double[] dArray2, RealFunctionOfOneVariable realFunctionOfOneVariable, Info info) {
        double d;
        double d2 = 0.0;
        double d3 = dArray[0];
        double d4 = dArray[1];
        double d5 = realFunctionOfOneVariable.eval(d3);
        double d6 = d = realFunctionOfOneVariable.eval(d4);
        if (d > d5) {
            d2 = d3;
            d3 = d4;
            d4 = d2;
            d2 = d5;
            d5 = d;
            d = d2;
        }
        double d7 = d4 + 1.618034 * (d4 - d3);
        double d8 = realFunctionOfOneVariable.eval(d7);
        while (d > d8) {
            double d9;
            double d10 = (d4 - d3) * (d - d8);
            double d11 = (d4 - d7) * (d - d5);
            double d12 = d4 - ((d4 - d7) * d11 - (d4 - d3) * d10) / (2.0 * Braket.sign(Math.max(Math.abs(d11 - d10), 1.0E-20), d11 - d10));
            double d13 = d4 + 100.0 * (d7 - d4);
            if ((d4 - d12) * (d12 - d7) > 0.0) {
                d9 = realFunctionOfOneVariable.eval(d12);
                if (d9 < d8) {
                    d3 = d4;
                    d4 = d12;
                    d5 = d;
                    d = d9;
                    break;
                }
                if (d9 > d) {
                    d7 = d12;
                    d8 = d9;
                    break;
                }
                d12 = d7 + 1.618034 * (d7 - d4);
                d9 = realFunctionOfOneVariable.eval(d12);
            } else if ((d7 - d12) * (d12 - d13) > 0.0) {
                d9 = realFunctionOfOneVariable.eval(d12);
                if (d9 < d8) {
                    d4 = d7;
                    d7 = d12;
                    d12 = d7 + 1.618034 * (d7 - d4);
                    d = d8;
                    d8 = d9;
                    d9 = realFunctionOfOneVariable.eval(d12);
                }
            } else if ((d12 - d13) * (d13 - d7) >= 0.0) {
                d12 = d13;
                d9 = realFunctionOfOneVariable.eval(d12);
            } else {
                d12 = d7 + 1.618034 * (d7 - d4);
                d9 = realFunctionOfOneVariable.eval(d12);
            }
            d3 = d4;
            d4 = d7;
            d7 = d12;
            d5 = d;
            d = d8;
            d8 = d9;
        }
        dArray[0] = d3;
        dArray2[0] = d5;
        dArray[1] = d4;
        dArray2[1] = d;
        dArray[2] = d7;
        dArray2[2] = d8;
        if (d > d6 && info != null) {
            info.setMessage("proc Braket failed to decrease center value! ");
            info.printDebug();
        }
    }
}

