/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.continuous;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Random;
import umontreal.iro.lecuyer.util.Num;

public class DirichletDiffSM
extends AbstractDifferentiableStatisticalModel {
    private static Random r = new Random();
    private double logNorm;
    private double[] partNorm;
    private double ess;
    private double[] pars;
    private double[] expPars;
    private double[] chi;
    private boolean isInitialized;
    private int numStarts;

    public DirichletDiffSM(AlphabetContainer alphabets, int length, double[] chi, double ess, int numStarts) throws IllegalArgumentException {
        super(alphabets, length);
        if (chi.length != length + 1) {
            throw new IllegalArgumentException();
        }
        this.pars = new double[length + 1];
        this.ess = ess;
        this.expPars = new double[length + 1];
        Arrays.fill(this.expPars, 1.0);
        this.chi = (double[])chi.clone();
        this.numStarts = numStarts;
    }

    @Override
    public DirichletDiffSM clone() throws CloneNotSupportedException {
        DirichletDiffSM clone = (DirichletDiffSM)super.clone();
        clone.chi = (double[])this.chi.clone();
        clone.expPars = (double[])this.expPars.clone();
        clone.pars = (double[])this.pars.clone();
        if (this.partNorm != null) {
            clone.partNorm = (double[])this.partNorm.clone();
        }
        return clone;
    }

    public DirichletDiffSM(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 1;
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        return this.numStarts;
    }

    @Override
    public double getLogNormalizationConstant() {
        return 0.0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    @Override
    public double getLogPriorTerm() {
        double prior = this.logNorm * this.ess;
        int i = 0;
        while (i < this.pars.length) {
            prior += this.ess * this.chi[i] * this.expPars[i] + this.pars[i];
            ++i;
        }
        return prior;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        int i = 0;
        while (i < this.pars.length) {
            int n = i + start;
            grad[n] = grad[n] + (this.ess * (this.partNorm[i] + this.chi[i] * this.expPars[i]) + 1.0);
            ++i;
        }
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        double[] sums = new double[this.length + 1];
        int i = 0;
        while (i < data[index].getNumberOfElements()) {
            double rest = 1.0;
            int j = 0;
            while (j < sums.length) {
                double temp = 0.0;
                if (j < sums.length - 1) {
                    temp = data[index].getElementAt(i).continuousVal(j);
                    rest -= temp;
                    temp *= weights[index][i];
                } else {
                    temp = rest * weights[index][i];
                }
                int n = j++;
                sums[n] = sums[n] + temp;
            }
            ++i;
        }
        Normalisation.sumNormalisation(sums);
        i = 0;
        while (i < sums.length) {
            sums[i] = Math.log(sums[i] * 2.0 + 2.0);
            ++i;
        }
        this.setParameters(sums, 0);
        this.isInitialized = true;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        int i = 0;
        while (i < this.pars.length) {
            this.pars[i] = 1.0 + Math.abs(r.nextGaussian());
            ++i;
        }
        this.precompute();
        this.isInitialized = true;
    }

    @Override
    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        double score = this.logNorm;
        double rest = 1.0;
        int i = 0;
        while (i < this.pars.length - 1) {
            score += Math.log(seq.continuousVal(start + i)) * (this.expPars[i] - 1.0);
            rest -= seq.continuousVal(start + i);
            ++i;
        }
        if (Double.isInfinite(score += Math.log(rest) * (this.expPars[this.expPars.length - 1] - 1.0))) {
            System.out.println(String.valueOf(Arrays.toString(this.pars)) + " " + Arrays.toString(this.expPars) + " " + seq);
        }
        return score;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double score = this.logNorm;
        double rest = 1.0;
        int i = 0;
        while (i < this.pars.length) {
            double temp = 0.0;
            if (i < this.pars.length - 1) {
                temp = Math.log(seq.continuousVal(start + i));
                rest -= seq.continuousVal(start + i);
            } else {
                temp = Math.log(rest);
            }
            score += temp * (this.expPars[i] - 1.0);
            indices.add(i);
            partialDer.add(this.partNorm[i] + temp * this.expPars[i]);
            ++i;
        }
        return score;
    }

    @Override
    public int getNumberOfParameters() {
        return this.pars.length;
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        return (double[])this.pars.clone();
    }

    @Override
    public void setParameters(double[] params, int start) {
        int i = 0;
        while (i < this.pars.length) {
            this.pars[i] = params[i + start];
            ++i;
        }
        this.precompute();
    }

    private void precompute() {
        try {
            this.logNorm = 0.0;
            if (this.partNorm == null) {
                this.partNorm = new double[this.pars.length];
            }
            int i = 0;
            while (i < this.pars.length) {
                this.expPars[i] = Math.exp(this.pars[i]);
                ++i;
            }
            this.logNorm += Num.lnGamma(ToolBox.sum(this.expPars));
            i = 0;
            while (i < this.pars.length) {
                this.logNorm -= Num.lnGamma(this.expPars[i]);
                this.partNorm[i] = this.expPars[i] * Num.digamma(ToolBox.sum(this.expPars)) - this.expPars[i] * Num.digamma(this.expPars[i]);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(Arrays.toString(this.pars));
            System.out.println(Arrays.toString(this.expPars));
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.alphabets, "alphabets");
        XMLParser.appendObjectWithTags(xml, this.length, "length");
        XMLParser.appendObjectWithTags(xml, this.ess, "ess");
        XMLParser.appendObjectWithTags(xml, this.pars, "pars");
        XMLParser.appendObjectWithTags(xml, this.chi, "chi");
        XMLParser.appendObjectWithTags(xml, this.isInitialized, "isInitialized");
        XMLParser.appendObjectWithTags(xml, this.numStarts, "numStarts");
        XMLParser.addTags(xml, "Dirichlet");
        return xml;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "Dirichlet");
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabets");
        this.length = XMLParser.extractObjectForTags(xml, "length", Integer.TYPE);
        this.ess = XMLParser.extractObjectForTags(xml, "ess", Double.TYPE);
        this.pars = (double[])XMLParser.extractObjectForTags(xml, "pars");
        this.chi = (double[])XMLParser.extractObjectForTags(xml, "chi");
        this.isInitialized = XMLParser.extractObjectForTags(xml, "isInitialized", Boolean.TYPE);
        this.numStarts = XMLParser.extractObjectForTags(xml, "numStarts", Integer.TYPE);
        this.expPars = new double[this.pars.length];
        this.precompute();
    }

    @Override
    public String toString(NumberFormat nf) {
        return Arrays.toString(this.expPars);
    }
}

