/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery;

import de.jstacs.algorithms.optimization.ConstantStartDistance;
import de.jstacs.algorithms.optimization.DifferentiableFunction;
import de.jstacs.algorithms.optimization.NegativeDifferentiableFunction;
import de.jstacs.algorithms.optimization.Optimizer;
import de.jstacs.algorithms.optimization.StartDistanceForecaster;
import de.jstacs.algorithms.optimization.termination.AbstractTerminationCondition;
import de.jstacs.algorithms.optimization.termination.CombinedCondition;
import de.jstacs.algorithms.optimization.termination.IterationCondition;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.classifiers.differentiableSequenceScoreBased.DiffSSBasedOptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.data.DataSet;
import de.jstacs.data.RecyclableSequenceEnumerator;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.MotifDiscovererToolBox;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.motifDiscovery.SignificantMotifOccurrencesFinder;
import de.jstacs.motifDiscovery.history.History;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.SafeOutputStream;
import java.io.OutputStream;
import java.util.Arrays;

public final class MutableMotifDiscovererToolbox
extends MotifDiscovererToolBox {
    private static double pVal = 1.0E-4;
    private static double threshold = 0.8;
    private static AbstractTerminationCondition steps;
    private static final SafeOutputStream DISCARD_OUT;
    private static final int NUMBER_OF_PERMUTATIONS = 1000;

    static {
        try {
            steps = new IterationCondition(10);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        DISCARD_OUT = SafeOutputStream.getSafeOutputStream(null);
    }

    public static Sequence enumerate(DifferentiableSequenceScore[] funs, int classIndex, int motifIndex, RecyclableSequenceEnumerator rse, double weight, DiffSSBasedOptimizableFunction opt, OutputStream out) throws Exception {
        return MutableMotifDiscovererToolbox.enumerate(funs, new int[]{classIndex}, new int[]{motifIndex}, new RecyclableSequenceEnumerator[]{rse}, weight, opt, out)[0];
    }

    public static Sequence[] enumerate(DifferentiableSequenceScore[] funs, int[] classIndex, int[] motifIndex, RecyclableSequenceEnumerator[] rse, double weight, DiffSSBasedOptimizableFunction opt, OutputStream out) throws Exception {
        DataSet[] data = opt.getData();
        double[][] dataWeights = opt.getSequenceWeights();
        int num = 0;
        Object[] seq = new Sequence[classIndex.length];
        Object[] bestSeq = new Sequence[classIndex.length];
        DataSet[] s = new DataSet[classIndex.length];
        boolean[] adjust = new boolean[funs.length];
        Arrays.fill(adjust, false);
        int i = 0;
        while (i < classIndex.length) {
            adjust[classIndex[i]] = true;
            ++i;
        }
        MutableMotifDiscoverer[] mmd = new MutableMotifDiscoverer[funs.length];
        i = 0;
        while (i < funs.length) {
            mmd[i] = adjust[i] ? (MutableMotifDiscoverer)((Object)funs[i]) : null;
            ++i;
        }
        int[] len = new int[classIndex.length];
        i = 0;
        while (i < classIndex.length) {
            len[i] = mmd[classIndex[i]].getMotifLength(motifIndex[i]);
            rse[i].reset();
            seq[i] = (Sequence)rse[i].nextElement();
            s[i] = new DataSet("data set " + i, seq[i]);
            ++i;
        }
        int idx = classIndex.length - 1;
        double best = Double.NEGATIVE_INFINITY;
        double[][] weights = new double[motifIndex.length][];
        Arrays.fill((Object[])weights, new double[]{weight});
        while (true) {
            MutableMotifDiscovererToolbox.initMotif(idx, classIndex, motifIndex, s, weights, adjust, mmd, len, data, dataWeights);
            opt.reset();
            double[] pars = opt.getParameters(OptimizableFunction.KindOfParameter.PLUGIN);
            double curr = opt.evaluateFunction(pars);
            out.write((String.valueOf(num++) + "\t" + Arrays.toString(seq) + "\t" + curr + "\n").getBytes());
            if (curr > best) {
                best = curr;
                System.arraycopy(seq, 0, bestSeq, 0, seq.length);
            }
            idx = 0;
            while (idx < rse.length && !rse[idx].hasMoreElements()) {
                rse[idx].reset();
                seq[idx] = (Sequence)rse[idx].nextElement();
                s[idx] = new DataSet("data set " + idx, new Sequence[]{seq[idx]});
                ++idx;
            }
            if (idx >= rse.length) break;
            seq[idx] = (Sequence)rse[idx].nextElement();
            s[idx] = new DataSet("data set " + idx, new Sequence[]{seq[idx]});
        }
        out.write(("best: " + Arrays.toString(bestSeq) + " " + best + "\n").getBytes());
        i = 0;
        while (i < classIndex.length) {
            s[i] = new DataSet("data set " + i, new Sequence[]{bestSeq[i]});
            ++i;
        }
        MutableMotifDiscovererToolbox.initMotif(classIndex.length - 1, classIndex, motifIndex, s, weights, adjust, mmd, len, data, dataWeights);
        return bestSeq;
    }

    public static void initMotif(int idx, int[] classIndex, int[] motifIndex, DataSet[] s, double[][] seqWeights, boolean[] adjust, MutableMotifDiscoverer[] mmd, int[] len, DataSet[] data, double[][] dataWeights) throws Exception {
        int i = 0;
        while (i <= idx) {
            int sl = s[i].getElementLength();
            if (sl > len[i]) {
                throw new WrongLengthException(sl);
            }
            if (sl < len[i]) {
                mmd[classIndex[i]].modifyMotif(motifIndex[i], 0, sl - len[i]);
            }
            mmd[classIndex[i]].initializeMotif(motifIndex[i], s[i], seqWeights[i]);
            if (sl < len[i]) {
                mmd[classIndex[i]].modifyMotif(motifIndex[i], -((int)Math.floor((double)(len[i] - sl) / 2.0)), (int)Math.ceil((double)(len[i] - sl) / 2.0));
            }
            ++i;
        }
        i = 0;
        while (i < adjust.length) {
            if (adjust[i]) {
                mmd[classIndex[i]].adjustHiddenParameters(classIndex[i], data, dataWeights);
            }
            ++i;
        }
    }

    public static ComparableElement<double[], Double>[] getSortedInitialParameters(DifferentiableSequenceScore[] funs, InitMethodForDiffSM[] init, DiffSSBasedOptimizableFunction opt, int n, OutputStream stream, int optimizationSteps) throws Exception {
        SafeOutputStream info = SafeOutputStream.getSafeOutputStream(stream);
        DataSet[] data = opt.getData();
        double[][] oldParams = new double[funs.length][];
        int j = 0;
        while (j < funs.length) {
            if (init[j] == InitMethodForDiffSM.NOTHING) {
                oldParams[j] = funs[j].getCurrentParameterValues();
            }
            ++j;
        }
        Object[] erg = new ComparableElement[n];
        ConstantStartDistance cs = new ConstantStartDistance(1.0);
        SafeOutputStream out = SafeOutputStream.getSafeOutputStream(null);
        NegativeDifferentiableFunction nOpt = new NegativeDifferentiableFunction(opt);
        IterationCondition condition = new IterationCondition(optimizationSteps);
        int i = 0;
        while (i < n) {
            int j2 = 0;
            while (j2 < funs.length) {
                switch (init[j2]) {
                    case PLUG_IN: {
                        funs[j2].initializeFunction(j2, false, data, null);
                        break;
                    }
                    case MOTIF_RANDOMLY: {
                        if (!(funs[j2] instanceof MutableMotifDiscoverer)) break;
                        MutableMotifDiscoverer mmd = (MutableMotifDiscoverer)((Object)funs[j2]);
                        int m = mmd.getNumberOfMotifs();
                        int k = 0;
                        while (k < m) {
                            mmd.initializeMotifRandomly(k);
                            ++k;
                        }
                        break;
                    }
                    case RANDOMLY: {
                        funs[j2].initializeFunctionRandomly(false);
                        break;
                    }
                    case NOTHING: {
                        funs[j2].setParameters(oldParams[j2], 0);
                    }
                }
                ++j2;
            }
            opt.reset();
            double[] params = opt.getParameters(OptimizableFunction.KindOfParameter.PLUGIN);
            if (optimizationSteps > 0) {
                Optimizer.optimize((byte)10, nOpt, params, condition, 1.0E-10, cs, out);
            }
            double c = opt.evaluateFunction(params);
            info.writeln(String.valueOf(i) + "\t" + c);
            erg[i] = new ComparableElement<double[], Double>(params, c);
            ++i;
        }
        Arrays.sort(erg);
        info.writeln("interval [" + ((ComparableElement)erg[0]).getWeight() + " .. " + ((ComparableElement)erg[n - 1]).getWeight() + "]");
        return erg;
    }

    public static int[][] createMinimalNewLengthArray(DifferentiableSequenceScore[] funs) {
        int[][] minimalNewLength = new int[funs.length][];
        int j = 0;
        while (j < funs.length) {
            if (funs[j] instanceof MutableMotifDiscoverer) {
                MutableMotifDiscoverer disc = (MutableMotifDiscoverer)((Object)funs[j]);
                minimalNewLength[j] = new int[disc.getNumberOfMotifs()];
                int i = 0;
                while (i < minimalNewLength[j].length) {
                    minimalNewLength[j][i] = disc.getMotifLength(i);
                    ++i;
                }
            }
            ++j;
        }
        return minimalNewLength;
    }

    public static History[][] createHistoryArray(DifferentiableSequenceScore[] funs, History template) throws CloneNotSupportedException {
        History[][] history = new History[funs.length][];
        int j = 0;
        while (j < funs.length) {
            if (funs[j] instanceof MutableMotifDiscoverer) {
                history[j] = new History[((MutableMotifDiscoverer)((Object)funs[j])).getNumberOfMotifs()];
                if (template != null) {
                    int i = 0;
                    while (i < history[j].length) {
                        history[j][i] = template.clone();
                        ++i;
                    }
                }
            }
            ++j;
        }
        return history;
    }

    public static void clearHistoryArray(History[][] history) {
        int j = 0;
        while (j < history.length) {
            if (history[j] != null) {
                int i = 0;
                while (i < history[j].length) {
                    if (history[j][i] != null) {
                        history[j][i].clear();
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public static double[][] optimize(DifferentiableSequenceScore[] funs, DiffSSBasedOptimizableFunction opt, byte algorithm, AbstractTerminationCondition condition, double linEps, StartDistanceForecaster startDistance, SafeOutputStream out, boolean breakOnChanged, History template, OptimizableFunction.KindOfParameter plugIn, boolean maxPos) throws Exception {
        return MutableMotifDiscovererToolbox.optimize(funs, opt, algorithm, condition, linEps, startDistance, out, breakOnChanged, MutableMotifDiscovererToolbox.createHistoryArray(funs, template), MutableMotifDiscovererToolbox.createMinimalNewLengthArray(funs), plugIn, maxPos);
    }

    public static double[][] optimize(DifferentiableSequenceScore[] funs, DiffSSBasedOptimizableFunction opt, byte algorithm, AbstractTerminationCondition condition, double linEps, StartDistanceForecaster startDistance, SafeOutputStream out, boolean breakOnChanged, History[][] hist, int[][] minimalNewLength, OptimizableFunction.KindOfParameter plugIn, boolean maxPos) throws Exception {
        NegativeDifferentiableFunction neg = new NegativeDifferentiableFunction(opt);
        DifferentiableSequenceScore[] best = null;
        double[] classParams = null;
        DataSet[] data = opt.getData();
        double[][] weights = opt.getSequenceWeights();
        double bestVal = Double.NEGATIVE_INFINITY;
        do {
            opt.reset();
            startDistance.reset();
            double[] params = opt.getParameters(plugIn);
            plugIn = OptimizableFunction.KindOfParameter.LAST;
            Optimizer.optimize(algorithm, neg, params, condition, linEps, startDistance, out);
            double current = opt.evaluateFunction(params);
            if (current > bestVal) {
                best = null;
                System.gc();
                best = (DifferentiableSequenceScore[])ArrayHandler.clone((Cloneable[])funs);
                bestVal = current;
                classParams = opt.getClassParams(params);
            }
            if (!(condition instanceof SmallDifferenceOfFunctionEvaluationsCondition)) continue;
            condition = new CombinedCondition(1, condition, steps);
        } while (MutableMotifDiscovererToolbox.doHeuristicSteps(funs, data, weights, opt, neg, algorithm, linEps, startDistance, out, breakOnChanged, hist, minimalNewLength, maxPos));
        int k = 0;
        while (k < funs.length) {
            funs[k] = best[k];
            ++k;
        }
        return new double[][]{{bestVal}, classParams};
    }

    public static boolean doHeuristicSteps(DifferentiableSequenceScore[] funs, DataSet[] data, double[][] weights, DiffSSBasedOptimizableFunction opt, DifferentiableFunction neg, byte algorithm, double linEps, StartDistanceForecaster startDistance, SafeOutputStream out, boolean breakOnChanged, History[][] hist, int[][] minimalNewLength, boolean maxPos) throws Exception {
        boolean changed = false;
        int k = 0;
        while (!(k >= funs.length || changed && breakOnChanged)) {
            if (funs[k] instanceof MutableMotifDiscoverer && ((MutableMotifDiscoverer)((Object)funs[k])).getNumberOfMotifs() > 0) {
                double normOld;
                DifferentiableStatisticalModel nsf;
                out.writeln("MutableMotifDiscoverer " + k + ":\n" + funs[k].toString());
                if (funs[k] instanceof DifferentiableStatisticalModel) {
                    nsf = (DifferentiableStatisticalModel)funs[k];
                    normOld = nsf.getLogNormalizationConstant();
                } else {
                    nsf = null;
                    normOld = 0.0;
                }
                MutableMotifDiscoverer currMD = (MutableMotifDiscoverer)((Object)funs[k]);
                int numMotifs = currMD.getNumberOfMotifs();
                boolean changedThisOne = false;
                int l = 0;
                while (!(l >= numMotifs || changedThisOne && breakOnChanged)) {
                    if (hist[k][l] != null) {
                        changedThisOne |= MutableMotifDiscovererToolbox.findModification(k, l, currMD, funs, data, weights, opt, neg, algorithm, linEps, startDistance, out, hist[k][l], minimalNewLength[k][l], maxPos);
                    }
                    ++l;
                }
                if (changedThisOne) {
                    changed = true;
                    if (nsf != null) {
                        double normNew = nsf.getLogNormalizationConstant();
                        opt.addTermToClassParameter(k, normOld - normNew);
                    }
                }
            }
            ++k;
        }
        return changed;
    }

    public static boolean findModification(int clazz, int motif, MutableMotifDiscoverer mmd, DifferentiableSequenceScore[] score, DataSet[] data, double[][] weights, DiffSSBasedOptimizableFunction opt, DifferentiableFunction neg, byte algo, double linEps, StartDistanceForecaster startDistance, SafeOutputStream out, History hist, int minimalNewLength, boolean maxPos) throws Exception {
        double[] params = opt.getParameters(OptimizableFunction.KindOfParameter.LAST);
        int len = mmd.getMotifLength(motif) / 2;
        DataSet[] dataSetArray = new DataSet[2];
        dataSetArray[0] = data[clazz];
        DataSet[] my = dataSetArray;
        double[][] dArrayArray = new double[2][];
        dArrayArray[0] = weights[clazz];
        double[][] myWeights = dArrayArray;
        if (data.length > 2) {
            boolean[] in = new boolean[data.length];
            Arrays.fill(in, true);
            in[clazz] = false;
            my[1] = DataSet.union(data, in);
            int anz = 0;
            int i = 0;
            while (i < data.length) {
                if (in[i]) {
                    anz += data[i].getNumberOfElements();
                }
                ++i;
            }
            myWeights[1] = new double[anz];
            anz = 0;
            int i2 = 0;
            while (i2 < data.length) {
                if (in[i2]) {
                    int n = data[i2].getNumberOfElements();
                    if (weights[i2] != null) {
                        System.arraycopy(weights[i2], 0, myWeights[1], anz, n);
                    } else {
                        Arrays.fill((Object[])myWeights, anz, anz + n, (Object)1.0);
                    }
                    anz += n;
                }
                ++i2;
            }
        } else {
            my[1] = data[1 - clazz];
            myWeights[1] = weights[1 - clazz];
        }
        SignificantMotifOccurrencesFinder smof = my[1] != null ? new SignificantMotifOccurrencesFinder(mmd, my[1], myWeights[1], pVal) : new SignificantMotifOccurrencesFinder((MotifDiscoverer)mmd, SignificantMotifOccurrencesFinder.RandomSeqType.PERMUTED, true, 1000, pVal);
        double current = smof.getNumberOfBoundSequences(my[0], myWeights[0], motif);
        out.writeln("optimized predicted bound sequences: " + current);
        out.writeln("====================================");
        int[] notSignif = new int[2];
        out.writeln("shift downstream");
        notSignif[0] = MutableMotifDiscovererToolbox.heuristic(clazz, motif, len, 1, my, myWeights, opt, neg, algo, linEps, startDistance, params, score, current, out, maxPos);
        out.writeln();
        out.writeln("shift upstream");
        notSignif[1] = MutableMotifDiscovererToolbox.heuristic(clazz, motif, len, -1, my, myWeights, opt, neg, algo, linEps, startDistance, params, score, current, out, maxPos);
        out.writeln();
        out.writeln("not significant: " + Arrays.toString(notSignif));
        boolean modified = MutableMotifDiscovererToolbox.modify(notSignif, mmd, clazz, motif, hist, minimalNewLength, out);
        if (modified) {
            opt.reset();
        }
        return modified;
    }

    private static int heuristic(int clazz, int motif, int len, int direction, DataSet[] data, double[][] weights, DiffSSBasedOptimizableFunction test, DifferentiableFunction neg, byte algo, double linEps, StartDistanceForecaster startDistance, double[] params, DifferentiableSequenceScore[] score, double pred, SafeOutputStream out, boolean maxPos) throws Exception {
        int dir2;
        test.setParams(params);
        MutableMotifDiscoverer mmd = (MutableMotifDiscoverer)((Object)score[clazz]);
        double normOld = Double.NEGATIVE_INFINITY;
        double[] val = new double[len];
        int dir1 = dir2 = direction;
        if (direction > 0) {
            dir1 = direction;
        } else {
            dir2 = direction;
        }
        int i = 1;
        while (i <= len) {
            if (score[clazz] instanceof DifferentiableStatisticalModel) {
                normOld = ((DifferentiableStatisticalModel)score[clazz]).getLogNormalizationConstant();
            }
            if (mmd.modifyMotif(motif, i * dir1, i * dir2)) {
                if (score[clazz] instanceof DifferentiableStatisticalModel) {
                    test.addTermToClassParameter(0, normOld - ((DifferentiableStatisticalModel)score[clazz]).getLogNormalizationConstant());
                }
                test.reset();
                double[] params_copy = test.getParameters(OptimizableFunction.KindOfParameter.LAST);
                Optimizer.optimize(algo, neg, params_copy, steps, linEps, startDistance, DISCARD_OUT);
                test.setParams(params_copy);
                SignificantMotifOccurrencesFinder smof = data.length > 1 && data[1] != null ? new SignificantMotifOccurrencesFinder(mmd, data[1], weights[1], pVal) : new SignificantMotifOccurrencesFinder((MotifDiscoverer)mmd, SignificantMotifOccurrencesFinder.RandomSeqType.PERMUTED, true, 1000, pVal);
                val[i - 1] = smof.getNumberOfBoundSequences(data[0], weights[0], motif);
                mmd.modifyMotif(motif, -i * dir1, -i * dir2);
                test.reset();
                test.setParams(params);
            } else {
                val[i - 1] = 0.0;
            }
            out.writeln(String.valueOf(i) + "\t" + val[i - 1]);
            ++i;
        }
        if (!maxPos) {
            i = 0;
            while (i < val.length && val[i] >= pred * threshold) {
                ++i;
            }
            --i;
        } else {
            i = -1;
            double max = pred * threshold;
            int j = 0;
            while (j < val.length) {
                if (val[j] >= max) {
                    max = val[j];
                    i = j;
                }
                ++j;
            }
        }
        return i + 1;
    }

    private static boolean modify(int[] notSignif, MutableMotifDiscoverer md, int clazz, int motif, History hist, int minimalNewLength, SafeOutputStream out) throws Exception {
        boolean modified = false;
        int sum = notSignif[0] + notSignif[1];
        int ml = md.getMotifLength(motif);
        int[] modification = new int[2];
        if (sum > 0) {
            if (sum < ml) {
                modification[0] = notSignif[0] >= notSignif[1] ? notSignif[0] : -notSignif[1];
                modification[1] = modification[0];
                if (hist.operationAllowed(modification)) {
                    modified = md.modifyMotif(motif, modification[0], modification[1]);
                }
            }
            if (!modified) {
                if (sum < ml) {
                    modification[0] = notSignif[0];
                    modification[1] = -notSignif[1];
                } else {
                    modification[0] = 0;
                    modification[1] = 1 - md.getMotifLength(motif);
                }
                if (modification[0] != modification[1] && hist.operationAllowed(modification)) {
                    modified = md.modifyMotif(motif, modification[0], modification[1]);
                }
            }
        } else {
            if (md.getMotifLength(motif) < minimalNewLength) {
                modification[0] = 0;
                modification[1] = minimalNewLength - md.getMotifLength(motif);
                if (!hist.operationAllowed(modification)) {
                    modification[0] = -(minimalNewLength - md.getMotifLength(motif));
                    modification[1] = 0;
                }
            } else {
                modification[0] = -1;
                modification[1] = 1;
            }
            if (hist.operationAllowed(modification)) {
                modified = md.modifyMotif(motif, modification[0], modification[1]);
            }
        }
        if (modified) {
            hist.operationPerfomed(modification);
            out.writeln("class " + clazz + ": modified motif " + motif + " => " + Arrays.toString(modification));
        }
        return modified;
    }

    public static enum InitMethodForDiffSM {
        PLUG_IN,
        MOTIF_RANDOMLY,
        RANDOMLY,
        NOTHING;

    }
}

