import { ApiObject, GroupVersionKind } from 'cdk8s';
import { Construct } from 'constructs';
import * as k8s from './imports/k8s';
export * as k8s from './imports/k8s';
export declare type Item = any;
export declare type Amount = number;
/**
 * @stability stable
 */
export interface GoogleProtobufAny {
    /**
     * @stability stable
     */
    readonly typeUrl?: string;
    /**
     * @stability stable
     */
    readonly value?: string;
}
/**
 * @stability stable
 */
export interface GrpcGatewayRuntimeError {
    /**
     * @stability stable
     */
    readonly code?: number;
    /**
     * @stability stable
     */
    readonly details?: GoogleProtobufAny[];
    /**
     * @stability stable
     */
    readonly error?: string;
    /**
     * @stability stable
     */
    readonly message?: string;
}
/**
 * @stability stable
 */
export interface GrpcGatewayRuntimeStreamError {
    /**
     * @stability stable
     */
    readonly details?: GoogleProtobufAny[];
    /**
     * @stability stable
     */
    readonly grpcCode?: number;
    /**
     * @stability stable
     */
    readonly httpCode?: number;
    /**
     * @stability stable
     */
    readonly httpStatus?: string;
    /**
     * @stability stable
     */
    readonly message?: string;
}
/**
 * @stability stable
 */
export interface ArchiveStrategy {
    /**
     * @stability stable
     */
    readonly none?: NoneStrategy;
    /**
     * @stability stable
     */
    readonly tar?: TarStrategy;
    /**
     * @stability stable
     */
    readonly zip?: ZipStrategy;
}
/**
 * @stability stable
 */
export interface ArchivedWorkflowDeletedResponse {
}
/**
 * @stability stable
 */
export interface Arguments {
    /**
     * @stability stable
     */
    readonly artifacts?: Artifact[];
    /**
     * @stability stable
     */
    readonly parameters?: Parameter[];
}
/**
 * @stability stable
 */
export interface Artifact {
    /**
     * @stability stable
     */
    readonly archive?: ArchiveStrategy;
    /**
     * @stability stable
     */
    readonly archiveLogs?: boolean;
    /**
     * @stability stable
     */
    readonly artifactory?: ArtifactoryArtifact;
    /**
     * @stability stable
     */
    readonly from?: string;
    /**
     * @stability stable
     */
    readonly fromExpression?: string;
    /**
     * @stability stable
     */
    readonly gcs?: GCSArtifact;
    /**
     * @stability stable
     */
    readonly git?: GitArtifact;
    /**
     * @stability stable
     */
    readonly globalName?: string;
    /**
     * @stability stable
     */
    readonly hdfs?: HDFSArtifact;
    /**
     * @stability stable
     */
    readonly http?: HTTPArtifact;
    /**
     * @stability stable
     */
    readonly mode?: number;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly optional?: boolean;
    /**
     * @stability stable
     */
    readonly oss?: OSSArtifact;
    /**
     * @stability stable
     */
    readonly path?: string;
    /**
     * @stability stable
     */
    readonly raw?: RawArtifact;
    /**
     * @stability stable
     */
    readonly recurseMode?: boolean;
    /**
     * @stability stable
     */
    readonly s3?: S3Artifact;
    /**
     * @stability stable
     */
    readonly subPath?: string;
}
/**
 * @stability stable
 */
export interface ArtifactLocation {
    /**
     * @stability stable
     */
    readonly archiveLogs?: boolean;
    /**
     * @stability stable
     */
    readonly artifactory?: ArtifactoryArtifact;
    /**
     * @stability stable
     */
    readonly gcs?: GCSArtifact;
    /**
     * @stability stable
     */
    readonly git?: GitArtifact;
    /**
     * @stability stable
     */
    readonly hdfs?: HDFSArtifact;
    /**
     * @stability stable
     */
    readonly http?: HTTPArtifact;
    /**
     * @stability stable
     */
    readonly oss?: OSSArtifact;
    /**
     * @stability stable
     */
    readonly raw?: RawArtifact;
    /**
     * @stability stable
     */
    readonly s3?: S3Artifact;
}
/**
 * @stability stable
 */
export interface ArtifactPaths {
    /**
     * @stability stable
     */
    readonly archive?: ArchiveStrategy;
    /**
     * @stability stable
     */
    readonly archiveLogs?: boolean;
    /**
     * @stability stable
     */
    readonly artifactory?: ArtifactoryArtifact;
    /**
     * @stability stable
     */
    readonly from?: string;
    /**
     * @stability stable
     */
    readonly fromExpression?: string;
    /**
     * @stability stable
     */
    readonly gcs?: GCSArtifact;
    /**
     * @stability stable
     */
    readonly git?: GitArtifact;
    /**
     * @stability stable
     */
    readonly globalName?: string;
    /**
     * @stability stable
     */
    readonly hdfs?: HDFSArtifact;
    /**
     * @stability stable
     */
    readonly http?: HTTPArtifact;
    /**
     * @stability stable
     */
    readonly mode?: number;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly optional?: boolean;
    /**
     * @stability stable
     */
    readonly oss?: OSSArtifact;
    /**
     * @stability stable
     */
    readonly path?: string;
    /**
     * @stability stable
     */
    readonly raw?: RawArtifact;
    /**
     * @stability stable
     */
    readonly recurseMode?: boolean;
    /**
     * @stability stable
     */
    readonly s3?: S3Artifact;
    /**
     * @stability stable
     */
    readonly subPath?: string;
}
/**
 * @stability stable
 */
export interface ArtifactRepositoryRef {
    /**
     * @stability stable
     */
    readonly configMap?: string;
    /**
     * @stability stable
     */
    readonly key?: string;
}
/**
 * @stability stable
 */
export interface ArtifactRepositoryRefStatus {
    /**
     * @stability stable
     */
    readonly configMap?: string;
    /**
     * @stability stable
     */
    readonly default?: boolean;
    /**
     * @stability stable
     */
    readonly key?: string;
    /**
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export interface ArtifactoryArtifact {
    /**
     * @stability stable
     */
    readonly passwordSecret?: k8s.SecretKeySelector;
    /**
     * @stability stable
     */
    readonly url: string;
    /**
     * @stability stable
     */
    readonly usernameSecret?: k8s.SecretKeySelector;
}
/**
 * @stability stable
 */
export interface Backoff {
    /**
     * @stability stable
     */
    readonly duration?: string;
    /**
     * @stability stable
     */
    readonly factor?: k8s.IntOrString;
    /**
     * @stability stable
     */
    readonly maxDuration?: string;
}
/**
 * @stability stable
 */
export interface Cache {
    /**
     * @stability stable
     */
    readonly configMap: k8s.ConfigMapKeySelector;
}
/**
 * @stability stable
 */
export interface ClusterWorkflowTemplate {
    /**
     * @stability stable
     */
    readonly apiVersion?: string;
    /**
     * @stability stable
     */
    readonly kind?: string;
    /**
     * @stability stable
     */
    readonly metadata: k8s.ObjectMeta;
    /**
     * @stability stable
     */
    readonly spec: WorkflowTemplateSpec;
}
/**
 * @stability stable
 */
export interface ClusterWorkflowTemplateDeleteResponse {
}
/**
 * @stability stable
 */
export interface ClusterWorkflowTemplateLintRequest {
    /**
     * @stability stable
     */
    readonly createOptions?: k8s.CreateOptions;
    /**
     * @stability stable
     */
    readonly template?: ClusterWorkflowTemplate;
}
/**
 * @stability stable
 */
export interface ClusterWorkflowTemplateList {
    /**
     * @stability stable
     */
    readonly apiVersion?: string;
    /**
     * @stability stable
     */
    readonly items: ClusterWorkflowTemplate[];
    /**
     * @stability stable
     */
    readonly kind?: string;
    /**
     * @stability stable
     */
    readonly metadata: k8s.ListMeta;
}
/**
 * @stability stable
 */
export interface ClusterWorkflowTemplateUpdateRequest {
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly template?: ClusterWorkflowTemplate;
}
/**
 * @stability stable
 */
export interface Condition {
    /**
     * @stability stable
     */
    readonly message?: string;
    /**
     * @stability stable
     */
    readonly status?: string;
    /**
     * @stability stable
     */
    readonly type?: string;
}
/**
 * @stability stable
 */
export interface ContainerNode {
    /**
     * @stability stable
     */
    readonly args?: string[];
    /**
     * @stability stable
     */
    readonly command?: string[];
    /**
     * @stability stable
     */
    readonly dependencies?: string[];
    /**
     * @stability stable
     */
    readonly env?: k8s.EnvVar[];
    /**
     * @stability stable
     */
    readonly envFrom?: k8s.EnvFromSource[];
    /**
     * @stability stable
     */
    readonly image?: string;
    /**
     * @stability stable
     */
    readonly imagePullPolicy?: string;
    /**
     * @stability stable
     */
    readonly lifecycle?: k8s.Lifecycle;
    /**
     * @stability stable
     */
    readonly livenessProbe?: k8s.Probe;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly ports?: k8s.ContainerPort[];
    /**
     * @stability stable
     */
    readonly readinessProbe?: k8s.Probe;
    /**
     * @stability stable
     */
    readonly resources?: k8s.ResourceRequirements;
    /**
     * @stability stable
     */
    readonly securityContext?: k8s.SecurityContext;
    /**
     * @stability stable
     */
    readonly startupProbe?: k8s.Probe;
    /**
     * @stability stable
     */
    readonly stdin?: boolean;
    /**
     * @stability stable
     */
    readonly stdinOnce?: boolean;
    /**
     * @stability stable
     */
    readonly terminationMessagePath?: string;
    /**
     * @stability stable
     */
    readonly terminationMessagePolicy?: string;
    /**
     * @stability stable
     */
    readonly tty?: boolean;
    /**
     * @stability stable
     */
    readonly volumeDevices?: k8s.VolumeDevice[];
    /**
     * @stability stable
     */
    readonly volumeMounts?: k8s.VolumeMount[];
    /**
     * @stability stable
     */
    readonly workingDir?: string;
}
/**
 * @stability stable
 */
export interface ContainerSetTemplate {
    /**
     * @stability stable
     */
    readonly containers: ContainerNode[];
    /**
     * @stability stable
     */
    readonly volumeMounts?: k8s.VolumeMount[];
}
/**
 * @stability stable
 */
export interface ContinueOn {
    /**
     * @stability stable
     */
    readonly error?: boolean;
    /**
     * @stability stable
     */
    readonly failed?: boolean;
}
/**
 * @stability stable
 */
export interface Counter {
    /**
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface CreateCronWorkflowRequest {
    /**
     * @stability stable
     */
    readonly createOptions?: k8s.CreateOptions;
    /**
     * @stability stable
     */
    readonly cronWorkflow?: CronWorkflow;
    /**
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export interface CreateS3BucketOptions {
    /**
     * @stability stable
     */
    readonly objectLocking?: boolean;
}
/**
 * @stability stable
 */
export interface CronWorkflow {
    /**
     * @stability stable
     */
    readonly metadata: k8s.ObjectMeta;
    /**
     * @stability stable
     */
    readonly spec: CronWorkflowSpec;
    /**
     * @stability stable
     */
    readonly status?: CronWorkflowStatus;
}
/**
 * @stability stable
 */
export interface CronWorkflowDeletedResponse {
}
/**
 * @stability stable
 */
export interface CronWorkflowList {
    /**
     * @stability stable
     */
    readonly apiVersion?: string;
    /**
     * @stability stable
     */
    readonly items: CronWorkflow[];
    /**
     * @stability stable
     */
    readonly kind?: string;
    /**
     * @stability stable
     */
    readonly metadata: k8s.ListMeta;
}
/**
 * @stability stable
 */
export interface CronWorkflowResumeRequest {
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export interface CronWorkflowSpec {
    /**
     * @stability stable
     */
    readonly concurrencyPolicy?: string;
    /**
     * @stability stable
     */
    readonly failedJobsHistoryLimit?: number;
    /**
     * @stability stable
     */
    readonly schedule: string;
    /**
     * @stability stable
     */
    readonly startingDeadlineSeconds?: number;
    /**
     * @stability stable
     */
    readonly successfulJobsHistoryLimit?: number;
    /**
     * @stability stable
     */
    readonly suspend?: boolean;
    /**
     * @stability stable
     */
    readonly timezone?: string;
    /**
     * @stability stable
     */
    readonly workflowMetadata?: k8s.ObjectMeta;
    /**
     * @stability stable
     */
    readonly workflowSpec: WorkflowSpec;
}
/**
 * @stability stable
 */
export interface CronWorkflowStatus {
    /**
     * @stability stable
     */
    readonly active: k8s.ObjectReference[];
    /**
     * @stability stable
     */
    readonly conditions: Condition[];
    /**
     * @stability stable
     */
    readonly lastScheduledTime: Date;
}
/**
 * @stability stable
 */
export interface CronWorkflowSuspendRequest {
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export interface DAGTask {
    /**
     * @stability stable
     */
    readonly arguments?: Arguments;
    /**
     * @stability stable
     */
    readonly continueOn?: ContinueOn;
    /**
     * @stability stable
     */
    readonly dependencies?: string[];
    /**
     * @stability stable
     */
    readonly depends?: string;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly onExit?: string;
    /**
     * @stability stable
     */
    readonly template?: string;
    /**
     * @stability stable
     */
    readonly templateRef?: TemplateRef;
    /**
     * @stability stable
     */
    readonly when?: string;
    /**
     * @stability stable
     */
    readonly withItems?: Item[];
    /**
     * @stability stable
     */
    readonly withParam?: string;
    /**
     * @stability stable
     */
    readonly withSequence?: Sequence;
}
/**
 * @stability stable
 */
export interface DAGTemplate {
    /**
     * @stability stable
     */
    readonly failFast?: boolean;
    /**
     * @stability stable
     */
    readonly target?: string;
    /**
     * @stability stable
     */
    readonly tasks: DAGTask[];
}
/**
 * @stability stable
 */
export interface Data {
    /**
     * @stability stable
     */
    readonly source: DataSource;
    /**
     * @stability stable
     */
    readonly transformation: TransformationStep[];
}
/**
 * @stability stable
 */
export interface DataSource {
    /**
     * @stability stable
     */
    readonly artifactPaths?: ArtifactPaths;
}
/**
 * @stability stable
 */
export interface Event {
    /**
     * @stability stable
     */
    readonly selector: string;
}
/**
 * @stability stable
 */
export interface EventResponse {
}
/**
 * @stability stable
 */
export interface ExecutorConfig {
    /**
     * @stability stable
     */
    readonly serviceAccountName?: string;
}
/**
 * @stability stable
 */
export interface GCSArtifact {
    /**
     * @stability stable
     */
    readonly bucket?: string;
    /**
     * @stability stable
     */
    readonly key: string;
    /**
     * @stability stable
     */
    readonly serviceAccountKeySecret?: k8s.SecretKeySelector;
}
/**
 * @stability stable
 */
export interface Gauge {
    /**
     * @stability stable
     */
    readonly realtime: boolean;
    /**
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface GetUserInfoResponse {
    /**
     * @stability stable
     */
    readonly email?: string;
    /**
     * @stability stable
     */
    readonly emailVerified?: boolean;
    /**
     * @stability stable
     */
    readonly groups?: string[];
    /**
     * @stability stable
     */
    readonly issuer?: string;
    /**
     * @stability stable
     */
    readonly serviceAccountName?: string;
    /**
     * @stability stable
     */
    readonly subject?: string;
}
/**
 * @stability stable
 */
export interface GitArtifact {
    /**
     * @stability stable
     */
    readonly depth?: number;
    /**
     * @stability stable
     */
    readonly fetch?: string[];
    /**
     * @stability stable
     */
    readonly insecureIgnoreHostKey?: boolean;
    /**
     * @stability stable
     */
    readonly passwordSecret?: k8s.SecretKeySelector;
    /**
     * @stability stable
     */
    readonly repo: string;
    /**
     * @stability stable
     */
    readonly revision?: string;
    /**
     * @stability stable
     */
    readonly sshPrivateKeySecret?: k8s.SecretKeySelector;
    /**
     * @stability stable
     */
    readonly usernameSecret?: k8s.SecretKeySelector;
}
/**
 * @stability stable
 */
export interface HDFSArtifact {
    /**
     * @stability stable
     */
    readonly addresses?: string[];
    /**
     * @stability stable
     */
    readonly force?: boolean;
    /**
     * @stability stable
     */
    readonly hdfsUser?: string;
    /**
     * @stability stable
     */
    readonly krbCCacheSecret?: k8s.SecretKeySelector;
    /**
     * @stability stable
     */
    readonly krbConfigConfigMap?: k8s.ConfigMapKeySelector;
    /**
     * @stability stable
     */
    readonly krbKeytabSecret?: k8s.SecretKeySelector;
    /**
     * @stability stable
     */
    readonly krbRealm?: string;
    /**
     * @stability stable
     */
    readonly krbServicePrincipalName?: string;
    /**
     * @stability stable
     */
    readonly krbUsername?: string;
    /**
     * @stability stable
     */
    readonly path: string;
}
/**
 * @stability stable
 */
export interface HTTPArtifact {
    /**
     * @stability stable
     */
    readonly headers?: Header[];
    /**
     * @stability stable
     */
    readonly url: string;
}
/**
 * @stability stable
 */
export interface Header {
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface Histogram {
    /**
     * @stability stable
     */
    readonly buckets: Amount[];
    /**
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface InfoResponse {
    /**
     * @stability stable
     */
    readonly links?: Link[];
    /**
     * @stability stable
     */
    readonly managedNamespace?: string;
}
/**
 * @stability stable
 */
export interface Inputs {
    /**
     * @stability stable
     */
    readonly artifacts?: Artifact[];
    /**
     * @stability stable
     */
    readonly parameters?: Parameter[];
}
/**
 * @stability stable
 */
export interface Link {
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly scope: string;
    /**
     * @stability stable
     */
    readonly url: string;
}
/**
 * @stability stable
 */
export interface LintCronWorkflowRequest {
    /**
     * @stability stable
     */
    readonly cronWorkflow?: CronWorkflow;
    /**
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export interface LogEntry {
    /**
     * @stability stable
     */
    readonly content?: string;
    /**
     * @stability stable
     */
    readonly podName?: string;
}
/**
 * @stability stable
 */
export interface MemoizationStatus {
    /**
     * @stability stable
     */
    readonly cacheName: string;
    /**
     * @stability stable
     */
    readonly hit: boolean;
    /**
     * @stability stable
     */
    readonly key: string;
}
/**
 * @stability stable
 */
export interface Memoize {
    /**
     * @stability stable
     */
    readonly cache: Cache;
    /**
     * @stability stable
     */
    readonly key: string;
    /**
     * @stability stable
     */
    readonly maxAge: string;
}
/**
 * @stability stable
 */
export interface Metadata {
    /**
     * @stability stable
     */
    readonly annotations?: {
        [name: string]: string;
    };
    /**
     * @stability stable
     */
    readonly labels?: {
        [name: string]: string;
    };
}
/**
 * @stability stable
 */
export interface MetricLabel {
    /**
     * @stability stable
     */
    readonly key: string;
    /**
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface Metrics {
    /**
     * @stability stable
     */
    readonly prometheus: Prometheus[];
}
/**
 * @stability stable
 */
export interface Mutex {
    /**
     * @stability stable
     */
    readonly name?: string;
}
/**
 * @stability stable
 */
export interface MutexHolding {
    /**
     * @stability stable
     */
    readonly holder?: string;
    /**
     * @stability stable
     */
    readonly mutex?: string;
}
/**
 * @stability stable
 */
export interface MutexStatus {
    /**
     * @stability stable
     */
    readonly holding?: MutexHolding[];
    /**
     * @stability stable
     */
    readonly waiting?: MutexHolding[];
}
/**
 * @stability stable
 */
export interface NodeStatus {
    /**
     * @stability stable
     */
    readonly boundaryID?: string;
    /**
     * @stability stable
     */
    readonly children?: string[];
    /**
     * @stability stable
     */
    readonly daemoned?: boolean;
    /**
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * @stability stable
     */
    readonly estimatedDuration?: number;
    /**
     * @stability stable
     */
    readonly finishedAt?: Date;
    /**
     * @stability stable
     */
    readonly hostNodeName?: string;
    /**
     * @stability stable
     */
    readonly id: string;
    /**
     * @stability stable
     */
    readonly inputs?: Inputs;
    /**
     * @stability stable
     */
    readonly memoizationStatus?: MemoizationStatus;
    /**
     * @stability stable
     */
    readonly message?: string;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly outboundNodes?: string[];
    /**
     * @stability stable
     */
    readonly outputs?: Outputs;
    /**
     * @stability stable
     */
    readonly phase?: string;
    /**
     * @stability stable
     */
    readonly podIP?: string;
    /**
     * @stability stable
     */
    readonly progress?: string;
    /**
     * @stability stable
     */
    readonly resourcesDuration?: {
        [name: string]: number;
    };
    /**
     * @stability stable
     */
    readonly startedAt?: Date;
    /**
     * @stability stable
     */
    readonly synchronizationStatus?: NodeSynchronizationStatus;
    /**
     * @stability stable
     */
    readonly templateName?: string;
    /**
     * @stability stable
     */
    readonly templateRef?: TemplateRef;
    /**
     * @stability stable
     */
    readonly templateScope?: string;
    /**
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface NodeSynchronizationStatus {
    /**
     * @stability stable
     */
    readonly waiting?: string;
}
/**
 * @stability stable
 */
export interface NoneStrategy {
}
/**
 * @stability stable
 */
export interface OSSArtifact {
    /**
     * @stability stable
     */
    readonly accessKeySecret?: k8s.SecretKeySelector;
    /**
     * @stability stable
     */
    readonly bucket?: string;
    /**
     * @stability stable
     */
    readonly createBucketIfNotPresent?: boolean;
    /**
     * @stability stable
     */
    readonly endpoint?: string;
    /**
     * @stability stable
     */
    readonly key: string;
    /**
     * @stability stable
     */
    readonly secretKeySecret?: k8s.SecretKeySelector;
    /**
     * @stability stable
     */
    readonly securityToken?: string;
}
/**
 * @stability stable
 */
export interface Outputs {
    /**
     * @stability stable
     */
    readonly artifacts?: Artifact[];
    /**
     * @stability stable
     */
    readonly exitCode?: string;
    /**
     * @stability stable
     */
    readonly parameters?: Parameter[];
    /**
     * @stability stable
     */
    readonly result?: string;
}
export declare type ParallelSteps = WorkflowStep[];
/**
 * @stability stable
 */
export interface Parameter {
    /**
     * @stability stable
     */
    readonly default?: string;
    /**
     * @stability stable
     */
    readonly enum?: string[];
    /**
     * @stability stable
     */
    readonly globalName?: string;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly value?: string;
    /**
     * @stability stable
     */
    readonly valueFrom?: ValueFrom;
}
/**
 * @stability stable
 */
export interface PodGC {
    /**
     * @stability stable
     */
    readonly labelSelector?: k8s.LabelSelector;
    /**
     * @stability stable
     */
    readonly strategy?: string;
}
/**
 * @stability stable
 */
export interface Prometheus {
    /**
     * @stability stable
     */
    readonly counter?: Counter;
    /**
     * @stability stable
     */
    readonly gauge?: Gauge;
    /**
     * @stability stable
     */
    readonly help: string;
    /**
     * @stability stable
     */
    readonly histogram?: Histogram;
    /**
     * @stability stable
     */
    readonly labels?: MetricLabel[];
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly when?: string;
}
/**
 * @stability stable
 */
export interface RawArtifact {
    /**
     * @stability stable
     */
    readonly data: string;
}
/**
 * @stability stable
 */
export interface ResourceTemplate {
    /**
     * @stability stable
     */
    readonly action: string;
    /**
     * @stability stable
     */
    readonly failureCondition?: string;
    /**
     * @stability stable
     */
    readonly flags?: string[];
    /**
     * @stability stable
     */
    readonly manifest?: string;
    /**
     * @stability stable
     */
    readonly mergeStrategy?: string;
    /**
     * @stability stable
     */
    readonly setOwnerReference?: boolean;
    /**
     * @stability stable
     */
    readonly successCondition?: string;
}
/**
 * @stability stable
 */
export interface RetryAffinity {
    /**
     * @stability stable
     */
    readonly nodeAntiAffinity?: RetryNodeAntiAffinity;
}
/**
 * @stability stable
 */
export interface RetryNodeAntiAffinity {
}
/**
 * @stability stable
 */
export interface RetryStrategy {
    /**
     * @stability stable
     */
    readonly affinity?: RetryAffinity;
    /**
     * @stability stable
     */
    readonly backoff?: Backoff;
    /**
     * @stability stable
     */
    readonly limit?: k8s.IntOrString;
    /**
     * @stability stable
     */
    readonly retryPolicy?: string;
}
/**
 * @stability stable
 */
export interface S3Artifact {
    /**
     * @stability stable
     */
    readonly accessKeySecret?: k8s.SecretKeySelector;
    /**
     * @stability stable
     */
    readonly bucket?: string;
    /**
     * @stability stable
     */
    readonly createBucketIfNotPresent?: CreateS3BucketOptions;
    /**
     * @stability stable
     */
    readonly endpoint?: string;
    /**
     * @stability stable
     */
    readonly insecure?: boolean;
    /**
     * @stability stable
     */
    readonly key?: string;
    /**
     * @stability stable
     */
    readonly region?: string;
    /**
     * @stability stable
     */
    readonly roleARN?: string;
    /**
     * @stability stable
     */
    readonly secretKeySecret?: k8s.SecretKeySelector;
    /**
     * @stability stable
     */
    readonly useSDKCreds?: boolean;
}
/**
 * @stability stable
 */
export interface ScriptTemplate {
    /**
     * @stability stable
     */
    readonly args?: string[];
    /**
     * @stability stable
     */
    readonly command?: string[];
    /**
     * @stability stable
     */
    readonly env?: k8s.EnvVar[];
    /**
     * @stability stable
     */
    readonly envFrom?: k8s.EnvFromSource[];
    /**
     * @stability stable
     */
    readonly image: string;
    /**
     * @stability stable
     */
    readonly imagePullPolicy?: string;
    /**
     * @stability stable
     */
    readonly lifecycle?: k8s.Lifecycle;
    /**
     * @stability stable
     */
    readonly livenessProbe?: k8s.Probe;
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly ports?: k8s.ContainerPort[];
    /**
     * @stability stable
     */
    readonly readinessProbe?: k8s.Probe;
    /**
     * @stability stable
     */
    readonly resources?: k8s.ResourceRequirements;
    /**
     * @stability stable
     */
    readonly securityContext?: k8s.SecurityContext;
    /**
     * @stability stable
     */
    readonly source: string;
    /**
     * @stability stable
     */
    readonly startupProbe?: k8s.Probe;
    /**
     * @stability stable
     */
    readonly stdin?: boolean;
    /**
     * @stability stable
     */
    readonly stdinOnce?: boolean;
    /**
     * @stability stable
     */
    readonly terminationMessagePath?: string;
    /**
     * @stability stable
     */
    readonly terminationMessagePolicy?: string;
    /**
     * @stability stable
     */
    readonly tty?: boolean;
    /**
     * @stability stable
     */
    readonly volumeDevices?: k8s.VolumeDevice[];
    /**
     * @stability stable
     */
    readonly volumeMounts?: k8s.VolumeMount[];
    /**
     * @stability stable
     */
    readonly workingDir?: string;
}
/**
 * @stability stable
 */
export interface SemaphoreHolding {
    /**
     * @stability stable
     */
    readonly holders?: string[];
    /**
     * @stability stable
     */
    readonly semaphore?: string;
}
/**
 * @stability stable
 */
export interface SemaphoreRef {
    /**
     * @stability stable
     */
    readonly configMapKeyRef?: k8s.ConfigMapKeySelector;
}
/**
 * @stability stable
 */
export interface SemaphoreStatus {
    /**
     * @stability stable
     */
    readonly holding?: SemaphoreHolding[];
    /**
     * @stability stable
     */
    readonly waiting?: SemaphoreHolding[];
}
/**
 * @stability stable
 */
export interface Sequence {
    /**
     * @stability stable
     */
    readonly count?: k8s.IntOrString;
    /**
     * @stability stable
     */
    readonly end?: k8s.IntOrString;
    /**
     * @stability stable
     */
    readonly format?: string;
    /**
     * @stability stable
     */
    readonly start?: k8s.IntOrString;
}
/**
 * @stability stable
 */
export interface Submit {
    /**
     * @stability stable
     */
    readonly arguments?: Arguments;
    /**
     * @stability stable
     */
    readonly metadata?: k8s.ObjectMeta;
    /**
     * @stability stable
     */
    readonly workflowTemplateRef: WorkflowTemplateRef;
}
/**
 * @stability stable
 */
export interface SubmitOpts {
    /**
     * @stability stable
     */
    readonly annotations?: string;
    /**
     * @stability stable
     */
    readonly dryRun?: boolean;
    /**
     * @stability stable
     */
    readonly entryPoint?: string;
    /**
     * @stability stable
     */
    readonly generateName?: string;
    /**
     * @stability stable
     */
    readonly labels?: string;
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly ownerReference?: k8s.OwnerReference;
    /**
     * @stability stable
     */
    readonly parameterFile?: string;
    /**
     * @stability stable
     */
    readonly parameters?: string[];
    /**
     * @stability stable
     */
    readonly serverDryRun?: boolean;
    /**
     * @stability stable
     */
    readonly serviceAccount?: string;
}
/**
 * @stability stable
 */
export interface SuppliedValueFrom {
}
/**
 * @stability stable
 */
export interface SuspendTemplate {
    /**
     * @stability stable
     */
    readonly duration?: string;
}
/**
 * @stability stable
 */
export interface Synchronization {
    /**
     * @stability stable
     */
    readonly mutex?: Mutex;
    /**
     * @stability stable
     */
    readonly semaphore?: SemaphoreRef;
}
/**
 * @stability stable
 */
export interface SynchronizationStatus {
    /**
     * @stability stable
     */
    readonly mutex?: MutexStatus;
    /**
     * @stability stable
     */
    readonly semaphore?: SemaphoreStatus;
}
/**
 * @stability stable
 */
export interface TTLStrategy {
    /**
     * @stability stable
     */
    readonly secondsAfterCompletion?: number;
    /**
     * @stability stable
     */
    readonly secondsAfterFailure?: number;
    /**
     * @stability stable
     */
    readonly secondsAfterSuccess?: number;
}
/**
 * @stability stable
 */
export interface TarStrategy {
    /**
     * @stability stable
     */
    readonly compressionLevel?: number;
}
/**
 * @stability stable
 */
export interface Template {
    /**
     * @stability stable
     */
    readonly activeDeadlineSeconds?: k8s.IntOrString;
    /**
     * @stability stable
     */
    readonly affinity?: k8s.Affinity;
    /**
     * @stability stable
     */
    readonly archiveLocation?: ArtifactLocation;
    /**
     * @stability stable
     */
    readonly automountServiceAccountToken?: boolean;
    /**
     * @stability stable
     */
    readonly container?: k8s.Container;
    /**
     * @stability stable
     */
    readonly containerSet?: ContainerSetTemplate;
    /**
     * @stability stable
     */
    readonly daemon?: boolean;
    /**
     * @stability stable
     */
    readonly dag?: DAGTemplate;
    /**
     * @stability stable
     */
    readonly data?: Data;
    /**
     * @stability stable
     */
    readonly executor?: ExecutorConfig;
    /**
     * @stability stable
     */
    readonly failFast?: boolean;
    /**
     * @stability stable
     */
    readonly hostAliases?: k8s.HostAlias[];
    /**
     * @stability stable
     */
    readonly initContainers?: UserContainer[];
    /**
     * @stability stable
     */
    readonly inputs?: Inputs;
    /**
     * @stability stable
     */
    readonly memoize?: Memoize;
    /**
     * @stability stable
     */
    readonly metadata?: Metadata;
    /**
     * @stability stable
     */
    readonly metrics?: Metrics;
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly nodeSelector?: {
        [name: string]: string;
    };
    /**
     * @stability stable
     */
    readonly outputs?: Outputs;
    /**
     * @stability stable
     */
    readonly parallelism?: number;
    /**
     * @stability stable
     */
    readonly podSpecPatch?: string;
    /**
     * @stability stable
     */
    readonly priority?: number;
    /**
     * @stability stable
     */
    readonly priorityClassName?: string;
    /**
     * @stability stable
     */
    readonly resource?: ResourceTemplate;
    /**
     * @stability stable
     */
    readonly retryStrategy?: RetryStrategy;
    /**
     * @stability stable
     */
    readonly schedulerName?: string;
    /**
     * @stability stable
     */
    readonly script?: ScriptTemplate;
    /**
     * @stability stable
     */
    readonly securityContext?: k8s.PodSecurityContext;
    /**
     * @stability stable
     */
    readonly serviceAccountName?: string;
    /**
     * @stability stable
     */
    readonly sidecars?: UserContainer[];
    /**
     * @stability stable
     */
    readonly steps?: ParallelSteps[];
    /**
     * @stability stable
     */
    readonly suspend?: SuspendTemplate;
    /**
     * @stability stable
     */
    readonly synchronization?: Synchronization;
    /**
     * @stability stable
     */
    readonly timeout?: string;
    /**
     * @stability stable
     */
    readonly tolerations?: k8s.Toleration[];
    /**
     * @stability stable
     */
    readonly volumes?: k8s.Volume[];
}
/**
 * @stability stable
 */
export interface TemplateRef {
    /**
     * @stability stable
     */
    readonly clusterScope?: boolean;
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly template?: string;
}
/**
 * @stability stable
 */
export interface TransformationStep {
    /**
     * @stability stable
     */
    readonly expression: string;
}
/**
 * @stability stable
 */
export interface UpdateCronWorkflowRequest {
    /**
     * @stability stable
     */
    readonly cronWorkflow?: CronWorkflow;
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export interface UserContainer {
    /**
     * @stability stable
     */
    readonly args?: string[];
    /**
     * @stability stable
     */
    readonly command?: string[];
    /**
     * @stability stable
     */
    readonly env?: k8s.EnvVar[];
    /**
     * @stability stable
     */
    readonly envFrom?: k8s.EnvFromSource[];
    /**
     * @stability stable
     */
    readonly image?: string;
    /**
     * @stability stable
     */
    readonly imagePullPolicy?: string;
    /**
     * @stability stable
     */
    readonly lifecycle?: k8s.Lifecycle;
    /**
     * @stability stable
     */
    readonly livenessProbe?: k8s.Probe;
    /**
     * @stability stable
     */
    readonly mirrorVolumeMounts?: boolean;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly ports?: k8s.ContainerPort[];
    /**
     * @stability stable
     */
    readonly readinessProbe?: k8s.Probe;
    /**
     * @stability stable
     */
    readonly resources?: k8s.ResourceRequirements;
    /**
     * @stability stable
     */
    readonly securityContext?: k8s.SecurityContext;
    /**
     * @stability stable
     */
    readonly startupProbe?: k8s.Probe;
    /**
     * @stability stable
     */
    readonly stdin?: boolean;
    /**
     * @stability stable
     */
    readonly stdinOnce?: boolean;
    /**
     * @stability stable
     */
    readonly terminationMessagePath?: string;
    /**
     * @stability stable
     */
    readonly terminationMessagePolicy?: string;
    /**
     * @stability stable
     */
    readonly tty?: boolean;
    /**
     * @stability stable
     */
    readonly volumeDevices?: k8s.VolumeDevice[];
    /**
     * @stability stable
     */
    readonly volumeMounts?: k8s.VolumeMount[];
    /**
     * @stability stable
     */
    readonly workingDir?: string;
}
/**
 * @stability stable
 */
export interface ValueFrom {
    /**
     * @stability stable
     */
    readonly default?: string;
    /**
     * @stability stable
     */
    readonly event?: string;
    /**
     * @stability stable
     */
    readonly expression?: string;
    /**
     * @stability stable
     */
    readonly jqFilter?: string;
    /**
     * @stability stable
     */
    readonly jsonPath?: string;
    /**
     * @stability stable
     */
    readonly parameter?: string;
    /**
     * @stability stable
     */
    readonly path?: string;
    /**
     * @stability stable
     */
    readonly supplied?: SuppliedValueFrom;
}
/**
 * @stability stable
 */
export interface Version {
    /**
     * @stability stable
     */
    readonly buildDate: string;
    /**
     * @stability stable
     */
    readonly compiler: string;
    /**
     * @stability stable
     */
    readonly gitCommit: string;
    /**
     * @stability stable
     */
    readonly gitTag: string;
    /**
     * @stability stable
     */
    readonly gitTreeState: string;
    /**
     * @stability stable
     */
    readonly goVersion: string;
    /**
     * @stability stable
     */
    readonly platform: string;
    /**
     * @stability stable
     */
    readonly version: string;
}
/**
 * @stability stable
 */
export interface VolumeClaimGC {
    /**
     * @stability stable
     */
    readonly strategy?: string;
}
/**
 * @stability stable
 */
export interface Workflow {
    /**
     * @stability stable
     */
    readonly apiVersion?: string;
    /**
     * @stability stable
     */
    readonly kind?: string;
    /**
     * @stability stable
     */
    readonly metadata: k8s.ObjectMeta;
    /**
     * @stability stable
     */
    readonly spec: WorkflowSpec;
    /**
     * @stability stable
     */
    readonly status?: WorkflowStatus;
}
/**
 * @stability stable
 */
export interface WorkflowCreateRequest {
    /**
     * @stability stable
     */
    readonly createOptions?: k8s.CreateOptions;
    /**
     * @stability stable
     */
    readonly instanceID?: string;
    /**
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * @stability stable
     */
    readonly serverDryRun?: boolean;
    /**
     * @stability stable
     */
    readonly workflow?: Workflow;
}
/**
 * @stability stable
 */
export interface WorkflowDeleteResponse {
}
/**
 * @stability stable
 */
export interface WorkflowEventBinding {
    /**
     * @stability stable
     */
    readonly apiVersion?: string;
    /**
     * @stability stable
     */
    readonly kind?: string;
    /**
     * @stability stable
     */
    readonly metadata: k8s.ObjectMeta;
    /**
     * @stability stable
     */
    readonly spec: WorkflowEventBindingSpec;
}
/**
 * @stability stable
 */
export interface WorkflowEventBindingList {
    /**
     * @stability stable
     */
    readonly apiVersion?: string;
    /**
     * @stability stable
     */
    readonly items: WorkflowEventBinding[];
    /**
     * @stability stable
     */
    readonly kind?: string;
    /**
     * @stability stable
     */
    readonly metadata: k8s.ListMeta;
}
/**
 * @stability stable
 */
export interface WorkflowEventBindingSpec {
    /**
     * @stability stable
     */
    readonly event: Event;
    /**
     * @stability stable
     */
    readonly submit?: Submit;
}
/**
 * @stability stable
 */
export interface WorkflowLintRequest {
    /**
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * @stability stable
     */
    readonly workflow?: Workflow;
}
/**
 * @stability stable
 */
export interface WorkflowList {
    /**
     * @stability stable
     */
    readonly apiVersion?: string;
    /**
     * @stability stable
     */
    readonly items: Workflow[];
    /**
     * @stability stable
     */
    readonly kind?: string;
    /**
     * @stability stable
     */
    readonly metadata: k8s.ListMeta;
}
/**
 * @stability stable
 */
export interface WorkflowResubmitRequest {
    /**
     * @stability stable
     */
    readonly memoized?: boolean;
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export interface WorkflowResumeRequest {
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * @stability stable
     */
    readonly nodeFieldSelector?: string;
}
/**
 * @stability stable
 */
export interface WorkflowRetryRequest {
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * @stability stable
     */
    readonly nodeFieldSelector?: string;
    /**
     * @stability stable
     */
    readonly restartSuccessful?: boolean;
}
/**
 * @stability stable
 */
export interface WorkflowSetRequest {
    /**
     * @stability stable
     */
    readonly message?: string;
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * @stability stable
     */
    readonly nodeFieldSelector?: string;
    /**
     * @stability stable
     */
    readonly outputParameters?: string;
    /**
     * @stability stable
     */
    readonly phase?: string;
}
/**
 * @stability stable
 */
export interface WorkflowSpec {
    /**
     * @stability stable
     */
    readonly activeDeadlineSeconds?: number;
    /**
     * @stability stable
     */
    readonly affinity?: k8s.Affinity;
    /**
     * @stability stable
     */
    readonly arguments?: Arguments;
    /**
     * @stability stable
     */
    readonly artifactRepositoryRef?: ArtifactRepositoryRef;
    /**
     * @stability stable
     */
    readonly automountServiceAccountToken?: boolean;
    /**
     * @stability stable
     */
    readonly dnsConfig?: k8s.PodDnsConfig;
    /**
     * @stability stable
     */
    readonly dnsPolicy?: string;
    /**
     * @stability stable
     */
    readonly entrypoint?: string;
    /**
     * @stability stable
     */
    readonly executor?: ExecutorConfig;
    /**
     * @stability stable
     */
    readonly hostAliases?: k8s.HostAlias[];
    /**
     * @stability stable
     */
    readonly hostNetwork?: boolean;
    /**
     * @stability stable
     */
    readonly imagePullSecrets?: k8s.LocalObjectReference[];
    /**
     * @stability stable
     */
    readonly metrics?: Metrics;
    /**
     * @stability stable
     */
    readonly nodeSelector?: {
        [name: string]: string;
    };
    /**
     * @stability stable
     */
    readonly onExit?: string;
    /**
     * @stability stable
     */
    readonly parallelism?: number;
    /**
     * @stability stable
     */
    readonly podDisruptionBudget?: k8s.PodDisruptionBudgetSpec;
    /**
     * @stability stable
     */
    readonly podGC?: PodGC;
    /**
     * @stability stable
     */
    readonly podMetadata?: Metadata;
    /**
     * @stability stable
     */
    readonly podPriority?: number;
    /**
     * @stability stable
     */
    readonly podPriorityClassName?: string;
    /**
     * @stability stable
     */
    readonly podSpecPatch?: string;
    /**
     * @stability stable
     */
    readonly priority?: number;
    /**
     * @stability stable
     */
    readonly retryStrategy?: RetryStrategy;
    /**
     * @stability stable
     */
    readonly schedulerName?: string;
    /**
     * @stability stable
     */
    readonly securityContext?: k8s.PodSecurityContext;
    /**
     * @stability stable
     */
    readonly serviceAccountName?: string;
    /**
     * @stability stable
     */
    readonly shutdown?: string;
    /**
     * @stability stable
     */
    readonly suspend?: boolean;
    /**
     * @stability stable
     */
    readonly synchronization?: Synchronization;
    /**
     * @stability stable
     */
    readonly templateDefaults?: Template;
    /**
     * @stability stable
     */
    readonly templates?: Template[];
    /**
     * @stability stable
     */
    readonly tolerations?: k8s.Toleration[];
    /**
     * @stability stable
     */
    readonly ttlStrategy?: TTLStrategy;
    /**
     * @stability stable
     */
    readonly volumeClaimGC?: VolumeClaimGC;
    /**
     * @stability stable
     */
    readonly volumeClaimTemplates?: k8s.KubePersistentVolumeClaimProps[];
    /**
     * @stability stable
     */
    readonly volumes?: k8s.Volume[];
    /**
     * @stability stable
     */
    readonly workflowTemplateRef?: WorkflowTemplateRef;
}
/**
 * @stability stable
 */
export interface WorkflowStatus {
    /**
     * @stability stable
     */
    readonly artifactRepositoryRef?: ArtifactRepositoryRefStatus;
    /**
     * @stability stable
     */
    readonly compressedNodes?: string;
    /**
     * @stability stable
     */
    readonly conditions?: Condition[];
    /**
     * @stability stable
     */
    readonly estimatedDuration?: number;
    /**
     * @stability stable
     */
    readonly finishedAt?: Date;
    /**
     * @stability stable
     */
    readonly message?: string;
    /**
     * @stability stable
     */
    readonly nodes?: {
        [name: string]: NodeStatus;
    };
    /**
     * @stability stable
     */
    readonly offloadNodeStatusVersion?: string;
    /**
     * @stability stable
     */
    readonly outputs?: Outputs;
    /**
     * @stability stable
     */
    readonly persistentVolumeClaimSpecs?: k8s.Volume[];
    /**
     * @stability stable
     */
    readonly phase?: string;
    /**
     * @stability stable
     */
    readonly progress?: string;
    /**
     * @stability stable
     */
    readonly resourcesDuration?: {
        [name: string]: number;
    };
    /**
     * @stability stable
     */
    readonly startedAt?: Date;
    /**
     * @stability stable
     */
    readonly storedTemplates?: {
        [name: string]: Template;
    };
    /**
     * @stability stable
     */
    readonly storedWorkflowTemplateSpec?: WorkflowSpec;
    /**
     * @stability stable
     */
    readonly synchronization?: SynchronizationStatus;
}
/**
 * @stability stable
 */
export interface WorkflowStep {
    /**
     * @stability stable
     */
    readonly arguments?: Arguments;
    /**
     * @stability stable
     */
    readonly continueOn?: ContinueOn;
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly onExit?: string;
    /**
     * @stability stable
     */
    readonly template?: string;
    /**
     * @stability stable
     */
    readonly templateRef?: TemplateRef;
    /**
     * @stability stable
     */
    readonly when?: string;
    /**
     * @stability stable
     */
    readonly withItems?: Item[];
    /**
     * @stability stable
     */
    readonly withParam?: string;
    /**
     * @stability stable
     */
    readonly withSequence?: Sequence;
}
/**
 * @stability stable
 */
export interface WorkflowStopRequest {
    /**
     * @stability stable
     */
    readonly message?: string;
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * @stability stable
     */
    readonly nodeFieldSelector?: string;
}
/**
 * @stability stable
 */
export interface WorkflowSubmitRequest {
    /**
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * @stability stable
     */
    readonly resourceKind?: string;
    /**
     * @stability stable
     */
    readonly resourceName?: string;
    /**
     * @stability stable
     */
    readonly submitOptions?: SubmitOpts;
}
/**
 * @stability stable
 */
export interface WorkflowSuspendRequest {
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export interface WorkflowTemplate {
    /**
     * @stability stable
     */
    readonly apiVersion?: string;
    /**
     * @stability stable
     */
    readonly kind?: string;
    /**
     * @stability stable
     */
    readonly metadata: k8s.ObjectMeta;
    /**
     * @stability stable
     */
    readonly spec: WorkflowTemplateSpec;
}
/**
 * @stability stable
 */
export interface WorkflowTemplateCreateRequest {
    /**
     * @stability stable
     */
    readonly createOptions?: k8s.CreateOptions;
    /**
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * @stability stable
     */
    readonly template?: WorkflowTemplate;
}
/**
 * @stability stable
 */
export interface WorkflowTemplateDeleteResponse {
}
/**
 * @stability stable
 */
export interface WorkflowTemplateLintRequest {
    /**
     * @stability stable
     */
    readonly createOptions?: k8s.CreateOptions;
    /**
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * @stability stable
     */
    readonly template?: WorkflowTemplate;
}
/**
 * @stability stable
 */
export interface WorkflowTemplateList {
    /**
     * @stability stable
     */
    readonly apiVersion?: string;
    /**
     * @stability stable
     */
    readonly items: WorkflowTemplate[];
    /**
     * @stability stable
     */
    readonly kind?: string;
    /**
     * @stability stable
     */
    readonly metadata: k8s.ListMeta;
}
/**
 * @stability stable
 */
export interface WorkflowTemplateRef {
    /**
     * @stability stable
     */
    readonly clusterScope?: boolean;
    /**
     * @stability stable
     */
    readonly name?: string;
}
/**
 * @stability stable
 */
export interface WorkflowTemplateSpec {
    /**
     * @stability stable
     */
    readonly activeDeadlineSeconds?: number;
    /**
     * @stability stable
     */
    readonly affinity?: k8s.Affinity;
    /**
     * @stability stable
     */
    readonly arguments?: Arguments;
    /**
     * @stability stable
     */
    readonly artifactRepositoryRef?: ArtifactRepositoryRef;
    /**
     * @stability stable
     */
    readonly automountServiceAccountToken?: boolean;
    /**
     * @stability stable
     */
    readonly dnsConfig?: k8s.PodDnsConfig;
    /**
     * @stability stable
     */
    readonly dnsPolicy?: string;
    /**
     * @stability stable
     */
    readonly entrypoint?: string;
    /**
     * @stability stable
     */
    readonly executor?: ExecutorConfig;
    /**
     * @stability stable
     */
    readonly hostAliases?: k8s.HostAlias[];
    /**
     * @stability stable
     */
    readonly hostNetwork?: boolean;
    /**
     * @stability stable
     */
    readonly imagePullSecrets?: k8s.LocalObjectReference[];
    /**
     * @stability stable
     */
    readonly metrics?: Metrics;
    /**
     * @stability stable
     */
    readonly nodeSelector?: {
        [name: string]: string;
    };
    /**
     * @stability stable
     */
    readonly onExit?: string;
    /**
     * @stability stable
     */
    readonly parallelism?: number;
    /**
     * @stability stable
     */
    readonly podDisruptionBudget?: k8s.PodDisruptionBudgetSpec;
    /**
     * @stability stable
     */
    readonly podGC?: PodGC;
    /**
     * @stability stable
     */
    readonly podMetadata?: Metadata;
    /**
     * @stability stable
     */
    readonly podPriority?: number;
    /**
     * @stability stable
     */
    readonly podPriorityClassName?: string;
    /**
     * @stability stable
     */
    readonly podSpecPatch?: string;
    /**
     * @stability stable
     */
    readonly priority?: number;
    /**
     * @stability stable
     */
    readonly retryStrategy?: RetryStrategy;
    /**
     * @stability stable
     */
    readonly schedulerName?: string;
    /**
     * @stability stable
     */
    readonly securityContext?: k8s.PodSecurityContext;
    /**
     * @stability stable
     */
    readonly serviceAccountName?: string;
    /**
     * @stability stable
     */
    readonly shutdown?: string;
    /**
     * @stability stable
     */
    readonly suspend?: boolean;
    /**
     * @stability stable
     */
    readonly synchronization?: Synchronization;
    /**
     * @stability stable
     */
    readonly templateDefaults?: Template;
    /**
     * @stability stable
     */
    readonly templates?: Template[];
    /**
     * @stability stable
     */
    readonly tolerations?: k8s.Toleration[];
    /**
     * @stability stable
     */
    readonly ttlStrategy?: TTLStrategy;
    /**
     * @stability stable
     */
    readonly volumeClaimGC?: VolumeClaimGC;
    /**
     * @stability stable
     */
    readonly volumeClaimTemplates?: k8s.PersistentVolumeClaimSpec[];
    /**
     * @stability stable
     */
    readonly volumes?: k8s.Volume[];
    /**
     * @stability stable
     */
    readonly workflowMetadata?: k8s.ObjectMeta;
    /**
     * @stability stable
     */
    readonly workflowTemplateRef?: WorkflowTemplateRef;
}
/**
 * @stability stable
 */
export interface WorkflowTemplateUpdateRequest {
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * @stability stable
     */
    readonly template?: WorkflowTemplate;
}
/**
 * @stability stable
 */
export interface WorkflowTerminateRequest {
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export interface WorkflowWatchEvent {
    /**
     * @stability stable
     */
    readonly object?: Workflow;
    /**
     * @stability stable
     */
    readonly type?: string;
}
/**
 * @stability stable
 */
export interface ZipStrategy {
}
/**
 * @stability stable
 */
export declare class ArgoWorkflowClusterWorkflowTemplate extends ApiObject {
    /**
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * @stability stable
     */
    static manifest(props: ClusterWorkflowTemplate): any;
    /**
     * @stability stable
     */
    constructor(scope: Construct, name: string, props: ClusterWorkflowTemplate);
}
/**
 * @stability stable
 */
export declare class ArgoWorkflowCronWorkflow extends ApiObject {
    /**
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * @stability stable
     */
    static manifest(props: CronWorkflow): any;
    /**
     * @stability stable
     */
    constructor(scope: Construct, name: string, props: CronWorkflow);
}
