#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['oauth2_lib']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.19.0',
 'ruamel.yaml~=0.16.10',
 'structlog>=20.2.0',
 'fastapi>=0.65.1',
 'httpx~=0.18.2',
 'authlib>=0.15.2',
 'pydantic',
 'opentelemetry-api~=1.4.1',
 'opentelemetry-instrumentation~=0.23b2']

extras_require = \
{'dev': ['bumpversion', 'pre-commit'],
 'test': ['apache-license-check',
          'black',
          'flake8',
          'flake8-bandit',
          'flake8-bugbear',
          'flake8-comprehensions',
          'flake8-docstrings',
          'flake8-junit-report',
          'flake8-logging-format',
          'flake8-pep3101',
          'flake8-print',
          'flake8-rst',
          'flake8-rst-docstrings',
          'flake8-tidy-imports',
          'isort',
          'mypy',
          'pygments',
          'pytest',
          'pytest-asyncio',
          'pytest-cov',
          'pytest-xdist',
          'requests_mock']}

setup(name='oauth2-lib',
      version='1.0.9',
      description='This is the SURF Oauth2 module that interfaces with the oauth2 setup.',
      author='SURF',
      author_email='automation-beheer@surf.nl',
      url='https://github.com/workfloworchestrator/oauth2-lib',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>3.8,<3.10',
     )
