import httpx

from mavtel_models import SessionState, CollectorState, StorageState


class ServicesMixin:
    """
    This is an autogenerated class!
    """

    async def session(self) -> SessionState:
        # noinspection PyUnresolvedReferences
        url = self._api_url + '/services/session'
        async with httpx.AsyncClient() as client:
            response: httpx.Response = await client.get(url)
            return SessionState(**response.json())

    async def collector(self) -> CollectorState:
        # noinspection PyUnresolvedReferences
        url = self._api_url + '/services/collector'
        async with httpx.AsyncClient() as client:
            response: httpx.Response = await client.get(url)
            return CollectorState(**response.json())

    async def storage(self) -> StorageState:
        # noinspection PyUnresolvedReferences
        url = self._api_url + '/services/storage'
        async with httpx.AsyncClient() as client:
            response: httpx.Response = await client.get(url)
            return StorageState(**response.json())
