# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['catpandoc']

package_data = \
{'': ['*']}

install_requires = \
['Pygments>=2.11.2,<3',
 'art>=5.4,<6',
 'catimage>=2021.0.1,<2023',
 'emoji>=1.6.3,<2',
 'pypandoc>=1.7.2,<2']

entry_points = \
{'console_scripts': ['catpandoc = catpandoc.application:cli']}

setup_kwargs = {
    'name': 'catpandoc',
    'version': '2022',
    'description': 'Cat multiple document files to the terminal',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/CatPandoc.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/CatPandoc.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/CatPandoc.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/CatPandoc.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/CatPandoc.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/CatPandoc.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/catpandoc.svg?style=for-the-badge)](https://pypistats.org/packages/catpandoc)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Fcatpandoc)](https://pepy.tech/project/catpandoc)\n[![PyPI Version](https://img.shields.io/pypi/v/catpandoc.svg?style=for-the-badge)](https://pypi.org/project/catpandoc)\n\n<!-- omit in toc -->\n# CatPandoc\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nCat multiple documents to the terminal. The continuation of CatMD\n\n- [Features](#features)\n\t- [Document Compatability](#document-compatability)\n\t- [Terminal \'rendering\'](#terminal-rendering)\n- [Roadmap](#roadmap)\n- [Use](#use)\n\t- [CLI](#cli)\n\t- [Import](#import)\n- [Documentation](#documentation)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Windows - Python.org](#windows---pythonorg)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n\t- [Dnf](#dnf)\n- [Install Python on MacOS](#install-python-on-macos)\n\t- [Homebrew](#homebrew)\n\t- [MacOS - Python.org](#macos---pythonorg)\n- [How to run](#how-to-run)\n\t- [Windows](#windows)\n\t- [Linux/ MacOS](#linux-macos)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n- [Screenshots](#screenshots)\n\t- [Desktop](#desktop)\n\t- [Themes](#themes)\n\n## Features\n\n### Document Compatability\n\nLightweight markup formats\n\n- Markdown (including CommonMark and GitHub-flavored Markdown)\n- reStructuredText\n- Emacs Org-Mode\n- Emacs Muse\n- Textile\n- txt2tags\n\nHTML formats\n\n- (X)HTML 4\n- HTML5\n\nEbooks\n\n- EPUB version 2 or 3\n- FictionBook2\n\nDocumentation formats\n\n- Haddock markup\n\nRoff formats\n\n- roff man\n\nTeX formats\n\n- LaTeX\n\nXML formats\n\n- DocBook version 4 or 5\n- JATS\n\nOutline formats\n\n- OPML\n\nData formats\n\n- CSV tables\n\nWord processor formats\n\n- Microsoft Word docx\n- OpenOffice/LibreOffice ODT\n\nInteractive notebook formats\n\n- Jupyter notebook (ipynb)\n\nWiki markup formats\n\n- MediaWiki markup\n- DokuWiki markup\n- TikiWiki markup\n- TWiki markup\n- Jira wiki markup\n\n### Terminal \'rendering\'\n\nHighlights the following:\n\n- Headers 1-6\n- Unordered and ordered lists\n- Block quotes\n- Bold, Italic, Strikethrough, inline code\n- Line Break (br)\n\nRenders the following\n\n- Tables\n- Images (uses catimage for this so they can look a bit blurry...)\n\nHiglights code blocks\n\n- Uses pygments for code syntax highlighting\n\n## Roadmap\n\nFor completed components, see the changelog (link below)\n\n|Feature|Description|Status|\n|---|---|---|\n|pandoc2pysimplegui.py|Generate PySimpleGUI widgets|-|\n\n## Use\n\n### CLI\n\n```bash\nusage: application.py [-h] [--width WIDTH] [--theme THEME] file\n```\n\n### Import\n\nTake a look at test/catcomplex.py for an example of how to use catpandoc in your own\nproject. Or take a look at the example below\n\n```python\nimport json\nimport pypandoc\nfrom catpandoc import pandoc2ansi, processpandoc\n\noutput = json.loads(pypandoc.convert_file("cheatsheet.md", \'json\'))\nfor block in output["blocks"]:\n\tpandoc = pandoc2ansi.Pandoc2Ansi(130, 5, (4, 0, 0))\n\tprocesspandoc.processBlock(block, pandoc)\n\tprint(pandoc.genOutput())\n```\n\n## Documentation\n\nSee the [Docs](/DOCS/) for more information.\n\n## Install With PIP\n\n```python\npip install catpandoc\n```\n\nHead to https://pypi.org/project/catpandoc/ for more info\n\n## Language information\n\n### Built for\n\nThis program has been written for Python versions 3.7 - 3.10 and has been tested with both 3.7 and\n3.10\n\n## Install Python on Windows\n\n### Chocolatey\n\n```powershell\nchoco install python\n```\n\n### Windows - Python.org\n\nTo install Python, go to https://www.python.org/downloads/windows/ and download the latest\nversion.\n\n## Install Python on Linux\n\n### Apt\n\n```bash\nsudo apt install python3.x\n```\n\n### Dnf\n\n```bash\nsudo dnf install python3.x\n```\n\n## Install Python on MacOS\n\n### Homebrew\n\n```bash\nbrew install python@3.x\n```\n\n### MacOS - Python.org\n\nTo install Python, go to https://www.python.org/downloads/macos/ and download the latest\nversion.\n\n## How to run\n\n### Windows\n\n- Module\n\t`py -3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`py -3.x [file]` or `./[file]`\n\n### Linux/ MacOS\n\n- Module\n\t`python3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`python3.x [file]` or `./[file]`\n\n## Download Project\n\n### Clone\n\n#### Using The Command Line\n\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n\n```bash\ngit clone https://github.com/FHPythonUtils/CatPandoc\n```\n\nMore information can be found at\nhttps://help.github.com/en/articles/cloning-a-repository\n\n#### Using GitHub Desktop\n\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\nhttps://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n\n### Licence\n\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\n\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\n\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\n\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\n\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\n\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\n\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n\n## Screenshots\n\n### Desktop\n\n<div>\n<img src="readme-assets/screenshots/desktop/screenshot-0.png" alt="Screenshot 1" width="600">\n<img src="readme-assets/screenshots/desktop/screenshot-1.png" alt="Screenshot 2" width="600">\n<img src="readme-assets/screenshots/desktop/screenshot-2.png" alt="Screenshot 3" width="600">\n</div>\n\n### Themes\n\n<div>\n<img src="readme-assets/screenshots/themes/theme-1.png" alt="Screenshot 1" width="200">\n<img src="readme-assets/screenshots/themes/theme-2.png" alt="Screenshot 2" width="200">\n<img src="readme-assets/screenshots/themes/theme-3.png" alt="Screenshot 3" width="200">\n</div>\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/CatPandoc',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
