# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['ddlsplit']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['ddlsplit = ddlsplit.__main__:main']}

setup_kwargs = {
    'name': 'ddlsplit',
    'version': '0.1.1',
    'description': 'Splits a DDL file generated by pgModeler by database objects into single DDL files.',
    'long_description': "# ddlsplit\n\nSplits a DDL file generated by [pgModeler](https://github.com/pgmodeler/pgmodeler)\ninto single files by database objects (schema, extension, table etc.).\nComments on Tables are parsed as multiline top-level comments,\nwhich can be utilized by [sphinx-sql](https://github.com/winkelband/sphinx-sql) (fork of [jackscodemonkey's sphinx-sql](https://github.com/jackscodemonkey/sphinx-sql)).\n\n## Installation\n\n`pip install ddlsplit`\n\n## Usage\n\n### Run as a program\n\n```bash\nddlsplit <ddl.sql> <output-dir>\n```\n\nOr clone this repo and run the program with `poetry` from the cloned repository without installation: \n\n```bash\npoetry install\npoetry run ddlsplit <ddl.sql> <output-dir>\n```\n\n### Use as a module\n\nMake sure, `ddlsplit` is in your `$PATH` or project's namespace!\n\n```python\nimport ddlsplit\n\n\nddl_code = '''\n...\n'''\n```\n\n## Reverse Engineering A Database & Its Documentation\n\n`pgModeler → ddlsplit → sphinx w/ sphinx-sql`\n\nIf you maintain your database model with a graphical data modeling tool like pgModeler,\nyou can build a pipeline to automatically build your documentation with [sphinx-sql](https://github.com/winkelband/sphinx-sql),\ne.g. by calling `pgModeler` and `ddlsplit` from your sphinx' Makefile.\n\nThis approach lets you keep the documentation of your SQL code inside the code itself,\nthus reducing overhead costs by keeping code and documentation residing in multiple places in sync.\n\n```bash\n# Optional: Reverse engineering an existing database:\npgmodeler-cli \\\n        -platform offscreen \\\n        --export-to-file \\\n        --import-db \\\n        --ignore-errors \\\n        --conn-alias local-db \\\n        --input-db demodb \\\n        --output demo.sql \\\n        --pgsql-ver 12.0\n\n# Export pgModeler's dbm to sql file:\npgmodeler-cli \\\n        -platform offscreen \\\n        --export-to-file \\\n        --input demo.dbm \\\n        --output demo.sql \\\n        --pgsql-ver 12.0\n```\n\nExample for top level comment for a table with pgModeler:\n\n```\nPurpose:\nThis a new table to show how auto documentation can add new objects quickly.\nDependent Objects:\n\tType\t|\tName\n\tSchema\t|\tmy_test_schema\nChangeLog:\n\tDate\t|\tAuthor\t|\tTicket\t|\tModification\n\t2020-12-26\t|\tDeveloper_2\t|\tT-247\t|\tInitial Definition\n\n```\n\nResults in:\n\n```SQL\nCOMMENT ON TABLE public.find IS E'Purpose:\\nThis a new table to show how auto documentation can add new objects quickly.\\nDependent Objects:\\n\\tType\\t|\\tName\\n\\tSchema\\t|\\tmy_test_schema\\nChangeLog:\\n\\tDate\\t|\\tAuthor\\t|\\tTicket\\t|\\tModification\\n\\t2020-12-26\\t|\\tDeveloper_2\\t|\\tT-247\\t|\\tInitial Definition';\n```\n\n## Developing\n\n```bash\npoetry install\npoetry build\n```\n\n## Contributing\n",
    'author': 'David Berthel',
    'author_email': 'code@davidberthel.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/winkelband/ddlsplit/',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
