# -*- encoding:utf-8 -*-
# Copyright © 2015-2016, THOORENS Bruno - http://bruno.thoorens.free.fr/licences/tyf.html

## Tiff tag values
NewSubfileType = {
    0: "bit flag 000",
    1: "bit flag 001",
    2: "bit flag 010",
    3: "bit flag 011",
    4: "bit flag 100",
    5: "bit flag 101",
    6: "bit flag 110",
    7: "bit flag 111"
}

SubfileType = {
    1: "Full-resolution image data",
    2: "Reduced-resolution image data",
    3: "Single page of a multi-page image"
}

Compression = {
    1:     "Uncompressed",
    2:     "CCITT 1d",
    3:     "Group 3 Fax",
    4:     "Group 4 Fax",
    5:     "LZW",
    6:     "JPEG",
    7:     "JPEG ('new-style' JPEG)",
    8:     "Deflate ('Adobe-style')",
    9:     "TIFF-F and TIFF-FX standard (RFC 2301) B&W",
    10:    "TIFF-F and TIFF-FX standard (RFC 2301) RGB",
    32771: "CCITTRLEW",  # 16-bit padding
    32773: "PACKBITS",
    32809: "THUNDERSCAN",
    32895: "IT8CTPAD",
    32896: "IT8LW",
    32897: "IT8MP",
    32908: "PIXARFILM",
    32909: "PIXARLOG",
    32946: "DEFLATE",
    32947: "DCS",
    34661: "JBIG",
    34676: "SGILOG",
    34677: "SGILOG24",
    34712: "JP2000",
}

PhotometricInterpretation = {
    0:     "WhiteIsZero",
    1:     "BlackIsZero",
    2:     "RGB",
    3:     "RGB Palette",
    4:     "Transparency Mask",
    5:     "CMYK",
    6:     "YCbCr",
    8:     "CIE L*a*b*",
    9:     "ICC L*a*b*",
    10:    "ITU L*a*b*",
    32803: "CFA",       # TIFF/EP, Adobe DNG
    32892: "LinearRaw"  # Adobe DNG
}

Thresholding = {
    1: "No dithering or halftoning has been applied to the image data",
    2: "An ordered dither or halftone technique has been applied to the image data",
    3: "A randomized process such as error diffusion has been applied to the image data"
}

FillOrder = {
    1: "Values stored in the higher-order bits of the byte",
    2: "Values stored in the lower-order bits of the byte"
}

Orientation = {
#   1        2       3      4         5            6           7          8
# 888888  888888      88  88      8888888888  88                  88  8888888888
# 88          88      88  88      88  88      88  88          88  88      88  88
# 8888      8888    8888  8888    88          8888888888  8888888888          88
# 88          88      88  88
# 88          88  888888  888888
    1: "Normal",
    2: "Fliped left to right",
    3: "Rotated 180 deg",
    4: "Fliped top to bottom",
    5: "Fliped left to right + rotated 90 deg counter clockwise",
    6: "Rotated 90 deg counter clockwise",
    7: "Fliped left to right + rotated 90 deg clockwise",
    8: "Rotated 90 deg clockwise"
}

PlanarConfiguration = {
    1: "Chunky",  # format: RGBARGBARGBA...RGBA 
    2: "Planar"   # format: RR...RGG...GBB...BAA...A
}

GrayResponseUnit = {
    1: "Number represents tenths of a unit",
    2: "Number represents hundredths of a unit",
    3: "Number represents thousandths of a unit",
    4: "Number represents ten-thousandths of a unit",
    5: "Number represents hundred-thousandths of a unit"
}

ResolutionUnit = {
    1:"No unit",
    2:"Inch",
    3:"Centimeter"
}

T4Options = {
    0: "bit flag 000",
    1: "bit flag 001",
    2: "bit flag 010",
    3: "bit flag 011",
    4: "bit flag 100",
    5: "bit flag 101",
    6: "bit flag 110",
    7: "bit flag 111"
}

T6Options = {
    0: "bit flag 00",
    2: "bit flag 10",
}

Predictor = {
    1: "No prediction",
    2: "Horizontal differencing",
    3: "Floating point horizontal differencing"
}

CleanFaxData = {
    0: "No 'bad' lines",
    1: "'bad' lines exist, but were regenerated by the receiver",
    2: "'bad' lines exist, but have not been regenerated"
}

InkSet = {
    1:"CMYK",
    2:"Not CMYK"
}

SampleFormat = {
    1: "Unsigned integer data",
    2: "Two's complement signed integer data",
    3: "IEEE floating point data [IEEE]",
    4: "Undefined data format"
}

Indexed = {
    0: "Not indexed",
    1: "Indexed"
}

OPIProxy = {
    0: "A higher-resolution version of this image does not exist",
    1: "A higher-resolution version of this image exists, and the name of that image is found in the ImageID tag"
}

ProfileType = {
    0: "Unspecified",
    1: "Group 3 fax"
}

FaxProfile = {
    0: "Does not conform to a profile defined for TIFF for facsimile",
    1: "Minimal black & white lossless, Profile S",
    2: "Extended black & white lossless, Profile F",
    3: "Lossless JBIG black & white, Profile J",
    4: "Lossy color and grayscale, Profile C",
    5: "Lossless color and grayscale, Profile L",
    6: "Mixed Raster Content, Profile M"
}

CodingMethods = {
    0b1       : "Unspecified compression",
    0b10      : "1-dimensional coding, ITU-T Rec. T.4 (MH - Modified Huffman)",
    0b100     : "2-dimensional coding, ITU-T Rec. T.4 (MR - Modified Read)",
    0b1000    : "2-dimensional coding, ITU-T Rec. T.6 (MMR - Modified MR)",
    0b10000   : "ITU-T Rec. T.82 coding, using ITU-T Rec. T.85 (JBIG)",
    0b100000  : "ITU-T Rec. T.81 (Baseline JPEG)",
    0b1000000 : "ITU-T Rec. T.82 coding, using ITU-T Rec. T.43 (JBIG color)"
}

JPEGProc = {
    1:  "Baseline sequential process",
    14: "Lossless process with Huffman coding"
}

JPEGLosslessPredictors = {
    1: "A",
    2: "B",
    3: "C",
    4: "A+B-C",
    5: "A+((B-C)/2)",
    6: "B+((A-C)/2)",
    7: "(A+B)/2"
}

YCbCrSubSampling = {
    (0,1): "YCbCrSubsampleHoriz : ImageWidth of this chroma image is equal to the ImageWidth of the associated luma image",
    (0,2): "YCbCrSubsampleHoriz : ImageWidth of this chroma image is half the ImageWidth of the associated luma image",
    (0,4): "YCbCrSubsampleHoriz : ImageWidth of this chroma image is one-quarter the ImageWidth of the associated luma image",
    (1,1): "YCbCrSubsampleVert : ImageLength (height) of this chroma image is equal to the ImageLength of the associated luma image",
    (2,2): "YCbCrSubsampleVert : ImageLength (height) of this chroma image is half the ImageLength of the associated luma image",
    (4,4): "YCbCrSubsampleVert : ImageLength (height) of this chroma image is one-quarter the ImageLength of the associated luma image"
}

YCbCrPositioning = {
    1: "Centered", 
    2: "Co-sited"
}

## EXIF tag values
ExposureProgram = {
    0: "Not defined",
    1: "Manual",
    2: "Normal program",
    3: "Aperture priority",
    4: "Shutter priority",
    5: "Creative program (biased toward depth of field)",
    6: "Action program (biased toward fast shutter speed)",
    7: "Portrait mode (for closeup photos with the background out of focus)",
    8: "Landscape mode (for landscape photos with the background in focus)"
}

MeteringMode = {
    0:   "Unknown",
    1:   "Average",
    2:   "Center Weighted Average",
    3:   "Spot",
    4:   "MultiSpot",
    5:   "Pattern",
    6:   "Partial",
    255: "other"
}

LightSource = {
    0:   "Unknown",
    1:   "Daylight",
    2:   "Fluorescent",
    3:   "Tungsten (incandescent light)",
    4:   "Flash",
    9:   "Fine weather",
    10:  "Cloudy weather",
    11:  "Shade",
    12:  "Daylight fluorescent (D 5700 - 7100K)",
    13:  "Day white fluorescent (N 4600 - 5400K)",
    14:  "Cool white fluorescent (W 3900 - 4500K)",
    15:  "White fluorescent (WW 3200 - 3700K)",
    17:  "Standard light A",
    18:  "Standard light B",
    19:  "Standard light C",
    20:  "D55",
    21:  "D65",
    22:  "D75",
    23:  "D50",
    24:  "ISO studio tungsten",
    255: "Other light source"
}

ColorSpace = {
    1:     "RGB",
    65535: "Uncalibrated"
}

Flash = {
    0x0000: "Flash did not fire",
    0x0001: "Flash fired",
    0x0005: "Strobe return light not detected",
    0x0007: "Strobe return light detected",
    0x0008: "On, did not fire",
    0x0009: "Flash fired, compulsory flash mode",
    0x000D: "Flash fired, compulsory flash mode, return light not detected",
    0x000F: "Flash fired, compulsory flash mode, return light detected",
    0x0010: "Flash did not fire, compulsory flash mode",
    0x0014: "Off, did not fire, return not detected",
    0x0018: "Flash did not fire, auto mode",
    0x0019: "Flash fired, auto mode",
    0x001D: "Flash fired, auto mode, return light not detected",
    0x001F: "Flash fired, auto mode, return light detected",
    0x0020: "No flash function",
    0x0030: "Off, no flash function",
    0x0041: "Flash fired, red-eye reduction mode",
    0x0045: "Flash fired, red-eye reduction mode, return light not detected",
    0x0047: "Flash fired, red-eye reduction mode, return light detected",
    0x0049: "Flash fired, compulsory flash mode, red-eye reduction mode",
    0x004D: "Flash fired, compulsory flash mode, red-eye reduction mode, return light not detected",
    0x004F: "Flash fired, compulsory flash mode, red-eye reduction mode, return light detected",
    0x0050: "Off, red-eye reduction",
    0x0058: "Auto, Did not fire, red-eye reduction",
    0x0059: "Flash fired, auto mode, red-eye reduction mode",
    0x005D: "Flash fired, auto mode, return light not detected, red-eye reduction mode",
    0x005F: "Flash fired, auto mode, return light detected, red-eye reduction mode"
}

FocalPlaneResolutionUnit = {
    1: "No absolute unit of measurement",
    2: "Inch",
    3: "Centimeter"
}

SensingMethod = {
    1: "Not defined",
    2: "One-chip color area sensor",
    3: "Two-chip color area sensor",
    4: "Three-chip color area sensor",
    5: "Color sequential area sensor",
    7: "Trilinear sensor",
    8: "Color sequential linear sensor"
}

CustomRendered = {
    0: "Normal process",
    1: "Custom process"
}

ExposureMode = {
    0: "Auto exposure",
    1: "Manual exposure",
    2: "Auto bracket"
}

WhiteBalance = {
    0: "Auto white balance",
    1: "Manual white balance"
}

SceneCaptureType = {
    0: "Standard",
    1: "Landscape",
    2: "Portrait",
    3: "Night scene"
}

GainControl = {
    0: "None",
    1: "Low gain up",
    2: "High gain up",
    3: "Low gain down",
    4: "High gain down"
}

Contrast = {
    0: "Normal",
    1: "Soft",
    2: "Hard"
}

Saturation = {
    0: "Normal",
    1: "Low saturation",
    2: "High saturation"
}

Sharpness = Contrast

SubjectDistanceRange = {
    0: "Unknown",
    1: "Macro",
    2: "Close view",
    3: "Distant view"
}

## GPS tag values
GPSAltitudeRef = {
    0: "Above sea level",
    1: "Below sea level"
}

GPSMeasureMode = {
    b'2':   "2-dimensional measurement",
    b'3':   "3-dimensional measurement",
    b'2\x00': "2-dimensional measurement",
    b'3\x00': "3-dimensional measurement"
}

GPSSpeedRef = {
    b'K':     "Kilometers per hour",
    b'M':     "Miles per hour",
    b'N':     "Knots",
    b'K\x00': "Kilometers per hour",
    b'M\x00': "Miles per hour",
    b'N\x00': "Knots"
}

GPSTrackRef = {
    b'T':     "True direction",
    b'M':     "Magnetic direction",
    b'T\x00': "True direction",
    b'M\x00': "Magnetic direction"
}

GPSImgDirectionRef = GPSTrackRef

GPSLatitudeRef = {
    b'N':     "North latitude",
    b'S':     "South latitude",
    b'N\x00': "North latitude",
    b'S\x00': "South latitude"
}
GPSDestLatitudeRef = GPSLatitudeRef

GPSLongitudeRef = {
    b'E':     "East longitude",
    b'W':     "West longitude",
    b'E\x00': "East longitude",
    b'W\x00': "West longitude"
}
GPSDestLongitudeRef = GPSLongitudeRef

GPSDestBearingRef = GPSTrackRef
GPSDestDistanceRef = GPSSpeedRef

GPSDifferential = {
    0: "Measurement without differential correction",
    1: "Differential correction applied"
}

## Geotiff tag values
GTModelTypeGeoKey = {
    0: "Undefined",
    1: "Projection Coordinate System",
    2: "Geographic (latitude,longitude) System",
    3: "Geocentric (X,Y,Z) Coordinate System",
}

GTRasterTypeGeoKey = {
        1: "Raster pixel is area",
        2: "Raster pixel is point",
}


# load from json

ProjCoordTransGeoKey = {
    1:  "CT_TransverseMercator",
    2:  "CT_TransvMercator_Modified_Alaska",
    3:  "CT_ObliqueMercator",
    4:  "CT_ObliqueMercator_Laborde",
    5:  "CT_ObliqueMercator_Rosenmund",
    6:  "CT_ObliqueMercator_Spherical",
    7:  "CT_Mercator",
    8:  "CT_LambertConfConic_2SP",
    9:  "CT_LambertConfConic_Helmert",
    10: "CT_LambertAzimEqualArea",
    11: "CT_AlbersEqualArea",
    12: "CT_AzimuthalEquidistant",
    13: "CT_EquidistantConic",
    14: "CT_Stereographic",
    15: "CT_PolarStereographic",
    16: "CT_ObliqueStereographic",
    17: "CT_Equirectangular",
    18: "CT_CassiniSoldner",
    19: "CT_Gnomonic",
    20: "CT_MillerCylindrical",
    21: "CT_Orthographic",
    22: "CT_Polyconic",
    23: "CT_Robinson",
    24: "CT_Sinusoidal",
    25: "CT_VanDerGrinten",
    26: "CT_NewZealandMapGrid",
    27: "CT_TransvMercator_SouthOriented",
    28: "User-defined",
    32767: "User-defined"
}

GeogPrimeMeridianGeoKey = {
    8901: "Greenwich",
    8902: "Lisbon",
    8903: "Paris",
    8904: "Bogota",
    8905: "Madrid",
    8906: "Rome",
    8907: "Bern",
    8908: "Jakarta",
    8909: "Ferro",
    8910: "Brussels",
    8911: "Stockholm",
    8912: "Athens",
    8913: "Oslo",
    8914: "Paris RGS"
}


GeogLinearUnitsGeoKey = {
    1025: "millimetre",
    1026: "metres per second",
    1027: "millimetres per year",
    1033: "centimetre",
    1034: "centimetres per year",
    1042: "metres per year",
    9001: "metre",
    9002: "foot",
    9003: "US survey foot",
    9005: "Clarke's foot",
    9014: "fathom",
    9030: "nautical mile",
    9031: "German legal metre",
    9033: "US survey chain",
    9034: "US survey link",
    9035: "US survey mile",
    9036: "kilometre",
    9037: "Clarke's yard",
    9038: "Clarke's chain",
    9039: "Clarke's link",
    9040: "British yard (Sears 1922)",
    9041: "British foot (Sears 1922)",
    9042: "British chain (Sears 1922)",
    9043: "British link (Sears 1922)",
    9050: "British yard (Benoit 1895 A)",
    9051: "British foot (Benoit 1895 A)",
    9052: "British chain (Benoit 1895 A)",
    9053: "British link (Benoit 1895 A)",
    9060: "British yard (Benoit 1895 B)",
    9061: "British foot (Benoit 1895 B)",
    9062: "British chain (Benoit 1895 B)",
    9063: "British link (Benoit 1895 B)",
    9070: "British foot (1865)",
    9080: "Indian foot",
    9081: "Indian foot (1937)",
    9082: "Indian foot (1962)",
    9083: "Indian foot (1975)",
    9084: "Indian yard",
    9085: "Indian yard (1937)",
    9086: "Indian yard (1962)",
    9087: "Indian yard (1975)",
    9093: "Statute mile",
    9094: "Gold Coast foot",
    9095: "British foot (1936)",
    9096: "yard",
    9097: "chain",
    9098: "link",
    9099: "British yard (Sears 1922 truncated)",
    9204: "Bin width 330 US survey feet",
    9205: "Bin width 165 US survey feet",
    9206: "Bin width 82.5 US survey feet",
    9207: "Bin width 37.5 metres",
    9208: "Bin width 25 metres",
    9209: "Bin width 12.5 metres",
    9210: "Bin width 6.25 metres",
    9211: "Bin width 3.125 metres",
    9300: "British foot (Sears 1922 truncated)",
    9301: "British chain (Sears 1922 truncated)",
    9302: "British link (Sears 1922 truncated)"
}


GeogAngularUnitsGeoKey = {
    1031: "milliarc-second",
    1032: "milliarc-seconds per year",
    1035: "radians per second",
    1043: "arc-seconds per year",
    9101: "radian",
    9102: "degree",
    9103: "arc-minute",
    9104: "arc-second",
    9105: "grad",
    9106: "gon",
    9107: "degree minute second",
    9108: "degree minute second hemisphere",
    9109: "microradian",
    9110: "sexagesimal DMS",
    9111: "sexagesimal DM",
    9112: "centesimal minute",
    9113: "centesimal second",
    9114: "mil_6400",
    9115: "degree minute",
    9116: "degree hemisphere",
    9117: "hemisphere degree",
    9118: "degree minute hemisphere",
    9119: "hemisphere degree minute",
    9120: "hemisphere degree minute second",
    9121: "sexagesimal DMS.s",
    9122: "degree (supplier to define representation)"
}


GeogAzimuthUnitsGeoKey = GeogAngularUnitsGeoKey

ProjLinearUnitsGeoKey = GeogLinearUnitsGeoKey

VerticalUnitsGeoKey = GeogLinearUnitsGeoKey


GeogEllipsoidGeoKey = {
    1024: "CGCS2000",
    7001: "Airy 1830",
    7002: "Airy Modified 1849",
    7003: "Australian National Spheroid",
    7004: "Bessel 1841",
    7005: "Bessel Modified",
    7006: "Bessel Namibia",
    7007: "Clarke 1858",
    7008: "Clarke 1866",
    7009: "Clarke 1866 Michigan",
    7010: "Clarke 1880 (Benoit)",
    7011: "Clarke 1880 (IGN)",
    7012: "Clarke 1880 (RGS)",
    7013: "Clarke 1880 (Arc)",
    7014: "Clarke 1880 (SGA 1922)",
    7015: "Everest 1830 (1937 Adjustment)",
    7016: "Everest 1830 (1967 Definition)",
    7018: "Everest 1830 Modified",
    7019: "GRS 1980",
    7020: "Helmert 1906",
    7021: "Indonesian National Spheroid",
    7022: "International 1924",
    7024: "Krassowsky 1940",
    7025: "NWL 9D",
    7027: "Plessis 1817",
    7028: "Struve 1860",
    7029: "War Office",
    7030: "WGS 84",
    7031: "GEM 10C",
    7032: "OSU86F",
    7033: "OSU91A",
    7034: "Clarke 1880",
    7035: "Sphere",
    7036: "GRS 1967",
    7041: "Average Terrestrial System 1977",
    7042: "Everest (1830 Definition)",
    7043: "WGS 72",
    7044: "Everest 1830 (1962 Definition)",
    7045: "Everest 1830 (1975 Definition)",
    7046: "Bessel Namibia (GLM)",
    7047: "GRS 1980 Authalic Sphere",
    7048: "GRS 1980 Authalic Sphere",
    7049: "IAG 1975",
    7050: "GRS 1967 Modified",
    7051: "Danish 1876",
    7052: "Clarke 1866 Authalic Sphere",
    7053: "Hough 1960",
    7054: "PZ-90",
    7055: "Clarke 1880 (international foot)",
    7056: "Everest 1830 (RSO 1969)",
    7057: "International 1924 Authalic Sphere",
    7058: "Hughes 1980",
    7059: "Popular Visualisation Sphere",
    32767: "User-defined"
}


GeogGeodeticDatumGeoKey = {
    1024: "Hungarian Datum 1909",
    1025: "Taiwan Datum 1967",
    1026: "Taiwan Datum 1997",
    1029: "Iraqi Geospatial Reference System",
    1031: "MGI 1901",
    1032: "MOLDREF99",
    1033: "Reseau Geodesique de la RDC 2005",
    1034: "Serbian Reference Network 1998",
    1035: "Red Geodesica de Canarias 1995",
    1036: "Reseau Geodesique de Mayotte 2004",
    1037: "Cadastre 1997",
    1038: "Reseau Geodesique de Saint Pierre et Miquelon 2006",
    1041: "Autonomous Regions of Portugal 2008",
    1042: "Mexico ITRF92",
    1043: "China 2000",
    1044: "Sao Tome",
    1045: "New Beijing",
    1046: "Principe",
    1047: "Reseau de Reference des Antilles Francaises 1991",
    1048: "Tokyo 1892",
    1052: "System Jednotne Trigonometricke Site Katastralni/05",
    1053: "Sri Lanka Datum 1999",
    1055: "System Jednotne Trigonometricke Site Katastralni/05 (Ferro)",
    1056: "Geocentric Datum Brunei Darussalam 2009",
    1057: "Turkish National Reference Frame",
    1058: "Bhutan National Geodetic Datum",
    1060: "Islands Net 2004",
    1061: "International Terrestrial Reference Frame 2008",
    1062: "Posiciones Geodesicas Argentinas 2007",
    1063: "Marco Geodesico Nacional",
    1064: "SIRGAS-Chile",
    1065: "Costa Rica 2005",
    1066: "Sistema Geodesico Nacional de Panama MACARIO SOLIS",
    1067: "Peru96",
    1068: "SIRGAS-ROU98",
    1069: "SIRGAS_ES2007.8",
    1070: "Ocotepeque 1935",
    1071: "Sibun Gorge 1922",
    1072: "Panama-Colon 1911",
    1073: "Reseau Geodesique des Antilles Francaises 2009",
    1074: "Corrego Alegre 1961",
    1075: "South American Datum 1969(96)",
    1076: "Papua New Guinea Geodetic Datum 1994",
    1077: "Ukraine 2000",
    1078: "Fehmarnbelt Datum 2010",
    1081: "Deutsche Bahn Reference System",
    1095: "Tonga Geodetic Datum 2005",
    1100: "Cayman Islands Geodetic Datum 2011",
    1111: "Nepal 1981",
    1112: "Cyprus Geodetic Reference System 1993",
    1113: "Reseau Geodesique des Terres Australes et Antarctiques Francaises 2007",
    1114: "Israeli Geodetic Datum 2005",
    1115: "Israeli Geodetic Datum 2005(2012)",
    1116: "NAD83 (National Spatial Reference System 2011)",
    1117: "NAD83 (National Spatial Reference System PA11)",
    1118: "NAD83 (National Spatial Reference System MA11)",
    1120: "Mexico ITRF2008",
    1128: "Japanese Geodetic Datum 2011",
    1132: "Rete Dinamica Nazionale 2008",
    1133: "NAD83 (Continuously Operating Reference Station 1996)",
    1135: "Aden 1925",
    1136: "Bioko",
    1137: "Bekaa Valley 1920",
    1138: "South East Island 1943",
    1139: "Gambia",
    1141: "IGS08",
    1142: "IG05 Intermediate Datum",
    1143: "Israeli Geodetic Datum 2005",
    1144: "IG05/12 Intermediate Datum",
    1145: "Israeli Geodetic Datum 2005(2012)",
    1147: "Oman National Geodetic Datum 2014",
    1160: "Kyrgyzstan Geodetic Datum 2006",
    6001: "Not specified (based on Airy 1830 ellipsoid)",
    6002: "Not specified (based on Airy Modified 1849 ellipsoid)",
    6003: "Not specified (based on Australian National Spheroid)",
    6004: "Not specified (based on Bessel 1841 ellipsoid)",
    6005: "Not specified (based on Bessel Modified ellipsoid)",
    6006: "Not specified (based on Bessel Namibia ellipsoid)",
    6007: "Not specified (based on Clarke 1858 ellipsoid)",
    6008: "Not specified (based on Clarke 1866 ellipsoid)",
    6009: "Not specified (based on Clarke 1866 Michigan ellipsoid)",
    6010: "Not specified (based on Clarke 1880 (Benoit) ellipsoid)",
    6011: "Not specified (based on Clarke 1880 (IGN) ellipsoid)",
    6012: "Not specified (based on Clarke 1880 (RGS) ellipsoid)",
    6013: "Not specified (based on Clarke 1880 (Arc) ellipsoid)",
    6014: "Not specified (based on Clarke 1880 (SGA 1922) ellipsoid)",
    6015: "Not specified (based on Everest 1830 (1937 Adjustment) ellipsoid)",
    6016: "Not specified (based on Everest 1830 (1967 Definition) ellipsoid)",
    6018: "Not specified (based on Everest 1830 Modified ellipsoid)",
    6019: "Not specified (based on GRS 1980 ellipsoid)",
    6020: "Not specified (based on Helmert 1906 ellipsoid)",
    6021: "Not specified (based on Indonesian National Spheroid)",
    6022: "Not specified (based on International 1924 ellipsoid)",
    6024: "Not specified (based on Krassowsky 1940 ellipsoid)",
    6025: "Not specified (based on NWL 9D ellipsoid)",
    6027: "Not specified (based on Plessis 1817 ellipsoid)",
    6028: "Not specified (based on Struve 1860 ellipsoid)",
    6029: "Not specified (based on War Office ellipsoid)",
    6030: "Not specified (based on WGS 84 ellipsoid)",
    6031: "Not specified (based on GEM 10C ellipsoid)",
    6032: "Not specified (based on OSU86F ellipsoid)",
    6033: "Not specified (based on OSU91A ellipsoid)",
    6034: "Not specified (based on Clarke 1880 ellipsoid)",
    6035: "Not specified (based on Authalic Sphere)",
    6036: "Not specified (based on GRS 1967 ellipsoid)",
    6041: "Not specified (based on Average Terrestrial System 1977 ellipsoid)",
    6042: "Not specified (based on Everest (1830 Definition) ellipsoid)",
    6043: "Not specified (based on WGS 72 ellipsoid)",
    6044: "Not specified (based on Everest 1830 (1962 Definition) ellipsoid)",
    6045: "Not specified (based on Everest 1830 (1975 Definition) ellipsoid)",
    6047: "Not specified (based on GRS 1980 Authalic Sphere)",
    6052: "Not specified (based on Clarke 1866 Authalic Sphere)",
    6053: "Not specified (based on International 1924 Authalic Sphere)",
    6054: "Not specified (based on Hughes 1980 ellipsoid)",
    6055: "Popular Visualisation Datum",
    6120: "Greek",
    6121: "Greek Geodetic Reference System 1987",
    6122: "Average Terrestrial System 1977",
    6123: "Kartastokoordinaattijarjestelma (1966)",
    6124: "Rikets koordinatsystem 1990",
    6125: "Samboja",
    6126: "Lithuania 1994 (ETRS89)",
    6127: "Tete",
    6128: "Madzansua",
    6129: "Observatario",
    6130: "Moznet (ITRF94)",
    6131: "Indian 1960",
    6132: "Final Datum 1958",
    6133: "Estonia 1992",
    6134: "PDO Survey Datum 1993",
    6135: "Old Hawaiian",
    6136: "St. Lawrence Island",
    6137: "St. Paul Island",
    6138: "St. George Island",
    6139: "Puerto Rico",
    6140: "NAD83 Canadian Spatial Reference System",
    6141: "Israel 1993",
    6142: "Locodjo 1965",
    6143: "Abidjan 1987",
    6144: "Kalianpur 1937",
    6145: "Kalianpur 1962",
    6146: "Kalianpur 1975",
    6147: "Hanoi 1972",
    6148: "Hartebeesthoek94",
    6149: "CH1903",
    6150: "CH1903+",
    6151: "Swiss Terrestrial Reference Frame 1995",
    6152: "NAD83 (High Accuracy Reference Network)",
    6153: "Rassadiran",
    6154: "European Datum 1950(1977)",
    6155: "Dabola 1981",
    6156: "System Jednotne Trigonometricke Site Katastralni",
    6157: "Mount Dillon",
    6158: "Naparima 1955",
    6159: "European Libyan Datum 1979",
    6160: "Chos Malal 1914",
    6161: "Pampa del Castillo",
    6162: "Korean Datum 1985",
    6163: "Yemen National Geodetic Network 1996",
    6164: "South Yemen",
    6165: "Bissau",
    6166: "Korean Datum 1995",
    6167: "New Zealand Geodetic Datum 2000",
    6168: "Accra",
    6169: "American Samoa 1962",
    6170: "Sistema de Referencia Geocentrico para America del Sur 1995",
    6171: "Reseau Geodesique Francais 1993",
    6172: "Posiciones Geodesicas Argentinas",
    6173: "IRENET95",
    6174: "Sierra Leone Colony 1924",
    6175: "Sierra Leone 1968",
    6176: "Australian Antarctic Datum 1998",
    6178: "Pulkovo 1942(83)",
    6179: "Pulkovo 1942(58)",
    6180: "Estonia 1997",
    6181: "Luxembourg 1930",
    6182: "Azores Occidental Islands 1939",
    6183: "Azores Central Islands 1948",
    6184: "Azores Oriental Islands 1940",
    6185: "Madeira 1936",
    6188: "OSNI 1952",
    6189: "Red Geodesica Venezolana",
    6190: "Posiciones Geodesicas Argentinas 1998",
    6191: "Albanian 1987",
    6192: "Douala 1948",
    6193: "Manoca 1962",
    6194: "Qornoq 1927",
    6195: "Scoresbysund 1952",
    6196: "Ammassalik 1958",
    6197: "Garoua",
    6198: "Kousseri",
    6199: "Egypt 1930",
    6200: "Pulkovo 1995",
    6201: "Adindan",
    6202: "Australian Geodetic Datum 1966",
    6203: "Australian Geodetic Datum 1984",
    6204: "Ain el Abd 1970",
    6205: "Afgooye",
    6206: "Agadez",
    6207: "Lisbon 1937",
    6208: "Aratu",
    6209: "Arc 1950",
    6210: "Arc 1960",
    6211: "Batavia",
    6212: "Barbados 1938",
    6213: "Beduaram",
    6214: "Beijing 1954",
    6215: "Reseau National Belge 1950",
    6216: "Bermuda 1957",
    6218: "Bogota 1975",
    6219: "Bukit Rimpah",
    6220: "Camacupa",
    6221: "Campo Inchauspe",
    6222: "Cape",
    6223: "Carthage",
    6224: "Chua",
    6225: "Corrego Alegre 1970-72",
    6226: "Cote d'Ivoire",
    6227: "Deir ez Zor",
    6228: "Douala",
    6229: "Egypt 1907",
    6230: "European Datum 1950",
    6231: "European Datum 1987",
    6232: "Fahud",
    6233: "Gandajika 1970",
    6234: "Garoua",
    6235: "Guyane Francaise",
    6236: "Hu Tzu Shan 1950",
    6237: "Hungarian Datum 1972",
    6238: "Indonesian Datum 1974",
    6239: "Indian 1954",
    6240: "Indian 1975",
    6241: "Jamaica 1875",
    6242: "Jamaica 1969",
    6243: "Kalianpur 1880",
    6244: "Kandawala",
    6245: "Kertau 1968",
    6246: "Kuwait Oil Company",
    6247: "La Canoa",
    6248: "Provisional South American Datum 1956",
    6249: "Lake",
    6250: "Leigon",
    6251: "Liberia 1964",
    6252: "Lome",
    6253: "Luzon 1911",
    6254: "Hito XVIII 1963",
    6255: "Herat North",
    6256: "Mahe 1971",
    6257: "Makassar",
    6258: "European Terrestrial Reference System 1989",
    6259: "Malongo 1987",
    6260: "Manoca",
    6261: "Merchich",
    6262: "Massawa",
    6263: "Minna",
    6264: "Mhast",
    6265: "Monte Mario",
    6266: "M'poraloko",
    6267: "North American Datum 1927",
    6268: "NAD27 Michigan",
    6269: "North American Datum 1983",
    6270: "Nahrwan 1967",
    6271: "Naparima 1972",
    6272: "New Zealand Geodetic Datum 1949",
    6273: "NGO 1948",
    6274: "Datum 73",
    6275: "Nouvelle Triangulation Francaise",
    6276: "NSWC 9Z-2",
    6277: "OSGB 1936",
    6278: "OSGB 1970 (SN)",
    6279: "OS (SN) 1980",
    6280: "Padang 1884",
    6281: "Palestine 1923",
    6282: "Congo 1960 Pointe Noire",
    6283: "Geocentric Datum of Australia 1994",
    6284: "Pulkovo 1942",
    6285: "Qatar 1974",
    6286: "Qatar 1948",
    6287: "Qornoq",
    6288: "Loma Quintana",
    6289: "Amersfoort",
    6291: "South American Datum 1969",
    6292: "Sapper Hill 1943",
    6293: "Schwarzeck",
    6294: "Segora",
    6295: "Serindung",
    6296: "Sudan",
    6297: "Tananarive 1925",
    6298: "Timbalai 1948",
    6299: "TM65",
    6300: "Geodetic Datum of 1965",
    6301: "Tokyo",
    6302: "Trinidad 1903",
    6303: "Trucial Coast 1948",
    6304: "Voirol 1875",
    6306: "Bern 1938",
    6307: "Nord Sahara 1959",
    6308: "Stockholm 1938",
    6309: "Yacare",
    6310: "Yoff",
    6311: "Zanderij",
    6312: "Militar-Geographische Institut",
    6313: "Reseau National Belge 1972",
    6314: "Deutsches Hauptdreiecksnetz",
    6315: "Conakry 1905",
    6316: "Dealul Piscului 1930",
    6317: "Dealul Piscului 1970",
    6318: "National Geodetic Network",
    6319: "Kuwait Utility",
    6322: "World Geodetic System 1972",
    6324: "WGS 72 Transit Broadcast Ephemeris",
    6326: "World Geodetic System 1984",
    6600: "Anguilla 1957",
    6601: "Antigua 1943",
    6602: "Dominica 1945",
    6603: "Grenada 1953",
    6604: "Montserrat 1958",
    6605: "St. Kitts 1955",
    6606: "St. Lucia 1955",
    6607: "St. Vincent 1945",
    6608: "North American Datum 1927 (1976)",
    6609: "North American Datum 1927 (CGQ77)",
    6610: "Xian 1980",
    6611: "Hong Kong 1980",
    6612: "Japanese Geodetic Datum 2000",
    6613: "Gunung Segara",
    6614: "Qatar National Datum 1995",
    6615: "Porto Santo 1936",
    6616: "Selvagem Grande",
    6618: "South American Datum 1969",
    6619: "SWEREF99",
    6620: "Point 58",
    6621: "Fort Marigot",
    6622: "Guadeloupe 1948",
    6623: "Centre Spatial Guyanais 1967",
    6624: "Reseau Geodesique Francais Guyane 1995",
    6625: "Martinique 1938",
    6626: "Reunion 1947",
    6627: "Reseau Geodesique de la Reunion 1992",
    6628: "Tahiti 52",
    6629: "Tahaa 54",
    6630: "IGN72 Nuku Hiva",
    6631: "K0 1949",
    6632: "Combani 1950",
    6633: "IGN56 Lifou",
    6634: "IGN72 Grande Terre",
    6635: "ST87 Ouvea",
    6636: "Petrels 1972",
    6637: "Pointe Geologie Perroud 1950",
    6638: "Saint Pierre et Miquelon 1950",
    6639: "MOP78",
    6640: "Reseau de Reference des Antilles Francaises 1991",
    6641: "IGN53 Mare",
    6642: "ST84 Ile des Pins",
    6643: "ST71 Belep",
    6644: "NEA74 Noumea",
    6645: "Reseau Geodesique Nouvelle Caledonie 1991",
    6646: "Grand Comoros",
    6647: "International Terrestrial Reference Frame 1988",
    6648: "International Terrestrial Reference Frame 1989",
    6649: "International Terrestrial Reference Frame 1990",
    6650: "International Terrestrial Reference Frame 1991",
    6651: "International Terrestrial Reference Frame 1992",
    6652: "International Terrestrial Reference Frame 1993",
    6653: "International Terrestrial Reference Frame 1994",
    6654: "International Terrestrial Reference Frame 1996",
    6655: "International Terrestrial Reference Frame 1997",
    6656: "International Terrestrial Reference Frame 2000",
    6657: "Reykjavik 1900",
    6658: "Hjorsey 1955",
    6659: "Islands Net 1993",
    6660: "Helle 1954",
    6661: "Latvia 1992",
    6663: "Porto Santo 1995",
    6664: "Azores Oriental Islands 1995",
    6665: "Azores Central Islands 1995",
    6666: "Lisbon 1890",
    6667: "Iraq-Kuwait Boundary Datum 1992",
    6668: "European Datum 1979",
    6670: "Istituto Geografico Militaire 1995",
    6671: "Voirol 1879",
    6672: "Chatham Islands Datum 1971",
    6673: "Chatham Islands Datum 1979",
    6674: "Sistema de Referencia Geocentrico para las AmericaS 2000",
    6675: "Guam 1963",
    6676: "Vientiane 1982",
    6677: "Lao 1993",
    6678: "Lao National Datum 1997",
    6679: "Jouik 1961",
    6680: "Nouakchott 1965",
    6681: "Mauritania 1999",
    6682: "Gulshan 303",
    6683: "Philippine Reference System 1992",
    6684: "Gan 1970",
    6685: "Gandajika",
    6686: "Marco Geocentrico Nacional de Referencia",
    6687: "Reseau Geodesique de la Polynesie Francaise",
    6688: "Fatu Iva 72",
    6689: "IGN63 Hiva Oa",
    6690: "Tahiti 79",
    6691: "Moorea 87",
    6692: "Maupiti 83",
    6693: "Nakhl-e Ghanem",
    6694: "Posiciones Geodesicas Argentinas 1994",
    6695: "Katanga 1955",
    6696: "Kasai 1953",
    6697: "IGC 1962 Arc of the 6th Parallel South",
    6698: "IGN 1962 Kerguelen",
    6699: "Le Pouce 1934",
    6700: "IGN Astro 1960",
    6701: "Institut Geographique du Congo Belge 1955",
    6702: "Mauritania 1999",
    6703: "Missao Hidrografico Angola y Sao Tome 1951",
    6704: "Mhast (onshore)",
    6705: "Mhast (offshore)",
    6706: "Egypt Gulf of Suez S-650 TL",
    6707: "Tern Island 1961",
    6708: "Cocos Islands 1965",
    6709: "Iwo Jima 1945",
    6710: "St. Helena 1971",
    6711: "Marcus Island 1952",
    6712: "Ascension Island 1958",
    6713: "Ayabelle Lighthouse",
    6714: "Bellevue",
    6715: "Camp Area Astro",
    6716: "Phoenix Islands 1966",
    6717: "Cape Canaveral",
    6718: "Solomon 1968",
    6719: "Easter Island 1967",
    6720: "Fiji Geodetic Datum 1986",
    6721: "Fiji 1956",
    6722: "South Georgia 1968",
    6723: "Grand Cayman Geodetic Datum 1959",
    6724: "Diego Garcia 1969",
    6725: "Johnston Island 1961",
    6726: "Sister Islands Geodetic Datum 1961",
    6727: "Midway 1961",
    6728: "Pico de las Nieves 1984",
    6729: "Pitcairn 1967",
    6730: "Santo 1965",
    6731: "Viti Levu 1916",
    6732: "Marshall Islands 1960",
    6733: "Wake Island 1952",
    6734: "Tristan 1968",
    6735: "Kusaie 1951",
    6736: "Deception Island",
    6737: "Geocentric datum of Korea",
    6738: "Hong Kong 1963",
    6739: "Hong Kong 1963(67)",
    6740: "Parametrop Zemp 1990",
    6741: "Faroe Datum 1954",
    6742: "Geodetic Datum of Malaysia 2000",
    6743: "Karbala 1979",
    6744: "Nahrwan 1934",
    6745: "Rauenberg Datum/83",
    6746: "Potsdam Datum/83",
    6747: "Greenland 1996",
    6748: "Vanua Levu 1915",
    6749: "Reseau Geodesique de Nouvelle Caledonie 91-93",
    6750: "ST87 Ouvea",
    6751: "Kertau (RSO)",
    6752: "Viti Levu 1912",
    6753: "fk89",
    6754: "Libyan Geodetic Datum 2006",
    6755: "Datum Geodesi Nasional 1995",
    6756: "Vietnam 2000",
    6757: "SVY21",
    6758: "Jamaica 2001",
    6759: "NAD83 (National Spatial Reference System 2007)",
    6760: "World Geodetic System 1966",
    6761: "Croatian Terrestrial Reference System",
    6762: "Bermuda 2000",
    6763: "Pitcairn 2006",
    6764: "Ross Sea Region Geodetic Datum 2000",
    6765: "Slovenia Geodetic Datum 1996",
    6801: "CH1903 (Bern)",
    6802: "Bogota 1975 (Bogota)",
    6803: "Lisbon 1937 (Lisbon)",
    6804: "Makassar (Jakarta)",
    6805: "Militar-Geographische Institut (Ferro)",
    6806: "Monte Mario (Rome)",
    6807: "Nouvelle Triangulation Francaise (Paris)",
    6808: "Padang 1884 (Jakarta)",
    6809: "Reseau National Belge 1950 (Brussels)",
    6810: "Tananarive 1925 (Paris)",
    6811: "Voirol 1875 (Paris)",
    6813: "Batavia (Jakarta)",
    6814: "Stockholm 1938 (Stockholm)",
    6815: "Greek (Athens)",
    6816: "Carthage (Paris)",
    6817: "NGO 1948 (Oslo)",
    6818: "System Jednotne Trigonometricke Site Katastralni (Ferro)",
    6819: "Nord Sahara 1959 (Paris)",
    6820: "Gunung Segara (Jakarta)",
    6821: "Voirol 1879 (Paris)",
    6896: "International Terrestrial Reference Frame 2005",
    6901: "Ancienne Triangulation Francaise (Paris)",
    6902: "Nord de Guerre (Paris)",
    6903: "Madrid 1870 (Madrid)",
    6904: "Lisbon 1890 (Lisbon)",
    32767: "User-defined"
}


VerticalDatumGeoKey = {
    1027: "EGM2008 geoid",
    1028: "Fao 1979",
    1030: "N2000",
    1039: "New Zealand Vertical Datum 2009",
    1040: "Dunedin-Bluff 1960",
    1049: "Incheon",
    1050: "Trieste",
    1051: "Genoa",
    1054: "Sri Lanka Vertical Datum",
    1059: "Faroe Islands Vertical Reference 2009",
    1079: "Fehmarnbelt Vertical Reference 2010",
    1080: "Lowest Astronomic Tide",
    1082: "Highest Astronomic Tide",
    1083: "Lower Low Water Large Tide",
    1084: "Higher High Water Large Tide",
    1085: "Indian Spring Low Water",
    1086: "Mean Lower Low Water Spring Tides",
    1087: "Mean Low Water Spring Tides",
    1088: "Mean High Water Spring Tides",
    1089: "Mean Lower Low Water",
    1090: "Mean Higher High Water",
    1091: "Mean Low Water",
    1092: "Mean High Water",
    1093: "Low Water",
    1094: "High Water",
    1096: "Norway Normal Null 2000",
    1097: "Grand Cayman Vertical Datum 1954",
    1098: "Little Cayman Vertical Datum 1961",
    1099: "Cayman Brac Vertical Datum 1961",
    1101: "Cais da Pontinha - Funchal",
    1102: "Cais da Vila - Porto Santo",
    1103: "Cais das Velas",
    1104: "Horta",
    1105: "Cais da Madalena",
    1106: "Santa Cruz da Graciosa",
    1107: "Cais da Figueirinha - Angra do Heroismo",
    1108: "Santa Cruz das Flores",
    1109: "Cais da Vila do Porto",
    1110: "Ponta Delgada",
    1119: "Northern Marianas Vertical Datum of 2003",
    1121: "Tutuila Vertical Datum of 1962",
    1122: "Guam Vertical Datum of 1963",
    1123: "Puerto Rico Vertical Datum of 2002",
    1124: "Virgin Islands Vertical Datum of 2009",
    1125: "American Samoa Vertical Datum of 2002",
    1126: "Guam Vertical Datum of 2004",
    1127: "Canadian Geodetic Vertical Datum of 2013",
    1129: "Japanese Standard Levelling Datum 1972",
    1130: "Japanese Geodetic Datum 2000 (vertical)",
    1131: "Japanese Geodetic Datum 2011 (vertical)",
    1140: "Singapore Height Datum",
    1146: "Ras Ghumays",
    1148: "Famagusta 1960",
    1149: "PNG08",
    1150: "Kumul 34",
    1151: "Kiunga",
    1161: "Deutsches Haupthoehennetz 1912",
    1162: "Latvian Height System 2000",
    5100: "Mean Sea Level",
    5101: "Ordnance Datum Newlyn",
    5102: "National Geodetic Vertical Datum 1929",
    5103: "North American Vertical Datum 1988",
    5104: "Yellow Sea 1956",
    5105: "Baltic Sea",
    5106: "Caspian Sea",
    5107: "Nivellement general de la France",
    5109: "Normaal Amsterdams Peil",
    5110: "Ostend",
    5111: "Australian Height Datum",
    5112: "Australian Height Datum (Tasmania)",
    5113: "Instantaneous Water Level",
    5114: "Canadian Geodetic Vertical Datum of 1928",
    5115: "Piraeus Harbour 1986",
    5116: "Helsinki 1960",
    5117: "Rikets hojdsystem 1970",
    5118: "Nivellement General de la France - Lallemand",
    5119: "Nivellement General de la France - IGN69",
    5120: "Nivellement General de la France - IGN78",
    5121: "Maputo",
    5122: "Japanese Standard Levelling Datum 1969",
    5123: "PDO Height Datum 1993",
    5124: "Fahud Height Datum",
    5125: "Ha Tien 1960",
    5126: "Hon Dau 1992",
    5127: "Landesnivellement 1902",
    5128: "Landeshohennetz 1995",
    5129: "European Vertical Reference Frame 2000",
    5130: "Malin Head",
    5131: "Belfast Lough",
    5132: "Dansk Normal Nul",
    5133: "AIOC 1995",
    5134: "Black Sea",
    5135: "Hong Kong Principal Datum",
    5136: "Hong Kong Chart Datum",
    5137: "Yellow Sea 1985",
    5138: "Ordnance Datum Newlyn (Orkney Isles)",
    5139: "Fair Isle",
    5140: "Lerwick",
    5141: "Foula",
    5142: "Sule Skerry",
    5143: "North Rona",
    5144: "Stornoway",
    5145: "St Kilda",
    5146: "Flannan Isles",
    5147: "St Marys",
    5148: "Douglas",
    5149: "Fao",
    5150: "Bandar Abbas",
    5151: "Nivellement General de Nouvelle Caledonie",
    5152: "Poolbeg",
    5153: "Nivellement General Guyanais 1977",
    5154: "Martinique 1987",
    5155: "Guadeloupe 1988",
    5156: "Reunion 1989",
    5157: "Auckland 1946",
    5158: "Bluff 1955",
    5159: "Dunedin 1958",
    5160: "Gisborne 1926",
    5161: "Lyttelton 1937",
    5162: "Moturiki 1953",
    5163: "Napier 1962",
    5164: "Nelson 1955",
    5165: "One Tree Point 1964",
    5166: "Tararu 1952",
    5167: "Taranaki 1970",
    5168: "Wellington 1953",
    5169: "Waitangi (Chatham Island) 1959",
    5170: "Stewart Island 1977",
    5171: "EGM96 geoid",
    5172: "Nivellement General du Luxembourg",
    5173: "Antalya",
    5174: "Norway Normal Null 1954",
    5175: "Durres",
    5176: "Gebrauchshohen ADRIA",
    5177: "National Vertical Network 1999",
    5178: "Cascais",
    5179: "Constanta",
    5180: "Alicante",
    5181: "Deutsches Haupthoehennetz 1992",
    5182: "Deutsches Haupthoehennetz 1985",
    5183: "Staatlichen Nivellementnetzes 1976",
    5184: "Baltic 1982",
    5185: "Baltic 1980",
    5186: "Kuwait PWD",
    5187: "KOC Well Datum",
    5188: "KOC Construction Datum",
    5189: "Nivellement General de la Corse 1948",
    5190: "Danger 1950",
    5191: "Mayotte 1950",
    5192: "Martinique 1955",
    5193: "Guadeloupe 1951",
    5194: "Lagos 1955",
    5195: "Nivellement General de Polynesie Francaise",
    5196: "IGN 1966",
    5197: "Moorea SAU 1981",
    5198: "Raiatea SAU 2001",
    5199: "Maupiti SAU 2001",
    5200: "Huahine SAU 2001",
    5201: "Tahaa SAU 2001",
    5202: "Bora Bora SAU 2001",
    5203: "EGM84 geoid",
    5204: "International Great Lakes Datum 1955",
    5205: "International Great Lakes Datum 1985",
    5206: "Dansk Vertikal Reference 1990",
    5207: "Croatian Vertical Reference System 1971",
    5208: "Rikets hojdsystem 2000",
    5209: "Rikets hojdsystem 1900",
    5210: "IGN 1988 LS",
    5211: "IGN 1988 MG",
    5212: "IGN 1992 LD",
    5213: "IGN 1988 SB",
    5214: "IGN 1988 SM",
    5215: "European Vertical Reference Frame 2007",
    32767: "User-defined"
}


VerticalCSTypeGeoKey = {
    3855: "EGM2008 height",
    3886: "Fao 1979 height",
    3900: "N2000 height",
    4440: "NZVD2009 height",
    4458: "Dunedin-Bluff 1960 height",
    5193: "Incheon height",
    5195: "Trieste height",
    5214: "Genoa height",
    5237: "SLVD height",
    5317: "FVR09 height",
    5336: "Black Sea depth",
    5597: "FCSVR10 height",
    5600: "NGPF height",
    5601: "IGN 1966 height",
    5602: "Moorea SAU 1981 height",
    5603: "Raiatea SAU 2001 height",
    5604: "Maupiti SAU 2001 height",
    5605: "Huahine SAU 2001 height",
    5606: "Tahaa SAU 2001 height",
    5607: "Bora Bora SAU 2001 height",
    5608: "IGLD 1955 height",
    5609: "IGLD 1985 height",
    5610: "HVRS71 height",
    5611: "Caspian height",
    5612: "Baltic depth",
    5613: "RH2000 height",
    5614: "KOC WD depth (ft)",
    5615: "RH00 height",
    5616: "IGN 1988 LS height",
    5617: "IGN 1988 MG height",
    5618: "IGN 1992 LD height",
    5619: "IGN 1988 SB height",
    5620: "IGN 1988 SM height",
    5621: "EVRF2007 height",
    5701: "ODN height",
    5702: "NGVD29 height",
    5703: "NAVD88 height",
    5704: "Yellow Sea",
    5705: "Baltic height",
    5706: "Caspian depth",
    5709: "NAP height",
    5710: "Ostend height",
    5711: "AHD height",
    5712: "AHD (Tasmania) height",
    5713: "CGVD28 height",
    5714: "MSL height",
    5715: "MSL depth",
    5716: "Piraeus height",
    5717: "N60 height",
    5718: "RH70 height",
    5719: "NGF Lallemand height",
    5720: "NGF-IGN69 height",
    5721: "NGF-IGN78 height",
    5722: "Maputo height",
    5723: "JSLD69 height",
    5724: "PHD93 height",
    5725: "Fahud HD height",
    5726: "Ha Tien 1960 height",
    5727: "Hon Dau 1992 height",
    5728: "LN02 height",
    5729: "LHN95 height",
    5730: "EVRF2000 height",
    5731: "Malin Head height",
    5732: "Belfast height",
    5733: "DNN height",
    5734: "AIOC95 depth",
    5735: "Black Sea height",
    5736: "Yellow Sea 1956 height",
    5737: "Yellow Sea 1985 height",
    5738: "HKPD height",
    5739: "HKCD depth",
    5740: "ODN Orkney height",
    5741: "Fair Isle height",
    5742: "Lerwick height",
    5743: "Foula height",
    5744: "Sule Skerry height",
    5745: "North Rona height",
    5746: "Stornoway height",
    5747: "St Kilda height",
    5748: "Flannan Isles height",
    5749: "St Marys height",
    5750: "Douglas height",
    5751: "Fao height",
    5752: "Bandar Abbas height",
    5753: "NGNC height",
    5754: "Poolbeg height",
    5755: "NGG1977 height",
    5756: "Martinique 1987 height",
    5757: "Guadeloupe 1988 height",
    5758: "Reunion 1989 height",
    5759: "Auckland 1946 height",
    5760: "Bluff 1955 height",
    5761: "Dunedin 1958 height",
    5762: "Gisborne 1926 height",
    5763: "Lyttelton 1937 height",
    5764: "Moturiki 1953 height",
    5765: "Napier 1962 height",
    5766: "Nelson 1955 height",
    5767: "One Tree Point 1964 height",
    5768: "Tararu 1952 height",
    5769: "Taranaki 1970 height",
    5770: "Wellington 1953 height",
    5771: "Chatham Island 1959 height",
    5772: "Stewart Island 1977 height",
    5773: "EGM96 height",
    5774: "NG-L height",
    5775: "Antalya height",
    5776: "NN54 height",
    5777: "Durres height",
    5778: "GHA height",
    5779: "NVN99 height",
    5780: "Cascais height",
    5781: "Constanta height",
    5782: "Alicante height",
    5783: "DHHN92 height",
    5784: "DHHN85 height",
    5785: "SNN76 height",
    5786: "Baltic 1982 height",
    5787: "EOMA 1980 height",
    5788: "Kuwait PWD height",
    5789: "KOC WD depth",
    5790: "KOC CD height",
    5791: "NGC 1948 height",
    5792: "Danger 1950 height",
    5793: "Mayotte 1950 height",
    5794: "Martinique 1955 height",
    5795: "Guadeloupe 1951 height",
    5796: "Lagos 1955 height",
    5797: "AIOC95 height",
    5798: "EGM84 height",
    5799: "DVR90 height",
    5829: "Instantaneous Water Level height",
    5831: "Instantaneous Water Level depth",
    5843: "Ras Ghumays height",
    5861: "LAT depth",
    5862: "LLWLT depth",
    5863: "ISLW depth",
    5864: "MLLWS depth",
    5865: "MLWS depth",
    5866: "MLLW depth",
    5867: "MLW depth",
    5868: "MHW height",
    5869: "MHHW height",
    5870: "MHWS height",
    5871: "HHWLT height",
    5872: "HAT height",
    5873: "Low Water depth",
    5874: "High Water height",
    5941: "NN2000 height",
    6130: "GCVD54 height",
    6131: "LCVD61 height",
    6132: "CBVD61 height",
    6178: "Cais da Pontinha - Funchal height",
    6179: "Cais da Vila - Porto Santo height",
    6180: "Cais das Velas height",
    6181: "Horta height",
    6182: "Cais da Madalena height",
    6183: "Santa Cruz da Graciosa height",
    6184: "Cais da Figueirinha - Angra do Heroismo height",
    6185: "Santa Cruz das Flores height",
    6186: "Cais da Vila do Porto height",
    6187: "Ponta Delgada height",
    6357: "NAVD88 depth",
    6358: "NAVD88 depth (ftUS)",
    6359: "NGVD29 depth",
    6360: "NAVD88 height (ftUS)",
    6638: "Tutuila 1962 height",
    6639: "Guam 1963 height",
    6640: "NMVD03 height",
    6641: "PRVD02 height",
    6642: "VIVD09 height",
    6643: "ASVD02 height",
    6644: "GUVD04 height",
    6647: "CGVD2013 height",
    6693: "JSLD72 height",
    6694: "JGD2000 (vertical) height",
    6695: "JGD2011 (vertical) height",
    6916: "SHD height",
    7446: "Famagusta 1960 height",
    7447: "PNG08 height",
    7651: "Kumul 34 height",
    7652: "Kiunga height",
    7699: "DHHN12 height",
    7700: "Latvia 2000 height",
    32767: "User-defined"
}


GeographicTypeGeoKey = {
    3819: "HD1909",
    3821: "TWD67",
    3824: "TWD97",
    3889: "IGRS",
    3906: "MGI 1901",
    4001: "Unknown datum based upon the Airy 1830 ellipsoid",
    4002: "Unknown datum based upon the Airy Modified 1849 ellipsoid",
    4003: "Unknown datum based upon the Australian National Spheroid",
    4004: "Unknown datum based upon the Bessel 1841 ellipsoid",
    4005: "Unknown datum based upon the Bessel Modified ellipsoid",
    4006: "Unknown datum based upon the Bessel Namibia ellipsoid",
    4007: "Unknown datum based upon the Clarke 1858 ellipsoid",
    4008: "Unknown datum based upon the Clarke 1866 ellipsoid",
    4009: "Unknown datum based upon the Clarke 1866 Michigan ellipsoid",
    4010: "Unknown datum based upon the Clarke 1880 (Benoit) ellipsoid",
    4011: "Unknown datum based upon the Clarke 1880 (IGN) ellipsoid",
    4012: "Unknown datum based upon the Clarke 1880 (RGS) ellipsoid",
    4013: "Unknown datum based upon the Clarke 1880 (Arc) ellipsoid",
    4014: "Unknown datum based upon the Clarke 1880 (SGA 1922) ellipsoid",
    4015: "Unknown datum based upon the Everest 1830 (1937 Adjustment) ellipsoid",
    4016: "Unknown datum based upon the Everest 1830 (1967 Definition) ellipsoid",
    4018: "Unknown datum based upon the Everest 1830 Modified ellipsoid",
    4019: "Unknown datum based upon the GRS 1980 ellipsoid",
    4020: "Unknown datum based upon the Helmert 1906 ellipsoid",
    4021: "Unknown datum based upon the Indonesian National Spheroid",
    4022: "Unknown datum based upon the International 1924 ellipsoid",
    4023: "MOLDREF99",
    4024: "Unknown datum based upon the Krassowsky 1940 ellipsoid",
    4025: "Unknown datum based upon the NWL 9D ellipsoid",
    4027: "Unknown datum based upon the Plessis 1817 ellipsoid",
    4028: "Unknown datum based upon the Struve 1860 ellipsoid",
    4029: "Unknown datum based upon the War Office ellipsoid",
    4030: "Unknown datum based upon the WGS 84 ellipsoid",
    4031: "Unknown datum based upon the GEM 10C ellipsoid",
    4032: "Unknown datum based upon the OSU86F ellipsoid",
    4033: "Unknown datum based upon the OSU91A ellipsoid",
    4034: "Unknown datum based upon the Clarke 1880 ellipsoid",
    4035: "Unknown datum based upon the Authalic Sphere",
    4036: "Unknown datum based upon the GRS 1967 ellipsoid",
    4041: "Unknown datum based upon the Average Terrestrial System 1977 ellipsoid",
    4042: "Unknown datum based upon the Everest (1830 Definition) ellipsoid",
    4043: "Unknown datum based upon the WGS 72 ellipsoid",
    4044: "Unknown datum based upon the Everest 1830 (1962 Definition) ellipsoid",
    4045: "Unknown datum based upon the Everest 1830 (1975 Definition) ellipsoid",
    4046: "RGRDC 2005",
    4047: "Unspecified datum based upon the GRS 1980 Authalic Sphere",
    4052: "Unspecified datum based upon the Clarke 1866 Authalic Sphere",
    4053: "Unspecified datum based upon the International 1924 Authalic Sphere",
    4054: "Unspecified datum based upon the Hughes 1980 ellipsoid",
    4055: "Popular Visualisation CRS",
    4075: "SREF98",
    4081: "REGCAN95",
    4120: "Greek",
    4121: "GGRS87",
    4122: "ATS77",
    4123: "KKJ",
    4124: "RT90",
    4125: "Samboja",
    4126: "LKS94 (ETRS89)",
    4127: "Tete",
    4128: "Madzansua",
    4129: "Observatario",
    4130: "Moznet",
    4131: "Indian 1960",
    4132: "FD58",
    4133: "EST92",
    4134: "PSD93",
    4135: "Old Hawaiian",
    4136: "St. Lawrence Island",
    4137: "St. Paul Island",
    4138: "St. George Island",
    4139: "Puerto Rico",
    4140: "NAD83(CSRS98)",
    4141: "Israel 1993",
    4142: "Locodjo 1965",
    4143: "Abidjan 1987",
    4144: "Kalianpur 1937",
    4145: "Kalianpur 1962",
    4146: "Kalianpur 1975",
    4147: "Hanoi 1972",
    4148: "Hartebeesthoek94",
    4149: "CH1903",
    4150: "CH1903+",
    4151: "CHTRF95",
    4152: "NAD83(HARN)",
    4153: "Rassadiran",
    4154: "ED50(ED77)",
    4155: "Dabola 1981",
    4156: "S-JTSK",
    4157: "Mount Dillon",
    4158: "Naparima 1955",
    4159: "ELD79",
    4160: "Chos Malal 1914",
    4161: "Pampa del Castillo",
    4162: "Korean 1985",
    4163: "Yemen NGN96",
    4164: "South Yemen",
    4165: "Bissau",
    4166: "Korean 1995",
    4167: "NZGD2000",
    4168: "Accra",
    4169: "American Samoa 1962",
    4170: "SIRGAS 1995",
    4171: "RGF93",
    4172: "POSGAR",
    4173: "IRENET95",
    4174: "Sierra Leone 1924",
    4175: "Sierra Leone 1968",
    4176: "Australian Antarctic",
    4178: "Pulkovo 1942(83)",
    4179: "Pulkovo 1942(58)",
    4180: "EST97",
    4181: "Luxembourg 1930",
    4182: "Azores Occidental 1939",
    4183: "Azores Central 1948",
    4184: "Azores Oriental 1940",
    4185: "Madeira 1936",
    4188: "OSNI 1952",
    4189: "REGVEN",
    4190: "POSGAR 98",
    4191: "Albanian 1987",
    4192: "Douala 1948",
    4193: "Manoca 1962",
    4194: "Qornoq 1927",
    4195: "Scoresbysund 1952",
    4196: "Ammassalik 1958",
    4197: "Garoua",
    4198: "Kousseri",
    4199: "Egypt 1930",
    4200: "Pulkovo 1995",
    4201: "Adindan",
    4202: "AGD66",
    4203: "AGD84",
    4204: "Ain el Abd",
    4205: "Afgooye",
    4206: "Agadez",
    4207: "Lisbon",
    4208: "Aratu",
    4209: "Arc 1950",
    4210: "Arc 1960",
    4211: "Batavia",
    4212: "Barbados 1938",
    4213: "Beduaram",
    4214: "Beijing 1954",
    4215: "Belge 1950",
    4216: "Bermuda 1957",
    4218: "Bogota 1975",
    4219: "Bukit Rimpah",
    4220: "Camacupa",
    4221: "Campo Inchauspe",
    4222: "Cape",
    4223: "Carthage",
    4224: "Chua",
    4225: "Corrego Alegre 1970-72",
    4226: "Cote d'Ivoire",
    4227: "Deir ez Zor",
    4228: "Douala",
    4229: "Egypt 1907",
    4230: "ED50",
    4231: "ED87",
    4232: "Fahud",
    4233: "Gandajika 1970",
    4234: "Garoua",
    4235: "Guyane Francaise",
    4236: "Hu Tzu Shan 1950",
    4237: "HD72",
    4238: "ID74",
    4239: "Indian 1954",
    4240: "Indian 1975",
    4241: "Jamaica 1875",
    4242: "JAD69",
    4243: "Kalianpur 1880",
    4244: "Kandawala",
    4245: "Kertau 1968",
    4246: "KOC",
    4247: "La Canoa",
    4248: "PSAD56",
    4249: "Lake",
    4250: "Leigon",
    4251: "Liberia 1964",
    4252: "Lome",
    4253: "Luzon 1911",
    4254: "Hito XVIII 1963",
    4255: "Herat North",
    4256: "Mahe 1971",
    4257: "Makassar",
    4258: "ETRS89",
    4259: "Malongo 1987",
    4260: "Manoca",
    4261: "Merchich",
    4262: "Massawa",
    4263: "Minna",
    4264: "Mhast",
    4265: "Monte Mario",
    4266: "M'poraloko",
    4267: "NAD27",
    4268: "NAD27 Michigan",
    4269: "NAD83",
    4270: "Nahrwan 1967",
    4271: "Naparima 1972",
    4272: "NZGD49",
    4273: "NGO 1948",
    4274: "Datum 73",
    4275: "NTF",
    4276: "NSWC 9Z-2",
    4277: "OSGB 1936",
    4278: "OSGB70",
    4279: "OS(SN)80",
    4280: "Padang",
    4281: "Palestine 1923",
    4282: "Pointe Noire",
    4283: "GDA94",
    4284: "Pulkovo 1942",
    4285: "Qatar 1974",
    4286: "Qatar 1948",
    4287: "Qornoq",
    4288: "Loma Quintana",
    4289: "Amersfoort",
    4291: "SAD69",
    4292: "Sapper Hill 1943",
    4293: "Schwarzeck",
    4294: "Segora",
    4295: "Serindung",
    4296: "Sudan",
    4297: "Tananarive",
    4298: "Timbalai 1948",
    4299: "TM65",
    4300: "TM75",
    4301: "Tokyo",
    4302: "Trinidad 1903",
    4303: "TC(1948)",
    4304: "Voirol 1875",
    4306: "Bern 1938",
    4307: "Nord Sahara 1959",
    4308: "RT38",
    4309: "Yacare",
    4310: "Yoff",
    4311: "Zanderij",
    4312: "MGI",
    4313: "Belge 1972",
    4314: "DHDN",
    4315: "Conakry 1905",
    4316: "Dealul Piscului 1930",
    4317: "Dealul Piscului 1970",
    4318: "NGN",
    4319: "KUDAMS",
    4322: "WGS 72",
    4324: "WGS 72BE",
    4326: "WGS 84",
    4463: "RGSPM06",
    4470: "RGM04",
    4475: "Cadastre 1997",
    4483: "Mexico ITRF92",
    4490: "China Geodetic Coordinate System 2000",
    4555: "New Beijing",
    4558: "RRAF 1991",
    4600: "Anguilla 1957",
    4601: "Antigua 1943",
    4602: "Dominica 1945",
    4603: "Grenada 1953",
    4604: "Montserrat 1958",
    4605: "St. Kitts 1955",
    4606: "St. Lucia 1955",
    4607: "St. Vincent 1945",
    4608: "NAD27(76)",
    4609: "NAD27(CGQ77)",
    4610: "Xian 1980",
    4611: "Hong Kong 1980",
    4612: "JGD2000",
    4613: "Segara",
    4614: "QND95",
    4615: "Porto Santo",
    4616: "Selvagem Grande",
    4617: "NAD83(CSRS)",
    4618: "SAD69",
    4619: "SWEREF99",
    4620: "Point 58",
    4621: "Fort Marigot",
    4622: "Guadeloupe 1948",
    4623: "CSG67",
    4624: "RGFG95",
    4625: "Martinique 1938",
    4626: "Reunion 1947",
    4627: "RGR92",
    4628: "Tahiti 52",
    4629: "Tahaa 54",
    4630: "IGN72 Nuku Hiva",
    4631: "K0 1949",
    4632: "Combani 1950",
    4633: "IGN56 Lifou",
    4634: "IGN72 Grand Terre",
    4635: "ST87 Ouvea",
    4636: "Petrels 1972",
    4637: "Perroud 1950",
    4638: "Saint Pierre et Miquelon 1950",
    4639: "MOP78",
    4640: "RRAF 1991",
    4641: "IGN53 Mare",
    4642: "ST84 Ile des Pins",
    4643: "ST71 Belep",
    4644: "NEA74 Noumea",
    4645: "RGNC 1991",
    4646: "Grand Comoros",
    4657: "Reykjavik 1900",
    4658: "Hjorsey 1955",
    4659: "ISN93",
    4660: "Helle 1954",
    4661: "LKS92",
    4662: "IGN72 Grande Terre",
    4663: "Porto Santo 1995",
    4664: "Azores Oriental 1995",
    4665: "Azores Central 1995",
    4666: "Lisbon 1890",
    4667: "IKBD-92",
    4668: "ED79",
    4669: "LKS94",
    4670: "IGM95",
    4671: "Voirol 1879",
    4672: "Chatham Islands 1971",
    4673: "Chatham Islands 1979",
    4674: "SIRGAS 2000",
    4675: "Guam 1963",
    4676: "Vientiane 1982",
    4677: "Lao 1993",
    4678: "Lao 1997",
    4679: "Jouik 1961",
    4680: "Nouakchott 1965",
    4681: "Mauritania 1999",
    4682: "Gulshan 303",
    4683: "PRS92",
    4684: "Gan 1970",
    4685: "Gandajika",
    4686: "MAGNA-SIRGAS",
    4687: "RGPF",
    4688: "Fatu Iva 72",
    4689: "IGN63 Hiva Oa",
    4690: "Tahiti 79",
    4691: "Moorea 87",
    4692: "Maupiti 83",
    4693: "Nakhl-e Ghanem",
    4694: "POSGAR 94",
    4695: "Katanga 1955",
    4696: "Kasai 1953",
    4697: "IGC 1962 6th Parallel South",
    4698: "IGN 1962 Kerguelen",
    4699: "Le Pouce 1934",
    4700: "IGN Astro 1960",
    4701: "IGCB 1955",
    4702: "Mauritania 1999",
    4703: "Mhast 1951",
    4704: "Mhast (onshore)",
    4705: "Mhast (offshore)",
    4706: "Egypt Gulf of Suez S-650 TL",
    4707: "Tern Island 1961",
    4708: "Cocos Islands 1965",
    4709: "Iwo Jima 1945",
    4710: "St. Helena 1971",
    4711: "Marcus Island 1952",
    4712: "Ascension Island 1958",
    4713: "Ayabelle Lighthouse",
    4714: "Bellevue",
    4715: "Camp Area Astro",
    4716: "Phoenix Islands 1966",
    4717: "Cape Canaveral",
    4718: "Solomon 1968",
    4719: "Easter Island 1967",
    4720: "Fiji 1986",
    4721: "Fiji 1956",
    4722: "South Georgia 1968",
    4723: "GCGD59",
    4724: "Diego Garcia 1969",
    4725: "Johnston Island 1961",
    4726: "SIGD61",
    4727: "Midway 1961",
    4728: "Pico de las Nieves 1984",
    4729: "Pitcairn 1967",
    4730: "Santo 1965",
    4731: "Viti Levu 1916",
    4732: "Marshall Islands 1960",
    4733: "Wake Island 1952",
    4734: "Tristan 1968",
    4735: "Kusaie 1951",
    4736: "Deception Island",
    4737: "Korea 2000",
    4738: "Hong Kong 1963",
    4739: "Hong Kong 1963(67)",
    4740: "PZ-90",
    4741: "FD54",
    4742: "GDM2000",
    4743: "Karbala 1979",
    4744: "Nahrwan 1934",
    4745: "RD/83",
    4746: "PD/83",
    4747: "GR96",
    4748: "Vanua Levu 1915",
    4749: "RGNC91-93",
    4750: "ST87 Ouvea",
    4751: "Kertau (RSO)",
    4752: "Viti Levu 1912",
    4753: "fk89",
    4754: "LGD2006",
    4755: "DGN95",
    4756: "VN-2000",
    4757: "SVY21",
    4758: "JAD2001",
    4759: "NAD83(NSRS2007)",
    4760: "WGS 66",
    4761: "HTRS96",
    4762: "BDA2000",
    4763: "Pitcairn 2006",
    4764: "RSRGD2000",
    4765: "Slovenia 1996",
    4801: "Bern 1898 (Bern)",
    4802: "Bogota 1975 (Bogota)",
    4803: "Lisbon (Lisbon)",
    4804: "Makassar (Jakarta)",
    4805: "MGI (Ferro)",
    4806: "Monte Mario (Rome)",
    4807: "NTF (Paris)",
    4808: "Padang (Jakarta)",
    4809: "Belge 1950 (Brussels)",
    4810: "Tananarive (Paris)",
    4811: "Voirol 1875 (Paris)",
    4813: "Batavia (Jakarta)",
    4814: "RT38 (Stockholm)",
    4815: "Greek (Athens)",
    4816: "Carthage (Paris)",
    4817: "NGO 1948 (Oslo)",
    4818: "S-JTSK (Ferro)",
    4819: "Nord Sahara 1959 (Paris)",
    4820: "Segara (Jakarta)",
    4821: "Voirol 1879 (Paris)",
    4823: "Sao Tome",
    4824: "Principe",
    4901: "ATF (Paris)",
    4902: "NDG (Paris)",
    4903: "Madrid 1870 (Madrid)",
    4904: "Lisbon 1890 (Lisbon)",
    5013: "PTRA08",
    5132: "Tokyo 1892",
    5228: "S-JTSK/05",
    5229: "S-JTSK/05 (Ferro)",
    5233: "SLD99",
    5246: "GDBD2009",
    5252: "TUREF",
    5264: "DRUKREF 03",
    5324: "ISN2004",
    5340: "POSGAR 2007",
    5354: "MARGEN",
    5360: "SIRGAS-Chile",
    5365: "CR05",
    5371: "MACARIO SOLIS",
    5373: "Peru96",
    5381: "SIRGAS-ROU98",
    5393: "SIRGAS_ES2007.8",
    5451: "Ocotepeque 1935",
    5464: "Sibun Gorge 1922",
    5467: "Panama-Colon 1911",
    5489: "RGAF09",
    5524: "Corrego Alegre 1961",
    5527: "SAD69(96)",
    5546: "PNG94",
    5561: "UCS-2000",
    5593: "FEH2010",
    5681: "DB_REF",
    5886: "TGD2005",
    6135: "CIGD11",
    6207: "Nepal 1981",
    6311: "CGRS93",
    6318: "NAD83(2011)",
    6322: "NAD83(PA11)",
    6325: "NAD83(MA11)",
    6365: "Mexico ITRF2008",
    6668: "JGD2011",
    6706: "RDN2008",
    6783: "NAD83(CORS96)",
    6881: "Aden 1925",
    6882: "Bekaa Valley 1920",
    6883: "Bioko",
    6892: "South East Island 1943",
    6894: "Gambia",
    6980: "IGD05",
    6983: "IG05 Intermediate CRS",
    6987: "IGD05/12",
    6990: "IG05/12 Intermediate CRS",
    7035: "RGSPM06 (lon-lat)",
    7037: "RGR92 (lon-lat)",
    7039: "RGM04 (lon-lat)",
    7041: "RGFG95 (lon-lat)",
    7073: "RGTAAF07",
    7084: "RGF93 (lon-lat)",
    7086: "RGAF09 (lon-lat)",
    7088: "RGTAAF07 (lon-lat)",
    7133: "RGTAAF07 (lon-lat)",
    7136: "IGD05",
    7139: "IGD05/12",
    7373: "ONGD14",
    7686: "Kyrg-06",
    32767: "User-defined",
    61206405: "Greek (deg)",
    61216405: "GGRS87 (deg)",
    61226405: "ATS77 (deg)",
    61236405: "KKJ (deg)",
    61246405: "RT90 (deg)",
    61266405: "LKS94 (ETRS89) (deg)",
    61266413: "LKS94 (ETRS89) (3D deg)",
    61276405: "Tete (deg)",
    61286405: "Madzansua (deg)",
    61296405: "Observatario (deg)",
    61306405: "Moznet (deg)",
    61316405: "Indian 1960 (deg)",
    61326405: "FD58 (deg)",
    61336405: "EST92 (deg)",
    61346405: "PDO Survey Datum 1993 (deg)",
    61356405: "Old Hawaiian (deg)",
    61366405: "St. Lawrence Island (deg)",
    61376405: "St. Paul Island (deg)",
    61386405: "St. George Island (deg)",
    61396405: "Puerto Rico (deg)",
    61406405: "NAD83(CSRS) (deg)",
    61416405: "Israel (deg)",
    61426405: "Locodjo 1965 (deg)",
    61436405: "Abidjan 1987 (deg)",
    61446405: "Kalianpur 1937 (deg)",
    61456405: "Kalianpur 1962 (deg)",
    61466405: "Kalianpur 1975 (deg)",
    61476405: "Hanoi 1972 (deg)",
    61486405: "Hartebeesthoek94 (deg)",
    61496405: "CH1903 (deg)",
    61506405: "CH1903+ (deg)",
    61516405: "CHTRF95 (deg)",
    61526405: "NAD83(HARN) (deg)",
    61536405: "Rassadiran (deg)",
    61546405: "ED50(ED77) (deg)",
    61556405: "Dabola 1981 (deg)",
    61566405: "S-JTSK (deg)",
    61576405: "Mount Dillon (deg)",
    61586405: "Naparima 1955 (deg)",
    61596405: "ELD79 (deg)",
    61606405: "Chos Malal 1914 (deg)",
    61616405: "Pampa del Castillo (deg)",
    61626405: "Korean 1985 (deg)",
    61636405: "Yemen NGN96 (deg)",
    61646405: "South Yemen (deg)",
    61656405: "Bissau (deg)",
    61666405: "Korean 1995 (deg)",
    61676405: "NZGD2000 (deg)",
    61686405: "Accra (deg)",
    61696405: "American Samoa 1962 (deg)",
    61706405: "SIRGAS (deg)",
    61716405: "RGF93 (deg)",
    61736405: "IRENET95 (deg)",
    61746405: "Sierra Leone 1924 (deg)",
    61756405: "Sierra Leone 1968 (deg)",
    61766405: "Australian Antarctic (deg)",
    61786405: "Pulkovo 1942(83) (deg)",
    61796405: "Pulkovo 1942(58) (deg)",
    61806405: "EST97 (deg)",
    61816405: "Luxembourg 1930 (deg)",
    61826405: "Azores Occidental 1939 (deg)",
    61836405: "Azores Central 1948 (deg)",
    61846405: "Azores Oriental 1940 (deg)",
    61886405: "OSNI 1952 (deg)",
    61896405: "REGVEN (deg)",
    61906405: "POSGAR 98 (deg)",
    61916405: "Albanian 1987 (deg)",
    61926405: "Douala 1948 (deg)",
    61936405: "Manoca 1962 (deg)",
    61946405: "Qornoq 1927 (deg)",
    61956405: "Scoresbysund 1952 (deg)",
    61966405: "Ammassalik 1958 (deg)",
    61976405: "Garoua (deg)",
    61986405: "Kousseri (deg)",
    61996405: "Egypt 1930 (deg)",
    62006405: "Pulkovo 1995 (deg)",
    62016405: "Adindan (deg)",
    62026405: "AGD66 (deg)",
    62036405: "AGD84 (deg)",
    62046405: "Ain el Abd (deg)",
    62056405: "Afgooye (deg)",
    62066405: "Agadez (deg)",
    62076405: "Lisbon (deg)",
    62086405: "Aratu (deg)",
    62096405: "Arc 1950 (deg)",
    62106405: "Arc 1960 (deg)",
    62116405: "Batavia (deg)",
    62126405: "Barbados 1938 (deg)",
    62136405: "Beduaram (deg)",
    62146405: "Beijing 1954 (deg)",
    62156405: "Belge 1950 (deg)",
    62166405: "Bermuda 1957 (deg)",
    62186405: "Bogota 1975 (deg)",
    62196405: "Bukit Rimpah (deg)",
    62206405: "Camacupa (deg)",
    62216405: "Campo Inchauspe (deg)",
    62226405: "Cape (deg)",
    62236405: "Carthage (deg)",
    62246405: "Chua (deg)",
    62256405: "Corrego Alegre (deg)",
    62276405: "Deir ez Zor (deg)",
    62296405: "Egypt 1907 (deg)",
    62306405: "ED50 (deg)",
    62316405: "ED87 (deg)",
    62326405: "Fahud (deg)",
    62336405: "Gandajika 1970 (deg)",
    62366405: "Hu Tzu Shan (deg)",
    62376405: "HD72 (deg)",
    62386405: "ID74 (deg)",
    62396405: "Indian 1954 (deg)",
    62406405: "Indian 1975 (deg)",
    62416405: "Jamaica 1875 (deg)",
    62426405: "JAD69 (deg)",
    62436405: "Kalianpur 1880 (deg)",
    62446405: "Kandawala (deg)",
    62456405: "Kertau (deg)",
    62466405: "KOC (deg)",
    62476405: "La Canoa (deg)",
    62486405: "PSAD56 (deg)",
    62496405: "Lake (deg)",
    62506405: "Leigon (deg)",
    62516405: "Liberia 1964 (deg)",
    62526405: "Lome (deg)",
    62536405: "Luzon 1911 (deg)",
    62546405: "Hito XVIII 1963 (deg)",
    62556405: "Herat North (deg)",
    62566405: "Mahe 1971 (deg)",
    62576405: "Makassar (deg)",
    62586405: "ETRS89 (deg)",
    62596405: "Malongo 1987 (deg)",
    62616405: "Merchich (deg)",
    62626405: "Massawa (deg)",
    62636405: "Minna (deg)",
    62646405: "Mhast (deg)",
    62656405: "Monte Mario (deg)",
    62666405: "M'poraloko (deg)",
    62676405: "NAD27 (deg)",
    62686405: "NAD27 Michigan (deg)",
    62696405: "NAD83 (deg)",
    62706405: "Nahrwan 1967 (deg)",
    62716405: "Naparima 1972 (deg)",
    62726405: "NZGD49 (deg)",
    62736405: "NGO 1948 (deg)",
    62746405: "Datum 73 (deg)",
    62756405: "NTF (deg)",
    62766405: "NSWC 9Z-2 (deg)",
    62776405: "OSGB 1936 (deg)",
    62786405: "OSGB70 (deg)",
    62796405: "OS(SN)80 (deg)",
    62806405: "Padang (deg)",
    62816405: "Palestine 1923 (deg)",
    62826405: "Pointe Noire (deg)",
    62836405: "GDA94 (deg)",
    62846405: "Pulkovo 1942 (deg)",
    62856405: "Qatar 1974 (deg)",
    62866405: "Qatar 1948 (deg)",
    62886405: "Loma Quintana (deg)",
    62896405: "Amersfoort (deg)",
    62926405: "Sapper Hill 1943 (deg)",
    62936405: "Schwarzeck (deg)",
    62956405: "Serindung (deg)",
    62976405: "Tananarive (deg)",
    62986405: "Timbalai 1948 (deg)",
    62996405: "TM65 (deg)",
    63006405: "TM75 (deg)",
    63016405: "Tokyo (deg)",
    63026405: "Trinidad 1903 (deg)",
    63036405: "TC(1948) (deg)",
    63046405: "Voirol 1875 (deg)",
    63066405: "Bern 1938 (deg)",
    63076405: "Nord Sahara 1959 (deg)",
    63086405: "RT38 (deg)",
    63096405: "Yacare (deg)",
    63106405: "Yoff (deg)",
    63116405: "Zanderij (deg)",
    63126405: "MGI (deg)",
    63136405: "Belge 1972 (deg)",
    63146405: "DHDN (deg)",
    63156405: "Conakry 1905 (deg)",
    63166405: "Dealul Piscului 1933 (deg)",
    63176405: "Dealul Piscului 1970 (deg)",
    63186405: "NGN (deg)",
    63196405: "KUDAMS (deg)",
    63226405: "WGS 72 (deg)",
    63246405: "WGS 72BE (deg)",
    63266405: "WGS 84 (deg)",
    63266406: "WGS 84 (degH)",
    63266407: "WGS 84 (Hdeg)",
    63266408: "WGS 84 (DM)",
    63266409: "WGS 84 (DMH)",
    63266410: "WGS 84 (HDM)",
    63266411: "WGS 84 (DMS)",
    63266412: "WGS 84 (HDMS)",
    66006405: "Anguilla 1957 (deg)",
    66016405: "Antigua 1943 (deg)",
    66026405: "Dominica 1945 (deg)",
    66036405: "Grenada 1953 (deg)",
    66046405: "Montserrat 1958 (deg)",
    66056405: "St. Kitts 1955 (deg)",
    66066405: "St. Lucia 1955 (deg)",
    66076405: "St. Vincent 1945 (deg)",
    66086405: "NAD27(76) (deg)",
    66096405: "NAD27(CGQ77) (deg)",
    66106405: "Xian 1980 (deg)",
    66116405: "Hong Kong 1980 (deg)",
    66126405: "JGD2000 (deg)",
    66136405: "Segara (deg)",
    66146405: "QND95 (deg)",
    66156405: "Porto Santo (deg)",
    66166405: "Selvagem Grande (deg)",
    66186405: "SAD69 (deg)",
    66196405: "SWEREF99 (deg)",
    66206405: "Point 58 (deg)",
    66216405: "Fort Marigot (deg)",
    66226405: "Sainte Anne (deg)",
    66236405: "CSG67 (deg)",
    66246405: "RGFG95 (deg)",
    66256405: "Fort Desaix (deg)",
    66266405: "Piton des Neiges (deg)",
    66276405: "RGR92 (deg)",
    66286405: "Tahiti (deg)",
    66296405: "Tahaa (deg)",
    66306405: "IGN72 Nuku Hiva (deg)",
    66316405: "K0 1949 (deg)",
    66326405: "Combani 1950 (deg)",
    66336405: "IGN56 Lifou (deg)",
    66346405: "IGN72 Grande Terre (deg)",
    66356405: "ST87 Ouvea (deg)",
    66366405: "Petrels 1972 (deg)",
    66376405: "Perroud 1950 (deg)",
    66386405: "Saint Pierre et Miquelon 1950 (deg)",
    66396405: "MOP78 (deg)",
    66406405: "RRAF 1991 (deg)",
    66416405: "IGN53 Mare (deg)",
    66426405: "ST84 Ile des Pins (deg)",
    66436405: "ST71 Belep (deg)",
    66446405: "NEA74 Noumea (deg)",
    66456405: "RGNC 1991 (deg)",
    66466405: "Grand Comoros (deg)",
    66576405: "Reykjavik 1900 (deg)",
    66586405: "Hjorsey 1955 (deg)",
    66596405: "ISN93 (deg)",
    66606405: "Helle 1954 (deg)",
    66616405: "LKS92 (deg)",
    66636405: "Porto Santo 1995 (deg)",
    66646405: "Azores Oriental 1995 (deg)",
    66656405: "Azores Central 1995 (deg)",
    66666405: "Lisbon 1890 (deg)",
    66676405: "IKBD-92 (deg)",
    68016405: "Bern 1898 (Bern) (deg)",
    68026405: "Bogota 1975 (Bogota) (deg)",
    68036405: "Lisbon (Lisbon) (deg)",
    68046405: "Makassar (Jakarta) (deg)",
    68056405: "MGI (Ferro) (deg)",
    68066405: "Monte Mario (Rome) (deg)",
    68086405: "Padang (Jakarta) (deg)",
    68096405: "Belge 1950 (Brussels) (deg)",
    68136405: "Batavia (Jakarta) (deg)",
    68146405: "RT38 (Stockholm) (deg)",
    68156405: "Greek (Athens) (deg)",
    68186405: "S-JTSK (Ferro) (deg)",
    68206405: "Segara (Jakarta) (deg)",
    69036405: "Madrid 1870 (Madrid) (deg)"
}


ProjectedCSTypeGeoKey = {
    2000: "Anguilla 1957 / British West Indies Grid",
    2001: "Antigua 1943 / British West Indies Grid",
    2002: "Dominica 1945 / British West Indies Grid",
    2003: "Grenada 1953 / British West Indies Grid",
    2004: "Montserrat 1958 / British West Indies Grid",
    2005: "St. Kitts 1955 / British West Indies Grid",
    2006: "St. Lucia 1955 / British West Indies Grid",
    2007: "St. Vincent 45 / British West Indies Grid",
    2008: "NAD27(CGQ77) / SCoPQ zone 2",
    2009: "NAD27(CGQ77) / SCoPQ zone 3",
    2010: "NAD27(CGQ77) / SCoPQ zone 4",
    2011: "NAD27(CGQ77) / SCoPQ zone 5",
    2012: "NAD27(CGQ77) / SCoPQ zone 6",
    2013: "NAD27(CGQ77) / SCoPQ zone 7",
    2014: "NAD27(CGQ77) / SCoPQ zone 8",
    2015: "NAD27(CGQ77) / SCoPQ zone 9",
    2016: "NAD27(CGQ77) / SCoPQ zone 10",
    2017: "NAD27(76) / MTM zone 8",
    2018: "NAD27(76) / MTM zone 9",
    2019: "NAD27(76) / MTM zone 10",
    2020: "NAD27(76) / MTM zone 11",
    2021: "NAD27(76) / MTM zone 12",
    2022: "NAD27(76) / MTM zone 13",
    2023: "NAD27(76) / MTM zone 14",
    2024: "NAD27(76) / MTM zone 15",
    2025: "NAD27(76) / MTM zone 16",
    2026: "NAD27(76) / MTM zone 17",
    2027: "NAD27(76) / UTM zone 15N",
    2028: "NAD27(76) / UTM zone 16N",
    2029: "NAD27(76) / UTM zone 17N",
    2030: "NAD27(76) / UTM zone 18N",
    2031: "NAD27(CGQ77) / UTM zone 17N",
    2032: "NAD27(CGQ77) / UTM zone 18N",
    2033: "NAD27(CGQ77) / UTM zone 19N",
    2034: "NAD27(CGQ77) / UTM zone 20N",
    2035: "NAD27(CGQ77) / UTM zone 21N",
    2036: "NAD83(CSRS98) / New Brunswick Stereo",
    2037: "NAD83(CSRS98) / UTM zone 19N",
    2038: "NAD83(CSRS98) / UTM zone 20N",
    2039: "Israel 1993 / Israeli TM Grid",
    2040: "Locodjo 1965 / UTM zone 30N",
    2041: "Abidjan 1987 / UTM zone 30N",
    2042: "Locodjo 1965 / UTM zone 29N",
    2043: "Abidjan 1987 / UTM zone 29N",
    2044: "Hanoi 1972 / Gauss-Kruger zone 18",
    2045: "Hanoi 1972 / Gauss-Kruger zone 19",
    2046: "Hartebeesthoek94 / Lo15",
    2047: "Hartebeesthoek94 / Lo17",
    2048: "Hartebeesthoek94 / Lo19",
    2049: "Hartebeesthoek94 / Lo21",
    2050: "Hartebeesthoek94 / Lo23",
    2051: "Hartebeesthoek94 / Lo25",
    2052: "Hartebeesthoek94 / Lo27",
    2053: "Hartebeesthoek94 / Lo29",
    2054: "Hartebeesthoek94 / Lo31",
    2055: "Hartebeesthoek94 / Lo33",
    2056: "CH1903+ / LV95",
    2057: "Rassadiran / Nakhl e Taqi",
    2058: "ED50(ED77) / UTM zone 38N",
    2059: "ED50(ED77) / UTM zone 39N",
    2060: "ED50(ED77) / UTM zone 40N",
    2061: "ED50(ED77) / UTM zone 41N",
    2062: "Madrid 1870 (Madrid) / Spain",
    2063: "Dabola 1981 / UTM zone 28N",
    2064: "Dabola 1981 / UTM zone 29N",
    2065: "S-JTSK (Ferro) / Krovak",
    2066: "Mount Dillon / Tobago Grid",
    2067: "Naparima 1955 / UTM zone 20N",
    2068: "ELD79 / Libya zone 5",
    2069: "ELD79 / Libya zone 6",
    2070: "ELD79 / Libya zone 7",
    2071: "ELD79 / Libya zone 8",
    2072: "ELD79 / Libya zone 9",
    2073: "ELD79 / Libya zone 10",
    2074: "ELD79 / Libya zone 11",
    2075: "ELD79 / Libya zone 12",
    2076: "ELD79 / Libya zone 13",
    2077: "ELD79 / UTM zone 32N",
    2078: "ELD79 / UTM zone 33N",
    2079: "ELD79 / UTM zone 34N",
    2080: "ELD79 / UTM zone 35N",
    2081: "Chos Malal 1914 / Argentina 2",
    2082: "Pampa del Castillo / Argentina 2",
    2083: "Hito XVIII 1963 / Argentina 2",
    2084: "Hito XVIII 1963 / UTM zone 19S",
    2085: "NAD27 / Cuba Norte",
    2086: "NAD27 / Cuba Sur",
    2087: "ELD79 / TM 12 NE",
    2088: "Carthage / TM 11 NE",
    2089: "Yemen NGN96 / UTM zone 38N",
    2090: "Yemen NGN96 / UTM zone 39N",
    2091: "South Yemen / Gauss Kruger zone 8",
    2092: "South Yemen / Gauss Kruger zone 9",
    2093: "Hanoi 1972 / GK 106 NE",
    2094: "WGS 72BE / TM 106 NE",
    2095: "Bissau / UTM zone 28N",
    2096: "Korean 1985 / East Belt",
    2097: "Korean 1985 / Central Belt",
    2098: "Korean 1985 / West Belt",
    2099: "Qatar 1948 / Qatar Grid",
    2100: "GGRS87 / Greek Grid",
    2101: "Lake / Maracaibo Grid M1",
    2102: "Lake / Maracaibo Grid",
    2103: "Lake / Maracaibo Grid M3",
    2104: "Lake / Maracaibo La Rosa Grid",
    2105: "NZGD2000 / Mount Eden 2000",
    2106: "NZGD2000 / Bay of Plenty 2000",
    2107: "NZGD2000 / Poverty Bay 2000",
    2108: "NZGD2000 / Hawkes Bay 2000",
    2109: "NZGD2000 / Taranaki 2000",
    2110: "NZGD2000 / Tuhirangi 2000",
    2111: "NZGD2000 / Wanganui 2000",
    2112: "NZGD2000 / Wairarapa 2000",
    2113: "NZGD2000 / Wellington 2000",
    2114: "NZGD2000 / Collingwood 2000",
    2115: "NZGD2000 / Nelson 2000",
    2116: "NZGD2000 / Karamea 2000",
    2117: "NZGD2000 / Buller 2000",
    2118: "NZGD2000 / Grey 2000",
    2119: "NZGD2000 / Amuri 2000",
    2120: "NZGD2000 / Marlborough 2000",
    2121: "NZGD2000 / Hokitika 2000",
    2122: "NZGD2000 / Okarito 2000",
    2123: "NZGD2000 / Jacksons Bay 2000",
    2124: "NZGD2000 / Mount Pleasant 2000",
    2125: "NZGD2000 / Gawler 2000",
    2126: "NZGD2000 / Timaru 2000",
    2127: "NZGD2000 / Lindis Peak 2000",
    2128: "NZGD2000 / Mount Nicholas 2000",
    2129: "NZGD2000 / Mount York 2000",
    2130: "NZGD2000 / Observation Point 2000",
    2131: "NZGD2000 / North Taieri 2000",
    2132: "NZGD2000 / Bluff 2000",
    2133: "NZGD2000 / UTM zone 58S",
    2134: "NZGD2000 / UTM zone 59S",
    2135: "NZGD2000 / UTM zone 60S",
    2136: "Accra / Ghana National Grid",
    2137: "Accra / TM 1 NW",
    2138: "NAD27(CGQ77) / Quebec Lambert",
    2139: "NAD83(CSRS98) / SCoPQ zone 2",
    2140: "NAD83(CSRS98) / MTM zone 3",
    2141: "NAD83(CSRS98) / MTM zone 4",
    2142: "NAD83(CSRS98) / MTM zone 5",
    2143: "NAD83(CSRS98) / MTM zone 6",
    2144: "NAD83(CSRS98) / MTM zone 7",
    2145: "NAD83(CSRS98) / MTM zone 8",
    2146: "NAD83(CSRS98) / MTM zone 9",
    2147: "NAD83(CSRS98) / MTM zone 10",
    2148: "NAD83(CSRS98) / UTM zone 21N",
    2149: "NAD83(CSRS98) / UTM zone 18N",
    2150: "NAD83(CSRS98) / UTM zone 17N",
    2151: "NAD83(CSRS98) / UTM zone 13N",
    2152: "NAD83(CSRS98) / UTM zone 12N",
    2153: "NAD83(CSRS98) / UTM zone 11N",
    2154: "RGF93 / Lambert-93",
    2155: "American Samoa 1962 / American Samoa Lambert",
    2156: "NAD83(HARN) / UTM zone 59S",
    2157: "IRENET95 / Irish Transverse Mercator",
    2158: "IRENET95 / UTM zone 29N",
    2159: "Sierra Leone 1924 / New Colony Grid",
    2160: "Sierra Leone 1924 / New War Office Grid",
    2161: "Sierra Leone 1968 / UTM zone 28N",
    2162: "Sierra Leone 1968 / UTM zone 29N",
    2163: "US National Atlas Equal Area",
    2164: "Locodjo 1965 / TM 5 NW",
    2165: "Abidjan 1987 / TM 5 NW",
    2166: "Pulkovo 1942(83) / Gauss Kruger zone 3",
    2167: "Pulkovo 1942(83) / Gauss Kruger zone 4",
    2168: "Pulkovo 1942(83) / Gauss Kruger zone 5",
    2169: "Luxembourg 1930 / Gauss",
    2170: "MGI / Slovenia Grid",
    2171: "Pulkovo 1942(58) / Poland zone I",
    2172: "Pulkovo 1942(58) / Poland zone II",
    2173: "Pulkovo 1942(58) / Poland zone III",
    2174: "Pulkovo 1942(58) / Poland zone IV",
    2175: "Pulkovo 1942(58) / Poland zone V",
    2176: "ETRS89 / Poland CS2000 zone 5",
    2177: "ETRS89 / Poland CS2000 zone 6",
    2178: "ETRS89 / Poland CS2000 zone 7",
    2179: "ETRS89 / Poland CS2000 zone 8",
    2180: "ETRS89 / Poland CS92",
    2188: "Azores Occidental 1939 / UTM zone 25N",
    2189: "Azores Central 1948 / UTM zone 26N",
    2190: "Azores Oriental 1940 / UTM zone 26N",
    2191: "Madeira 1936 / UTM zone 28N",
    2192: "ED50 / France EuroLambert",
    2193: "NZGD2000 / New Zealand Transverse Mercator 2000",
    2194: "American Samoa 1962 / American Samoa Lambert",
    2195: "NAD83(HARN) / UTM zone 2S",
    2196: "ETRS89 / Kp2000 Jutland",
    2197: "ETRS89 / Kp2000 Zealand",
    2198: "ETRS89 / Kp2000 Bornholm",
    2199: "Albanian 1987 / Gauss Kruger zone 4",
    2200: "ATS77 / New Brunswick Stereographic (ATS77)",
    2201: "REGVEN / UTM zone 18N",
    2202: "REGVEN / UTM zone 19N",
    2203: "REGVEN / UTM zone 20N",
    2204: "NAD27 / Tennessee",
    2205: "NAD83 / Kentucky North",
    2206: "ED50 / 3-degree Gauss-Kruger zone 9",
    2207: "ED50 / 3-degree Gauss-Kruger zone 10",
    2208: "ED50 / 3-degree Gauss-Kruger zone 11",
    2209: "ED50 / 3-degree Gauss-Kruger zone 12",
    2210: "ED50 / 3-degree Gauss-Kruger zone 13",
    2211: "ED50 / 3-degree Gauss-Kruger zone 14",
    2212: "ED50 / 3-degree Gauss-Kruger zone 15",
    2213: "ETRS89 / TM 30 NE",
    2214: "Douala 1948 / AOF west",
    2215: "Manoca 1962 / UTM zone 32N",
    2216: "Qornoq 1927 / UTM zone 22N",
    2217: "Qornoq 1927 / UTM zone 23N",
    2218: "Scoresbysund 1952 / Greenland zone 5 east",
    2219: "ATS77 / UTM zone 19N",
    2220: "ATS77 / UTM zone 20N",
    2221: "Scoresbysund 1952 / Greenland zone 6 east",
    2222: "NAD83 / Arizona East (ft)",
    2223: "NAD83 / Arizona Central (ft)",
    2224: "NAD83 / Arizona West (ft)",
    2225: "NAD83 / California zone 1 (ftUS)",
    2226: "NAD83 / California zone 2 (ftUS)",
    2227: "NAD83 / California zone 3 (ftUS)",
    2228: "NAD83 / California zone 4 (ftUS)",
    2229: "NAD83 / California zone 5 (ftUS)",
    2230: "NAD83 / California zone 6 (ftUS)",
    2231: "NAD83 / Colorado North (ftUS)",
    2232: "NAD83 / Colorado Central (ftUS)",
    2233: "NAD83 / Colorado South (ftUS)",
    2234: "NAD83 / Connecticut (ftUS)",
    2235: "NAD83 / Delaware (ftUS)",
    2236: "NAD83 / Florida East (ftUS)",
    2237: "NAD83 / Florida West (ftUS)",
    2238: "NAD83 / Florida North (ftUS)",
    2239: "NAD83 / Georgia East (ftUS)",
    2240: "NAD83 / Georgia West (ftUS)",
    2241: "NAD83 / Idaho East (ftUS)",
    2242: "NAD83 / Idaho Central (ftUS)",
    2243: "NAD83 / Idaho West (ftUS)",
    2244: "NAD83 / Indiana East (ftUS)",
    2245: "NAD83 / Indiana West (ftUS)",
    2246: "NAD83 / Kentucky North (ftUS)",
    2247: "NAD83 / Kentucky South (ftUS)",
    2248: "NAD83 / Maryland (ftUS)",
    2249: "NAD83 / Massachusetts Mainland (ftUS)",
    2250: "NAD83 / Massachusetts Island (ftUS)",
    2251: "NAD83 / Michigan North (ft)",
    2252: "NAD83 / Michigan Central (ft)",
    2253: "NAD83 / Michigan South (ft)",
    2254: "NAD83 / Mississippi East (ftUS)",
    2255: "NAD83 / Mississippi West (ftUS)",
    2256: "NAD83 / Montana (ft)",
    2257: "NAD83 / New Mexico East (ftUS)",
    2258: "NAD83 / New Mexico Central (ftUS)",
    2259: "NAD83 / New Mexico West (ftUS)",
    2260: "NAD83 / New York East (ftUS)",
    2261: "NAD83 / New York Central (ftUS)",
    2262: "NAD83 / New York West (ftUS)",
    2263: "NAD83 / New York Long Island (ftUS)",
    2264: "NAD83 / North Carolina (ftUS)",
    2265: "NAD83 / North Dakota North (ft)",
    2266: "NAD83 / North Dakota South (ft)",
    2267: "NAD83 / Oklahoma North (ftUS)",
    2268: "NAD83 / Oklahoma South (ftUS)",
    2269: "NAD83 / Oregon North (ft)",
    2270: "NAD83 / Oregon South (ft)",
    2271: "NAD83 / Pennsylvania North (ftUS)",
    2272: "NAD83 / Pennsylvania South (ftUS)",
    2273: "NAD83 / South Carolina (ft)",
    2274: "NAD83 / Tennessee (ftUS)",
    2275: "NAD83 / Texas North (ftUS)",
    2276: "NAD83 / Texas North Central (ftUS)",
    2277: "NAD83 / Texas Central (ftUS)",
    2278: "NAD83 / Texas South Central (ftUS)",
    2279: "NAD83 / Texas South (ftUS)",
    2280: "NAD83 / Utah North (ft)",
    2281: "NAD83 / Utah Central (ft)",
    2282: "NAD83 / Utah South (ft)",
    2283: "NAD83 / Virginia North (ftUS)",
    2284: "NAD83 / Virginia South (ftUS)",
    2285: "NAD83 / Washington North (ftUS)",
    2286: "NAD83 / Washington South (ftUS)",
    2287: "NAD83 / Wisconsin North (ftUS)",
    2288: "NAD83 / Wisconsin Central (ftUS)",
    2289: "NAD83 / Wisconsin South (ftUS)",
    2290: "ATS77 / Prince Edward Isl. Stereographic (ATS77)",
    2291: "NAD83(CSRS98) / Prince Edward Isl. Stereographic (NAD83)",
    2292: "NAD83(CSRS98) / Prince Edward Isl. Stereographic (NAD83)",
    2294: "ATS77 / MTM Nova Scotia zone 4",
    2295: "ATS77 / MTM Nova Scotia zone 5",
    2296: "Ammassalik 1958 / Greenland zone 7 east",
    2297: "Qornoq 1927 / Greenland zone 1 east",
    2298: "Qornoq 1927 / Greenland zone 2 east",
    2299: "Qornoq 1927 / Greenland zone 2 west",
    2300: "Qornoq 1927 / Greenland zone 3 east",
    2301: "Qornoq 1927 / Greenland zone 3 west",
    2302: "Qornoq 1927 / Greenland zone 4 east",
    2303: "Qornoq 1927 / Greenland zone 4 west",
    2304: "Qornoq 1927 / Greenland zone 5 west",
    2305: "Qornoq 1927 / Greenland zone 6 west",
    2306: "Qornoq 1927 / Greenland zone 7 west",
    2307: "Qornoq 1927 / Greenland zone 8 east",
    2308: "Batavia / TM 109 SE",
    2309: "WGS 84 / TM 116 SE",
    2310: "WGS 84 / TM 132 SE",
    2311: "WGS 84 / TM 6 NE",
    2312: "Garoua / UTM zone 33N",
    2313: "Kousseri / UTM zone 33N",
    2314: "Trinidad 1903 / Trinidad Grid (ftCla)",
    2315: "Campo Inchauspe / UTM zone 19S",
    2316: "Campo Inchauspe / UTM zone 20S",
    2317: "PSAD56 / ICN Regional",
    2318: "Ain el Abd / Aramco Lambert",
    2319: "ED50 / TM27",
    2320: "ED50 / TM30",
    2321: "ED50 / TM33",
    2322: "ED50 / TM36",
    2323: "ED50 / TM39",
    2324: "ED50 / TM42",
    2325: "ED50 / TM45",
    2326: "Hong Kong 1980 Grid System",
    2327: "Xian 1980 / Gauss-Kruger zone 13",
    2328: "Xian 1980 / Gauss-Kruger zone 14",
    2329: "Xian 1980 / Gauss-Kruger zone 15",
    2330: "Xian 1980 / Gauss-Kruger zone 16",
    2331: "Xian 1980 / Gauss-Kruger zone 17",
    2332: "Xian 1980 / Gauss-Kruger zone 18",
    2333: "Xian 1980 / Gauss-Kruger zone 19",
    2334: "Xian 1980 / Gauss-Kruger zone 20",
    2335: "Xian 1980 / Gauss-Kruger zone 21",
    2336: "Xian 1980 / Gauss-Kruger zone 22",
    2337: "Xian 1980 / Gauss-Kruger zone 23",
    2338: "Xian 1980 / Gauss-Kruger CM 75E",
    2339: "Xian 1980 / Gauss-Kruger CM 81E",
    2340: "Xian 1980 / Gauss-Kruger CM 87E",
    2341: "Xian 1980 / Gauss-Kruger CM 93E",
    2342: "Xian 1980 / Gauss-Kruger CM 99E",
    2343: "Xian 1980 / Gauss-Kruger CM 105E",
    2344: "Xian 1980 / Gauss-Kruger CM 111E",
    2345: "Xian 1980 / Gauss-Kruger CM 117E",
    2346: "Xian 1980 / Gauss-Kruger CM 123E",
    2347: "Xian 1980 / Gauss-Kruger CM 129E",
    2348: "Xian 1980 / Gauss-Kruger CM 135E",
    2349: "Xian 1980 / 3-degree Gauss-Kruger zone 25",
    2350: "Xian 1980 / 3-degree Gauss-Kruger zone 26",
    2351: "Xian 1980 / 3-degree Gauss-Kruger zone 27",
    2352: "Xian 1980 / 3-degree Gauss-Kruger zone 28",
    2353: "Xian 1980 / 3-degree Gauss-Kruger zone 29",
    2354: "Xian 1980 / 3-degree Gauss-Kruger zone 30",
    2355: "Xian 1980 / 3-degree Gauss-Kruger zone 31",
    2356: "Xian 1980 / 3-degree Gauss-Kruger zone 32",
    2357: "Xian 1980 / 3-degree Gauss-Kruger zone 33",
    2358: "Xian 1980 / 3-degree Gauss-Kruger zone 34",
    2359: "Xian 1980 / 3-degree Gauss-Kruger zone 35",
    2360: "Xian 1980 / 3-degree Gauss-Kruger zone 36",
    2361: "Xian 1980 / 3-degree Gauss-Kruger zone 37",
    2362: "Xian 1980 / 3-degree Gauss-Kruger zone 38",
    2363: "Xian 1980 / 3-degree Gauss-Kruger zone 39",
    2364: "Xian 1980 / 3-degree Gauss-Kruger zone 40",
    2365: "Xian 1980 / 3-degree Gauss-Kruger zone 41",
    2366: "Xian 1980 / 3-degree Gauss-Kruger zone 42",
    2367: "Xian 1980 / 3-degree Gauss-Kruger zone 43",
    2368: "Xian 1980 / 3-degree Gauss-Kruger zone 44",
    2369: "Xian 1980 / 3-degree Gauss-Kruger zone 45",
    2370: "Xian 1980 / 3-degree Gauss-Kruger CM 75E",
    2371: "Xian 1980 / 3-degree Gauss-Kruger CM 78E",
    2372: "Xian 1980 / 3-degree Gauss-Kruger CM 81E",
    2373: "Xian 1980 / 3-degree Gauss-Kruger CM 84E",
    2374: "Xian 1980 / 3-degree Gauss-Kruger CM 87E",
    2375: "Xian 1980 / 3-degree Gauss-Kruger CM 90E",
    2376: "Xian 1980 / 3-degree Gauss-Kruger CM 93E",
    2377: "Xian 1980 / 3-degree Gauss-Kruger CM 96E",
    2378: "Xian 1980 / 3-degree Gauss-Kruger CM 99E",
    2379: "Xian 1980 / 3-degree Gauss-Kruger CM 102E",
    2380: "Xian 1980 / 3-degree Gauss-Kruger CM 105E",
    2381: "Xian 1980 / 3-degree Gauss-Kruger CM 108E",
    2382: "Xian 1980 / 3-degree Gauss-Kruger CM 111E",
    2383: "Xian 1980 / 3-degree Gauss-Kruger CM 114E",
    2384: "Xian 1980 / 3-degree Gauss-Kruger CM 117E",
    2385: "Xian 1980 / 3-degree Gauss-Kruger CM 120E",
    2386: "Xian 1980 / 3-degree Gauss-Kruger CM 123E",
    2387: "Xian 1980 / 3-degree Gauss-Kruger CM 126E",
    2388: "Xian 1980 / 3-degree Gauss-Kruger CM 129E",
    2389: "Xian 1980 / 3-degree Gauss-Kruger CM 132E",
    2390: "Xian 1980 / 3-degree Gauss-Kruger CM 135E",
    2391: "KKJ / Finland zone 1",
    2392: "KKJ / Finland zone 2",
    2393: "KKJ / Finland Uniform Coordinate System",
    2394: "KKJ / Finland zone 4",
    2395: "South Yemen / Gauss-Kruger zone 8",
    2396: "South Yemen / Gauss-Kruger zone 9",
    2397: "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3",
    2398: "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4",
    2399: "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5",
    2400: "RT90 2.5 gon W",
    2401: "Beijing 1954 / 3-degree Gauss-Kruger zone 25",
    2402: "Beijing 1954 / 3-degree Gauss-Kruger zone 26",
    2403: "Beijing 1954 / 3-degree Gauss-Kruger zone 27",
    2404: "Beijing 1954 / 3-degree Gauss-Kruger zone 28",
    2405: "Beijing 1954 / 3-degree Gauss-Kruger zone 29",
    2406: "Beijing 1954 / 3-degree Gauss-Kruger zone 30",
    2407: "Beijing 1954 / 3-degree Gauss-Kruger zone 31",
    2408: "Beijing 1954 / 3-degree Gauss-Kruger zone 32",
    2409: "Beijing 1954 / 3-degree Gauss-Kruger zone 33",
    2410: "Beijing 1954 / 3-degree Gauss-Kruger zone 34",
    2411: "Beijing 1954 / 3-degree Gauss-Kruger zone 35",
    2412: "Beijing 1954 / 3-degree Gauss-Kruger zone 36",
    2413: "Beijing 1954 / 3-degree Gauss-Kruger zone 37",
    2414: "Beijing 1954 / 3-degree Gauss-Kruger zone 38",
    2415: "Beijing 1954 / 3-degree Gauss-Kruger zone 39",
    2416: "Beijing 1954 / 3-degree Gauss-Kruger zone 40",
    2417: "Beijing 1954 / 3-degree Gauss-Kruger zone 41",
    2418: "Beijing 1954 / 3-degree Gauss-Kruger zone 42",
    2419: "Beijing 1954 / 3-degree Gauss-Kruger zone 43",
    2420: "Beijing 1954 / 3-degree Gauss-Kruger zone 44",
    2421: "Beijing 1954 / 3-degree Gauss-Kruger zone 45",
    2422: "Beijing 1954 / 3-degree Gauss-Kruger CM 75E",
    2423: "Beijing 1954 / 3-degree Gauss-Kruger CM 78E",
    2424: "Beijing 1954 / 3-degree Gauss-Kruger CM 81E",
    2425: "Beijing 1954 / 3-degree Gauss-Kruger CM 84E",
    2426: "Beijing 1954 / 3-degree Gauss-Kruger CM 87E",
    2427: "Beijing 1954 / 3-degree Gauss-Kruger CM 90E",
    2428: "Beijing 1954 / 3-degree Gauss-Kruger CM 93E",
    2429: "Beijing 1954 / 3-degree Gauss-Kruger CM 96E",
    2430: "Beijing 1954 / 3-degree Gauss-Kruger CM 99E",
    2431: "Beijing 1954 / 3-degree Gauss-Kruger CM 102E",
    2432: "Beijing 1954 / 3-degree Gauss-Kruger CM 105E",
    2433: "Beijing 1954 / 3-degree Gauss-Kruger CM 108E",
    2434: "Beijing 1954 / 3-degree Gauss-Kruger CM 111E",
    2435: "Beijing 1954 / 3-degree Gauss-Kruger CM 114E",
    2436: "Beijing 1954 / 3-degree Gauss-Kruger CM 117E",
    2437: "Beijing 1954 / 3-degree Gauss-Kruger CM 120E",
    2438: "Beijing 1954 / 3-degree Gauss-Kruger CM 123E",
    2439: "Beijing 1954 / 3-degree Gauss-Kruger CM 126E",
    2440: "Beijing 1954 / 3-degree Gauss-Kruger CM 129E",
    2441: "Beijing 1954 / 3-degree Gauss-Kruger CM 132E",
    2442: "Beijing 1954 / 3-degree Gauss-Kruger CM 135E",
    2443: "JGD2000 / Japan Plane Rectangular CS I",
    2444: "JGD2000 / Japan Plane Rectangular CS II",
    2445: "JGD2000 / Japan Plane Rectangular CS III",
    2446: "JGD2000 / Japan Plane Rectangular CS IV",
    2447: "JGD2000 / Japan Plane Rectangular CS V",
    2448: "JGD2000 / Japan Plane Rectangular CS VI",
    2449: "JGD2000 / Japan Plane Rectangular CS VII",
    2450: "JGD2000 / Japan Plane Rectangular CS VIII",
    2451: "JGD2000 / Japan Plane Rectangular CS IX",
    2452: "JGD2000 / Japan Plane Rectangular CS X",
    2453: "JGD2000 / Japan Plane Rectangular CS XI",
    2454: "JGD2000 / Japan Plane Rectangular CS XII",
    2455: "JGD2000 / Japan Plane Rectangular CS XIII",
    2456: "JGD2000 / Japan Plane Rectangular CS XIV",
    2457: "JGD2000 / Japan Plane Rectangular CS XV",
    2458: "JGD2000 / Japan Plane Rectangular CS XVI",
    2459: "JGD2000 / Japan Plane Rectangular CS XVII",
    2460: "JGD2000 / Japan Plane Rectangular CS XVIII",
    2461: "JGD2000 / Japan Plane Rectangular CS XIX",
    2462: "Albanian 1987 / Gauss-Kruger zone 4",
    2463: "Pulkovo 1995 / Gauss-Kruger CM 21E",
    2464: "Pulkovo 1995 / Gauss-Kruger CM 27E",
    2465: "Pulkovo 1995 / Gauss-Kruger CM 33E",
    2466: "Pulkovo 1995 / Gauss-Kruger CM 39E",
    2467: "Pulkovo 1995 / Gauss-Kruger CM 45E",
    2468: "Pulkovo 1995 / Gauss-Kruger CM 51E",
    2469: "Pulkovo 1995 / Gauss-Kruger CM 57E",
    2470: "Pulkovo 1995 / Gauss-Kruger CM 63E",
    2471: "Pulkovo 1995 / Gauss-Kruger CM 69E",
    2472: "Pulkovo 1995 / Gauss-Kruger CM 75E",
    2473: "Pulkovo 1995 / Gauss-Kruger CM 81E",
    2474: "Pulkovo 1995 / Gauss-Kruger CM 87E",
    2475: "Pulkovo 1995 / Gauss-Kruger CM 93E",
    2476: "Pulkovo 1995 / Gauss-Kruger CM 99E",
    2477: "Pulkovo 1995 / Gauss-Kruger CM 105E",
    2478: "Pulkovo 1995 / Gauss-Kruger CM 111E",
    2479: "Pulkovo 1995 / Gauss-Kruger CM 117E",
    2480: "Pulkovo 1995 / Gauss-Kruger CM 123E",
    2481: "Pulkovo 1995 / Gauss-Kruger CM 129E",
    2482: "Pulkovo 1995 / Gauss-Kruger CM 135E",
    2483: "Pulkovo 1995 / Gauss-Kruger CM 141E",
    2484: "Pulkovo 1995 / Gauss-Kruger CM 147E",
    2485: "Pulkovo 1995 / Gauss-Kruger CM 153E",
    2486: "Pulkovo 1995 / Gauss-Kruger CM 159E",
    2487: "Pulkovo 1995 / Gauss-Kruger CM 165E",
    2488: "Pulkovo 1995 / Gauss-Kruger CM 171E",
    2489: "Pulkovo 1995 / Gauss-Kruger CM 177E",
    2490: "Pulkovo 1995 / Gauss-Kruger CM 177W",
    2491: "Pulkovo 1995 / Gauss-Kruger CM 171W",
    2492: "Pulkovo 1942 / Gauss-Kruger CM 9E",
    2493: "Pulkovo 1942 / Gauss-Kruger CM 15E",
    2494: "Pulkovo 1942 / Gauss-Kruger CM 21E",
    2495: "Pulkovo 1942 / Gauss-Kruger CM 27E",
    2496: "Pulkovo 1942 / Gauss-Kruger CM 33E",
    2497: "Pulkovo 1942 / Gauss-Kruger CM 39E",
    2498: "Pulkovo 1942 / Gauss-Kruger CM 45E",
    2499: "Pulkovo 1942 / Gauss-Kruger CM 51E",
    2500: "Pulkovo 1942 / Gauss-Kruger CM 57E",
    2501: "Pulkovo 1942 / Gauss-Kruger CM 63E",
    2502: "Pulkovo 1942 / Gauss-Kruger CM 69E",
    2503: "Pulkovo 1942 / Gauss-Kruger CM 75E",
    2504: "Pulkovo 1942 / Gauss-Kruger CM 81E",
    2505: "Pulkovo 1942 / Gauss-Kruger CM 87E",
    2506: "Pulkovo 1942 / Gauss-Kruger CM 93E",
    2507: "Pulkovo 1942 / Gauss-Kruger CM 99E",
    2508: "Pulkovo 1942 / Gauss-Kruger CM 105E",
    2509: "Pulkovo 1942 / Gauss-Kruger CM 111E",
    2510: "Pulkovo 1942 / Gauss-Kruger CM 117E",
    2511: "Pulkovo 1942 / Gauss-Kruger CM 123E",
    2512: "Pulkovo 1942 / Gauss-Kruger CM 129E",
    2513: "Pulkovo 1942 / Gauss-Kruger CM 135E",
    2514: "Pulkovo 1942 / Gauss-Kruger CM 141E",
    2515: "Pulkovo 1942 / Gauss-Kruger CM 147E",
    2516: "Pulkovo 1942 / Gauss-Kruger CM 153E",
    2517: "Pulkovo 1942 / Gauss-Kruger CM 159E",
    2518: "Pulkovo 1942 / Gauss-Kruger CM 165E",
    2519: "Pulkovo 1942 / Gauss-Kruger CM 171E",
    2520: "Pulkovo 1942 / Gauss-Kruger CM 177E",
    2521: "Pulkovo 1942 / Gauss-Kruger CM 177W",
    2522: "Pulkovo 1942 / Gauss-Kruger CM 171W",
    2523: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 7",
    2524: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 8",
    2525: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 9",
    2526: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 10",
    2527: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 11",
    2528: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 12",
    2529: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 13",
    2530: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 14",
    2531: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 15",
    2532: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 16",
    2533: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 17",
    2534: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 18",
    2535: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 19",
    2536: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 20",
    2537: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 21",
    2538: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 22",
    2539: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 23",
    2540: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 24",
    2541: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 25",
    2542: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 26",
    2543: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 27",
    2544: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 28",
    2545: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 29",
    2546: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 30",
    2547: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 31",
    2548: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 32",
    2549: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 33",
    2550: "Samboja / UTM zone 50S",
    2551: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 34",
    2552: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 35",
    2553: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 36",
    2554: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 37",
    2555: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 38",
    2556: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 39",
    2557: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 40",
    2558: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 41",
    2559: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 42",
    2560: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 43",
    2561: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 44",
    2562: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 45",
    2563: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 46",
    2564: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 47",
    2565: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 48",
    2566: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 49",
    2567: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 50",
    2568: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 51",
    2569: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 52",
    2570: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 53",
    2571: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 54",
    2572: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 55",
    2573: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 56",
    2574: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 57",
    2575: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 58",
    2576: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 59",
    2577: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 60",
    2578: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 61",
    2579: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 62",
    2580: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 63",
    2581: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 64",
    2582: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 21E",
    2583: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 24E",
    2584: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 27E",
    2585: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 30E",
    2586: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 33E",
    2587: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 36E",
    2588: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 39E",
    2589: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 42E",
    2590: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 45E",
    2591: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 48E",
    2592: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 51E",
    2593: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 54E",
    2594: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 57E",
    2595: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 60E",
    2596: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 63E",
    2597: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 66E",
    2598: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 69E",
    2599: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 72E",
    2600: "Lietuvos Koordinoei Sistema 1994",
    2601: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 75E",
    2602: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 78E",
    2603: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 81E",
    2604: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 84E",
    2605: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 87E",
    2606: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 90E",
    2607: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 93E",
    2608: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 96E",
    2609: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 99E",
    2610: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 102E",
    2611: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 105E",
    2612: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 108E",
    2613: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 111E",
    2614: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 114E",
    2615: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 117E",
    2616: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 120E",
    2617: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 123E",
    2618: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 126E",
    2619: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 129E",
    2620: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 132E",
    2621: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 135E",
    2622: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 138E",
    2623: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 141E",
    2624: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 144E",
    2625: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 147E",
    2626: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 150E",
    2627: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 153E",
    2628: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 156E",
    2629: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 159E",
    2630: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 162E",
    2631: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 165E",
    2632: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 168E",
    2633: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 171E",
    2634: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 174E",
    2635: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 177E",
    2636: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 180E",
    2637: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 177W",
    2638: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 174W",
    2639: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 171W",
    2640: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 168W",
    2641: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 7",
    2642: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 8",
    2643: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 9",
    2644: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 10",
    2645: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 11",
    2646: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 12",
    2647: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 13",
    2648: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 14",
    2649: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 15",
    2650: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 16",
    2651: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 17",
    2652: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 18",
    2653: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 19",
    2654: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 20",
    2655: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 21",
    2656: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 22",
    2657: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 23",
    2658: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 24",
    2659: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 25",
    2660: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 26",
    2661: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 27",
    2662: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 28",
    2663: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 29",
    2664: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 30",
    2665: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 31",
    2666: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 32",
    2667: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 33",
    2668: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 34",
    2669: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 35",
    2670: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 36",
    2671: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 37",
    2672: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 38",
    2673: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 39",
    2674: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 40",
    2675: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 41",
    2676: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 42",
    2677: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 43",
    2678: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 44",
    2679: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 45",
    2680: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 46",
    2681: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 47",
    2682: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 48",
    2683: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 49",
    2684: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 50",
    2685: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 51",
    2686: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 52",
    2687: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 53",
    2688: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 54",
    2689: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 55",
    2690: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 56",
    2691: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 57",
    2692: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 58",
    2693: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 59",
    2694: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 60",
    2695: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 61",
    2696: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 62",
    2697: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 63",
    2698: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 64",
    2699: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 21E",
    2700: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 24E",
    2701: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 27E",
    2702: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 30E",
    2703: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 33E",
    2704: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 36E",
    2705: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 39E",
    2706: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 42E",
    2707: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 45E",
    2708: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 48E",
    2709: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 51E",
    2710: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 54E",
    2711: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 57E",
    2712: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 60E",
    2713: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 63E",
    2714: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 66E",
    2715: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 69E",
    2716: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 72E",
    2717: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 75E",
    2718: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 78E",
    2719: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 81E",
    2720: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 84E",
    2721: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 87E",
    2722: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 90E",
    2723: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 93E",
    2724: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 96E",
    2725: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 99E",
    2726: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 102E",
    2727: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 105E",
    2728: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 108E",
    2729: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 111E",
    2730: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 114E",
    2731: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 117E",
    2732: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 120E",
    2733: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 123E",
    2734: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 126E",
    2735: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 129E",
    2736: "Tete / UTM zone 36S",
    2737: "Tete / UTM zone 37S",
    2738: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 132E",
    2739: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 135E",
    2740: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 138E",
    2741: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 141E",
    2742: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 144E",
    2743: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 147E",
    2744: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 150E",
    2745: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 153E",
    2746: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 156E",
    2747: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 159E",
    2748: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 162E",
    2749: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 165E",
    2750: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 168E",
    2751: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 171E",
    2752: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 174E",
    2753: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 177E",
    2754: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 180E",
    2755: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 177W",
    2756: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 174W",
    2757: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 171W",
    2758: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 168W",
    2759: "NAD83(HARN) / Alabama East",
    2760: "NAD83(HARN) / Alabama West",
    2761: "NAD83(HARN) / Arizona East",
    2762: "NAD83(HARN) / Arizona Central",
    2763: "NAD83(HARN) / Arizona West",
    2764: "NAD83(HARN) / Arkansas North",
    2765: "NAD83(HARN) / Arkansas South",
    2766: "NAD83(HARN) / California zone 1",
    2767: "NAD83(HARN) / California zone 2",
    2768: "NAD83(HARN) / California zone 3",
    2769: "NAD83(HARN) / California zone 4",
    2770: "NAD83(HARN) / California zone 5",
    2771: "NAD83(HARN) / California zone 6",
    2772: "NAD83(HARN) / Colorado North",
    2773: "NAD83(HARN) / Colorado Central",
    2774: "NAD83(HARN) / Colorado South",
    2775: "NAD83(HARN) / Connecticut",
    2776: "NAD83(HARN) / Delaware",
    2777: "NAD83(HARN) / Florida East",
    2778: "NAD83(HARN) / Florida West",
    2779: "NAD83(HARN) / Florida North",
    2780: "NAD83(HARN) / Georgia East",
    2781: "NAD83(HARN) / Georgia West",
    2782: "NAD83(HARN) / Hawaii zone 1",
    2783: "NAD83(HARN) / Hawaii zone 2",
    2784: "NAD83(HARN) / Hawaii zone 3",
    2785: "NAD83(HARN) / Hawaii zone 4",
    2786: "NAD83(HARN) / Hawaii zone 5",
    2787: "NAD83(HARN) / Idaho East",
    2788: "NAD83(HARN) / Idaho Central",
    2789: "NAD83(HARN) / Idaho West",
    2790: "NAD83(HARN) / Illinois East",
    2791: "NAD83(HARN) / Illinois West",
    2792: "NAD83(HARN) / Indiana East",
    2793: "NAD83(HARN) / Indiana West",
    2794: "NAD83(HARN) / Iowa North",
    2795: "NAD83(HARN) / Iowa South",
    2796: "NAD83(HARN) / Kansas North",
    2797: "NAD83(HARN) / Kansas South",
    2798: "NAD83(HARN) / Kentucky North",
    2799: "NAD83(HARN) / Kentucky South",
    2800: "NAD83(HARN) / Louisiana North",
    2801: "NAD83(HARN) / Louisiana South",
    2802: "NAD83(HARN) / Maine East",
    2803: "NAD83(HARN) / Maine West",
    2804: "NAD83(HARN) / Maryland",
    2805: "NAD83(HARN) / Massachusetts Mainland",
    2806: "NAD83(HARN) / Massachusetts Island",
    2807: "NAD83(HARN) / Michigan North",
    2808: "NAD83(HARN) / Michigan Central",
    2809: "NAD83(HARN) / Michigan South",
    2810: "NAD83(HARN) / Minnesota North",
    2811: "NAD83(HARN) / Minnesota Central",
    2812: "NAD83(HARN) / Minnesota South",
    2813: "NAD83(HARN) / Mississippi East",
    2814: "NAD83(HARN) / Mississippi West",
    2815: "NAD83(HARN) / Missouri East",
    2816: "NAD83(HARN) / Missouri Central",
    2817: "NAD83(HARN) / Missouri West",
    2818: "NAD83(HARN) / Montana",
    2819: "NAD83(HARN) / Nebraska",
    2820: "NAD83(HARN) / Nevada East",
    2821: "NAD83(HARN) / Nevada Central",
    2822: "NAD83(HARN) / Nevada West",
    2823: "NAD83(HARN) / New Hampshire",
    2824: "NAD83(HARN) / New Jersey",
    2825: "NAD83(HARN) / New Mexico East",
    2826: "NAD83(HARN) / New Mexico Central",
    2827: "NAD83(HARN) / New Mexico West",
    2828: "NAD83(HARN) / New York East",
    2829: "NAD83(HARN) / New York Central",
    2830: "NAD83(HARN) / New York West",
    2831: "NAD83(HARN) / New York Long Island",
    2832: "NAD83(HARN) / North Dakota North",
    2833: "NAD83(HARN) / North Dakota South",
    2834: "NAD83(HARN) / Ohio North",
    2835: "NAD83(HARN) / Ohio South",
    2836: "NAD83(HARN) / Oklahoma North",
    2837: "NAD83(HARN) / Oklahoma South",
    2838: "NAD83(HARN) / Oregon North",
    2839: "NAD83(HARN) / Oregon South",
    2840: "NAD83(HARN) / Rhode Island",
    2841: "NAD83(HARN) / South Dakota North",
    2842: "NAD83(HARN) / South Dakota South",
    2843: "NAD83(HARN) / Tennessee",
    2844: "NAD83(HARN) / Texas North",
    2845: "NAD83(HARN) / Texas North Central",
    2846: "NAD83(HARN) / Texas Central",
    2847: "NAD83(HARN) / Texas South Central",
    2848: "NAD83(HARN) / Texas South",
    2849: "NAD83(HARN) / Utah North",
    2850: "NAD83(HARN) / Utah Central",
    2851: "NAD83(HARN) / Utah South",
    2852: "NAD83(HARN) / Vermont",
    2853: "NAD83(HARN) / Virginia North",
    2854: "NAD83(HARN) / Virginia South",
    2855: "NAD83(HARN) / Washington North",
    2856: "NAD83(HARN) / Washington South",
    2857: "NAD83(HARN) / West Virginia North",
    2858: "NAD83(HARN) / West Virginia South",
    2859: "NAD83(HARN) / Wisconsin North",
    2860: "NAD83(HARN) / Wisconsin Central",
    2861: "NAD83(HARN) / Wisconsin South",
    2862: "NAD83(HARN) / Wyoming East",
    2863: "NAD83(HARN) / Wyoming East Central",
    2864: "NAD83(HARN) / Wyoming West Central",
    2865: "NAD83(HARN) / Wyoming West",
    2866: "NAD83(HARN) / Puerto Rico and Virgin Is.",
    2867: "NAD83(HARN) / Arizona East (ft)",
    2868: "NAD83(HARN) / Arizona Central (ft)",
    2869: "NAD83(HARN) / Arizona West (ft)",
    2870: "NAD83(HARN) / California zone 1 (ftUS)",
    2871: "NAD83(HARN) / California zone 2 (ftUS)",
    2872: "NAD83(HARN) / California zone 3 (ftUS)",
    2873: "NAD83(HARN) / California zone 4 (ftUS)",
    2874: "NAD83(HARN) / California zone 5 (ftUS)",
    2875: "NAD83(HARN) / California zone 6 (ftUS)",
    2876: "NAD83(HARN) / Colorado North (ftUS)",
    2877: "NAD83(HARN) / Colorado Central (ftUS)",
    2878: "NAD83(HARN) / Colorado South (ftUS)",
    2879: "NAD83(HARN) / Connecticut (ftUS)",
    2880: "NAD83(HARN) / Delaware (ftUS)",
    2881: "NAD83(HARN) / Florida East (ftUS)",
    2882: "NAD83(HARN) / Florida West (ftUS)",
    2883: "NAD83(HARN) / Florida North (ftUS)",
    2884: "NAD83(HARN) / Georgia East (ftUS)",
    2885: "NAD83(HARN) / Georgia West (ftUS)",
    2886: "NAD83(HARN) / Idaho East (ftUS)",
    2887: "NAD83(HARN) / Idaho Central (ftUS)",
    2888: "NAD83(HARN) / Idaho West (ftUS)",
    2889: "NAD83(HARN) / Indiana East (ftUS)",
    2890: "NAD83(HARN) / Indiana West (ftUS)",
    2891: "NAD83(HARN) / Kentucky North (ftUS)",
    2892: "NAD83(HARN) / Kentucky South (ftUS)",
    2893: "NAD83(HARN) / Maryland (ftUS)",
    2894: "NAD83(HARN) / Massachusetts Mainland (ftUS)",
    2895: "NAD83(HARN) / Massachusetts Island (ftUS)",
    2896: "NAD83(HARN) / Michigan North (ft)",
    2897: "NAD83(HARN) / Michigan Central (ft)",
    2898: "NAD83(HARN) / Michigan South (ft)",
    2899: "NAD83(HARN) / Mississippi East (ftUS)",
    2900: "NAD83(HARN) / Mississippi West (ftUS)",
    2901: "NAD83(HARN) / Montana (ft)",
    2902: "NAD83(HARN) / New Mexico East (ftUS)",
    2903: "NAD83(HARN) / New Mexico Central (ftUS)",
    2904: "NAD83(HARN) / New Mexico West (ftUS)",
    2905: "NAD83(HARN) / New York East (ftUS)",
    2906: "NAD83(HARN) / New York Central (ftUS)",
    2907: "NAD83(HARN) / New York West (ftUS)",
    2908: "NAD83(HARN) / New York Long Island (ftUS)",
    2909: "NAD83(HARN) / North Dakota North (ft)",
    2910: "NAD83(HARN) / North Dakota South (ft)",
    2911: "NAD83(HARN) / Oklahoma North (ftUS)",
    2912: "NAD83(HARN) / Oklahoma South (ftUS)",
    2913: "NAD83(HARN) / Oregon North (ft)",
    2914: "NAD83(HARN) / Oregon South (ft)",
    2915: "NAD83(HARN) / Tennessee (ftUS)",
    2916: "NAD83(HARN) / Texas North (ftUS)",
    2917: "NAD83(HARN) / Texas North Central (ftUS)",
    2918: "NAD83(HARN) / Texas Central (ftUS)",
    2919: "NAD83(HARN) / Texas South Central (ftUS)",
    2920: "NAD83(HARN) / Texas South (ftUS)",
    2921: "NAD83(HARN) / Utah North (ft)",
    2922: "NAD83(HARN) / Utah Central (ft)",
    2923: "NAD83(HARN) / Utah South (ft)",
    2924: "NAD83(HARN) / Virginia North (ftUS)",
    2925: "NAD83(HARN) / Virginia South (ftUS)",
    2926: "NAD83(HARN) / Washington North (ftUS)",
    2927: "NAD83(HARN) / Washington South (ftUS)",
    2928: "NAD83(HARN) / Wisconsin North (ftUS)",
    2929: "NAD83(HARN) / Wisconsin Central (ftUS)",
    2930: "NAD83(HARN) / Wisconsin South (ftUS)",
    2931: "Beduaram / TM 13 NE",
    2932: "QND95 / Qatar National Grid",
    2933: "Segara / UTM zone 50S",
    2934: "Segara (Jakarta) / NEIEZ",
    2935: "Pulkovo 1942 / CS63 zone A1",
    2936: "Pulkovo 1942 / CS63 zone A2",
    2937: "Pulkovo 1942 / CS63 zone A3",
    2938: "Pulkovo 1942 / CS63 zone A4",
    2939: "Pulkovo 1942 / CS63 zone K2",
    2940: "Pulkovo 1942 / CS63 zone K3",
    2941: "Pulkovo 1942 / CS63 zone K4",
    2942: "Porto Santo / UTM zone 28N",
    2943: "Selvagem Grande / UTM zone 28N",
    2944: "NAD83(CSRS) / SCoPQ zone 2",
    2945: "NAD83(CSRS) / MTM zone 3",
    2946: "NAD83(CSRS) / MTM zone 4",
    2947: "NAD83(CSRS) / MTM zone 5",
    2948: "NAD83(CSRS) / MTM zone 6",
    2949: "NAD83(CSRS) / MTM zone 7",
    2950: "NAD83(CSRS) / MTM zone 8",
    2951: "NAD83(CSRS) / MTM zone 9",
    2952: "NAD83(CSRS) / MTM zone 10",
    2953: "NAD83(CSRS) / New Brunswick Stereographic",
    2954: "NAD83(CSRS) / Prince Edward Isl. Stereographic (NAD83)",
    2955: "NAD83(CSRS) / UTM zone 11N",
    2956: "NAD83(CSRS) / UTM zone 12N",
    2957: "NAD83(CSRS) / UTM zone 13N",
    2958: "NAD83(CSRS) / UTM zone 17N",
    2959: "NAD83(CSRS) / UTM zone 18N",
    2960: "NAD83(CSRS) / UTM zone 19N",
    2961: "NAD83(CSRS) / UTM zone 20N",
    2962: "NAD83(CSRS) / UTM zone 21N",
    2963: "Lisbon 1890 (Lisbon) / Portugal Bonne",
    2964: "NAD27 / Alaska Albers",
    2965: "NAD83 / Indiana East (ftUS)",
    2966: "NAD83 / Indiana West (ftUS)",
    2967: "NAD83(HARN) / Indiana East (ftUS)",
    2968: "NAD83(HARN) / Indiana West (ftUS)",
    2969: "Fort Marigot / UTM zone 20N",
    2970: "Guadeloupe 1948 / UTM zone 20N",
    2971: "CSG67 / UTM zone 22N",
    2972: "RGFG95 / UTM zone 22N",
    2973: "Martinique 1938 / UTM zone 20N",
    2975: "RGR92 / UTM zone 40S",
    2976: "Tahiti 52 / UTM zone 6S",
    2977: "Tahaa 54 / UTM zone 5S",
    2978: "IGN72 Nuku Hiva / UTM zone 7S",
    2979: "K0 1949 / UTM zone 42S",
    2980: "Combani 1950 / UTM zone 38S",
    2981: "IGN56 Lifou / UTM zone 58S",
    2982: "IGN72 Grand Terre / UTM zone 58S",
    2983: "ST87 Ouvea / UTM zone 58S",
    2984: "RGNC 1991 / Lambert New Caledonia",
    2985: "Petrels 1972 / Terre Adelie Polar Stereographic",
    2986: "Perroud 1950 / Terre Adelie Polar Stereographic",
    2987: "Saint Pierre et Miquelon 1950 / UTM zone 21N",
    2988: "MOP78 / UTM zone 1S",
    2989: "RRAF 1991 / UTM zone 20N",
    2990: "Reunion 1947 / TM Reunion",
    2991: "NAD83 / Oregon LCC (m)",
    2992: "NAD83 / Oregon GIC Lambert (ft)",
    2993: "NAD83(HARN) / Oregon LCC (m)",
    2994: "NAD83(HARN) / Oregon GIC Lambert (ft)",
    2995: "IGN53 Mare / UTM zone 58S",
    2996: "ST84 Ile des Pins / UTM zone 58S",
    2997: "ST71 Belep / UTM zone 58S",
    2998: "NEA74 Noumea / UTM zone 58S",
    2999: "Grand Comoros / UTM zone 38S",
    3000: "Segara / NEIEZ",
    3001: "Batavia / NEIEZ",
    3002: "Makassar / NEIEZ",
    3003: "Monte Mario / Italy zone 1",
    3004: "Monte Mario / Italy zone 2",
    3005: "NAD83 / BC Albers",
    3006: "SWEREF99 TM",
    3007: "SWEREF99 12 00",
    3008: "SWEREF99 13 30",
    3009: "SWEREF99 15 00",
    3010: "SWEREF99 16 30",
    3011: "SWEREF99 18 00",
    3012: "SWEREF99 14 15",
    3013: "SWEREF99 15 45",
    3014: "SWEREF99 17 15",
    3015: "SWEREF99 18 45",
    3016: "SWEREF99 20 15",
    3017: "SWEREF99 21 45",
    3018: "SWEREF99 23 15",
    3019: "RT90 7.5 gon V",
    3020: "RT90 5 gon V",
    3021: "RT90 2.5 gon V",
    3022: "RT90 0 gon",
    3023: "RT90 2.5 gon O",
    3024: "RT90 5 gon O",
    3025: "RT38 7.5 gon V",
    3026: "RT38 5 gon V",
    3027: "RT38 2.5 gon V",
    3028: "RT38 0 gon",
    3029: "RT38 2.5 gon O",
    3030: "RT38 5 gon O",
    3031: "WGS 84 / Antarctic Polar Stereographic",
    3032: "WGS 84 / Australian Antarctic Polar Stereographic",
    3033: "WGS 84 / Australian Antarctic Lambert",
    3034: "ETRS89 / LCC Europe",
    3035: "ETRS89 / LAEA Europe",
    3036: "Moznet / UTM zone 36S",
    3037: "Moznet / UTM zone 37S",
    3038: "ETRS89 / TM26",
    3039: "ETRS89 / TM27",
    3040: "ETRS89 / UTM zone 28N (N-E)",
    3041: "ETRS89 / UTM zone 29N (N-E)",
    3042: "ETRS89 / UTM zone 30N (N-E)",
    3043: "ETRS89 / UTM zone 31N (N-E)",
    3044: "ETRS89 / UTM zone 32N (N-E)",
    3045: "ETRS89 / UTM zone 33N (N-E)",
    3046: "ETRS89 / UTM zone 34N (N-E)",
    3047: "ETRS89 / UTM zone 35N (N-E)",
    3048: "ETRS89 / UTM zone 36N (N-E)",
    3049: "ETRS89 / UTM zone 37N (N-E)",
    3050: "ETRS89 / TM38",
    3051: "ETRS89 / TM39",
    3052: "Reykjavik 1900 / Lambert 1900",
    3053: "Hjorsey 1955 / Lambert 1955",
    3054: "Hjorsey 1955 / UTM zone 26N",
    3055: "Hjorsey 1955 / UTM zone 27N",
    3056: "Hjorsey 1955 / UTM zone 28N",
    3057: "ISN93 / Lambert 1993",
    3058: "Helle 1954 / Jan Mayen Grid",
    3059: "LKS92 / Latvia TM",
    3060: "IGN72 Grande Terre / UTM zone 58S",
    3061: "Porto Santo 1995 / UTM zone 28N",
    3062: "Azores Oriental 1995 / UTM zone 26N",
    3063: "Azores Central 1995 / UTM zone 26N",
    3064: "IGM95 / UTM zone 32N",
    3065: "IGM95 / UTM zone 33N",
    3066: "ED50 / Jordan TM",
    3067: "ETRS89 / TM35FIN(E,N)",
    3068: "DHDN / Soldner Berlin",
    3069: "NAD27 / Wisconsin Transverse Mercator",
    3070: "NAD83 / Wisconsin Transverse Mercator",
    3071: "NAD83(HARN) / Wisconsin Transverse Mercator",
    3072: "NAD83 / Maine CS2000 East",
    3073: "NAD83 / Maine CS2000 Central",
    3074: "NAD83 / Maine CS2000 West",
    3075: "NAD83(HARN) / Maine CS2000 East",
    3076: "NAD83(HARN) / Maine CS2000 Central",
    3077: "NAD83(HARN) / Maine CS2000 West",
    3078: "NAD83 / Michigan Oblique Mercator",
    3079: "NAD83(HARN) / Michigan Oblique Mercator",
    3080: "NAD27 / Shackleford",
    3081: "NAD83 / Texas State Mapping System",
    3082: "NAD83 / Texas Centric Lambert Conformal",
    3083: "NAD83 / Texas Centric Albers Equal Area",
    3084: "NAD83(HARN) / Texas Centric Lambert Conformal",
    3085: "NAD83(HARN) / Texas Centric Albers Equal Area",
    3086: "NAD83 / Florida GDL Albers",
    3087: "NAD83(HARN) / Florida GDL Albers",
    3088: "NAD83 / Kentucky Single Zone",
    3089: "NAD83 / Kentucky Single Zone (ftUS)",
    3090: "NAD83(HARN) / Kentucky Single Zone",
    3091: "NAD83(HARN) / Kentucky Single Zone (ftUS)",
    3092: "Tokyo / UTM zone 51N",
    3093: "Tokyo / UTM zone 52N",
    3094: "Tokyo / UTM zone 53N",
    3095: "Tokyo / UTM zone 54N",
    3096: "Tokyo / UTM zone 55N",
    3097: "JGD2000 / UTM zone 51N",
    3098: "JGD2000 / UTM zone 52N",
    3099: "JGD2000 / UTM zone 53N",
    3100: "JGD2000 / UTM zone 54N",
    3101: "JGD2000 / UTM zone 55N",
    3102: "American Samoa 1962 / American Samoa Lambert",
    3103: "Mauritania 1999 / UTM zone 28N",
    3104: "Mauritania 1999 / UTM zone 29N",
    3105: "Mauritania 1999 / UTM zone 30N",
    3106: "Gulshan 303 / Bangladesh Transverse Mercator",
    3107: "GDA94 / SA Lambert",
    3108: "ETRS89 / Guernsey Grid",
    3109: "ETRS89 / Jersey Transverse Mercator",
    3110: "AGD66 / Vicgrid66",
    3111: "GDA94 / Vicgrid94",
    3112: "GDA94 / Geoscience Australia Lambert",
    3113: "GDA94 / BCSG02",
    3114: "MAGNA-SIRGAS / Colombia Far West zone",
    3115: "MAGNA-SIRGAS / Colombia West zone",
    3116: "MAGNA-SIRGAS / Colombia Bogota zone",
    3117: "MAGNA-SIRGAS / Colombia East Central zone",
    3118: "MAGNA-SIRGAS / Colombia East zone",
    3119: "Douala 1948 / AEF west",
    3120: "Pulkovo 1942(58) / Poland zone I",
    3121: "PRS92 / Philippines zone 1",
    3122: "PRS92 / Philippines zone 2",
    3123: "PRS92 / Philippines zone 3",
    3124: "PRS92 / Philippines zone 4",
    3125: "PRS92 / Philippines zone 5",
    3126: "ETRS89 / ETRS-GK19FIN",
    3127: "ETRS89 / ETRS-GK20FIN",
    3128: "ETRS89 / ETRS-GK21FIN",
    3129: "ETRS89 / ETRS-GK22FIN",
    3130: "ETRS89 / ETRS-GK23FIN",
    3131: "ETRS89 / ETRS-GK24FIN",
    3132: "ETRS89 / ETRS-GK25FIN",
    3133: "ETRS89 / ETRS-GK26FIN",
    3134: "ETRS89 / ETRS-GK27FIN",
    3135: "ETRS89 / ETRS-GK28FIN",
    3136: "ETRS89 / ETRS-GK29FIN",
    3137: "ETRS89 / ETRS-GK30FIN",
    3138: "ETRS89 / ETRS-GK31FIN",
    3139: "Vanua Levu 1915 / Vanua Levu Grid",
    3140: "Viti Levu 1912 / Viti Levu Grid",
    3141: "Fiji 1956 / UTM zone 60S",
    3142: "Fiji 1956 / UTM zone 1S",
    3143: "Fiji 1986 / Fiji Map Grid",
    3144: "FD54 / Faroe Lambert",
    3145: "ETRS89 / Faroe Lambert",
    3146: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 6",
    3147: "Pulkovo 1942 / 3-degree Gauss-Kruger CM 18E",
    3148: "Indian 1960 / UTM zone 48N",
    3149: "Indian 1960 / UTM zone 49N",
    3150: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 6",
    3151: "Pulkovo 1995 / 3-degree Gauss-Kruger CM 18E",
    3152: "ST74",
    3153: "NAD83(CSRS) / BC Albers",
    3154: "NAD83(CSRS) / UTM zone 7N",
    3155: "NAD83(CSRS) / UTM zone 8N",
    3156: "NAD83(CSRS) / UTM zone 9N",
    3157: "NAD83(CSRS) / UTM zone 10N",
    3158: "NAD83(CSRS) / UTM zone 14N",
    3159: "NAD83(CSRS) / UTM zone 15N",
    3160: "NAD83(CSRS) / UTM zone 16N",
    3161: "NAD83 / Ontario MNR Lambert",
    3162: "NAD83(CSRS) / Ontario MNR Lambert",
    3163: "RGNC91-93 / Lambert New Caledonia",
    3164: "ST87 Ouvea / UTM zone 58S",
    3165: "NEA74 Noumea / Noumea Lambert",
    3166: "NEA74 Noumea / Noumea Lambert 2",
    3167: "Kertau (RSO) / RSO Malaya (ch)",
    3168: "Kertau (RSO) / RSO Malaya (m)",
    3169: "RGNC91-93 / UTM zone 57S",
    3170: "RGNC91-93 / UTM zone 58S",
    3171: "RGNC91-93 / UTM zone 59S",
    3172: "IGN53 Mare / UTM zone 59S",
    3173: "fk89 / Faroe Lambert FK89",
    3174: "NAD83 / Great Lakes Albers",
    3175: "NAD83 / Great Lakes and St Lawrence Albers",
    3176: "Indian 1960 / TM 106 NE",
    3177: "LGD2006 / Libya TM",
    3178: "GR96 / UTM zone 18N",
    3179: "GR96 / UTM zone 19N",
    3180: "GR96 / UTM zone 20N",
    3181: "GR96 / UTM zone 21N",
    3182: "GR96 / UTM zone 22N",
    3183: "GR96 / UTM zone 23N",
    3184: "GR96 / UTM zone 24N",
    3185: "GR96 / UTM zone 25N",
    3186: "GR96 / UTM zone 26N",
    3187: "GR96 / UTM zone 27N",
    3188: "GR96 / UTM zone 28N",
    3189: "GR96 / UTM zone 29N",
    3190: "LGD2006 / Libya TM zone 5",
    3191: "LGD2006 / Libya TM zone 6",
    3192: "LGD2006 / Libya TM zone 7",
    3193: "LGD2006 / Libya TM zone 8",
    3194: "LGD2006 / Libya TM zone 9",
    3195: "LGD2006 / Libya TM zone 10",
    3196: "LGD2006 / Libya TM zone 11",
    3197: "LGD2006 / Libya TM zone 12",
    3198: "LGD2006 / Libya TM zone 13",
    3199: "LGD2006 / UTM zone 32N",
    3200: "FD58 / Iraq zone",
    3201: "LGD2006 / UTM zone 33N",
    3202: "LGD2006 / UTM zone 34N",
    3203: "LGD2006 / UTM zone 35N",
    3204: "WGS 84 / SCAR IMW SP19-20",
    3205: "WGS 84 / SCAR IMW SP21-22",
    3206: "WGS 84 / SCAR IMW SP23-24",
    3207: "WGS 84 / SCAR IMW SQ01-02",
    3208: "WGS 84 / SCAR IMW SQ19-20",
    3209: "WGS 84 / SCAR IMW SQ21-22",
    3210: "WGS 84 / SCAR IMW SQ37-38",
    3211: "WGS 84 / SCAR IMW SQ39-40",
    3212: "WGS 84 / SCAR IMW SQ41-42",
    3213: "WGS 84 / SCAR IMW SQ43-44",
    3214: "WGS 84 / SCAR IMW SQ45-46",
    3215: "WGS 84 / SCAR IMW SQ47-48",
    3216: "WGS 84 / SCAR IMW SQ49-50",
    3217: "WGS 84 / SCAR IMW SQ51-52",
    3218: "WGS 84 / SCAR IMW SQ53-54",
    3219: "WGS 84 / SCAR IMW SQ55-56",
    3220: "WGS 84 / SCAR IMW SQ57-58",
    3221: "WGS 84 / SCAR IMW SR13-14",
    3222: "WGS 84 / SCAR IMW SR15-16",
    3223: "WGS 84 / SCAR IMW SR17-18",
    3224: "WGS 84 / SCAR IMW SR19-20",
    3225: "WGS 84 / SCAR IMW SR27-28",
    3226: "WGS 84 / SCAR IMW SR29-30",
    3227: "WGS 84 / SCAR IMW SR31-32",
    3228: "WGS 84 / SCAR IMW SR33-34",
    3229: "WGS 84 / SCAR IMW SR35-36",
    3230: "WGS 84 / SCAR IMW SR37-38",
    3231: "WGS 84 / SCAR IMW SR39-40",
    3232: "WGS 84 / SCAR IMW SR41-42",
    3233: "WGS 84 / SCAR IMW SR43-44",
    3234: "WGS 84 / SCAR IMW SR45-46",
    3235: "WGS 84 / SCAR IMW SR47-48",
    3236: "WGS 84 / SCAR IMW SR49-50",
    3237: "WGS 84 / SCAR IMW SR51-52",
    3238: "WGS 84 / SCAR IMW SR53-54",
    3239: "WGS 84 / SCAR IMW SR55-56",
    3240: "WGS 84 / SCAR IMW SR57-58",
    3241: "WGS 84 / SCAR IMW SR59-60",
    3242: "WGS 84 / SCAR IMW SS04-06",
    3243: "WGS 84 / SCAR IMW SS07-09",
    3244: "WGS 84 / SCAR IMW SS10-12",
    3245: "WGS 84 / SCAR IMW SS13-15",
    3246: "WGS 84 / SCAR IMW SS16-18",
    3247: "WGS 84 / SCAR IMW SS19-21",
    3248: "WGS 84 / SCAR IMW SS25-27",
    3249: "WGS 84 / SCAR IMW SS28-30",
    3250: "WGS 84 / SCAR IMW SS31-33",
    3251: "WGS 84 / SCAR IMW SS34-36",
    3252: "WGS 84 / SCAR IMW SS37-39",
    3253: "WGS 84 / SCAR IMW SS40-42",
    3254: "WGS 84 / SCAR IMW SS43-45",
    3255: "WGS 84 / SCAR IMW SS46-48",
    3256: "WGS 84 / SCAR IMW SS49-51",
    3257: "WGS 84 / SCAR IMW SS52-54",
    3258: "WGS 84 / SCAR IMW SS55-57",
    3259: "WGS 84 / SCAR IMW SS58-60",
    3260: "WGS 84 / SCAR IMW ST01-04",
    3261: "WGS 84 / SCAR IMW ST05-08",
    3262: "WGS 84 / SCAR IMW ST09-12",
    3263: "WGS 84 / SCAR IMW ST13-16",
    3264: "WGS 84 / SCAR IMW ST17-20",
    3265: "WGS 84 / SCAR IMW ST21-24",
    3266: "WGS 84 / SCAR IMW ST25-28",
    3267: "WGS 84 / SCAR IMW ST29-32",
    3268: "WGS 84 / SCAR IMW ST33-36",
    3269: "WGS 84 / SCAR IMW ST37-40",
    3270: "WGS 84 / SCAR IMW ST41-44",
    3271: "WGS 84 / SCAR IMW ST45-48",
    3272: "WGS 84 / SCAR IMW ST49-52",
    3273: "WGS 84 / SCAR IMW ST53-56",
    3274: "WGS 84 / SCAR IMW ST57-60",
    3275: "WGS 84 / SCAR IMW SU01-05",
    3276: "WGS 84 / SCAR IMW SU06-10",
    3277: "WGS 84 / SCAR IMW SU11-15",
    3278: "WGS 84 / SCAR IMW SU16-20",
    3279: "WGS 84 / SCAR IMW SU21-25",
    3280: "WGS 84 / SCAR IMW SU26-30",
    3281: "WGS 84 / SCAR IMW SU31-35",
    3282: "WGS 84 / SCAR IMW SU36-40",
    3283: "WGS 84 / SCAR IMW SU41-45",
    3284: "WGS 84 / SCAR IMW SU46-50",
    3285: "WGS 84 / SCAR IMW SU51-55",
    3286: "WGS 84 / SCAR IMW SU56-60",
    3287: "WGS 84 / SCAR IMW SV01-10",
    3288: "WGS 84 / SCAR IMW SV11-20",
    3289: "WGS 84 / SCAR IMW SV21-30",
    3290: "WGS 84 / SCAR IMW SV31-40",
    3291: "WGS 84 / SCAR IMW SV41-50",
    3292: "WGS 84 / SCAR IMW SV51-60",
    3293: "WGS 84 / SCAR IMW SW01-60",
    3294: "WGS 84 / USGS Transantarctic Mountains",
    3295: "Guam 1963 / Yap Islands",
    3296: "RGPF / UTM zone 5S",
    3297: "RGPF / UTM zone 6S",
    3298: "RGPF / UTM zone 7S",
    3299: "RGPF / UTM zone 8S",
    3300: "Estonian Coordinate System of 1992",
    3301: "Estonian Coordinate System of 1997",
    3302: "IGN63 Hiva Oa / UTM zone 7S",
    3303: "Fatu Iva 72 / UTM zone 7S",
    3304: "Tahiti 79 / UTM zone 6S",
    3305: "Moorea 87 / UTM zone 6S",
    3306: "Maupiti 83 / UTM zone 5S",
    3307: "Nakhl-e Ghanem / UTM zone 39N",
    3308: "GDA94 / NSW Lambert",
    3309: "NAD27 / California Albers",
    3310: "NAD83 / California Albers",
    3311: "NAD83(HARN) / California Albers",
    3312: "CSG67 / UTM zone 21N",
    3313: "RGFG95 / UTM zone 21N",
    3314: "Katanga 1955 / Katanga Lambert",
    3315: "Katanga 1955 / Katanga TM",
    3316: "Kasai 1953 / Congo TM zone 22",
    3317: "Kasai 1953 / Congo TM zone 24",
    3318: "IGC 1962 / Congo TM zone 12",
    3319: "IGC 1962 / Congo TM zone 14",
    3320: "IGC 1962 / Congo TM zone 16",
    3321: "IGC 1962 / Congo TM zone 18",
    3322: "IGC 1962 / Congo TM zone 20",
    3323: "IGC 1962 / Congo TM zone 22",
    3324: "IGC 1962 / Congo TM zone 24",
    3325: "IGC 1962 / Congo TM zone 26",
    3326: "IGC 1962 / Congo TM zone 28",
    3327: "IGC 1962 / Congo TM zone 30",
    3328: "Pulkovo 1942(58) / GUGiK-80",
    3329: "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 5",
    3330: "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 6",
    3331: "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 7",
    3332: "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 8",
    3333: "Pulkovo 1942(58) / Gauss-Kruger zone 3",
    3334: "Pulkovo 1942(58) / Gauss-Kruger zone 4",
    3335: "Pulkovo 1942(58) / Gauss-Kruger zone 5",
    3336: "IGN 1962 Kerguelen / UTM zone 42S",
    3337: "Le Pouce 1934 / Mauritius Grid",
    3338: "NAD83 / Alaska Albers",
    3339: "IGCB 1955 / Congo TM zone 12",
    3340: "IGCB 1955 / Congo TM zone 14",
    3341: "IGCB 1955 / Congo TM zone 16",
    3342: "IGCB 1955 / UTM zone 33S",
    3343: "Mauritania 1999 / UTM zone 28N",
    3344: "Mauritania 1999 / UTM zone 29N",
    3345: "Mauritania 1999 / UTM zone 30N",
    3346: "LKS94 / Lithuania TM",
    3347: "NAD83 / Statistics Canada Lambert",
    3348: "NAD83(CSRS) / Statistics Canada Lambert",
    3349: "WGS 84 / PDC Mercator",
    3350: "Pulkovo 1942 / CS63 zone C0",
    3351: "Pulkovo 1942 / CS63 zone C1",
    3352: "Pulkovo 1942 / CS63 zone C2",
    3353: "Mhast (onshore) / UTM zone 32S",
    3354: "Mhast (offshore) / UTM zone 32S",
    3355: "Egypt Gulf of Suez S-650 TL / Red Belt",
    3356: "Grand Cayman 1959 / UTM zone 17N",
    3357: "Little Cayman 1961 / UTM zone 17N",
    3358: "NAD83(HARN) / North Carolina",
    3359: "NAD83(HARN) / North Carolina (ftUS)",
    3360: "NAD83(HARN) / South Carolina",
    3361: "NAD83(HARN) / South Carolina (ft)",
    3362: "NAD83(HARN) / Pennsylvania North",
    3363: "NAD83(HARN) / Pennsylvania North (ftUS)",
    3364: "NAD83(HARN) / Pennsylvania South",
    3365: "NAD83(HARN) / Pennsylvania South (ftUS)",
    3366: "Hong Kong 1963 Grid System",
    3367: "IGN Astro 1960 / UTM zone 28N",
    3368: "IGN Astro 1960 / UTM zone 29N",
    3369: "IGN Astro 1960 / UTM zone 30N",
    3370: "NAD27 / UTM zone 59N",
    3371: "NAD27 / UTM zone 60N",
    3372: "NAD83 / UTM zone 59N",
    3373: "NAD83 / UTM zone 60N",
    3374: "FD54 / UTM zone 29N",
    3375: "GDM2000 / Peninsula RSO",
    3376: "GDM2000 / East Malaysia BRSO",
    3377: "GDM2000 / Johor Grid",
    3378: "GDM2000 / Sembilan and Melaka Grid",
    3379: "GDM2000 / Pahang Grid",
    3380: "GDM2000 / Selangor Grid",
    3381: "GDM2000 / Terengganu Grid",
    3382: "GDM2000 / Pinang Grid",
    3383: "GDM2000 / Kedah and Perlis Grid",
    3384: "GDM2000 / Perak Grid",
    3385: "GDM2000 / Kelantan Grid",
    3386: "KKJ / Finland zone 0",
    3387: "KKJ / Finland zone 5",
    3388: "Pulkovo 1942 / Caspian Sea Mercator",
    3389: "Pulkovo 1942 / 3-degree Gauss-Kruger zone 60",
    3390: "Pulkovo 1995 / 3-degree Gauss-Kruger zone 60",
    3391: "Karbala 1979 / UTM zone 37N",
    3392: "Karbala 1979 / UTM zone 38N",
    3393: "Karbala 1979 / UTM zone 39N",
    3394: "Nahrwan 1934 / Iraq zone",
    3395: "WGS 84 / World Mercator",
    3396: "PD/83 / 3-degree Gauss-Kruger zone 3",
    3397: "PD/83 / 3-degree Gauss-Kruger zone 4",
    3398: "RD/83 / 3-degree Gauss-Kruger zone 4",
    3399: "RD/83 / 3-degree Gauss-Kruger zone 5",
    3400: "NAD83 / Alberta 10-TM (Forest)",
    3401: "NAD83 / Alberta 10-TM (Resource)",
    3402: "NAD83(CSRS) / Alberta 10-TM (Forest)",
    3403: "NAD83(CSRS) / Alberta 10-TM (Resource)",
    3404: "NAD83(HARN) / North Carolina (ftUS)",
    3405: "VN-2000 / UTM zone 48N",
    3406: "VN-2000 / UTM zone 49N",
    3407: "Hong Kong 1963 Grid System",
    3408: "NSIDC EASE-Grid North",
    3409: "NSIDC EASE-Grid South",
    3410: "NSIDC EASE-Grid Global",
    3411: "NSIDC Sea Ice Polar Stereographic North",
    3412: "NSIDC Sea Ice Polar Stereographic South",
    3413: "WGS 84 / NSIDC Sea Ice Polar Stereographic North",
    3414: "SVY21 / Singapore TM",
    3415: "WGS 72BE / South China Sea Lambert",
    3416: "ETRS89 / Austria Lambert",
    3417: "NAD83 / Iowa North (ftUS)",
    3418: "NAD83 / Iowa South (ftUS)",
    3419: "NAD83 / Kansas North (ftUS)",
    3420: "NAD83 / Kansas South (ftUS)",
    3421: "NAD83 / Nevada East (ftUS)",
    3422: "NAD83 / Nevada Central (ftUS)",
    3423: "NAD83 / Nevada West (ftUS)",
    3424: "NAD83 / New Jersey (ftUS)",
    3425: "NAD83(HARN) / Iowa North (ftUS)",
    3426: "NAD83(HARN) / Iowa South (ftUS)",
    3427: "NAD83(HARN) / Kansas North (ftUS)",
    3428: "NAD83(HARN) / Kansas South (ftUS)",
    3429: "NAD83(HARN) / Nevada East (ftUS)",
    3430: "NAD83(HARN) / Nevada Central (ftUS)",
    3431: "NAD83(HARN) / Nevada West (ftUS)",
    3432: "NAD83(HARN) / New Jersey (ftUS)",
    3433: "NAD83 / Arkansas North (ftUS)",
    3434: "NAD83 / Arkansas South (ftUS)",
    3435: "NAD83 / Illinois East (ftUS)",
    3436: "NAD83 / Illinois West (ftUS)",
    3437: "NAD83 / New Hampshire (ftUS)",
    3438: "NAD83 / Rhode Island (ftUS)",
    3439: "PSD93 / UTM zone 39N",
    3440: "PSD93 / UTM zone 40N",
    3441: "NAD83(HARN) / Arkansas North (ftUS)",
    3442: "NAD83(HARN) / Arkansas South (ftUS)",
    3443: "NAD83(HARN) / Illinois East (ftUS)",
    3444: "NAD83(HARN) / Illinois West (ftUS)",
    3445: "NAD83(HARN) / New Hampshire (ftUS)",
    3446: "NAD83(HARN) / Rhode Island (ftUS)",
    3447: "ETRS89 / Belgian Lambert 2005",
    3448: "JAD2001 / Jamaica Metric Grid",
    3449: "JAD2001 / UTM zone 17N",
    3450: "JAD2001 / UTM zone 18N",
    3451: "NAD83 / Louisiana North (ftUS)",
    3452: "NAD83 / Louisiana South (ftUS)",
    3453: "NAD83 / Louisiana Offshore (ftUS)",
    3454: "NAD83 / South Dakota North (ftUS)",
    3455: "NAD83 / South Dakota South (ftUS)",
    3456: "NAD83(HARN) / Louisiana North (ftUS)",
    3457: "NAD83(HARN) / Louisiana South (ftUS)",
    3458: "NAD83(HARN) / South Dakota North (ftUS)",
    3459: "NAD83(HARN) / South Dakota South (ftUS)",
    3460: "Fiji 1986 / Fiji Map Grid",
    3461: "Dabola 1981 / UTM zone 28N",
    3462: "Dabola 1981 / UTM zone 29N",
    3463: "NAD83 / Maine CS2000 Central",
    3464: "NAD83(HARN) / Maine CS2000 Central",
    3465: "NAD83(NSRS2007) / Alabama East",
    3466: "NAD83(NSRS2007) / Alabama West",
    3467: "NAD83(NSRS2007) / Alaska Albers",
    3468: "NAD83(NSRS2007) / Alaska zone 1",
    3469: "NAD83(NSRS2007) / Alaska zone 2",
    3470: "NAD83(NSRS2007) / Alaska zone 3",
    3471: "NAD83(NSRS2007) / Alaska zone 4",
    3472: "NAD83(NSRS2007) / Alaska zone 5",
    3473: "NAD83(NSRS2007) / Alaska zone 6",
    3474: "NAD83(NSRS2007) / Alaska zone 7",
    3475: "NAD83(NSRS2007) / Alaska zone 8",
    3476: "NAD83(NSRS2007) / Alaska zone 9",
    3477: "NAD83(NSRS2007) / Alaska zone 10",
    3478: "NAD83(NSRS2007) / Arizona Central",
    3479: "NAD83(NSRS2007) / Arizona Central (ft)",
    3480: "NAD83(NSRS2007) / Arizona East",
    3481: "NAD83(NSRS2007) / Arizona East (ft)",
    3482: "NAD83(NSRS2007) / Arizona West",
    3483: "NAD83(NSRS2007) / Arizona West (ft)",
    3484: "NAD83(NSRS2007) / Arkansas North",
    3485: "NAD83(NSRS2007) / Arkansas North (ftUS)",
    3486: "NAD83(NSRS2007) / Arkansas South",
    3487: "NAD83(NSRS2007) / Arkansas South (ftUS)",
    3488: "NAD83(NSRS2007) / California Albers",
    3489: "NAD83(NSRS2007) / California zone 1",
    3490: "NAD83(NSRS2007) / California zone 1 (ftUS)",
    3491: "NAD83(NSRS2007) / California zone 2",
    3492: "NAD83(NSRS2007) / California zone 2 (ftUS)",
    3493: "NAD83(NSRS2007) / California zone 3",
    3494: "NAD83(NSRS2007) / California zone 3 (ftUS)",
    3495: "NAD83(NSRS2007) / California zone 4",
    3496: "NAD83(NSRS2007) / California zone 4 (ftUS)",
    3497: "NAD83(NSRS2007) / California zone 5",
    3498: "NAD83(NSRS2007) / California zone 5 (ftUS)",
    3499: "NAD83(NSRS2007) / California zone 6",
    3500: "NAD83(NSRS2007) / California zone 6 (ftUS)",
    3501: "NAD83(NSRS2007) / Colorado Central",
    3502: "NAD83(NSRS2007) / Colorado Central (ftUS)",
    3503: "NAD83(NSRS2007) / Colorado North",
    3504: "NAD83(NSRS2007) / Colorado North (ftUS)",
    3505: "NAD83(NSRS2007) / Colorado South",
    3506: "NAD83(NSRS2007) / Colorado South (ftUS)",
    3507: "NAD83(NSRS2007) / Connecticut",
    3508: "NAD83(NSRS2007) / Connecticut (ftUS)",
    3509: "NAD83(NSRS2007) / Delaware",
    3510: "NAD83(NSRS2007) / Delaware (ftUS)",
    3511: "NAD83(NSRS2007) / Florida East",
    3512: "NAD83(NSRS2007) / Florida East (ftUS)",
    3513: "NAD83(NSRS2007) / Florida GDL Albers",
    3514: "NAD83(NSRS2007) / Florida North",
    3515: "NAD83(NSRS2007) / Florida North (ftUS)",
    3516: "NAD83(NSRS2007) / Florida West",
    3517: "NAD83(NSRS2007) / Florida West (ftUS)",
    3518: "NAD83(NSRS2007) / Georgia East",
    3519: "NAD83(NSRS2007) / Georgia East (ftUS)",
    3520: "NAD83(NSRS2007) / Georgia West",
    3521: "NAD83(NSRS2007) / Georgia West (ftUS)",
    3522: "NAD83(NSRS2007) / Idaho Central",
    3523: "NAD83(NSRS2007) / Idaho Central (ftUS)",
    3524: "NAD83(NSRS2007) / Idaho East",
    3525: "NAD83(NSRS2007) / Idaho East (ftUS)",
    3526: "NAD83(NSRS2007) / Idaho West",
    3527: "NAD83(NSRS2007) / Idaho West (ftUS)",
    3528: "NAD83(NSRS2007) / Illinois East",
    3529: "NAD83(NSRS2007) / Illinois East (ftUS)",
    3530: "NAD83(NSRS2007) / Illinois West",
    3531: "NAD83(NSRS2007) / Illinois West (ftUS)",
    3532: "NAD83(NSRS2007) / Indiana East",
    3533: "NAD83(NSRS2007) / Indiana East (ftUS)",
    3534: "NAD83(NSRS2007) / Indiana West",
    3535: "NAD83(NSRS2007) / Indiana West (ftUS)",
    3536: "NAD83(NSRS2007) / Iowa North",
    3537: "NAD83(NSRS2007) / Iowa North (ftUS)",
    3538: "NAD83(NSRS2007) / Iowa South",
    3539: "NAD83(NSRS2007) / Iowa South (ftUS)",
    3540: "NAD83(NSRS2007) / Kansas North",
    3541: "NAD83(NSRS2007) / Kansas North (ftUS)",
    3542: "NAD83(NSRS2007) / Kansas South",
    3543: "NAD83(NSRS2007) / Kansas South (ftUS)",
    3544: "NAD83(NSRS2007) / Kentucky North",
    3545: "NAD83(NSRS2007) / Kentucky North (ftUS)",
    3546: "NAD83(NSRS2007) / Kentucky Single Zone",
    3547: "NAD83(NSRS2007) / Kentucky Single Zone (ftUS)",
    3548: "NAD83(NSRS2007) / Kentucky South",
    3549: "NAD83(NSRS2007) / Kentucky South (ftUS)",
    3550: "NAD83(NSRS2007) / Louisiana North",
    3551: "NAD83(NSRS2007) / Louisiana North (ftUS)",
    3552: "NAD83(NSRS2007) / Louisiana South",
    3553: "NAD83(NSRS2007) / Louisiana South (ftUS)",
    3554: "NAD83(NSRS2007) / Maine CS2000 Central",
    3555: "NAD83(NSRS2007) / Maine CS2000 East",
    3556: "NAD83(NSRS2007) / Maine CS2000 West",
    3557: "NAD83(NSRS2007) / Maine East",
    3558: "NAD83(NSRS2007) / Maine West",
    3559: "NAD83(NSRS2007) / Maryland",
    3560: "NAD83 / Utah North (ftUS)",
    3561: "Old Hawaiian / Hawaii zone 1",
    3562: "Old Hawaiian / Hawaii zone 2",
    3563: "Old Hawaiian / Hawaii zone 3",
    3564: "Old Hawaiian / Hawaii zone 4",
    3565: "Old Hawaiian / Hawaii zone 5",
    3566: "NAD83 / Utah Central (ftUS)",
    3567: "NAD83 / Utah South (ftUS)",
    3568: "NAD83(HARN) / Utah North (ftUS)",
    3569: "NAD83(HARN) / Utah Central (ftUS)",
    3570: "NAD83(HARN) / Utah South (ftUS)",
    3571: "WGS 84 / North Pole LAEA Bering Sea",
    3572: "WGS 84 / North Pole LAEA Alaska",
    3573: "WGS 84 / North Pole LAEA Canada",
    3574: "WGS 84 / North Pole LAEA Atlantic",
    3575: "WGS 84 / North Pole LAEA Europe",
    3576: "WGS 84 / North Pole LAEA Russia",
    3577: "GDA94 / Australian Albers",
    3578: "NAD83 / Yukon Albers",
    3579: "NAD83(CSRS) / Yukon Albers",
    3580: "NAD83 / NWT Lambert",
    3581: "NAD83(CSRS) / NWT Lambert",
    3582: "NAD83(NSRS2007) / Maryland (ftUS)",
    3583: "NAD83(NSRS2007) / Massachusetts Island",
    3584: "NAD83(NSRS2007) / Massachusetts Island (ftUS)",
    3585: "NAD83(NSRS2007) / Massachusetts Mainland",
    3586: "NAD83(NSRS2007) / Massachusetts Mainland (ftUS)",
    3587: "NAD83(NSRS2007) / Michigan Central",
    3588: "NAD83(NSRS2007) / Michigan Central (ft)",
    3589: "NAD83(NSRS2007) / Michigan North",
    3590: "NAD83(NSRS2007) / Michigan North (ft)",
    3591: "NAD83(NSRS2007) / Michigan Oblique Mercator",
    3592: "NAD83(NSRS2007) / Michigan South",
    3593: "NAD83(NSRS2007) / Michigan South (ft)",
    3594: "NAD83(NSRS2007) / Minnesota Central",
    3595: "NAD83(NSRS2007) / Minnesota North",
    3596: "NAD83(NSRS2007) / Minnesota South",
    3597: "NAD83(NSRS2007) / Mississippi East",
    3598: "NAD83(NSRS2007) / Mississippi East (ftUS)",
    3599: "NAD83(NSRS2007) / Mississippi West",
    3600: "NAD83(NSRS2007) / Mississippi West (ftUS)",
    3601: "NAD83(NSRS2007) / Missouri Central",
    3602: "NAD83(NSRS2007) / Missouri East",
    3603: "NAD83(NSRS2007) / Missouri West",
    3604: "NAD83(NSRS2007) / Montana",
    3605: "NAD83(NSRS2007) / Montana (ft)",
    3606: "NAD83(NSRS2007) / Nebraska",
    3607: "NAD83(NSRS2007) / Nevada Central",
    3608: "NAD83(NSRS2007) / Nevada Central (ftUS)",
    3609: "NAD83(NSRS2007) / Nevada East",
    3610: "NAD83(NSRS2007) / Nevada East (ftUS)",
    3611: "NAD83(NSRS2007) / Nevada West",
    3612: "NAD83(NSRS2007) / Nevada West (ftUS)",
    3613: "NAD83(NSRS2007) / New Hampshire",
    3614: "NAD83(NSRS2007) / New Hampshire (ftUS)",
    3615: "NAD83(NSRS2007) / New Jersey",
    3616: "NAD83(NSRS2007) / New Jersey (ftUS)",
    3617: "NAD83(NSRS2007) / New Mexico Central",
    3618: "NAD83(NSRS2007) / New Mexico Central (ftUS)",
    3619: "NAD83(NSRS2007) / New Mexico East",
    3620: "NAD83(NSRS2007) / New Mexico East (ftUS)",
    3621: "NAD83(NSRS2007) / New Mexico West",
    3622: "NAD83(NSRS2007) / New Mexico West (ftUS)",
    3623: "NAD83(NSRS2007) / New York Central",
    3624: "NAD83(NSRS2007) / New York Central (ftUS)",
    3625: "NAD83(NSRS2007) / New York East",
    3626: "NAD83(NSRS2007) / New York East (ftUS)",
    3627: "NAD83(NSRS2007) / New York Long Island",
    3628: "NAD83(NSRS2007) / New York Long Island (ftUS)",
    3629: "NAD83(NSRS2007) / New York West",
    3630: "NAD83(NSRS2007) / New York West (ftUS)",
    3631: "NAD83(NSRS2007) / North Carolina",
    3632: "NAD83(NSRS2007) / North Carolina (ftUS)",
    3633: "NAD83(NSRS2007) / North Dakota North",
    3634: "NAD83(NSRS2007) / North Dakota North (ft)",
    3635: "NAD83(NSRS2007) / North Dakota South",
    3636: "NAD83(NSRS2007) / North Dakota South (ft)",
    3637: "NAD83(NSRS2007) / Ohio North",
    3638: "NAD83(NSRS2007) / Ohio South",
    3639: "NAD83(NSRS2007) / Oklahoma North",
    3640: "NAD83(NSRS2007) / Oklahoma North (ftUS)",
    3641: "NAD83(NSRS2007) / Oklahoma South",
    3642: "NAD83(NSRS2007) / Oklahoma South (ftUS)",
    3643: "NAD83(NSRS2007) / Oregon LCC (m)",
    3644: "NAD83(NSRS2007) / Oregon GIC Lambert (ft)",
    3645: "NAD83(NSRS2007) / Oregon North",
    3646: "NAD83(NSRS2007) / Oregon North (ft)",
    3647: "NAD83(NSRS2007) / Oregon South",
    3648: "NAD83(NSRS2007) / Oregon South (ft)",
    3649: "NAD83(NSRS2007) / Pennsylvania North",
    3650: "NAD83(NSRS2007) / Pennsylvania North (ftUS)",
    3651: "NAD83(NSRS2007) / Pennsylvania South",
    3652: "NAD83(NSRS2007) / Pennsylvania South (ftUS)",
    3653: "NAD83(NSRS2007) / Rhode Island",
    3654: "NAD83(NSRS2007) / Rhode Island (ftUS)",
    3655: "NAD83(NSRS2007) / South Carolina",
    3656: "NAD83(NSRS2007) / South Carolina (ft)",
    3657: "NAD83(NSRS2007) / South Dakota North",
    3658: "NAD83(NSRS2007) / South Dakota North (ftUS)",
    3659: "NAD83(NSRS2007) / South Dakota South",
    3660: "NAD83(NSRS2007) / South Dakota South (ftUS)",
    3661: "NAD83(NSRS2007) / Tennessee",
    3662: "NAD83(NSRS2007) / Tennessee (ftUS)",
    3663: "NAD83(NSRS2007) / Texas Central",
    3664: "NAD83(NSRS2007) / Texas Central (ftUS)",
    3665: "NAD83(NSRS2007) / Texas Centric Albers Equal Area",
    3666: "NAD83(NSRS2007) / Texas Centric Lambert Conformal",
    3667: "NAD83(NSRS2007) / Texas North",
    3668: "NAD83(NSRS2007) / Texas North (ftUS)",
    3669: "NAD83(NSRS2007) / Texas North Central",
    3670: "NAD83(NSRS2007) / Texas North Central (ftUS)",
    3671: "NAD83(NSRS2007) / Texas South",
    3672: "NAD83(NSRS2007) / Texas South (ftUS)",
    3673: "NAD83(NSRS2007) / Texas South Central",
    3674: "NAD83(NSRS2007) / Texas South Central (ftUS)",
    3675: "NAD83(NSRS2007) / Utah Central",
    3676: "NAD83(NSRS2007) / Utah Central (ft)",
    3677: "NAD83(NSRS2007) / Utah Central (ftUS)",
    3678: "NAD83(NSRS2007) / Utah North",
    3679: "NAD83(NSRS2007) / Utah North (ft)",
    3680: "NAD83(NSRS2007) / Utah North (ftUS)",
    3681: "NAD83(NSRS2007) / Utah South",
    3682: "NAD83(NSRS2007) / Utah South (ft)",
    3683: "NAD83(NSRS2007) / Utah South (ftUS)",
    3684: "NAD83(NSRS2007) / Vermont",
    3685: "NAD83(NSRS2007) / Virginia North",
    3686: "NAD83(NSRS2007) / Virginia North (ftUS)",
    3687: "NAD83(NSRS2007) / Virginia South",
    3688: "NAD83(NSRS2007) / Virginia South (ftUS)",
    3689: "NAD83(NSRS2007) / Washington North",
    3690: "NAD83(NSRS2007) / Washington North (ftUS)",
    3691: "NAD83(NSRS2007) / Washington South",
    3692: "NAD83(NSRS2007) / Washington South (ftUS)",
    3693: "NAD83(NSRS2007) / West Virginia North",
    3694: "NAD83(NSRS2007) / West Virginia South",
    3695: "NAD83(NSRS2007) / Wisconsin Central",
    3696: "NAD83(NSRS2007) / Wisconsin Central (ftUS)",
    3697: "NAD83(NSRS2007) / Wisconsin North",
    3698: "NAD83(NSRS2007) / Wisconsin North (ftUS)",
    3699: "NAD83(NSRS2007) / Wisconsin South",
    3700: "NAD83(NSRS2007) / Wisconsin South (ftUS)",
    3701: "NAD83(NSRS2007) / Wisconsin Transverse Mercator",
    3702: "NAD83(NSRS2007) / Wyoming East",
    3703: "NAD83(NSRS2007) / Wyoming East Central",
    3704: "NAD83(NSRS2007) / Wyoming West Central",
    3705: "NAD83(NSRS2007) / Wyoming West",
    3706: "NAD83(NSRS2007) / UTM zone 59N",
    3707: "NAD83(NSRS2007) / UTM zone 60N",
    3708: "NAD83(NSRS2007) / UTM zone 1N",
    3709: "NAD83(NSRS2007) / UTM zone 2N",
    3710: "NAD83(NSRS2007) / UTM zone 3N",
    3711: "NAD83(NSRS2007) / UTM zone 4N",
    3712: "NAD83(NSRS2007) / UTM zone 5N",
    3713: "NAD83(NSRS2007) / UTM zone 6N",
    3714: "NAD83(NSRS2007) / UTM zone 7N",
    3715: "NAD83(NSRS2007) / UTM zone 8N",
    3716: "NAD83(NSRS2007) / UTM zone 9N",
    3717: "NAD83(NSRS2007) / UTM zone 10N",
    3718: "NAD83(NSRS2007) / UTM zone 11N",
    3719: "NAD83(NSRS2007) / UTM zone 12N",
    3720: "NAD83(NSRS2007) / UTM zone 13N",
    3721: "NAD83(NSRS2007) / UTM zone 14N",
    3722: "NAD83(NSRS2007) / UTM zone 15N",
    3723: "NAD83(NSRS2007) / UTM zone 16N",
    3724: "NAD83(NSRS2007) / UTM zone 17N",
    3725: "NAD83(NSRS2007) / UTM zone 18N",
    3726: "NAD83(NSRS2007) / UTM zone 19N",
    3727: "Reunion 1947 / TM Reunion",
    3728: "NAD83(NSRS2007) / Ohio North (ftUS)",
    3729: "NAD83(NSRS2007) / Ohio South (ftUS)",
    3730: "NAD83(NSRS2007) / Wyoming East (ftUS)",
    3731: "NAD83(NSRS2007) / Wyoming East Central (ftUS)",
    3732: "NAD83(NSRS2007) / Wyoming West Central (ftUS)",
    3733: "NAD83(NSRS2007) / Wyoming West (ftUS)",
    3734: "NAD83 / Ohio North (ftUS)",
    3735: "NAD83 / Ohio South (ftUS)",
    3736: "NAD83 / Wyoming East (ftUS)",
    3737: "NAD83 / Wyoming East Central (ftUS)",
    3738: "NAD83 / Wyoming West Central (ftUS)",
    3739: "NAD83 / Wyoming West (ftUS)",
    3740: "NAD83(HARN) / UTM zone 10N",
    3741: "NAD83(HARN) / UTM zone 11N",
    3742: "NAD83(HARN) / UTM zone 12N",
    3743: "NAD83(HARN) / UTM zone 13N",
    3744: "NAD83(HARN) / UTM zone 14N",
    3745: "NAD83(HARN) / UTM zone 15N",
    3746: "NAD83(HARN) / UTM zone 16N",
    3747: "NAD83(HARN) / UTM zone 17N",
    3748: "NAD83(HARN) / UTM zone 18N",
    3749: "NAD83(HARN) / UTM zone 19N",
    3750: "NAD83(HARN) / UTM zone 4N",
    3751: "NAD83(HARN) / UTM zone 5N",
    3752: "WGS 84 / Mercator 41",
    3753: "NAD83(HARN) / Ohio North (ftUS)",
    3754: "NAD83(HARN) / Ohio South (ftUS)",
    3755: "NAD83(HARN) / Wyoming East (ftUS)",
    3756: "NAD83(HARN) / Wyoming East Central (ftUS)",
    3757: "NAD83(HARN) / Wyoming West Central (ftUS)",
    3758: "NAD83(HARN) / Wyoming West (ftUS)",
    3759: "NAD83 / Hawaii zone 3 (ftUS)",
    3760: "NAD83(HARN) / Hawaii zone 3 (ftUS)",
    3761: "NAD83(CSRS) / UTM zone 22N",
    3762: "WGS 84 / South Georgia Lambert",
    3763: "ETRS89 / Portugal TM06",
    3764: "NZGD2000 / Chatham Island Circuit 2000",
    3765: "HTRS96 / Croatia TM",
    3766: "HTRS96 / Croatia LCC",
    3767: "HTRS96 / UTM zone 33N",
    3768: "HTRS96 / UTM zone 34N",
    3769: "Bermuda 1957 / UTM zone 20N",
    3770: "BDA2000 / Bermuda 2000 National Grid",
    3771: "NAD27 / Alberta 3TM ref merid 111 W",
    3772: "NAD27 / Alberta 3TM ref merid 114 W",
    3773: "NAD27 / Alberta 3TM ref merid 117 W",
    3774: "NAD27 / Alberta 3TM ref merid 120 W",
    3775: "NAD83 / Alberta 3TM ref merid 111 W",
    3776: "NAD83 / Alberta 3TM ref merid 114 W",
    3777: "NAD83 / Alberta 3TM ref merid 117 W",
    3778: "NAD83 / Alberta 3TM ref merid 120 W",
    3779: "NAD83(CSRS) / Alberta 3TM ref merid 111 W",
    3780: "NAD83(CSRS) / Alberta 3TM ref merid 114 W",
    3781: "NAD83(CSRS) / Alberta 3TM ref merid 117 W",
    3782: "NAD83(CSRS) / Alberta 3TM ref merid 120 W",
    3783: "Pitcairn 2006 / Pitcairn TM 2006",
    3784: "Pitcairn 1967 / UTM zone 9S",
    3785: "Popular Visualisation CRS / Mercator",
    3786: "World Equidistant Cylindrical (Sphere)",
    3787: "MGI / Slovene National Grid",
    3788: "NZGD2000 / Auckland Islands TM 2000",
    3789: "NZGD2000 / Campbell Island TM 2000",
    3790: "NZGD2000 / Antipodes Islands TM 2000",
    3791: "NZGD2000 / Raoul Island TM 2000",
    3793: "NZGD2000 / Chatham Islands TM 2000",
    3794: "Slovenia 1996 / Slovene National Grid",
    3795: "NAD27 / Cuba Norte",
    3796: "NAD27 / Cuba Sur",
    3797: "NAD27 / MTQ Lambert",
    3798: "NAD83 / MTQ Lambert",
    3799: "NAD83(CSRS) / MTQ Lambert",
    3800: "NAD27 / Alberta 3TM ref merid 120 W",
    3801: "NAD83 / Alberta 3TM ref merid 120 W",
    3802: "NAD83(CSRS) / Alberta 3TM ref merid 120 W",
    3812: "ETRS89 / Belgian Lambert 2008",
    3814: "NAD83 / Mississippi TM",
    3815: "NAD83(HARN) / Mississippi TM",
    3816: "NAD83(NSRS2007) / Mississippi TM",
    3825: "TWD97 / TM2 zone 119",
    3826: "TWD97 / TM2 zone 121",
    3827: "TWD67 / TM2 zone 119",
    3828: "TWD67 / TM2 zone 121",
    3829: "Hu Tzu Shan 1950 / UTM zone 51N",
    3832: "WGS 84 / PDC Mercator",
    3833: "Pulkovo 1942(58) / Gauss-Kruger zone 2",
    3834: "Pulkovo 1942(83) / Gauss-Kruger zone 2",
    3835: "Pulkovo 1942(83) / Gauss-Kruger zone 3",
    3836: "Pulkovo 1942(83) / Gauss-Kruger zone 4",
    3837: "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 3",
    3838: "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 4",
    3839: "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 9",
    3840: "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 10",
    3841: "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 6",
    3842: "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 7",
    3843: "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 8",
    3844: "Pulkovo 1942(58) / Stereo70",
    3845: "SWEREF99 / RT90 7.5 gon V emulation",
    3846: "SWEREF99 / RT90 5 gon V emulation",
    3847: "SWEREF99 / RT90 2.5 gon V emulation",
    3848: "SWEREF99 / RT90 0 gon emulation",
    3849: "SWEREF99 / RT90 2.5 gon O emulation",
    3850: "SWEREF99 / RT90 5 gon O emulation",
    3851: "NZGD2000 / NZCS2000",
    3852: "RSRGD2000 / DGLC2000",
    3854: "County ST74",
    3857: "WGS 84 / Pseudo-Mercator",
    3873: "ETRS89 / GK19FIN",
    3874: "ETRS89 / GK20FIN",
    3875: "ETRS89 / GK21FIN",
    3876: "ETRS89 / GK22FIN",
    3877: "ETRS89 / GK23FIN",
    3878: "ETRS89 / GK24FIN",
    3879: "ETRS89 / GK25FIN",
    3880: "ETRS89 / GK26FIN",
    3881: "ETRS89 / GK27FIN",
    3882: "ETRS89 / GK28FIN",
    3883: "ETRS89 / GK29FIN",
    3884: "ETRS89 / GK30FIN",
    3885: "ETRS89 / GK31FIN",
    3890: "IGRS / UTM zone 37N",
    3891: "IGRS / UTM zone 38N",
    3892: "IGRS / UTM zone 39N",
    3893: "ED50 / Iraq National Grid",
    3907: "MGI 1901 / Balkans zone 5",
    3908: "MGI 1901 / Balkans zone 6",
    3909: "MGI 1901 / Balkans zone 7",
    3910: "MGI 1901 / Balkans zone 8",
    3911: "MGI 1901 / Slovenia Grid",
    3912: "MGI 1901 / Slovene National Grid",
    3920: "Puerto Rico / UTM zone 20N",
    3942: "RGF93 / CC42",
    3943: "RGF93 / CC43",
    3944: "RGF93 / CC44",
    3945: "RGF93 / CC45",
    3946: "RGF93 / CC46",
    3947: "RGF93 / CC47",
    3948: "RGF93 / CC48",
    3949: "RGF93 / CC49",
    3950: "RGF93 / CC50",
    3968: "NAD83 / Virginia Lambert",
    3969: "NAD83(HARN) / Virginia Lambert",
    3970: "NAD83(NSRS2007) / Virginia Lambert",
    3973: "WGS 84 / NSIDC EASE-Grid North",
    3974: "WGS 84 / NSIDC EASE-Grid South",
    3975: "WGS 84 / NSIDC EASE-Grid Global",
    3976: "WGS 84 / NSIDC Sea Ice Polar Stereographic South",
    3978: "NAD83 / Canada Atlas Lambert",
    3979: "NAD83(CSRS) / Canada Atlas Lambert",
    3985: "Katanga 1955 / Katanga Lambert",
    3986: "Katanga 1955 / Katanga Gauss zone A",
    3987: "Katanga 1955 / Katanga Gauss zone B",
    3988: "Katanga 1955 / Katanga Gauss zone C",
    3989: "Katanga 1955 / Katanga Gauss zone D",
    3991: "Puerto Rico State Plane CS of 1927",
    3992: "Puerto Rico / St. Croix",
    3993: "Guam 1963 / Guam SPCS",
    3994: "WGS 84 / Mercator 41",
    3995: "WGS 84 / Arctic Polar Stereographic",
    3996: "WGS 84 / IBCAO Polar Stereographic",
    3997: "WGS 84 / Dubai Local TM",
    4026: "MOLDREF99 / Moldova TM",
    4037: "WGS 84 / TMzn35N",
    4038: "WGS 84 / TMzn36N",
    4048: "RGRDC 2005 / Congo TM zone 12",
    4049: "RGRDC 2005 / Congo TM zone 14",
    4050: "RGRDC 2005 / Congo TM zone 16",
    4051: "RGRDC 2005 / Congo TM zone 18",
    4056: "RGRDC 2005 / Congo TM zone 20",
    4057: "RGRDC 2005 / Congo TM zone 22",
    4058: "RGRDC 2005 / Congo TM zone 24",
    4059: "RGRDC 2005 / Congo TM zone 26",
    4060: "RGRDC 2005 / Congo TM zone 28",
    4061: "RGRDC 2005 / UTM zone 33S",
    4062: "RGRDC 2005 / UTM zone 34S",
    4063: "RGRDC 2005 / UTM zone 35S",
    4071: "Chua / UTM zone 23S",
    4082: "REGCAN95 / UTM zone 27N",
    4083: "REGCAN95 / UTM zone 28N",
    4087: "WGS 84 / World Equidistant Cylindrical",
    4088: "World Equidistant Cylindrical (Sphere)",
    4093: "ETRS89 / DKTM1",
    4094: "ETRS89 / DKTM2",
    4095: "ETRS89 / DKTM3",
    4096: "ETRS89 / DKTM4",
    4217: "NAD83 / BLM 59N (ftUS)",
    4390: "Kertau 1968 / Johor Grid",
    4391: "Kertau 1968 / Sembilan and Melaka Grid",
    4392: "Kertau 1968 / Pahang Grid",
    4393: "Kertau 1968 / Selangor Grid",
    4394: "Kertau 1968 / Terengganu Grid",
    4395: "Kertau 1968 / Pinang Grid",
    4396: "Kertau 1968 / Kedah and Perlis Grid",
    4397: "Kertau 1968 / Perak Revised Grid",
    4398: "Kertau 1968 / Kelantan Grid",
    4399: "NAD27 / BLM 59N (ftUS)",
    4400: "NAD27 / BLM 60N (ftUS)",
    4401: "NAD27 / BLM 1N (ftUS)",
    4402: "NAD27 / BLM 2N (ftUS)",
    4403: "NAD27 / BLM 3N (ftUS)",
    4404: "NAD27 / BLM 4N (ftUS)",
    4405: "NAD27 / BLM 5N (ftUS)",
    4406: "NAD27 / BLM 6N (ftUS)",
    4407: "NAD27 / BLM 7N (ftUS)",
    4408: "NAD27 / BLM 8N (ftUS)",
    4409: "NAD27 / BLM 9N (ftUS)",
    4410: "NAD27 / BLM 10N (ftUS)",
    4411: "NAD27 / BLM 11N (ftUS)",
    4412: "NAD27 / BLM 12N (ftUS)",
    4413: "NAD27 / BLM 13N (ftUS)",
    4414: "NAD83(HARN) / Guam Map Grid",
    4415: "Katanga 1955 / Katanga Lambert",
    4417: "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 7",
    4418: "NAD27 / BLM 18N (ftUS)",
    4419: "NAD27 / BLM 19N (ftUS)",
    4420: "NAD83 / BLM 60N (ftUS)",
    4421: "NAD83 / BLM 1N (ftUS)",
    4422: "NAD83 / BLM 2N (ftUS)",
    4423: "NAD83 / BLM 3N (ftUS)",
    4424: "NAD83 / BLM 4N (ftUS)",
    4425: "NAD83 / BLM 5N (ftUS)",
    4426: "NAD83 / BLM 6N (ftUS)",
    4427: "NAD83 / BLM 7N (ftUS)",
    4428: "NAD83 / BLM 8N (ftUS)",
    4429: "NAD83 / BLM 9N (ftUS)",
    4430: "NAD83 / BLM 10N (ftUS)",
    4431: "NAD83 / BLM 11N (ftUS)",
    4432: "NAD83 / BLM 12N (ftUS)",
    4433: "NAD83 / BLM 13N (ftUS)",
    4434: "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 8",
    4437: "NAD83(NSRS2007) / Puerto Rico and Virgin Is.",
    4438: "NAD83 / BLM 18N (ftUS)",
    4439: "NAD83 / BLM 19N (ftUS)",
    4455: "NAD27 / Pennsylvania South",
    4456: "NAD27 / New York Long Island",
    4457: "NAD83 / South Dakota North (ftUS)",
    4462: "WGS 84 / Australian Centre for Remote Sensing Lambert",
    4467: "RGSPM06 / UTM zone 21N",
    4471: "RGM04 / UTM zone 38S",
    4474: "Cadastre 1997 / UTM zone 38S",
    4484: "Mexico ITRF92 / UTM zone 11N",
    4485: "Mexico ITRF92 / UTM zone 12N",
    4486: "Mexico ITRF92 / UTM zone 13N",
    4487: "Mexico ITRF92 / UTM zone 14N",
    4488: "Mexico ITRF92 / UTM zone 15N",
    4489: "Mexico ITRF92 / UTM zone 16N",
    4491: "CGCS2000 / Gauss-Kruger zone 13",
    4492: "CGCS2000 / Gauss-Kruger zone 14",
    4493: "CGCS2000 / Gauss-Kruger zone 15",
    4494: "CGCS2000 / Gauss-Kruger zone 16",
    4495: "CGCS2000 / Gauss-Kruger zone 17",
    4496: "CGCS2000 / Gauss-Kruger zone 18",
    4497: "CGCS2000 / Gauss-Kruger zone 19",
    4498: "CGCS2000 / Gauss-Kruger zone 20",
    4499: "CGCS2000 / Gauss-Kruger zone 21",
    4500: "CGCS2000 / Gauss-Kruger zone 22",
    4501: "CGCS2000 / Gauss-Kruger zone 23",
    4502: "CGCS2000 / Gauss-Kruger CM 75E",
    4503: "CGCS2000 / Gauss-Kruger CM 81E",
    4504: "CGCS2000 / Gauss-Kruger CM 87E",
    4505: "CGCS2000 / Gauss-Kruger CM 93E",
    4506: "CGCS2000 / Gauss-Kruger CM 99E",
    4507: "CGCS2000 / Gauss-Kruger CM 105E",
    4508: "CGCS2000 / Gauss-Kruger CM 111E",
    4509: "CGCS2000 / Gauss-Kruger CM 117E",
    4510: "CGCS2000 / Gauss-Kruger CM 123E",
    4511: "CGCS2000 / Gauss-Kruger CM 129E",
    4512: "CGCS2000 / Gauss-Kruger CM 135E",
    4513: "CGCS2000 / 3-degree Gauss-Kruger zone 25",
    4514: "CGCS2000 / 3-degree Gauss-Kruger zone 26",
    4515: "CGCS2000 / 3-degree Gauss-Kruger zone 27",
    4516: "CGCS2000 / 3-degree Gauss-Kruger zone 28",
    4517: "CGCS2000 / 3-degree Gauss-Kruger zone 29",
    4518: "CGCS2000 / 3-degree Gauss-Kruger zone 30",
    4519: "CGCS2000 / 3-degree Gauss-Kruger zone 31",
    4520: "CGCS2000 / 3-degree Gauss-Kruger zone 32",
    4521: "CGCS2000 / 3-degree Gauss-Kruger zone 33",
    4522: "CGCS2000 / 3-degree Gauss-Kruger zone 34",
    4523: "CGCS2000 / 3-degree Gauss-Kruger zone 35",
    4524: "CGCS2000 / 3-degree Gauss-Kruger zone 36",
    4525: "CGCS2000 / 3-degree Gauss-Kruger zone 37",
    4526: "CGCS2000 / 3-degree Gauss-Kruger zone 38",
    4527: "CGCS2000 / 3-degree Gauss-Kruger zone 39",
    4528: "CGCS2000 / 3-degree Gauss-Kruger zone 40",
    4529: "CGCS2000 / 3-degree Gauss-Kruger zone 41",
    4530: "CGCS2000 / 3-degree Gauss-Kruger zone 42",
    4531: "CGCS2000 / 3-degree Gauss-Kruger zone 43",
    4532: "CGCS2000 / 3-degree Gauss-Kruger zone 44",
    4533: "CGCS2000 / 3-degree Gauss-Kruger zone 45",
    4534: "CGCS2000 / 3-degree Gauss-Kruger CM 75E",
    4535: "CGCS2000 / 3-degree Gauss-Kruger CM 78E",
    4536: "CGCS2000 / 3-degree Gauss-Kruger CM 81E",
    4537: "CGCS2000 / 3-degree Gauss-Kruger CM 84E",
    4538: "CGCS2000 / 3-degree Gauss-Kruger CM 87E",
    4539: "CGCS2000 / 3-degree Gauss-Kruger CM 90E",
    4540: "CGCS2000 / 3-degree Gauss-Kruger CM 93E",
    4541: "CGCS2000 / 3-degree Gauss-Kruger CM 96E",
    4542: "CGCS2000 / 3-degree Gauss-Kruger CM 99E",
    4543: "CGCS2000 / 3-degree Gauss-Kruger CM 102E",
    4544: "CGCS2000 / 3-degree Gauss-Kruger CM 105E",
    4545: "CGCS2000 / 3-degree Gauss-Kruger CM 108E",
    4546: "CGCS2000 / 3-degree Gauss-Kruger CM 111E",
    4547: "CGCS2000 / 3-degree Gauss-Kruger CM 114E",
    4548: "CGCS2000 / 3-degree Gauss-Kruger CM 117E",
    4549: "CGCS2000 / 3-degree Gauss-Kruger CM 120E",
    4550: "CGCS2000 / 3-degree Gauss-Kruger CM 123E",
    4551: "CGCS2000 / 3-degree Gauss-Kruger CM 126E",
    4552: "CGCS2000 / 3-degree Gauss-Kruger CM 129E",
    4553: "CGCS2000 / 3-degree Gauss-Kruger CM 132E",
    4554: "CGCS2000 / 3-degree Gauss-Kruger CM 135E",
    4559: "RRAF 1991 / UTM zone 20N",
    4568: "New Beijing / Gauss-Kruger zone 13",
    4569: "New Beijing / Gauss-Kruger zone 14",
    4570: "New Beijing / Gauss-Kruger zone 15",
    4571: "New Beijing / Gauss-Kruger zone 16",
    4572: "New Beijing / Gauss-Kruger zone 17",
    4573: "New Beijing / Gauss-Kruger zone 18",
    4574: "New Beijing / Gauss-Kruger zone 19",
    4575: "New Beijing / Gauss-Kruger zone 20",
    4576: "New Beijing / Gauss-Kruger zone 21",
    4577: "New Beijing / Gauss-Kruger zone 22",
    4578: "New Beijing / Gauss-Kruger zone 23",
    4579: "New Beijing / Gauss-Kruger CM 75E",
    4580: "New Beijing / Gauss-Kruger CM 81E",
    4581: "New Beijing / Gauss-Kruger CM 87E",
    4582: "New Beijing / Gauss-Kruger CM 93E",
    4583: "New Beijing / Gauss-Kruger CM 99E",
    4584: "New Beijing / Gauss-Kruger CM 105E",
    4585: "New Beijing / Gauss-Kruger CM 111E",
    4586: "New Beijing / Gauss-Kruger CM 117E",
    4587: "New Beijing / Gauss-Kruger CM 123E",
    4588: "New Beijing / Gauss-Kruger CM 129E",
    4589: "New Beijing / Gauss-Kruger CM 135E",
    4647: "ETRS89 / UTM zone 32N (zE-N)",
    4652: "New Beijing / 3-degree Gauss-Kruger zone 25",
    4653: "New Beijing / 3-degree Gauss-Kruger zone 26",
    4654: "New Beijing / 3-degree Gauss-Kruger zone 27",
    4655: "New Beijing / 3-degree Gauss-Kruger zone 28",
    4656: "New Beijing / 3-degree Gauss-Kruger zone 29",
    4766: "New Beijing / 3-degree Gauss-Kruger zone 30",
    4767: "New Beijing / 3-degree Gauss-Kruger zone 31",
    4768: "New Beijing / 3-degree Gauss-Kruger zone 32",
    4769: "New Beijing / 3-degree Gauss-Kruger zone 33",
    4770: "New Beijing / 3-degree Gauss-Kruger zone 34",
    4771: "New Beijing / 3-degree Gauss-Kruger zone 35",
    4772: "New Beijing / 3-degree Gauss-Kruger zone 36",
    4773: "New Beijing / 3-degree Gauss-Kruger zone 37",
    4774: "New Beijing / 3-degree Gauss-Kruger zone 38",
    4775: "New Beijing / 3-degree Gauss-Kruger zone 39",
    4776: "New Beijing / 3-degree Gauss-Kruger zone 40",
    4777: "New Beijing / 3-degree Gauss-Kruger zone 41",
    4778: "New Beijing / 3-degree Gauss-Kruger zone 42",
    4779: "New Beijing / 3-degree Gauss-Kruger zone 43",
    4780: "New Beijing / 3-degree Gauss-Kruger zone 44",
    4781: "New Beijing / 3-degree Gauss-Kruger zone 45",
    4782: "New Beijing / 3-degree Gauss-Kruger CM 75E",
    4783: "New Beijing / 3-degree Gauss-Kruger CM 78E",
    4784: "New Beijing / 3-degree Gauss-Kruger CM 81E",
    4785: "New Beijing / 3-degree Gauss-Kruger CM 84E",
    4786: "New Beijing / 3-degree Gauss-Kruger CM 87E",
    4787: "New Beijing / 3-degree Gauss-Kruger CM 90E",
    4788: "New Beijing / 3-degree Gauss-Kruger CM 93E",
    4789: "New Beijing / 3-degree Gauss-Kruger CM 96E",
    4790: "New Beijing / 3-degree Gauss-Kruger CM 99E",
    4791: "New Beijing / 3-degree Gauss-Kruger CM 102E",
    4792: "New Beijing / 3-degree Gauss-Kruger CM 105E",
    4793: "New Beijing / 3-degree Gauss-Kruger CM 108E",
    4794: "New Beijing / 3-degree Gauss-Kruger CM 111E",
    4795: "New Beijing / 3-degree Gauss-Kruger CM 114E",
    4796: "New Beijing / 3-degree Gauss-Kruger CM 117E",
    4797: "New Beijing / 3-degree Gauss-Kruger CM 120E",
    4798: "New Beijing / 3-degree Gauss-Kruger CM 123E",
    4799: "New Beijing / 3-degree Gauss-Kruger CM 126E",
    4800: "New Beijing / 3-degree Gauss-Kruger CM 129E",
    4812: "New Beijing / 3-degree Gauss-Kruger CM 132E",
    4822: "New Beijing / 3-degree Gauss-Kruger CM 135E",
    4826: "WGS 84 / Cape Verde National",
    4839: "ETRS89 / LCC Germany (N-E)",
    4855: "ETRS89 / NTM zone 5",
    4856: "ETRS89 / NTM zone 6",
    4857: "ETRS89 / NTM zone 7",
    4858: "ETRS89 / NTM zone 8",
    4859: "ETRS89 / NTM zone 9",
    4860: "ETRS89 / NTM zone 10",
    4861: "ETRS89 / NTM zone 11",
    4862: "ETRS89 / NTM zone 12",
    4863: "ETRS89 / NTM zone 13",
    4864: "ETRS89 / NTM zone 14",
    4865: "ETRS89 / NTM zone 15",
    4866: "ETRS89 / NTM zone 16",
    4867: "ETRS89 / NTM zone 17",
    4868: "ETRS89 / NTM zone 18",
    4869: "ETRS89 / NTM zone 19",
    4870: "ETRS89 / NTM zone 20",
    4871: "ETRS89 / NTM zone 21",
    4872: "ETRS89 / NTM zone 22",
    4873: "ETRS89 / NTM zone 23",
    4874: "ETRS89 / NTM zone 24",
    4875: "ETRS89 / NTM zone 25",
    4876: "ETRS89 / NTM zone 26",
    4877: "ETRS89 / NTM zone 27",
    4878: "ETRS89 / NTM zone 28",
    4879: "ETRS89 / NTM zone 29",
    4880: "ETRS89 / NTM zone 30",
    5014: "PTRA08 / UTM zone 25N",
    5015: "PTRA08 / UTM zone 26N",
    5016: "PTRA08 / UTM zone 28N",
    5017: "Lisbon 1890 / Portugal Bonne New",
    5018: "Lisbon / Portuguese Grid New",
    5041: "WGS 84 / UPS North (E,N)",
    5042: "WGS 84 / UPS South (E,N)",
    5048: "ETRS89 / TM35FIN(N,E)",
    5069: "NAD27 / Conus Albers",
    5070: "NAD83 / Conus Albers",
    5071: "NAD83(HARN) / Conus Albers",
    5072: "NAD83(NSRS2007) / Conus Albers",
    5105: "ETRS89 / NTM zone 5",
    5106: "ETRS89 / NTM zone 6",
    5107: "ETRS89 / NTM zone 7",
    5108: "ETRS89 / NTM zone 8",
    5109: "ETRS89 / NTM zone 9",
    5110: "ETRS89 / NTM zone 10",
    5111: "ETRS89 / NTM zone 11",
    5112: "ETRS89 / NTM zone 12",
    5113: "ETRS89 / NTM zone 13",
    5114: "ETRS89 / NTM zone 14",
    5115: "ETRS89 / NTM zone 15",
    5116: "ETRS89 / NTM zone 16",
    5117: "ETRS89 / NTM zone 17",
    5118: "ETRS89 / NTM zone 18",
    5119: "ETRS89 / NTM zone 19",
    5120: "ETRS89 / NTM zone 20",
    5121: "ETRS89 / NTM zone 21",
    5122: "ETRS89 / NTM zone 22",
    5123: "ETRS89 / NTM zone 23",
    5124: "ETRS89 / NTM zone 24",
    5125: "ETRS89 / NTM zone 25",
    5126: "ETRS89 / NTM zone 26",
    5127: "ETRS89 / NTM zone 27",
    5128: "ETRS89 / NTM zone 28",
    5129: "ETRS89 / NTM zone 29",
    5130: "ETRS89 / NTM zone 30",
    5167: "Korean 1985 / East Sea Belt",
    5168: "Korean 1985 / Central Belt Jeju",
    5169: "Tokyo 1892 / Korea West Belt",
    5170: "Tokyo 1892 / Korea Central Belt",
    5171: "Tokyo 1892 / Korea East Belt",
    5172: "Tokyo 1892 / Korea East Sea Belt",
    5173: "Korean 1985 / Modified West Belt",
    5174: "Korean 1985 / Modified Central Belt",
    5175: "Korean 1985 / Modified Central Belt Jeju",
    5176: "Korean 1985 / Modified East Belt",
    5177: "Korean 1985 / Modified East Sea Belt",
    5178: "Korean 1985 / Unified CS",
    5179: "Korea 2000 / Unified CS",
    5180: "Korea 2000 / West Belt",
    5181: "Korea 2000 / Central Belt",
    5182: "Korea 2000 / Central Belt Jeju",
    5183: "Korea 2000 / East Belt",
    5184: "Korea 2000 / East Sea Belt",
    5185: "Korea 2000 / West Belt 2010",
    5186: "Korea 2000 / Central Belt 2010",
    5187: "Korea 2000 / East Belt 2010",
    5188: "Korea 2000 / East Sea Belt 2010",
    5221: "S-JTSK (Ferro) / Krovak East North",
    5223: "WGS 84 / Gabon TM",
    5224: "S-JTSK/05 (Ferro) / Modified Krovak",
    5225: "S-JTSK/05 (Ferro) / Modified Krovak East North",
    5234: "Kandawala / Sri Lanka Grid",
    5235: "SLD99 / Sri Lanka Grid 1999",
    5243: "ETRS89 / LCC Germany (E-N)",
    5247: "GDBD2009 / Brunei BRSO",
    5253: "TUREF / TM27",
    5254: "TUREF / TM30",
    5255: "TUREF / TM33",
    5256: "TUREF / TM36",
    5257: "TUREF / TM39",
    5258: "TUREF / TM42",
    5259: "TUREF / TM45",
    5266: "DRUKREF 03 / Bhutan National Grid",
    5269: "TUREF / 3-degree Gauss-Kruger zone 9",
    5270: "TUREF / 3-degree Gauss-Kruger zone 10",
    5271: "TUREF / 3-degree Gauss-Kruger zone 11",
    5272: "TUREF / 3-degree Gauss-Kruger zone 12",
    5273: "TUREF / 3-degree Gauss-Kruger zone 13",
    5274: "TUREF / 3-degree Gauss-Kruger zone 14",
    5275: "TUREF / 3-degree Gauss-Kruger zone 15",
    5292: "DRUKREF 03 / Bumthang TM",
    5293: "DRUKREF 03 / Chhukha TM",
    5294: "DRUKREF 03 / Dagana TM",
    5295: "DRUKREF 03 / Gasa TM",
    5296: "DRUKREF 03 / Ha TM",
    5297: "DRUKREF 03 / Lhuentse TM",
    5298: "DRUKREF 03 / Mongar TM",
    5299: "DRUKREF 03 / Paro TM",
    5300: "DRUKREF 03 / Pemagatshel TM",
    5301: "DRUKREF 03 / Punakha TM",
    5302: "DRUKREF 03 / Samdrup Jongkhar TM",
    5303: "DRUKREF 03 / Samtse TM",
    5304: "DRUKREF 03 / Sarpang TM",
    5305: "DRUKREF 03 / Thimphu TM",
    5306: "DRUKREF 03 / Trashigang TM",
    5307: "DRUKREF 03 / Trongsa TM",
    5308: "DRUKREF 03 / Tsirang TM",
    5309: "DRUKREF 03 / Wangdue Phodrang TM",
    5310: "DRUKREF 03 / Yangtse TM",
    5311: "DRUKREF 03 / Zhemgang TM",
    5316: "ETRS89 / Faroe TM",
    5320: "NAD83 / Teranet Ontario Lambert",
    5321: "NAD83(CSRS) / Teranet Ontario Lambert",
    5325: "ISN2004 / Lambert 2004",
    5329: "Segara (Jakarta) / NEIEZ",
    5330: "Batavia (Jakarta) / NEIEZ",
    5331: "Makassar (Jakarta) / NEIEZ",
    5337: "Aratu / UTM zone 25S",
    5343: "POSGAR 2007 / Argentina 1",
    5344: "POSGAR 2007 / Argentina 2",
    5345: "POSGAR 2007 / Argentina 3",
    5346: "POSGAR 2007 / Argentina 4",
    5347: "POSGAR 2007 / Argentina 5",
    5348: "POSGAR 2007 / Argentina 6",
    5349: "POSGAR 2007 / Argentina 7",
    5355: "MARGEN / UTM zone 20S",
    5356: "MARGEN / UTM zone 19S",
    5357: "MARGEN / UTM zone 21S",
    5361: "SIRGAS-Chile / UTM zone 19S",
    5362: "SIRGAS-Chile / UTM zone 18S",
    5367: "CR05 / CRTM05",
    5382: "SIRGAS-ROU98 / UTM zone 21S",
    5383: "SIRGAS-ROU98 / UTM zone 22S",
    5387: "Peru96 / UTM zone 18S",
    5388: "Peru96 / UTM zone 17S",
    5389: "Peru96 / UTM zone 19S",
    5396: "SIRGAS 2000 / UTM zone 26S",
    5456: "Ocotepeque 1935 / Costa Rica Norte",
    5457: "Ocotepeque 1935 / Costa Rica Sur",
    5458: "Ocotepeque 1935 / Guatemala Norte",
    5459: "Ocotepeque 1935 / Guatemala Sur",
    5460: "Ocotepeque 1935 / El Salvador Lambert",
    5461: "Ocotepeque 1935 / Nicaragua Norte",
    5462: "Ocotepeque 1935 / Nicaragua Sur",
    5463: "SAD69 / UTM zone 17N",
    5466: "Sibun Gorge 1922 / Colony Grid",
    5469: "Panama-Colon 1911 / Panama Lambert",
    5472: "Panama-Colon 1911 / Panama Polyconic",
    5479: "RSRGD2000 / MSLC2000",
    5480: "RSRGD2000 / BCLC2000",
    5481: "RSRGD2000 / PCLC2000",
    5482: "RSRGD2000 / RSPS2000",
    5490: "RGAF09 / UTM zone 20N",
    5513: "S-JTSK / Krovak",
    5514: "S-JTSK / Krovak East North",
    5515: "S-JTSK/05 / Modified Krovak",
    5516: "S-JTSK/05 / Modified Krovak East North",
    5518: "CI1971 / Chatham Islands Map Grid",
    5519: "CI1979 / Chatham Islands Map Grid",
    5520: "DHDN / 3-degree Gauss-Kruger zone 1",
    5523: "WGS 84 / Gabon TM 2011",
    5530: "SAD69(96) / Brazil Polyconic",
    5531: "SAD69(96) / UTM zone 21S",
    5532: "SAD69(96) / UTM zone 22S",
    5533: "SAD69(96) / UTM zone 23S",
    5534: "SAD69(96) / UTM zone 24S",
    5535: "SAD69(96) / UTM zone 25S",
    5536: "Corrego Alegre 1961 / UTM zone 21S",
    5537: "Corrego Alegre 1961 / UTM zone 22S",
    5538: "Corrego Alegre 1961 / UTM zone 23S",
    5539: "Corrego Alegre 1961 / UTM zone 24S",
    5550: "PNG94 / PNGMG94 zone 54",
    5551: "PNG94 / PNGMG94 zone 55",
    5552: "PNG94 / PNGMG94 zone 56",
    5559: "Ocotepeque 1935 / Guatemala Norte",
    5562: "UCS-2000 / Gauss-Kruger zone 4",
    5563: "UCS-2000 / Gauss-Kruger zone 5",
    5564: "UCS-2000 / Gauss-Kruger zone 6",
    5565: "UCS-2000 / Gauss-Kruger zone 7",
    5566: "UCS-2000 / Gauss-Kruger CM 21E",
    5567: "UCS-2000 / Gauss-Kruger CM 27E",
    5568: "UCS-2000 / Gauss-Kruger CM 33E",
    5569: "UCS-2000 / Gauss-Kruger CM 39E",
    5570: "UCS-2000 / 3-degree Gauss-Kruger zone 7",
    5571: "UCS-2000 / 3-degree Gauss-Kruger zone 8",
    5572: "UCS-2000 / 3-degree Gauss-Kruger zone 9",
    5573: "UCS-2000 / 3-degree Gauss-Kruger zone 10",
    5574: "UCS-2000 / 3-degree Gauss-Kruger zone 11",
    5575: "UCS-2000 / 3-degree Gauss-Kruger zone 12",
    5576: "UCS-2000 / 3-degree Gauss-Kruger zone 13",
    5577: "UCS-2000 / 3-degree Gauss-Kruger CM 21E",
    5578: "UCS-2000 / 3-degree Gauss-Kruger CM 24E",
    5579: "UCS-2000 / 3-degree Gauss-Kruger CM 27E",
    5580: "UCS-2000 / 3-degree Gauss-Kruger CM 30E",
    5581: "UCS-2000 / 3-degree Gauss-Kruger CM 33E",
    5582: "UCS-2000 / 3-degree Gauss-Kruger CM 36E",
    5583: "UCS-2000 / 3-degree Gauss-Kruger CM 39E",
    5588: "NAD27 / New Brunswick Stereographic (NAD27)",
    5589: "Sibun Gorge 1922 / Colony Grid",
    5596: "FEH2010 / Fehmarnbelt TM",
    5623: "NAD27 / Michigan East",
    5624: "NAD27 / Michigan Old Central",
    5625: "NAD27 / Michigan West",
    5627: "ED50 / TM 6 NE",
    5629: "Moznet / UTM zone 38S",
    5631: "Pulkovo 1942(58) / Gauss-Kruger zone 2 (E-N)",
    5632: "PTRA08 / LCC Europe",
    5633: "PTRA08 / LAEA Europe",
    5634: "REGCAN95 / LCC Europe",
    5635: "REGCAN95 / LAEA Europe",
    5636: "TUREF / LAEA Europe",
    5637: "TUREF / LCC Europe",
    5638: "ISN2004 / LAEA Europe",
    5639: "ISN2004 / LCC Europe",
    5641: "SIRGAS 2000 / Brazil Mercator",
    5643: "ED50 / SPBA LCC",
    5644: "RGR92 / UTM zone 39S",
    5646: "NAD83 / Vermont (ftUS)",
    5649: "ETRS89 / UTM zone 31N (zE-N)",
    5650: "ETRS89 / UTM zone 33N (zE-N)",
    5651: "ETRS89 / UTM zone 31N (N-zE)",
    5652: "ETRS89 / UTM zone 32N (N-zE)",
    5653: "ETRS89 / UTM zone 33N (N-zE)",
    5654: "NAD83(HARN) / Vermont (ftUS)",
    5655: "NAD83(NSRS2007) / Vermont (ftUS)",
    5659: "Monte Mario / TM Emilia-Romagna",
    5663: "Pulkovo 1942(58) / Gauss-Kruger zone 3 (E-N)",
    5664: "Pulkovo 1942(83) / Gauss-Kruger zone 2 (E-N)",
    5665: "Pulkovo 1942(83) / Gauss-Kruger zone 3 (E-N)",
    5666: "PD/83 / 3-degree Gauss-Kruger zone 3 (E-N)",
    5667: "PD/83 / 3-degree Gauss-Kruger zone 4 (E-N)",
    5668: "RD/83 / 3-degree Gauss-Kruger zone 4 (E-N)",
    5669: "RD/83 / 3-degree Gauss-Kruger zone 5 (E-N)",
    5670: "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 3 (E-N)",
    5671: "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 4 (E-N)",
    5672: "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 5 (E-N)",
    5673: "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3 (E-N)",
    5674: "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4 (E-N)",
    5675: "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5 (E-N)",
    5676: "DHDN / 3-degree Gauss-Kruger zone 2 (E-N)",
    5677: "DHDN / 3-degree Gauss-Kruger zone 3 (E-N)",
    5678: "DHDN / 3-degree Gauss-Kruger zone 4 (E-N)",
    5679: "DHDN / 3-degree Gauss-Kruger zone 5 (E-N)",
    5680: "DHDN / 3-degree Gauss-Kruger zone 1 (E-N)",
    5682: "DB_REF / 3-degree Gauss-Kruger zone 2 (E-N)",
    5683: "DB_REF / 3-degree Gauss-Kruger zone 3 (E-N)",
    5684: "DB_REF / 3-degree Gauss-Kruger zone 4 (E-N)",
    5685: "DB_REF / 3-degree Gauss-Kruger zone 5 (E-N)",
    5700: "NZGD2000 / UTM zone 1S",
    5819: "EPSG topocentric example A",
    5820: "EPSG topocentric example B",
    5821: "EPSG vertical perspective example",
    5825: "AGD66 / ACT Standard Grid",
    5836: "Yemen NGN96 / UTM zone 37N",
    5837: "Yemen NGN96 / UTM zone 40N",
    5839: "Peru96 / UTM zone 17S",
    5842: "WGS 84 / TM 12 SE",
    5844: "RGRDC 2005 / Congo TM zone 30",
    5858: "SAD69(96) / UTM zone 22S",
    5875: "SAD69(96) / UTM zone 18S",
    5876: "SAD69(96) / UTM zone 19S",
    5877: "SAD69(96) / UTM zone 20S",
    5879: "Cadastre 1997 / UTM zone 38S",
    5880: "SIRGAS 2000 / Brazil Polyconic",
    5887: "TGD2005 / Tonga Map Grid",
    5890: "JAXA Snow Depth Polar Stereographic North",
    5921: "WGS 84 / EPSG Arctic Regional zone A1",
    5922: "WGS 84 / EPSG Arctic Regional zone A2",
    5923: "WGS 84 / EPSG Arctic Regional zone A3",
    5924: "WGS 84 / EPSG Arctic Regional zone A4",
    5925: "WGS 84 / EPSG Arctic Regional zone A5",
    5926: "WGS 84 / EPSG Arctic Regional zone B1",
    5927: "WGS 84 / EPSG Arctic Regional zone B2",
    5928: "WGS 84 / EPSG Arctic Regional zone B3",
    5929: "WGS 84 / EPSG Arctic Regional zone B4",
    5930: "WGS 84 / EPSG Arctic Regional zone B5",
    5931: "WGS 84 / EPSG Arctic Regional zone C1",
    5932: "WGS 84 / EPSG Arctic Regional zone C2",
    5933: "WGS 84 / EPSG Arctic Regional zone C3",
    5934: "WGS 84 / EPSG Arctic Regional zone C4",
    5935: "WGS 84 / EPSG Arctic Regional zone C5",
    5936: "WGS 84 / EPSG Alaska Polar Stereographic",
    5937: "WGS 84 / EPSG Canada Polar Stereographic",
    5938: "WGS 84 / EPSG Greenland Polar Stereographic",
    5939: "WGS 84 / EPSG Norway Polar Stereographic",
    5940: "WGS 84 / EPSG Russia Polar Stereographic",
    6050: "GR96 / EPSG Arctic zone 1-25",
    6051: "GR96 / EPSG Arctic zone 2-18",
    6052: "GR96 / EPSG Arctic zone 2-20",
    6053: "GR96 / EPSG Arctic zone 3-29",
    6054: "GR96 / EPSG Arctic zone 3-31",
    6055: "GR96 / EPSG Arctic zone 3-33",
    6056: "GR96 / EPSG Arctic zone 4-20",
    6057: "GR96 / EPSG Arctic zone 4-22",
    6058: "GR96 / EPSG Arctic zone 4-24",
    6059: "GR96 / EPSG Arctic zone 5-41",
    6060: "GR96 / EPSG Arctic zone 5-43",
    6061: "GR96 / EPSG Arctic zone 5-45",
    6062: "GR96 / EPSG Arctic zone 6-26",
    6063: "GR96 / EPSG Arctic zone 6-28",
    6064: "GR96 / EPSG Arctic zone 6-30",
    6065: "GR96 / EPSG Arctic zone 7-11",
    6066: "GR96 / EPSG Arctic zone 7-13",
    6067: "GR96 / EPSG Arctic zone 8-20",
    6068: "GR96 / EPSG Arctic zone 8-22",
    6069: "ETRS89 / EPSG Arctic zone 2-22",
    6070: "ETRS89 / EPSG Arctic zone 3-11",
    6071: "ETRS89 / EPSG Arctic zone 4-26",
    6072: "ETRS89 / EPSG Arctic zone 4-28",
    6073: "ETRS89 / EPSG Arctic zone 5-11",
    6074: "ETRS89 / EPSG Arctic zone 5-13",
    6075: "WGS 84 / EPSG Arctic zone 2-24",
    6076: "WGS 84 / EPSG Arctic zone 2-26",
    6077: "WGS 84 / EPSG Arctic zone 3-13",
    6078: "WGS 84 / EPSG Arctic zone 3-15",
    6079: "WGS 84 / EPSG Arctic zone 3-17",
    6080: "WGS 84 / EPSG Arctic zone 3-19",
    6081: "WGS 84 / EPSG Arctic zone 4-30",
    6082: "WGS 84 / EPSG Arctic zone 4-32",
    6083: "WGS 84 / EPSG Arctic zone 4-34",
    6084: "WGS 84 / EPSG Arctic zone 4-36",
    6085: "WGS 84 / EPSG Arctic zone 4-38",
    6086: "WGS 84 / EPSG Arctic zone 4-40",
    6087: "WGS 84 / EPSG Arctic zone 5-15",
    6088: "WGS 84 / EPSG Arctic zone 5-17",
    6089: "WGS 84 / EPSG Arctic zone 5-19",
    6090: "WGS 84 / EPSG Arctic zone 5-21",
    6091: "WGS 84 / EPSG Arctic zone 5-23",
    6092: "WGS 84 / EPSG Arctic zone 5-25",
    6093: "WGS 84 / EPSG Arctic zone 5-27",
    6094: "NAD83(NSRS2007) / EPSG Arctic zone 5-29",
    6095: "NAD83(NSRS2007) / EPSG Arctic zone 5-31",
    6096: "NAD83(NSRS2007) / EPSG Arctic zone 6-14",
    6097: "NAD83(NSRS2007) / EPSG Arctic zone 6-16",
    6098: "NAD83(CSRS) / EPSG Arctic zone 1-23",
    6099: "NAD83(CSRS) / EPSG Arctic zone 2-14",
    6100: "NAD83(CSRS) / EPSG Arctic zone 2-16",
    6101: "NAD83(CSRS) / EPSG Arctic zone 3-25",
    6102: "NAD83(CSRS) / EPSG Arctic zone 3-27",
    6103: "NAD83(CSRS) / EPSG Arctic zone 3-29",
    6104: "NAD83(CSRS) / EPSG Arctic zone 4-14",
    6105: "NAD83(CSRS) / EPSG Arctic zone 4-16",
    6106: "NAD83(CSRS) / EPSG Arctic zone 4-18",
    6107: "NAD83(CSRS) / EPSG Arctic zone 5-33",
    6108: "NAD83(CSRS) / EPSG Arctic zone 5-35",
    6109: "NAD83(CSRS) / EPSG Arctic zone 5-37",
    6110: "NAD83(CSRS) / EPSG Arctic zone 5-39",
    6111: "NAD83(CSRS) / EPSG Arctic zone 6-18",
    6112: "NAD83(CSRS) / EPSG Arctic zone 6-20",
    6113: "NAD83(CSRS) / EPSG Arctic zone 6-22",
    6114: "NAD83(CSRS) / EPSG Arctic zone 6-24",
    6115: "WGS 84 / EPSG Arctic zone 1-27",
    6116: "WGS 84 / EPSG Arctic zone 1-29",
    6117: "WGS 84 / EPSG Arctic zone 1-31",
    6118: "WGS 84 / EPSG Arctic zone 1-21",
    6119: "WGS 84 / EPSG Arctic zone 2-28",
    6120: "WGS 84 / EPSG Arctic zone 2-10",
    6121: "WGS 84 / EPSG Arctic zone 2-12",
    6122: "WGS 84 / EPSG Arctic zone 3-21",
    6123: "WGS 84 / EPSG Arctic zone 3-23",
    6124: "WGS 84 / EPSG Arctic zone 4-12",
    6125: "ETRS89 / EPSG Arctic zone 5-47",
    6128: "Grand Cayman National Grid 1959",
    6129: "Sister Islands National Grid 1961",
    6141: "Cayman Islands National Grid 2011",
    6200: "NAD27 / Michigan North",
    6201: "NAD27 / Michigan Central",
    6202: "NAD27 / Michigan South",
    6204: "Macedonia State Coordinate System",
    6210: "SIRGAS 2000 / UTM zone 23N",
    6211: "SIRGAS 2000 / UTM zone 24N",
    6244: "MAGNA-SIRGAS / Arauca urban grid",
    6245: "MAGNA-SIRGAS / Armenia urban grid",
    6246: "MAGNA-SIRGAS / Barranquilla urban grid",
    6247: "MAGNA-SIRGAS / Bogota urban grid",
    6248: "MAGNA-SIRGAS / Bucaramanga urban grid",
    6249: "MAGNA-SIRGAS / Cali urban grid",
    6250: "MAGNA-SIRGAS / Cartagena urban grid",
    6251: "MAGNA-SIRGAS / Cucuta urban grid",
    6252: "MAGNA-SIRGAS / Florencia urban grid",
    6253: "MAGNA-SIRGAS / Ibague urban grid",
    6254: "MAGNA-SIRGAS / Inirida urban grid",
    6255: "MAGNA-SIRGAS / Leticia urban grid",
    6256: "MAGNA-SIRGAS / Manizales urban grid",
    6257: "MAGNA-SIRGAS / Medellin urban grid",
    6258: "MAGNA-SIRGAS / Mitu urban grid",
    6259: "MAGNA-SIRGAS / Mocoa urban grid",
    6260: "MAGNA-SIRGAS / Monteria urban grid",
    6261: "MAGNA-SIRGAS / Neiva urban grid",
    6262: "MAGNA-SIRGAS / Pasto urban grid",
    6263: "MAGNA-SIRGAS / Pereira urban grid",
    6264: "MAGNA-SIRGAS / Popayan urban grid",
    6265: "MAGNA-SIRGAS / Puerto Carreno urban grid",
    6266: "MAGNA-SIRGAS / Quibdo urban grid",
    6267: "MAGNA-SIRGAS / Riohacha urban grid",
    6268: "MAGNA-SIRGAS / San Andres urban grid",
    6269: "MAGNA-SIRGAS / San Jose del Guaviare urban grid",
    6270: "MAGNA-SIRGAS / Santa Marta urban grid",
    6271: "MAGNA-SIRGAS / Sucre urban grid",
    6272: "MAGNA-SIRGAS / Tunja urban grid",
    6273: "MAGNA-SIRGAS / Valledupar urban grid",
    6274: "MAGNA-SIRGAS / Villavicencio urban grid",
    6275: "MAGNA-SIRGAS / Yopal urban grid",
    6307: "NAD83(CORS96) / Puerto Rico and Virgin Is.",
    6312: "CGRS93 / Cyprus Local Transverse Mercator",
    6316: "Macedonia State Coordinate System zone 7",
    6328: "NAD83(2011) / UTM zone 59N",
    6329: "NAD83(2011) / UTM zone 60N",
    6330: "NAD83(2011) / UTM zone 1N",
    6331: "NAD83(2011) / UTM zone 2N",
    6332: "NAD83(2011) / UTM zone 3N",
    6333: "NAD83(2011) / UTM zone 4N",
    6334: "NAD83(2011) / UTM zone 5N",
    6335: "NAD83(2011) / UTM zone 6N",
    6336: "NAD83(2011) / UTM zone 7N",
    6337: "NAD83(2011) / UTM zone 8N",
    6338: "NAD83(2011) / UTM zone 9N",
    6339: "NAD83(2011) / UTM zone 10N",
    6340: "NAD83(2011) / UTM zone 11N",
    6341: "NAD83(2011) / UTM zone 12N",
    6342: "NAD83(2011) / UTM zone 13N",
    6343: "NAD83(2011) / UTM zone 14N",
    6344: "NAD83(2011) / UTM zone 15N",
    6345: "NAD83(2011) / UTM zone 16N",
    6346: "NAD83(2011) / UTM zone 17N",
    6347: "NAD83(2011) / UTM zone 18N",
    6348: "NAD83(2011) / UTM zone 19N",
    6350: "NAD83(2011) / Conus Albers",
    6351: "NAD83(2011) / EPSG Arctic zone 5-29",
    6352: "NAD83(2011) / EPSG Arctic zone 5-31",
    6353: "NAD83(2011) / EPSG Arctic zone 6-14",
    6354: "NAD83(2011) / EPSG Arctic zone 6-16",
    6355: "NAD83(2011) / Alabama East",
    6356: "NAD83(2011) / Alabama West",
    6362: "Mexico ITRF92 / LCC",
    6366: "Mexico ITRF2008 / UTM zone 11N",
    6367: "Mexico ITRF2008 / UTM zone 12N",
    6368: "Mexico ITRF2008 / UTM zone 13N",
    6369: "Mexico ITRF2008 / UTM zone 14N",
    6370: "Mexico ITRF2008 / UTM zone 15N",
    6371: "Mexico ITRF2008 / UTM zone 16N",
    6372: "Mexico ITRF2008 / LCC",
    6381: "UCS-2000 / Ukraine TM zone 7",
    6382: "UCS-2000 / Ukraine TM zone 8",
    6383: "UCS-2000 / Ukraine TM zone 9",
    6384: "UCS-2000 / Ukraine TM zone 10",
    6385: "UCS-2000 / Ukraine TM zone 11",
    6386: "UCS-2000 / Ukraine TM zone 12",
    6387: "UCS-2000 / Ukraine TM zone 13",
    6391: "Cayman Islands National Grid 2011",
    6393: "NAD83(2011) / Alaska Albers",
    6394: "NAD83(2011) / Alaska zone 1",
    6395: "NAD83(2011) / Alaska zone 2",
    6396: "NAD83(2011) / Alaska zone 3",
    6397: "NAD83(2011) / Alaska zone 4",
    6398: "NAD83(2011) / Alaska zone 5",
    6399: "NAD83(2011) / Alaska zone 6",
    6400: "NAD83(2011) / Alaska zone 7",
    6401: "NAD83(2011) / Alaska zone 8",
    6402: "NAD83(2011) / Alaska zone 9",
    6403: "NAD83(2011) / Alaska zone 10",
    6404: "NAD83(2011) / Arizona Central",
    6405: "NAD83(2011) / Arizona Central (ft)",
    6406: "NAD83(2011) / Arizona East",
    6407: "NAD83(2011) / Arizona East (ft)",
    6408: "NAD83(2011) / Arizona West",
    6409: "NAD83(2011) / Arizona West (ft)",
    6410: "NAD83(2011) / Arkansas North",
    6411: "NAD83(2011) / Arkansas North (ftUS)",
    6412: "NAD83(2011) / Arkansas South",
    6413: "NAD83(2011) / Arkansas South (ftUS)",
    6414: "NAD83(2011) / California Albers",
    6415: "NAD83(2011) / California zone 1",
    6416: "NAD83(2011) / California zone 1 (ftUS)",
    6417: "NAD83(2011) / California zone 2",
    6418: "NAD83(2011) / California zone 2 (ftUS)",
    6419: "NAD83(2011) / California zone 3",
    6420: "NAD83(2011) / California zone 3 (ftUS)",
    6421: "NAD83(2011) / California zone 4",
    6422: "NAD83(2011) / California zone 4 (ftUS)",
    6423: "NAD83(2011) / California zone 5",
    6424: "NAD83(2011) / California zone 5 (ftUS)",
    6425: "NAD83(2011) / California zone 6",
    6426: "NAD83(2011) / California zone 6 (ftUS)",
    6427: "NAD83(2011) / Colorado Central",
    6428: "NAD83(2011) / Colorado Central (ftUS)",
    6429: "NAD83(2011) / Colorado North",
    6430: "NAD83(2011) / Colorado North (ftUS)",
    6431: "NAD83(2011) / Colorado South",
    6432: "NAD83(2011) / Colorado South (ftUS)",
    6433: "NAD83(2011) / Connecticut",
    6434: "NAD83(2011) / Connecticut (ftUS)",
    6435: "NAD83(2011) / Delaware",
    6436: "NAD83(2011) / Delaware (ftUS)",
    6437: "NAD83(2011) / Florida East",
    6438: "NAD83(2011) / Florida East (ftUS)",
    6439: "NAD83(2011) / Florida GDL Albers",
    6440: "NAD83(2011) / Florida North",
    6441: "NAD83(2011) / Florida North (ftUS)",
    6442: "NAD83(2011) / Florida West",
    6443: "NAD83(2011) / Florida West (ftUS)",
    6444: "NAD83(2011) / Georgia East",
    6445: "NAD83(2011) / Georgia East (ftUS)",
    6446: "NAD83(2011) / Georgia West",
    6447: "NAD83(2011) / Georgia West (ftUS)",
    6448: "NAD83(2011) / Idaho Central",
    6449: "NAD83(2011) / Idaho Central (ftUS)",
    6450: "NAD83(2011) / Idaho East",
    6451: "NAD83(2011) / Idaho East (ftUS)",
    6452: "NAD83(2011) / Idaho West",
    6453: "NAD83(2011) / Idaho West (ftUS)",
    6454: "NAD83(2011) / Illinois East",
    6455: "NAD83(2011) / Illinois East (ftUS)",
    6456: "NAD83(2011) / Illinois West",
    6457: "NAD83(2011) / Illinois West (ftUS)",
    6458: "NAD83(2011) / Indiana East",
    6459: "NAD83(2011) / Indiana East (ftUS)",
    6460: "NAD83(2011) / Indiana West",
    6461: "NAD83(2011) / Indiana West (ftUS)",
    6462: "NAD83(2011) / Iowa North",
    6463: "NAD83(2011) / Iowa North (ftUS)",
    6464: "NAD83(2011) / Iowa South",
    6465: "NAD83(2011) / Iowa South (ftUS)",
    6466: "NAD83(2011) / Kansas North",
    6467: "NAD83(2011) / Kansas North (ftUS)",
    6468: "NAD83(2011) / Kansas South",
    6469: "NAD83(2011) / Kansas South (ftUS)",
    6470: "NAD83(2011) / Kentucky North",
    6471: "NAD83(2011) / Kentucky North (ftUS)",
    6472: "NAD83(2011) / Kentucky Single Zone",
    6473: "NAD83(2011) / Kentucky Single Zone (ftUS)",
    6474: "NAD83(2011) / Kentucky South",
    6475: "NAD83(2011) / Kentucky South (ftUS)",
    6476: "NAD83(2011) / Louisiana North",
    6477: "NAD83(2011) / Louisiana North (ftUS)",
    6478: "NAD83(2011) / Louisiana South",
    6479: "NAD83(2011) / Louisiana South (ftUS)",
    6480: "NAD83(2011) / Maine CS2000 Central",
    6481: "NAD83(2011) / Maine CS2000 East",
    6482: "NAD83(2011) / Maine CS2000 West",
    6483: "NAD83(2011) / Maine East",
    6484: "NAD83(2011) / Maine East (ftUS)",
    6485: "NAD83(2011) / Maine West",
    6486: "NAD83(2011) / Maine West (ftUS)",
    6487: "NAD83(2011) / Maryland",
    6488: "NAD83(2011) / Maryland (ftUS)",
    6489: "NAD83(2011) / Massachusetts Island",
    6490: "NAD83(2011) / Massachusetts Island (ftUS)",
    6491: "NAD83(2011) / Massachusetts Mainland",
    6492: "NAD83(2011) / Massachusetts Mainland (ftUS)",
    6493: "NAD83(2011) / Michigan Central",
    6494: "NAD83(2011) / Michigan Central (ft)",
    6495: "NAD83(2011) / Michigan North",
    6496: "NAD83(2011) / Michigan North (ft)",
    6497: "NAD83(2011) / Michigan Oblique Mercator",
    6498: "NAD83(2011) / Michigan South",
    6499: "NAD83(2011) / Michigan South (ft)",
    6500: "NAD83(2011) / Minnesota Central",
    6501: "NAD83(2011) / Minnesota Central (ftUS)",
    6502: "NAD83(2011) / Minnesota North",
    6503: "NAD83(2011) / Minnesota North (ftUS)",
    6504: "NAD83(2011) / Minnesota South",
    6505: "NAD83(2011) / Minnesota South (ftUS)",
    6506: "NAD83(2011) / Mississippi East",
    6507: "NAD83(2011) / Mississippi East (ftUS)",
    6508: "NAD83(2011) / Mississippi TM",
    6509: "NAD83(2011) / Mississippi West",
    6510: "NAD83(2011) / Mississippi West (ftUS)",
    6511: "NAD83(2011) / Missouri Central",
    6512: "NAD83(2011) / Missouri East",
    6513: "NAD83(2011) / Missouri West",
    6514: "NAD83(2011) / Montana",
    6515: "NAD83(2011) / Montana (ft)",
    6516: "NAD83(2011) / Nebraska",
    6517: "NAD83(2011) / Nebraska (ftUS)",
    6518: "NAD83(2011) / Nevada Central",
    6519: "NAD83(2011) / Nevada Central (ftUS)",
    6520: "NAD83(2011) / Nevada East",
    6521: "NAD83(2011) / Nevada East (ftUS)",
    6522: "NAD83(2011) / Nevada West",
    6523: "NAD83(2011) / Nevada West (ftUS)",
    6524: "NAD83(2011) / New Hampshire",
    6525: "NAD83(2011) / New Hampshire (ftUS)",
    6526: "NAD83(2011) / New Jersey",
    6527: "NAD83(2011) / New Jersey (ftUS)",
    6528: "NAD83(2011) / New Mexico Central",
    6529: "NAD83(2011) / New Mexico Central (ftUS)",
    6530: "NAD83(2011) / New Mexico East",
    6531: "NAD83(2011) / New Mexico East (ftUS)",
    6532: "NAD83(2011) / New Mexico West",
    6533: "NAD83(2011) / New Mexico West (ftUS)",
    6534: "NAD83(2011) / New York Central",
    6535: "NAD83(2011) / New York Central (ftUS)",
    6536: "NAD83(2011) / New York East",
    6537: "NAD83(2011) / New York East (ftUS)",
    6538: "NAD83(2011) / New York Long Island",
    6539: "NAD83(2011) / New York Long Island (ftUS)",
    6540: "NAD83(2011) / New York West",
    6541: "NAD83(2011) / New York West (ftUS)",
    6542: "NAD83(2011) / North Carolina",
    6543: "NAD83(2011) / North Carolina (ftUS)",
    6544: "NAD83(2011) / North Dakota North",
    6545: "NAD83(2011) / North Dakota North (ft)",
    6546: "NAD83(2011) / North Dakota South",
    6547: "NAD83(2011) / North Dakota South (ft)",
    6548: "NAD83(2011) / Ohio North",
    6549: "NAD83(2011) / Ohio North (ftUS)",
    6550: "NAD83(2011) / Ohio South",
    6551: "NAD83(2011) / Ohio South (ftUS)",
    6552: "NAD83(2011) / Oklahoma North",
    6553: "NAD83(2011) / Oklahoma North (ftUS)",
    6554: "NAD83(2011) / Oklahoma South",
    6555: "NAD83(2011) / Oklahoma South (ftUS)",
    6556: "NAD83(2011) / Oregon LCC (m)",
    6557: "NAD83(2011) / Oregon GIC Lambert (ft)",
    6558: "NAD83(2011) / Oregon North",
    6559: "NAD83(2011) / Oregon North (ft)",
    6560: "NAD83(2011) / Oregon South",
    6561: "NAD83(2011) / Oregon South (ft)",
    6562: "NAD83(2011) / Pennsylvania North",
    6563: "NAD83(2011) / Pennsylvania North (ftUS)",
    6564: "NAD83(2011) / Pennsylvania South",
    6565: "NAD83(2011) / Pennsylvania South (ftUS)",
    6566: "NAD83(2011) / Puerto Rico and Virgin Is.",
    6567: "NAD83(2011) / Rhode Island",
    6568: "NAD83(2011) / Rhode Island (ftUS)",
    6569: "NAD83(2011) / South Carolina",
    6570: "NAD83(2011) / South Carolina (ft)",
    6571: "NAD83(2011) / South Dakota North",
    6572: "NAD83(2011) / South Dakota North (ftUS)",
    6573: "NAD83(2011) / South Dakota South",
    6574: "NAD83(2011) / South Dakota South (ftUS)",
    6575: "NAD83(2011) / Tennessee",
    6576: "NAD83(2011) / Tennessee (ftUS)",
    6577: "NAD83(2011) / Texas Central",
    6578: "NAD83(2011) / Texas Central (ftUS)",
    6579: "NAD83(2011) / Texas Centric Albers Equal Area",
    6580: "NAD83(2011) / Texas Centric Lambert Conformal",
    6581: "NAD83(2011) / Texas North",
    6582: "NAD83(2011) / Texas North (ftUS)",
    6583: "NAD83(2011) / Texas North Central",
    6584: "NAD83(2011) / Texas North Central (ftUS)",
    6585: "NAD83(2011) / Texas South",
    6586: "NAD83(2011) / Texas South (ftUS)",
    6587: "NAD83(2011) / Texas South Central",
    6588: "NAD83(2011) / Texas South Central (ftUS)",
    6589: "NAD83(2011) / Vermont",
    6590: "NAD83(2011) / Vermont (ftUS)",
    6591: "NAD83(2011) / Virginia Lambert",
    6592: "NAD83(2011) / Virginia North",
    6593: "NAD83(2011) / Virginia North (ftUS)",
    6594: "NAD83(2011) / Virginia South",
    6595: "NAD83(2011) / Virginia South (ftUS)",
    6596: "NAD83(2011) / Washington North",
    6597: "NAD83(2011) / Washington North (ftUS)",
    6598: "NAD83(2011) / Washington South",
    6599: "NAD83(2011) / Washington South (ftUS)",
    6600: "NAD83(2011) / West Virginia North",
    6601: "NAD83(2011) / West Virginia North (ftUS)",
    6602: "NAD83(2011) / West Virginia South",
    6603: "NAD83(2011) / West Virginia South (ftUS)",
    6604: "NAD83(2011) / Wisconsin Central",
    6605: "NAD83(2011) / Wisconsin Central (ftUS)",
    6606: "NAD83(2011) / Wisconsin North",
    6607: "NAD83(2011) / Wisconsin North (ftUS)",
    6608: "NAD83(2011) / Wisconsin South",
    6609: "NAD83(2011) / Wisconsin South (ftUS)",
    6610: "NAD83(2011) / Wisconsin Transverse Mercator",
    6611: "NAD83(2011) / Wyoming East",
    6612: "NAD83(2011) / Wyoming East (ftUS)",
    6613: "NAD83(2011) / Wyoming East Central",
    6614: "NAD83(2011) / Wyoming East Central (ftUS)",
    6615: "NAD83(2011) / Wyoming West",
    6616: "NAD83(2011) / Wyoming West (ftUS)",
    6617: "NAD83(2011) / Wyoming West Central",
    6618: "NAD83(2011) / Wyoming West Central (ftUS)",
    6619: "NAD83(2011) / Utah Central",
    6620: "NAD83(2011) / Utah North",
    6621: "NAD83(2011) / Utah South",
    6622: "NAD83(CSRS) / Quebec Lambert",
    6623: "NAD83 / Quebec Albers",
    6624: "NAD83(CSRS) / Quebec Albers",
    6625: "NAD83(2011) / Utah Central (ftUS)",
    6626: "NAD83(2011) / Utah North (ftUS)",
    6627: "NAD83(2011) / Utah South (ftUS)",
    6628: "NAD83(PA11) / Hawaii zone 1",
    6629: "NAD83(PA11) / Hawaii zone 2",
    6630: "NAD83(PA11) / Hawaii zone 3",
    6631: "NAD83(PA11) / Hawaii zone 4",
    6632: "NAD83(PA11) / Hawaii zone 5",
    6633: "NAD83(PA11) / Hawaii zone 3 (ftUS)",
    6634: "NAD83(PA11) / UTM zone 4N",
    6635: "NAD83(PA11) / UTM zone 5N",
    6636: "NAD83(PA11) / UTM zone 2S",
    6637: "NAD83(MA11) / Guam Map Grid",
    6646: "Karbala 1979 / Iraq National Grid",
    6669: "JGD2011 / Japan Plane Rectangular CS I",
    6670: "JGD2011 / Japan Plane Rectangular CS II",
    6671: "JGD2011 / Japan Plane Rectangular CS III",
    6672: "JGD2011 / Japan Plane Rectangular CS IV",
    6673: "JGD2011 / Japan Plane Rectangular CS V",
    6674: "JGD2011 / Japan Plane Rectangular CS VI",
    6675: "JGD2011 / Japan Plane Rectangular CS VII",
    6676: "JGD2011 / Japan Plane Rectangular CS VIII",
    6677: "JGD2011 / Japan Plane Rectangular CS IX",
    6678: "JGD2011 / Japan Plane Rectangular CS X",
    6679: "JGD2011 / Japan Plane Rectangular CS XI",
    6680: "JGD2011 / Japan Plane Rectangular CS XII",
    6681: "JGD2011 / Japan Plane Rectangular CS XIII",
    6682: "JGD2011 / Japan Plane Rectangular CS XIV",
    6683: "JGD2011 / Japan Plane Rectangular CS XV",
    6684: "JGD2011 / Japan Plane Rectangular CS XVI",
    6685: "JGD2011 / Japan Plane Rectangular CS XVII",
    6686: "JGD2011 / Japan Plane Rectangular CS XVIII",
    6687: "JGD2011 / Japan Plane Rectangular CS XIX",
    6688: "JGD2011 / UTM zone 51N",
    6689: "JGD2011 / UTM zone 52N",
    6690: "JGD2011 / UTM zone 53N",
    6691: "JGD2011 / UTM zone 54N",
    6692: "JGD2011 / UTM zone 55N",
    6703: "WGS 84 / TM 60 SW",
    6707: "RDN2008 / TM32",
    6708: "RDN2008 / TM33",
    6709: "RDN2008 / TM34",
    6720: "WGS 84 / CIG92",
    6721: "GDA94 / CIG94",
    6722: "WGS 84 / CKIG92",
    6723: "GDA94 / CKIG94",
    6732: "GDA94 / MGA zone 41",
    6733: "GDA94 / MGA zone 42",
    6734: "GDA94 / MGA zone 43",
    6735: "GDA94 / MGA zone 44",
    6736: "GDA94 / MGA zone 46",
    6737: "GDA94 / MGA zone 47",
    6738: "GDA94 / MGA zone 59",
    6784: "NAD83(CORS96) / Oregon Baker zone (m)",
    6785: "NAD83(CORS96) / Oregon Baker zone (ft)",
    6786: "NAD83(2011) / Oregon Baker zone (m)",
    6787: "NAD83(2011) / Oregon Baker zone (ft)",
    6788: "NAD83(CORS96) / Oregon Bend-Klamath Falls zone (m)",
    6789: "NAD83(CORS96) / Oregon Bend-Klamath Falls zone (ft)",
    6790: "NAD83(2011) / Oregon Bend-Klamath Falls zone (m)",
    6791: "NAD83(2011) / Oregon Bend-Klamath Falls zone (ft)",
    6792: "NAD83(CORS96) / Oregon Bend-Redmond-Prineville zone (m)",
    6793: "NAD83(CORS96) / Oregon Bend-Redmond-Prineville zone (ft)",
    6794: "NAD83(2011) / Oregon Bend-Redmond-Prineville zone (m)",
    6795: "NAD83(2011) / Oregon Bend-Redmond-Prineville zone (ft)",
    6796: "NAD83(CORS96) / Oregon Bend-Burns zone (m)",
    6797: "NAD83(CORS96) / Oregon Bend-Burns zone (ft)",
    6798: "NAD83(2011) / Oregon Bend-Burns zone (m)",
    6799: "NAD83(2011) / Oregon Bend-Burns zone (ft)",
    6800: "NAD83(CORS96) / Oregon Canyonville-Grants Pass zone (m)",
    6801: "NAD83(CORS96) / Oregon Canyonville-Grants Pass zone (ft)",
    6802: "NAD83(2011) / Oregon Canyonville-Grants Pass zone (m)",
    6803: "NAD83(2011) / Oregon Canyonville-Grants Pass zone (ft)",
    6804: "NAD83(CORS96) / Oregon Columbia River East zone (m)",
    6805: "NAD83(CORS96) / Oregon Columbia River East zone (ft)",
    6806: "NAD83(2011) / Oregon Columbia River East zone (m)",
    6807: "NAD83(2011) / Oregon Columbia River East zone (ft)",
    6808: "NAD83(CORS96) / Oregon Columbia River West zone (m)",
    6809: "NAD83(CORS96) / Oregon Columbia River West zone (ft)",
    6810: "NAD83(2011) / Oregon Columbia River West zone (m)",
    6811: "NAD83(2011) / Oregon Columbia River West zone (ft)",
    6812: "NAD83(CORS96) / Oregon Cottage Grove-Canyonville zone (m)",
    6813: "NAD83(CORS96) / Oregon Cottage Grove-Canyonville zone (ft)",
    6814: "NAD83(2011) / Oregon Cottage Grove-Canyonville zone (m)",
    6815: "NAD83(2011) / Oregon Cottage Grove-Canyonville zone (ft)",
    6816: "NAD83(CORS96) / Oregon Dufur-Madras zone (m)",
    6817: "NAD83(CORS96) / Oregon Dufur-Madras zone (ft)",
    6818: "NAD83(2011) / Oregon Dufur-Madras zone (m)",
    6819: "NAD83(2011) / Oregon Dufur-Madras zone (ft)",
    6820: "NAD83(CORS96) / Oregon Eugene zone (m)",
    6821: "NAD83(CORS96) / Oregon Eugene zone (ft)",
    6822: "NAD83(2011) / Oregon Eugene zone (m)",
    6823: "NAD83(2011) / Oregon Eugene zone (ft)",
    6824: "NAD83(CORS96) / Oregon Grants Pass-Ashland zone (m)",
    6825: "NAD83(CORS96) / Oregon Grants Pass-Ashland zone (ft)",
    6826: "NAD83(2011) / Oregon Grants Pass-Ashland zone (m)",
    6827: "NAD83(2011) / Oregon Grants Pass-Ashland zone (ft)",
    6828: "NAD83(CORS96) / Oregon Gresham-Warm Springs zone (m)",
    6829: "NAD83(CORS96) / Oregon Gresham-Warm Springs zone (ft)",
    6830: "NAD83(2011) / Oregon Gresham-Warm Springs zone (m)",
    6831: "NAD83(2011) / Oregon Gresham-Warm Springs zone (ft)",
    6832: "NAD83(CORS96) / Oregon La Grande zone (m)",
    6833: "NAD83(CORS96) / Oregon La Grande zone (ft)",
    6834: "NAD83(2011) / Oregon La Grande zone (m)",
    6835: "NAD83(2011) / Oregon La Grande zone (ft)",
    6836: "NAD83(CORS96) / Oregon Ontario zone (m)",
    6837: "NAD83(CORS96) / Oregon Ontario zone (ft)",
    6838: "NAD83(2011) / Oregon Ontario zone (m)",
    6839: "NAD83(2011) / Oregon Ontario zone (ft)",
    6840: "NAD83(CORS96) / Oregon Coast zone (m)",
    6841: "NAD83(CORS96) / Oregon Coast zone (ft)",
    6842: "NAD83(2011) / Oregon Coast zone (m)",
    6843: "NAD83(2011) / Oregon Coast zone (ft)",
    6844: "NAD83(CORS96) / Oregon Pendleton zone (m)",
    6845: "NAD83(CORS96) / Oregon Pendleton zone (ft)",
    6846: "NAD83(2011) / Oregon Pendleton zone (m)",
    6847: "NAD83(2011) / Oregon Pendleton zone (ft)",
    6848: "NAD83(CORS96) / Oregon Pendleton-La Grande zone (m)",
    6849: "NAD83(CORS96) / Oregon Pendleton-La Grande zone (ft)",
    6850: "NAD83(2011) / Oregon Pendleton-La Grande zone (m)",
    6851: "NAD83(2011) / Oregon Pendleton-La Grande zone (ft)",
    6852: "NAD83(CORS96) / Oregon Portland zone (m)",
    6853: "NAD83(CORS96) / Oregon Portland zone (ft)",
    6854: "NAD83(2011) / Oregon Portland zone (m)",
    6855: "NAD83(2011) / Oregon Portland zone (ft)",
    6856: "NAD83(CORS96) / Oregon Salem zone (m)",
    6857: "NAD83(CORS96) / Oregon Salem zone (ft)",
    6858: "NAD83(2011) / Oregon Salem zone (m)",
    6859: "NAD83(2011) / Oregon Salem zone (ft)",
    6860: "NAD83(CORS96) / Oregon Santiam Pass zone (m)",
    6861: "NAD83(CORS96) / Oregon Santiam Pass zone (ft)",
    6862: "NAD83(2011) / Oregon Santiam Pass zone (m)",
    6863: "NAD83(2011) / Oregon Santiam Pass (ft)",
    6867: "NAD83(CORS96) / Oregon LCC (m)",
    6868: "NAD83(CORS96) / Oregon GIC Lambert (ft)",
    6870: "ETRS89 / Albania TM 2010",
    6875: "RDN2008 / Italy zone",
    6876: "RDN2008 / Zone 12",
    6879: "NAD83(2011) / Wisconsin Central",
    6880: "NAD83(2011) / Nebraska (ftUS)",
    6884: "NAD83(CORS96) / Oregon North",
    6885: "NAD83(CORS96) / Oregon North (ft)",
    6886: "NAD83(CORS96) / Oregon South",
    6887: "NAD83(CORS96) / Oregon South (ft)",
    6915: "South East Island 1943 / UTM zone 40N",
    6922: "NAD83 / Kansas LCC",
    6923: "NAD83 / Kansas LCC (ftUS)",
    6924: "NAD83(2011) / Kansas LCC",
    6925: "NAD83(2011) / Kansas LCC (ftUS)",
    6931: "WGS 84 / NSIDC EASE-Grid 2.0 North",
    6932: "WGS 84 / NSIDC EASE-Grid 2.0 South",
    6933: "WGS 84 / NSIDC EASE-Grid 2.0 Global",
    6956: "VN-2000 / TM-3 zone 481",
    6957: "VN-2000 / TM-3 zone 482",
    6958: "VN-2000 / TM-3 zone 491",
    6959: "VN-2000 / TM-3 Da Nang zone",
    6962: "ETRS89 / Albania LCC 2010",
    6966: "NAD27 / Michigan North",
    6984: "Israeli Grid 05",
    6991: "Israeli Grid 05/12",
    6996: "NAD83(2011) / San Francisco CS13",
    6997: "NAD83(2011) / San Francisco CS13 (ftUS)",
    7005: "Nahrwan 1934 / UTM zone 37N",
    7006: "Nahrwan 1934 / UTM zone 38N",
    7007: "Nahrwan 1934 / UTM zone 39N",
    7057: "NAD83(2011) / IaRCS zone 1",
    7058: "NAD83(2011) / IaRCS zone 2",
    7059: "NAD83(2011) / IaRCS zone 3",
    7060: "NAD83(2011) / IaRCS zone 4",
    7061: "NAD83(2011) / IaRCS zone 5",
    7062: "NAD83(2011) / IaRCS zone 6",
    7063: "NAD83(2011) / IaRCS zone 7",
    7064: "NAD83(2011) / IaRCS zone 8",
    7065: "NAD83(2011) / IaRCS zone 9",
    7066: "NAD83(2011) / IaRCS zone 10",
    7067: "NAD83(2011) / IaRCS zone 11",
    7068: "NAD83(2011) / IaRCS zone 12",
    7069: "NAD83(2011) / IaRCS zone 13",
    7070: "NAD83(2011) / IaRCS zone 14",
    7074: "RGTAAF07 / UTM zone 37S",
    7075: "RGTAAF07 / UTM zone 38S",
    7076: "RGTAAF07 / UTM zone 39S",
    7077: "RGTAAF07 / UTM zone 40S",
    7078: "RGTAAF07 / UTM zone 41S",
    7079: "RGTAAF07 / UTM zone 42S",
    7080: "RGTAAF07 / UTM zone 43S",
    7081: "RGTAAF07 / UTM zone 44S",
    7082: "RGTAAF07 / Terre Adelie Polar Stereographic",
    7109: "NAD83(2011) / RMTCRS St Mary (m)",
    7110: "NAD83(2011) / RMTCRS Blackfeet (m)",
    7111: "NAD83(2011) / RMTCRS Milk River (m)",
    7112: "NAD83(2011) / RMTCRS Fort Belknap (m)",
    7113: "NAD83(2011) / RMTCRS Fort Peck Assiniboine (m)",
    7114: "NAD83(2011) / RMTCRS Fort Peck Sioux (m)",
    7115: "NAD83(2011) / RMTCRS Crow (m)",
    7116: "NAD83(2011) / RMTCRS Bobcat (m)",
    7117: "NAD83(2011) / RMTCRS Billings (m)",
    7118: "NAD83(2011) / RMTCRS Wind River (m)",
    7119: "NAD83(2011) / RMTCRS St Mary (ft)",
    7120: "NAD83(2011) / RMTCRS Blackfeet (ft)",
    7121: "NAD83(2011) / RMTCRS Milk River (ft)",
    7122: "NAD83(2011) / RMTCRS Fort Belknap (ft)",
    7123: "NAD83(2011) / RMTCRS Fort Peck Assiniboine (ft)",
    7124: "NAD83(2011) / RMTCRS Fort Peck Sioux (ft)",
    7125: "NAD83(2011) / RMTCRS Crow (ft)",
    7126: "NAD83(2011) / RMTCRS Bobcat (ft)",
    7127: "NAD83(2011) / RMTCRS Billings (ft)",
    7128: "NAD83(2011) / RMTCRS Wind River (ftUS)",
    7131: "NAD83(2011) / San Francisco CS13",
    7132: "NAD83(2011) / San Francisco CS13 (ftUS)",
    7142: "Palestine 1923 / Palestine Grid modified",
    7257: "NAD83(2011) / InGCS Adams (m)",
    7258: "NAD83(2011) / InGCS Adams (ftUS)",
    7259: "NAD83(2011) / InGCS Allen (m)",
    7260: "NAD83(2011) / InGCS Allen (ftUS)",
    7261: "NAD83(2011) / InGCS Bartholomew (m)",
    7262: "NAD83(2011) / InGCS Bartholomew (ftUS)",
    7263: "NAD83(2011) / InGCS Benton (m)",
    7264: "NAD83(2011) / InGCS Benton (ftUS)",
    7265: "NAD83(2011) / InGCS Blackford-Delaware (m)",
    7266: "NAD83(2011) / InGCS Blackford-Delaware (ftUS)",
    7267: "NAD83(2011) / InGCS Boone-Hendricks (m)",
    7268: "NAD83(2011) / InGCS Boone-Hendricks (ftUS)",
    7269: "NAD83(2011) / InGCS Brown (m)",
    7270: "NAD83(2011) / InGCS Brown (ftUS)",
    7271: "NAD83(2011) / InGCS Carroll (m)",
    7272: "NAD83(2011) / InGCS Carroll (ftUS)",
    7273: "NAD83(2011) / InGCS Cass (m)",
    7274: "NAD83(2011) / InGCS Cass (ftUS)",
    7275: "NAD83(2011) / InGCS Clark-Floyd-Scott (m)",
    7276: "NAD83(2011) / InGCS Clark-Floyd-Scott (ftUS)",
    7277: "NAD83(2011) / InGCS Clay (m)",
    7278: "NAD83(2011) / InGCS Clay (ftUS)",
    7279: "NAD83(2011) / InGCS Clinton (m)",
    7280: "NAD83(2011) / InGCS Clinton (ftUS)",
    7281: "NAD83(2011) / InGCS Crawford-Lawrence-Orange (m)",
    7282: "NAD83(2011) / InGCS Crawford-Lawrence-Orange (ftUS)",
    7283: "NAD83(2011) / InGCS Daviess-Greene (m)",
    7284: "NAD83(2011) / InGCS Daviess-Greene (ftUS)",
    7285: "NAD83(2011) / InGCS Dearborn-Ohio-Switzerland (m)",
    7286: "NAD83(2011) / InGCS Dearborn-Ohio-Switzerland (ftUS)",
    7287: "NAD83(2011) / InGCS Decatur-Rush (m)",
    7288: "NAD83(2011) / InGCS Decatur-Rush (ftUS)",
    7289: "NAD83(2011) / InGCS DeKalb (m)",
    7290: "NAD83(2011) / InGCS DeKalb (ftUS)",
    7291: "NAD83(2011) / InGCS Dubois-Martin (m)",
    7292: "NAD83(2011) / InGCS Dubois-Martin (ftUS)",
    7293: "NAD83(2011) / InGCS Elkhart-Kosciusko-Wabash (m)",
    7294: "NAD83(2011) / InGCS Elkhart-Kosciusko-Wabash (ftUS)",
    7295: "NAD83(2011) / InGCS Fayette-Franklin-Union (m)",
    7296: "NAD83(2011) / InGCS Fayette-Franklin-Union (ftUS)",
    7297: "NAD83(2011) / InGCS Fountain-Warren (m)",
    7298: "NAD83(2011) / InGCS Fountain-Warren (ftUS)",
    7299: "NAD83(2011) / InGCS Fulton-Marshall-St. Joseph (m)",
    7300: "NAD83(2011) / InGCS Fulton-Marshall-St. Joseph (ftUS)",
    7301: "NAD83(2011) / InGCS Gibson (m)",
    7302: "NAD83(2011) / InGCS Gibson (ftUS)",
    7303: "NAD83(2011) / InGCS Grant (m)",
    7304: "NAD83(2011) / InGCS Grant (ftUS)",
    7305: "NAD83(2011) / InGCS Hamilton-Tipton (m)",
    7306: "NAD83(2011) / InGCS Hamilton-Tipton (ftUS)",
    7307: "NAD83(2011) / InGCS Hancock-Madison (m)",
    7308: "NAD83(2011) / InGCS Hancock-Madison (ftUS)",
    7309: "NAD83(2011) / InGCS Harrison-Washington (m)",
    7310: "NAD83(2011) / InGCS Harrison-Washington (ftUS)",
    7311: "NAD83(2011) / InGCS Henry (m)",
    7312: "NAD83(2011) / InGCS Henry (ftUS)",
    7313: "NAD83(2011) / InGCS Howard-Miami (m)",
    7314: "NAD83(2011) / InGCS Howard-Miami (ftUS)",
    7315: "NAD83(2011) / InGCS Huntington-Whitley (m)",
    7316: "NAD83(2011) / InGCS Huntington-Whitley (ftUS)",
    7317: "NAD83(2011) / InGCS Jackson (m)",
    7318: "NAD83(2011) / InGCS Jackson (ftUS)",
    7319: "NAD83(2011) / InGCS Jasper-Porter (m)",
    7320: "NAD83(2011) / InGCS Jasper-Porter (ftUS)",
    7321: "NAD83(2011) / InGCS Jay (m)",
    7322: "NAD83(2011) / InGCS Jay (ftUS)",
    7323: "NAD83(2011) / InGCS Jefferson (m)",
    7324: "NAD83(2011) / InGCS Jefferson (ftUS)",
    7325: "NAD83(2011) / InGCS Jennings (m)",
    7326: "NAD83(2011) / InGCS Jennings (ftUS)",
    7327: "NAD83(2011) / InGCS Johnson-Marion (m)",
    7328: "NAD83(2011) / InGCS Johnson-Marion (ftUS)",
    7329: "NAD83(2011) / InGCS Knox (m)",
    7330: "NAD83(2011) / InGCS Knox (ftUS)",
    7331: "NAD83(2011) / InGCS LaGrange-Noble (m)",
    7332: "NAD83(2011) / InGCS LaGrange-Noble (ftUS)",
    7333: "NAD83(2011) / InGCS Lake-Newton (m)",
    7334: "NAD83(2011) / InGCS Lake-Newton (ftUS)",
    7335: "NAD83(2011) / InGCS LaPorte-Pulaski-Starke (m)",
    7336: "NAD83(2011) / InGCS LaPorte-Pulaski-Starke (ftUS)",
    7337: "NAD83(2011) / InGCS Monroe-Morgan (m)",
    7338: "NAD83(2011) / InGCS Monroe-Morgan (ftUS)",
    7339: "NAD83(2011) / InGCS Montgomery-Putnam (m)",
    7340: "NAD83(2011) / InGCS Montgomery-Putnam (ftUS)",
    7341: "NAD83(2011) / InGCS Owen (m)",
    7342: "NAD83(2011) / InGCS Owen (ftUS)",
    7343: "NAD83(2011) / InGCS Parke-Vermillion (m)",
    7344: "NAD83(2011) / InGCS Parke-Vermillion (ftUS)",
    7345: "NAD83(2011) / InGCS Perry (m)",
    7346: "NAD83(2011) / InGCS Perry (ftUS)",
    7347: "NAD83(2011) / InGCS Pike-Warrick (m)",
    7348: "NAD83(2011) / InGCS Pike-Warrick (ftUS)",
    7349: "NAD83(2011) / InGCS Posey (m)",
    7350: "NAD83(2011) / InGCS Posey (ftUS)",
    7351: "NAD83(2011) / InGCS Randolph-Wayne (m)",
    7352: "NAD83(2011) / InGCS Randolph-Wayne (ftUS)",
    7353: "NAD83(2011) / InGCS Ripley (m)",
    7354: "NAD83(2011) / InGCS Ripley (ftUS)",
    7355: "NAD83(2011) / InGCS Shelby (m)",
    7356: "NAD83(2011) / InGCS Shelby (ftUS)",
    7357: "NAD83(2011) / InGCS Spencer (m)",
    7358: "NAD83(2011) / InGCS Spencer (ftUS)",
    7359: "NAD83(2011) / InGCS Steuben (m)",
    7360: "NAD83(2011) / InGCS Steuben (ftUS)",
    7361: "NAD83(2011) / InGCS Sullivan (m)",
    7362: "NAD83(2011) / InGCS Sullivan (ftUS)",
    7363: "NAD83(2011) / InGCS Tippecanoe-White (m)",
    7364: "NAD83(2011) / InGCS Tippecanoe-White (ftUS)",
    7365: "NAD83(2011) / InGCS Vanderburgh (m)",
    7366: "NAD83(2011) / InGCS Vanderburgh (ftUS)",
    7367: "NAD83(2011) / InGCS Vigo (m)",
    7368: "NAD83(2011) / InGCS Vigo (ftUS)",
    7369: "NAD83(2011) / InGCS Wells (m)",
    7370: "NAD83(2011) / InGCS Wells (ftUS)",
    7374: "ONGD14 / UTM zone 39N",
    7375: "ONGD14 / UTM zone 40N",
    7376: "ONGD14 / UTM zone 41N",
    7528: "NAD83(2011) / WISCRS Adams and Juneau (m)",
    7529: "NAD83(2011) / WISCRS Ashland (m)",
    7530: "NAD83(2011) / WISCRS Barron (m)",
    7531: "NAD83(2011) / WISCRS Bayfield (m)",
    7532: "NAD83(2011) / WISCRS Brown (m)",
    7533: "NAD83(2011) / WISCRS Buffalo (m)",
    7534: "NAD83(2011) / WISCRS Burnett (m)",
    7535: "NAD83(2011) / WISCRS Calumet, Fond du Lac, Outagamie and Winnebago (m)",
    7536: "NAD83(2011) / WISCRS Chippewa (m)",
    7537: "NAD83(2011) / WISCRS Clark (m)",
    7538: "NAD83(2011) / WISCRS Columbia (m)",
    7539: "NAD83(2011) / WISCRS Crawford (m)",
    7540: "NAD83(2011) / WISCRS Dane (m)",
    7541: "NAD83(2011) / WISCRS Dodge and Jefferson (m)",
    7542: "NAD83(2011) / WISCRS Door (m)",
    7543: "NAD83(2011) / WISCRS Douglas (m)",
    7544: "NAD83(2011) / WISCRS Dunn (m)",
    7545: "NAD83(2011) / WISCRS Eau Claire (m)",
    7546: "NAD83(2011) / WISCRS Florence (m)",
    7547: "NAD83(2011) / WISCRS Forest (m)",
    7548: "NAD83(2011) / WISCRS Grant (m)",
    7549: "NAD83(2011) / WISCRS Green and Lafayette (m)",
    7550: "NAD83(2011) / WISCRS Green Lake and Marquette (m)",
    7551: "NAD83(2011) / WISCRS Iowa (m)",
    7552: "NAD83(2011) / WISCRS Iron (m)",
    7553: "NAD83(2011) / WISCRS Jackson (m)",
    7554: "NAD83(2011) / WISCRS Kenosha, Milwaukee, Ozaukee and Racine (m)",
    7555: "NAD83(2011) / WISCRS Kewaunee, Manitowoc and Sheboygan (m)",
    7556: "NAD83(2011) / WISCRS La Crosse (m)",
    7557: "NAD83(2011) / WISCRS Langlade (m)",
    7558: "NAD83(2011) / WISCRS Lincoln (m)",
    7559: "NAD83(2011) / WISCRS Marathon (m)",
    7560: "NAD83(2011) / WISCRS Marinette (m)",
    7561: "NAD83(2011) / WISCRS Menominee (m)",
    7562: "NAD83(2011) / WISCRS Monroe (m)",
    7563: "NAD83(2011) / WISCRS Oconto (m)",
    7564: "NAD83(2011) / WISCRS Oneida (m)",
    7565: "NAD83(2011) / WISCRS Pepin and Pierce (m)",
    7566: "NAD83(2011) / WISCRS Polk (m)",
    7567: "NAD83(2011) / WISCRS Portage (m)",
    7568: "NAD83(2011) / WISCRS Price (m)",
    7569: "NAD83(2011) / WISCRS Richland (m)",
    7570: "NAD83(2011) / WISCRS Rock (m)",
    7571: "NAD83(2011) / WISCRS Rusk (m)",
    7572: "NAD83(2011) / WISCRS Sauk (m)",
    7573: "NAD83(2011) / WISCRS Sawyer (m)",
    7574: "NAD83(2011) / WISCRS Shawano (m)",
    7575: "NAD83(2011) / WISCRS St. Croix (m)",
    7576: "NAD83(2011) / WISCRS Taylor (m)",
    7577: "NAD83(2011) / WISCRS Trempealeau (m)",
    7578: "NAD83(2011) / WISCRS Vernon (m)",
    7579: "NAD83(2011) / WISCRS Vilas (m)",
    7580: "NAD83(2011) / WISCRS Walworth (m)",
    7581: "NAD83(2011) / WISCRS Washburn (m)",
    7582: "NAD83(2011) / WISCRS Washington (m)",
    7583: "NAD83(2011) / WISCRS Waukesha (m)",
    7584: "NAD83(2011) / WISCRS Waupaca (m)",
    7585: "NAD83(2011) / WISCRS Waushara (m)",
    7586: "NAD83(2011) / WISCRS Wood (m)",
    7587: "NAD83(2011) / WISCRS Adams and Juneau (ftUS)",
    7588: "NAD83(2011) / WISCRS Ashland (ftUS)",
    7589: "NAD83(2011) / WISCRS Barron (ftUS)",
    7590: "NAD83(2011) / WISCRS Bayfield (ftUS)",
    7591: "NAD83(2011) / WISCRS Brown (ftUS)",
    7592: "NAD83(2011) / WISCRS Buffalo (ftUS)",
    7593: "NAD83(2011) / WISCRS Burnett (ftUS)",
    7594: "NAD83(2011) / WISCRS Calumet, Fond du Lac, Outagamie and Winnebago (ftUS)",
    7595: "NAD83(2011) / WISCRS Chippewa (ftUS)",
    7596: "NAD83(2011) / WISCRS Clark (ftUS)",
    7597: "NAD83(2011) / WISCRS Columbia (ftUS)",
    7598: "NAD83(2011) / WISCRS Crawford (ftUS)",
    7599: "NAD83(2011) / WISCRS Dane (ftUS)",
    7600: "NAD83(2011) / WISCRS Dodge and Jefferson (ftUS)",
    7601: "NAD83(2011) / WISCRS Door (ftUS)",
    7602: "NAD83(2011) / WISCRS Douglas (ftUS)",
    7603: "NAD83(2011) / WISCRS Dunn (ftUS)",
    7604: "NAD83(2011) / WISCRS Eau Claire (ftUS)",
    7605: "NAD83(2011) / WISCRS Florence (ftUS)",
    7606: "NAD83(2011) / WISCRS Forest (ftUS)",
    7607: "NAD83(2011) / WISCRS Grant (ftUS)",
    7608: "NAD83(2011) / WISCRS Green and Lafayette (ftUS)",
    7609: "NAD83(2011) / WISCRS Green Lake and Marquette (ftUS)",
    7610: "NAD83(2011) / WISCRS Iowa (ftUS)",
    7611: "NAD83(2011) / WISCRS Iron (ftUS)",
    7612: "NAD83(2011) / WISCRS Jackson (ftUS)",
    7613: "NAD83(2011) / WISCRS Kenosha, Milwaukee, Ozaukee and Racine (ftUS)",
    7614: "NAD83(2011) / WISCRS Kewaunee, Manitowoc and Sheboygan (ftUS)",
    7615: "NAD83(2011) / WISCRS La Crosse (ftUS)",
    7616: "NAD83(2011) / WISCRS Langlade (ftUS)",
    7617: "NAD83(2011) / WISCRS Lincoln (ftUS)",
    7618: "NAD83(2011) / WISCRS Marathon (ftUS)",
    7619: "NAD83(2011) / WISCRS Marinette (ftUS)",
    7620: "NAD83(2011) / WISCRS Menominee (ftUS)",
    7621: "NAD83(2011) / WISCRS Monroe (ftUS)",
    7622: "NAD83(2011) / WISCRS Oconto (ftUS)",
    7623: "NAD83(2011) / WISCRS Oneida (ftUS)",
    7624: "NAD83(2011) / WISCRS Pepin and Pierce (ftUS)",
    7625: "NAD83(2011) / WISCRS Polk (ftUS)",
    7626: "NAD83(2011) / WISCRS Portage (ftUS)",
    7627: "NAD83(2011) / WISCRS Price (ftUS)",
    7628: "NAD83(2011) / WISCRS Richland (ftUS)",
    7629: "NAD83(2011) / WISCRS Rock (ftUS)",
    7630: "NAD83(2011) / WISCRS Rusk (ftUS)",
    7631: "NAD83(2011) / WISCRS Sauk (ftUS)",
    7632: "NAD83(2011) / WISCRS Sawyer (ftUS)",
    7633: "NAD83(2011) / WISCRS Shawano (ftUS)",
    7634: "NAD83(2011) / WISCRS St. Croix (ftUS)",
    7635: "NAD83(2011) / WISCRS Taylor (ftUS)",
    7636: "NAD83(2011) / WISCRS Trempealeau (ftUS)",
    7637: "NAD83(2011) / WISCRS Vernon (ftUS)",
    7638: "NAD83(2011) / WISCRS Vilas (ftUS)",
    7639: "NAD83(2011) / WISCRS Walworth (ftUS)",
    7640: "NAD83(2011) / WISCRS Washburn (ftUS)",
    7641: "NAD83(2011) / WISCRS Washington (ftUS)",
    7642: "NAD83(2011) / WISCRS Waukesha (ftUS)",
    7643: "NAD83(2011) / WISCRS Waupaca (ftUS)",
    7644: "NAD83(2011) / WISCRS Waushara (ftUS)",
    7645: "NAD83(2011) / WISCRS Wood (ftUS)",
    7692: "Kyrg-06 / zone 1",
    7693: "Kyrg-06 / zone 2",
    7694: "Kyrg-06 / zone 3",
    7695: "Kyrg-06 / zone 4",
    7696: "Kyrg-06 / zone 5",
    20004: "Pulkovo 1995 / Gauss-Kruger zone 4",
    20005: "Pulkovo 1995 / Gauss-Kruger zone 5",
    20006: "Pulkovo 1995 / Gauss-Kruger zone 6",
    20007: "Pulkovo 1995 / Gauss-Kruger zone 7",
    20008: "Pulkovo 1995 / Gauss-Kruger zone 8",
    20009: "Pulkovo 1995 / Gauss-Kruger zone 9",
    20010: "Pulkovo 1995 / Gauss-Kruger zone 10",
    20011: "Pulkovo 1995 / Gauss-Kruger zone 11",
    20012: "Pulkovo 1995 / Gauss-Kruger zone 12",
    20013: "Pulkovo 1995 / Gauss-Kruger zone 13",
    20014: "Pulkovo 1995 / Gauss-Kruger zone 14",
    20015: "Pulkovo 1995 / Gauss-Kruger zone 15",
    20016: "Pulkovo 1995 / Gauss-Kruger zone 16",
    20017: "Pulkovo 1995 / Gauss-Kruger zone 17",
    20018: "Pulkovo 1995 / Gauss-Kruger zone 18",
    20019: "Pulkovo 1995 / Gauss-Kruger zone 19",
    20020: "Pulkovo 1995 / Gauss-Kruger zone 20",
    20021: "Pulkovo 1995 / Gauss-Kruger zone 21",
    20022: "Pulkovo 1995 / Gauss-Kruger zone 22",
    20023: "Pulkovo 1995 / Gauss-Kruger zone 23",
    20024: "Pulkovo 1995 / Gauss-Kruger zone 24",
    20025: "Pulkovo 1995 / Gauss-Kruger zone 25",
    20026: "Pulkovo 1995 / Gauss-Kruger zone 26",
    20027: "Pulkovo 1995 / Gauss-Kruger zone 27",
    20028: "Pulkovo 1995 / Gauss-Kruger zone 28",
    20029: "Pulkovo 1995 / Gauss-Kruger zone 29",
    20030: "Pulkovo 1995 / Gauss-Kruger zone 30",
    20031: "Pulkovo 1995 / Gauss-Kruger zone 31",
    20032: "Pulkovo 1995 / Gauss-Kruger zone 32",
    20064: "Pulkovo 1995 / Gauss-Kruger 4N",
    20065: "Pulkovo 1995 / Gauss-Kruger 5N",
    20066: "Pulkovo 1995 / Gauss-Kruger 6N",
    20067: "Pulkovo 1995 / Gauss-Kruger 7N",
    20068: "Pulkovo 1995 / Gauss-Kruger 8N",
    20069: "Pulkovo 1995 / Gauss-Kruger 9N",
    20070: "Pulkovo 1995 / Gauss-Kruger 10N",
    20071: "Pulkovo 1995 / Gauss-Kruger 11N",
    20072: "Pulkovo 1995 / Gauss-Kruger 12N",
    20073: "Pulkovo 1995 / Gauss-Kruger 13N",
    20074: "Pulkovo 1995 / Gauss-Kruger 14N",
    20075: "Pulkovo 1995 / Gauss-Kruger 15N",
    20076: "Pulkovo 1995 / Gauss-Kruger 16N",
    20077: "Pulkovo 1995 / Gauss-Kruger 17N",
    20078: "Pulkovo 1995 / Gauss-Kruger 18N",
    20079: "Pulkovo 1995 / Gauss-Kruger 19N",
    20080: "Pulkovo 1995 / Gauss-Kruger 20N",
    20081: "Pulkovo 1995 / Gauss-Kruger 21N",
    20082: "Pulkovo 1995 / Gauss-Kruger 22N",
    20083: "Pulkovo 1995 / Gauss-Kruger 23N",
    20084: "Pulkovo 1995 / Gauss-Kruger 24N",
    20085: "Pulkovo 1995 / Gauss-Kruger 25N",
    20086: "Pulkovo 1995 / Gauss-Kruger 26N",
    20087: "Pulkovo 1995 / Gauss-Kruger 27N",
    20088: "Pulkovo 1995 / Gauss-Kruger 28N",
    20089: "Pulkovo 1995 / Gauss-Kruger 29N",
    20090: "Pulkovo 1995 / Gauss-Kruger 30N",
    20091: "Pulkovo 1995 / Gauss-Kruger 31N",
    20092: "Pulkovo 1995 / Gauss-Kruger 32N",
    20135: "Adindan / UTM zone 35N",
    20136: "Adindan / UTM zone 36N",
    20137: "Adindan / UTM zone 37N",
    20138: "Adindan / UTM zone 38N",
    20248: "AGD66 / AMG zone 48",
    20249: "AGD66 / AMG zone 49",
    20250: "AGD66 / AMG zone 50",
    20251: "AGD66 / AMG zone 51",
    20252: "AGD66 / AMG zone 52",
    20253: "AGD66 / AMG zone 53",
    20254: "AGD66 / AMG zone 54",
    20255: "AGD66 / AMG zone 55",
    20256: "AGD66 / AMG zone 56",
    20257: "AGD66 / AMG zone 57",
    20258: "AGD66 / AMG zone 58",
    20348: "AGD84 / AMG zone 48",
    20349: "AGD84 / AMG zone 49",
    20350: "AGD84 / AMG zone 50",
    20351: "AGD84 / AMG zone 51",
    20352: "AGD84 / AMG zone 52",
    20353: "AGD84 / AMG zone 53",
    20354: "AGD84 / AMG zone 54",
    20355: "AGD84 / AMG zone 55",
    20356: "AGD84 / AMG zone 56",
    20357: "AGD84 / AMG zone 57",
    20358: "AGD84 / AMG zone 58",
    20436: "Ain el Abd / UTM zone 36N",
    20437: "Ain el Abd / UTM zone 37N",
    20438: "Ain el Abd / UTM zone 38N",
    20439: "Ain el Abd / UTM zone 39N",
    20440: "Ain el Abd / UTM zone 40N",
    20499: "Ain el Abd / Bahrain Grid",
    20538: "Afgooye / UTM zone 38N",
    20539: "Afgooye / UTM zone 39N",
    20790: "Lisbon (Lisbon) / Portuguese National Grid",
    20791: "Lisbon (Lisbon) / Portuguese Grid",
    20822: "Aratu / UTM zone 22S",
    20823: "Aratu / UTM zone 23S",
    20824: "Aratu / UTM zone 24S",
    20934: "Arc 1950 / UTM zone 34S",
    20935: "Arc 1950 / UTM zone 35S",
    20936: "Arc 1950 / UTM zone 36S",
    21035: "Arc 1960 / UTM zone 35S",
    21036: "Arc 1960 / UTM zone 36S",
    21037: "Arc 1960 / UTM zone 37S",
    21095: "Arc 1960 / UTM zone 35N",
    21096: "Arc 1960 / UTM zone 36N",
    21097: "Arc 1960 / UTM zone 37N",
    21100: "Batavia (Jakarta) / NEIEZ",
    21148: "Batavia / UTM zone 48S",
    21149: "Batavia / UTM zone 49S",
    21150: "Batavia / UTM zone 50S",
    21291: "Barbados 1938 / British West Indies Grid",
    21292: "Barbados 1938 / Barbados National Grid",
    21413: "Beijing 1954 / Gauss-Kruger zone 13",
    21414: "Beijing 1954 / Gauss-Kruger zone 14",
    21415: "Beijing 1954 / Gauss-Kruger zone 15",
    21416: "Beijing 1954 / Gauss-Kruger zone 16",
    21417: "Beijing 1954 / Gauss-Kruger zone 17",
    21418: "Beijing 1954 / Gauss-Kruger zone 18",
    21419: "Beijing 1954 / Gauss-Kruger zone 19",
    21420: "Beijing 1954 / Gauss-Kruger zone 20",
    21421: "Beijing 1954 / Gauss-Kruger zone 21",
    21422: "Beijing 1954 / Gauss-Kruger zone 22",
    21423: "Beijing 1954 / Gauss-Kruger zone 23",
    21453: "Beijing 1954 / Gauss-Kruger CM 75E",
    21454: "Beijing 1954 / Gauss-Kruger CM 81E",
    21455: "Beijing 1954 / Gauss-Kruger CM 87E",
    21456: "Beijing 1954 / Gauss-Kruger CM 93E",
    21457: "Beijing 1954 / Gauss-Kruger CM 99E",
    21458: "Beijing 1954 / Gauss-Kruger CM 105E",
    21459: "Beijing 1954 / Gauss-Kruger CM 111E",
    21460: "Beijing 1954 / Gauss-Kruger CM 117E",
    21461: "Beijing 1954 / Gauss-Kruger CM 123E",
    21462: "Beijing 1954 / Gauss-Kruger CM 129E",
    21463: "Beijing 1954 / Gauss-Kruger CM 135E",
    21473: "Beijing 1954 / Gauss-Kruger 13N",
    21474: "Beijing 1954 / Gauss-Kruger 14N",
    21475: "Beijing 1954 / Gauss-Kruger 15N",
    21476: "Beijing 1954 / Gauss-Kruger 16N",
    21477: "Beijing 1954 / Gauss-Kruger 17N",
    21478: "Beijing 1954 / Gauss-Kruger 18N",
    21479: "Beijing 1954 / Gauss-Kruger 19N",
    21480: "Beijing 1954 / Gauss-Kruger 20N",
    21481: "Beijing 1954 / Gauss-Kruger 21N",
    21482: "Beijing 1954 / Gauss-Kruger 22N",
    21483: "Beijing 1954 / Gauss-Kruger 23N",
    21500: "Belge 1950 (Brussels) / Belge Lambert 50",
    21780: "Bern 1898 (Bern) / LV03C",
    21781: "CH1903 / LV03",
    21782: "CH1903 / LV03C-G",
    21817: "Bogota 1975 / UTM zone 17N",
    21818: "Bogota 1975 / UTM zone 18N",
    21891: "Bogota 1975 / Colombia West zone",
    21892: "Bogota 1975 / Colombia Bogota zone",
    21893: "Bogota 1975 / Colombia East Central zone",
    21894: "Bogota 1975 / Colombia East",
    21896: "Bogota 1975 / Colombia West zone",
    21897: "Bogota 1975 / Colombia Bogota zone",
    21898: "Bogota 1975 / Colombia East Central zone",
    21899: "Bogota 1975 / Colombia East",
    22032: "Camacupa / UTM zone 32S",
    22033: "Camacupa / UTM zone 33S",
    22091: "Camacupa / TM 11.30 SE",
    22092: "Camacupa / TM 12 SE",
    22171: "POSGAR 98 / Argentina 1",
    22172: "POSGAR 98 / Argentina 2",
    22173: "POSGAR 98 / Argentina 3",
    22174: "POSGAR 98 / Argentina 4",
    22175: "POSGAR 98 / Argentina 5",
    22176: "POSGAR 98 / Argentina 6",
    22177: "POSGAR 98 / Argentina 7",
    22181: "POSGAR 94 / Argentina 1",
    22182: "POSGAR 94 / Argentina 2",
    22183: "POSGAR 94 / Argentina 3",
    22184: "POSGAR 94 / Argentina 4",
    22185: "POSGAR 94 / Argentina 5",
    22186: "POSGAR 94 / Argentina 6",
    22187: "POSGAR 94 / Argentina 7",
    22191: "Campo Inchauspe / Argentina 1",
    22192: "Campo Inchauspe / Argentina 2",
    22193: "Campo Inchauspe / Argentina 3",
    22194: "Campo Inchauspe / Argentina 4",
    22195: "Campo Inchauspe / Argentina 5",
    22196: "Campo Inchauspe / Argentina 6",
    22197: "Campo Inchauspe / Argentina 7",
    22234: "Cape / UTM zone 34S",
    22235: "Cape / UTM zone 35S",
    22236: "Cape / UTM zone 36S",
    22275: "Cape / Lo15",
    22277: "Cape / Lo17",
    22279: "Cape / Lo19",
    22281: "Cape / Lo21",
    22283: "Cape / Lo23",
    22285: "Cape / Lo25",
    22287: "Cape / Lo27",
    22289: "Cape / Lo29",
    22291: "Cape / Lo31",
    22293: "Cape / Lo33",
    22300: "Carthage (Paris) / Tunisia Mining Grid",
    22332: "Carthage / UTM zone 32N",
    22391: "Carthage / Nord Tunisie",
    22392: "Carthage / Sud Tunisie",
    22521: "Corrego Alegre 1970-72 / UTM zone 21S",
    22522: "Corrego Alegre 1970-72 / UTM zone 22S",
    22523: "Corrego Alegre 1970-72 / UTM zone 23S",
    22524: "Corrego Alegre 1970-72 / UTM zone 24S",
    22525: "Corrego Alegre 1970-72 / UTM zone 25S",
    22700: "Deir ez Zor / Levant Zone",
    22770: "Deir ez Zor / Syria Lambert",
    22780: "Deir ez Zor / Levant Stereographic",
    22832: "Douala / UTM zone 32N",
    22991: "Egypt 1907 / Blue Belt",
    22992: "Egypt 1907 / Red Belt",
    22993: "Egypt 1907 / Purple Belt",
    22994: "Egypt 1907 / Extended Purple Belt",
    23028: "ED50 / UTM zone 28N",
    23029: "ED50 / UTM zone 29N",
    23030: "ED50 / UTM zone 30N",
    23031: "ED50 / UTM zone 31N",
    23032: "ED50 / UTM zone 32N",
    23033: "ED50 / UTM zone 33N",
    23034: "ED50 / UTM zone 34N",
    23035: "ED50 / UTM zone 35N",
    23036: "ED50 / UTM zone 36N",
    23037: "ED50 / UTM zone 37N",
    23038: "ED50 / UTM zone 38N",
    23090: "ED50 / TM 0 N",
    23095: "ED50 / TM 5 NE",
    23239: "Fahud / UTM zone 39N",
    23240: "Fahud / UTM zone 40N",
    23433: "Garoua / UTM zone 33N",
    23700: "HD72 / EOV",
    23830: "DGN95 / Indonesia TM-3 zone 46.2",
    23831: "DGN95 / Indonesia TM-3 zone 47.1",
    23832: "DGN95 / Indonesia TM-3 zone 47.2",
    23833: "DGN95 / Indonesia TM-3 zone 48.1",
    23834: "DGN95 / Indonesia TM-3 zone 48.2",
    23835: "DGN95 / Indonesia TM-3 zone 49.1",
    23836: "DGN95 / Indonesia TM-3 zone 49.2",
    23837: "DGN95 / Indonesia TM-3 zone 50.1",
    23838: "DGN95 / Indonesia TM-3 zone 50.2",
    23839: "DGN95 / Indonesia TM-3 zone 51.1",
    23840: "DGN95 / Indonesia TM-3 zone 51.2",
    23841: "DGN95 / Indonesia TM-3 zone 52.1",
    23842: "DGN95 / Indonesia TM-3 zone 52.2",
    23843: "DGN95 / Indonesia TM-3 zone 53.1",
    23844: "DGN95 / Indonesia TM-3 zone 53.2",
    23845: "DGN95 / Indonesia TM-3 zone 54.1",
    23846: "ID74 / UTM zone 46N",
    23847: "ID74 / UTM zone 47N",
    23848: "ID74 / UTM zone 48N",
    23849: "ID74 / UTM zone 49N",
    23850: "ID74 / UTM zone 50N",
    23851: "ID74 / UTM zone 51N",
    23852: "ID74 / UTM zone 52N",
    23853: "ID74 / UTM zone 53N",
    23866: "DGN95 / UTM zone 46N",
    23867: "DGN95 / UTM zone 47N",
    23868: "DGN95 / UTM zone 48N",
    23869: "DGN95 / UTM zone 49N",
    23870: "DGN95 / UTM zone 50N",
    23871: "DGN95 / UTM zone 51N",
    23872: "DGN95 / UTM zone 52N",
    23877: "DGN95 / UTM zone 47S",
    23878: "DGN95 / UTM zone 48S",
    23879: "DGN95 / UTM zone 49S",
    23880: "DGN95 / UTM zone 50S",
    23881: "DGN95 / UTM zone 51S",
    23882: "DGN95 / UTM zone 52S",
    23883: "DGN95 / UTM zone 53S",
    23884: "DGN95 / UTM zone 54S",
    23886: "ID74 / UTM zone 46S",
    23887: "ID74 / UTM zone 47S",
    23888: "ID74 / UTM zone 48S",
    23889: "ID74 / UTM zone 49S",
    23890: "ID74 / UTM zone 50S",
    23891: "ID74 / UTM zone 51S",
    23892: "ID74 / UTM zone 52S",
    23893: "ID74 / UTM zone 53S",
    23894: "ID74 / UTM zone 54S",
    23946: "Indian 1954 / UTM zone 46N",
    23947: "Indian 1954 / UTM zone 47N",
    23948: "Indian 1954 / UTM zone 48N",
    24047: "Indian 1975 / UTM zone 47N",
    24048: "Indian 1975 / UTM zone 48N",
    24100: "Jamaica 1875 / Jamaica (Old Grid)",
    24200: "JAD69 / Jamaica National Grid",
    24305: "Kalianpur 1937 / UTM zone 45N",
    24306: "Kalianpur 1937 / UTM zone 46N",
    24311: "Kalianpur 1962 / UTM zone 41N",
    24312: "Kalianpur 1962 / UTM zone 42N",
    24313: "Kalianpur 1962 / UTM zone 43N",
    24342: "Kalianpur 1975 / UTM zone 42N",
    24343: "Kalianpur 1975 / UTM zone 43N",
    24344: "Kalianpur 1975 / UTM zone 44N",
    24345: "Kalianpur 1975 / UTM zone 45N",
    24346: "Kalianpur 1975 / UTM zone 46N",
    24347: "Kalianpur 1975 / UTM zone 47N",
    24370: "Kalianpur 1880 / India zone 0",
    24371: "Kalianpur 1880 / India zone I",
    24372: "Kalianpur 1880 / India zone IIa",
    24373: "Kalianpur 1880 / India zone IIIa",
    24374: "Kalianpur 1880 / India zone IVa",
    24375: "Kalianpur 1937 / India zone IIb",
    24376: "Kalianpur 1962 / India zone I",
    24377: "Kalianpur 1962 / India zone IIa",
    24378: "Kalianpur 1975 / India zone I",
    24379: "Kalianpur 1975 / India zone IIa",
    24380: "Kalianpur 1975 / India zone IIb",
    24381: "Kalianpur 1975 / India zone IIIa",
    24382: "Kalianpur 1880 / India zone IIb",
    24383: "Kalianpur 1975 / India zone IVa",
    24500: "Kertau 1968 / Singapore Grid",
    24547: "Kertau 1968 / UTM zone 47N",
    24548: "Kertau 1968 / UTM zone 48N",
    24571: "Kertau / R.S.O. Malaya (ch)",
    24600: "KOC Lambert",
    24718: "La Canoa / UTM zone 18N",
    24719: "La Canoa / UTM zone 19N",
    24720: "La Canoa / UTM zone 20N",
    24817: "PSAD56 / UTM zone 17N",
    24818: "PSAD56 / UTM zone 18N",
    24819: "PSAD56 / UTM zone 19N",
    24820: "PSAD56 / UTM zone 20N",
    24821: "PSAD56 / UTM zone 21N",
    24877: "PSAD56 / UTM zone 17S",
    24878: "PSAD56 / UTM zone 18S",
    24879: "PSAD56 / UTM zone 19S",
    24880: "PSAD56 / UTM zone 20S",
    24881: "PSAD56 / UTM zone 21S",
    24882: "PSAD56 / UTM zone 22S",
    24891: "PSAD56 / Peru west zone",
    24892: "PSAD56 / Peru central zone",
    24893: "PSAD56 / Peru east zone",
    25000: "Leigon / Ghana Metre Grid",
    25231: "Lome / UTM zone 31N",
    25391: "Luzon 1911 / Philippines zone I",
    25392: "Luzon 1911 / Philippines zone II",
    25393: "Luzon 1911 / Philippines zone III",
    25394: "Luzon 1911 / Philippines zone IV",
    25395: "Luzon 1911 / Philippines zone V",
    25700: "Makassar (Jakarta) / NEIEZ",
    25828: "ETRS89 / UTM zone 28N",
    25829: "ETRS89 / UTM zone 29N",
    25830: "ETRS89 / UTM zone 30N",
    25831: "ETRS89 / UTM zone 31N",
    25832: "ETRS89 / UTM zone 32N",
    25833: "ETRS89 / UTM zone 33N",
    25834: "ETRS89 / UTM zone 34N",
    25835: "ETRS89 / UTM zone 35N",
    25836: "ETRS89 / UTM zone 36N",
    25837: "ETRS89 / UTM zone 37N",
    25838: "ETRS89 / UTM zone 38N",
    25884: "ETRS89 / TM Baltic93",
    25932: "Malongo 1987 / UTM zone 32S",
    26191: "Merchich / Nord Maroc",
    26192: "Merchich / Sud Maroc",
    26193: "Merchich / Sahara",
    26194: "Merchich / Sahara Nord",
    26195: "Merchich / Sahara Sud",
    26237: "Massawa / UTM zone 37N",
    26331: "Minna / UTM zone 31N",
    26332: "Minna / UTM zone 32N",
    26391: "Minna / Nigeria West Belt",
    26392: "Minna / Nigeria Mid Belt",
    26393: "Minna / Nigeria East Belt",
    26432: "Mhast / UTM zone 32S",
    26591: "Monte Mario (Rome) / Italy zone 1",
    26592: "Monte Mario (Rome) / Italy zone 2",
    26632: "M'poraloko / UTM zone 32N",
    26692: "M'poraloko / UTM zone 32S",
    26701: "NAD27 / UTM zone 1N",
    26702: "NAD27 / UTM zone 2N",
    26703: "NAD27 / UTM zone 3N",
    26704: "NAD27 / UTM zone 4N",
    26705: "NAD27 / UTM zone 5N",
    26706: "NAD27 / UTM zone 6N",
    26707: "NAD27 / UTM zone 7N",
    26708: "NAD27 / UTM zone 8N",
    26709: "NAD27 / UTM zone 9N",
    26710: "NAD27 / UTM zone 10N",
    26711: "NAD27 / UTM zone 11N",
    26712: "NAD27 / UTM zone 12N",
    26713: "NAD27 / UTM zone 13N",
    26714: "NAD27 / UTM zone 14N",
    26715: "NAD27 / UTM zone 15N",
    26716: "NAD27 / UTM zone 16N",
    26717: "NAD27 / UTM zone 17N",
    26718: "NAD27 / UTM zone 18N",
    26719: "NAD27 / UTM zone 19N",
    26720: "NAD27 / UTM zone 20N",
    26721: "NAD27 / UTM zone 21N",
    26722: "NAD27 / UTM zone 22N",
    26729: "NAD27 / Alabama East",
    26730: "NAD27 / Alabama West",
    26731: "NAD27 / Alaska zone 1",
    26732: "NAD27 / Alaska zone 2",
    26733: "NAD27 / Alaska zone 3",
    26734: "NAD27 / Alaska zone 4",
    26735: "NAD27 / Alaska zone 5",
    26736: "NAD27 / Alaska zone 6",
    26737: "NAD27 / Alaska zone 7",
    26738: "NAD27 / Alaska zone 8",
    26739: "NAD27 / Alaska zone 9",
    26740: "NAD27 / Alaska zone 10",
    26741: "NAD27 / California zone I",
    26742: "NAD27 / California zone II",
    26743: "NAD27 / California zone III",
    26744: "NAD27 / California zone IV",
    26745: "NAD27 / California zone V",
    26746: "NAD27 / California zone VI",
    26747: "NAD27 / California zone VII",
    26748: "NAD27 / Arizona East",
    26749: "NAD27 / Arizona Central",
    26750: "NAD27 / Arizona West",
    26751: "NAD27 / Arkansas North",
    26752: "NAD27 / Arkansas South",
    26753: "NAD27 / Colorado North",
    26754: "NAD27 / Colorado Central",
    26755: "NAD27 / Colorado South",
    26756: "NAD27 / Connecticut",
    26757: "NAD27 / Delaware",
    26758: "NAD27 / Florida East",
    26759: "NAD27 / Florida West",
    26760: "NAD27 / Florida North",
    26766: "NAD27 / Georgia East",
    26767: "NAD27 / Georgia West",
    26768: "NAD27 / Idaho East",
    26769: "NAD27 / Idaho Central",
    26770: "NAD27 / Idaho West",
    26771: "NAD27 / Illinois East",
    26772: "NAD27 / Illinois West",
    26773: "NAD27 / Indiana East",
    26774: "NAD27 / Indiana West",
    26775: "NAD27 / Iowa North",
    26776: "NAD27 / Iowa South",
    26777: "NAD27 / Kansas North",
    26778: "NAD27 / Kansas South",
    26779: "NAD27 / Kentucky North",
    26780: "NAD27 / Kentucky South",
    26781: "NAD27 / Louisiana North",
    26782: "NAD27 / Louisiana South",
    26783: "NAD27 / Maine East",
    26784: "NAD27 / Maine West",
    26785: "NAD27 / Maryland",
    26786: "NAD27 / Massachusetts Mainland",
    26787: "NAD27 / Massachusetts Island",
    26791: "NAD27 / Minnesota North",
    26792: "NAD27 / Minnesota Central",
    26793: "NAD27 / Minnesota South",
    26794: "NAD27 / Mississippi East",
    26795: "NAD27 / Mississippi West",
    26796: "NAD27 / Missouri East",
    26797: "NAD27 / Missouri Central",
    26798: "NAD27 / Missouri West",
    26799: "NAD27 / California zone VII",
    26801: "NAD Michigan / Michigan East",
    26802: "NAD Michigan / Michigan Old Central",
    26803: "NAD Michigan / Michigan West",
    26811: "NAD Michigan / Michigan North",
    26812: "NAD Michigan / Michigan Central",
    26813: "NAD Michigan / Michigan South",
    26814: "NAD83 / Maine East (ftUS)",
    26815: "NAD83 / Maine West (ftUS)",
    26819: "NAD83 / Minnesota North (ftUS)",
    26820: "NAD83 / Minnesota Central (ftUS)",
    26821: "NAD83 / Minnesota South (ftUS)",
    26822: "NAD83 / Nebraska (ftUS)",
    26823: "NAD83 / West Virginia North (ftUS)",
    26824: "NAD83 / West Virginia South (ftUS)",
    26825: "NAD83(HARN) / Maine East (ftUS)",
    26826: "NAD83(HARN) / Maine West (ftUS)",
    26830: "NAD83(HARN) / Minnesota North (ftUS)",
    26831: "NAD83(HARN) / Minnesota Central (ftUS)",
    26832: "NAD83(HARN) / Minnesota South (ftUS)",
    26833: "NAD83(HARN) / Nebraska (ftUS)",
    26834: "NAD83(HARN) / West Virginia North (ftUS)",
    26835: "NAD83(HARN) / West Virginia South (ftUS)",
    26836: "NAD83(NSRS2007) / Maine East (ftUS)",
    26837: "NAD83(NSRS2007) / Maine West (ftUS)",
    26841: "NAD83(NSRS2007) / Minnesota North (ftUS)",
    26842: "NAD83(NSRS2007) / Minnesota Central (ftUS)",
    26843: "NAD83(NSRS2007) / Minnesota South (ftUS)",
    26844: "NAD83(NSRS2007) / Nebraska (ftUS)",
    26845: "NAD83(NSRS2007) / West Virginia North (ftUS)",
    26846: "NAD83(NSRS2007) / West Virginia South (ftUS)",
    26847: "NAD83 / Maine East (ftUS)",
    26848: "NAD83 / Maine West (ftUS)",
    26849: "NAD83 / Minnesota North (ftUS)",
    26850: "NAD83 / Minnesota Central (ftUS)",
    26851: "NAD83 / Minnesota South (ftUS)",
    26852: "NAD83 / Nebraska (ftUS)",
    26853: "NAD83 / West Virginia North (ftUS)",
    26854: "NAD83 / West Virginia South (ftUS)",
    26855: "NAD83(HARN) / Maine East (ftUS)",
    26856: "NAD83(HARN) / Maine West (ftUS)",
    26857: "NAD83(HARN) / Minnesota North (ftUS)",
    26858: "NAD83(HARN) / Minnesota Central (ftUS)",
    26859: "NAD83(HARN) / Minnesota South (ftUS)",
    26860: "NAD83(HARN) / Nebraska (ftUS)",
    26861: "NAD83(HARN) / West Virginia North (ftUS)",
    26862: "NAD83(HARN) / West Virginia South (ftUS)",
    26863: "NAD83(NSRS2007) / Maine East (ftUS)",
    26864: "NAD83(NSRS2007) / Maine West (ftUS)",
    26865: "NAD83(NSRS2007) / Minnesota North (ftUS)",
    26866: "NAD83(NSRS2007) / Minnesota Central (ftUS)",
    26867: "NAD83(NSRS2007) / Minnesota South (ftUS)",
    26868: "NAD83(NSRS2007) / Nebraska (ftUS)",
    26869: "NAD83(NSRS2007) / West Virginia North (ftUS)",
    26870: "NAD83(NSRS2007) / West Virginia South (ftUS)",
    26891: "NAD83(CSRS) / MTM zone 11",
    26892: "NAD83(CSRS) / MTM zone 12",
    26893: "NAD83(CSRS) / MTM zone 13",
    26894: "NAD83(CSRS) / MTM zone 14",
    26895: "NAD83(CSRS) / MTM zone 15",
    26896: "NAD83(CSRS) / MTM zone 16",
    26897: "NAD83(CSRS) / MTM zone 17",
    26898: "NAD83(CSRS) / MTM zone 1",
    26899: "NAD83(CSRS) / MTM zone 2",
    26901: "NAD83 / UTM zone 1N",
    26902: "NAD83 / UTM zone 2N",
    26903: "NAD83 / UTM zone 3N",
    26904: "NAD83 / UTM zone 4N",
    26905: "NAD83 / UTM zone 5N",
    26906: "NAD83 / UTM zone 6N",
    26907: "NAD83 / UTM zone 7N",
    26908: "NAD83 / UTM zone 8N",
    26909: "NAD83 / UTM zone 9N",
    26910: "NAD83 / UTM zone 10N",
    26911: "NAD83 / UTM zone 11N",
    26912: "NAD83 / UTM zone 12N",
    26913: "NAD83 / UTM zone 13N",
    26914: "NAD83 / UTM zone 14N",
    26915: "NAD83 / UTM zone 15N",
    26916: "NAD83 / UTM zone 16N",
    26917: "NAD83 / UTM zone 17N",
    26918: "NAD83 / UTM zone 18N",
    26919: "NAD83 / UTM zone 19N",
    26920: "NAD83 / UTM zone 20N",
    26921: "NAD83 / UTM zone 21N",
    26922: "NAD83 / UTM zone 22N",
    26923: "NAD83 / UTM zone 23N",
    26929: "NAD83 / Alabama East",
    26930: "NAD83 / Alabama West",
    26931: "NAD83 / Alaska zone 1",
    26932: "NAD83 / Alaska zone 2",
    26933: "NAD83 / Alaska zone 3",
    26934: "NAD83 / Alaska zone 4",
    26935: "NAD83 / Alaska zone 5",
    26936: "NAD83 / Alaska zone 6",
    26937: "NAD83 / Alaska zone 7",
    26938: "NAD83 / Alaska zone 8",
    26939: "NAD83 / Alaska zone 9",
    26940: "NAD83 / Alaska zone 10",
    26941: "NAD83 / California zone 1",
    26942: "NAD83 / California zone 2",
    26943: "NAD83 / California zone 3",
    26944: "NAD83 / California zone 4",
    26945: "NAD83 / California zone 5",
    26946: "NAD83 / California zone 6",
    26948: "NAD83 / Arizona East",
    26949: "NAD83 / Arizona Central",
    26950: "NAD83 / Arizona West",
    26951: "NAD83 / Arkansas North",
    26952: "NAD83 / Arkansas South",
    26953: "NAD83 / Colorado North",
    26954: "NAD83 / Colorado Central",
    26955: "NAD83 / Colorado South",
    26956: "NAD83 / Connecticut",
    26957: "NAD83 / Delaware",
    26958: "NAD83 / Florida East",
    26959: "NAD83 / Florida West",
    26960: "NAD83 / Florida North",
    26961: "NAD83 / Hawaii zone 1",
    26962: "NAD83 / Hawaii zone 2",
    26963: "NAD83 / Hawaii zone 3",
    26964: "NAD83 / Hawaii zone 4",
    26965: "NAD83 / Hawaii zone 5",
    26966: "NAD83 / Georgia East",
    26967: "NAD83 / Georgia West",
    26968: "NAD83 / Idaho East",
    26969: "NAD83 / Idaho Central",
    26970: "NAD83 / Idaho West",
    26971: "NAD83 / Illinois East",
    26972: "NAD83 / Illinois West",
    26973: "NAD83 / Indiana East",
    26974: "NAD83 / Indiana West",
    26975: "NAD83 / Iowa North",
    26976: "NAD83 / Iowa South",
    26977: "NAD83 / Kansas North",
    26978: "NAD83 / Kansas South",
    26979: "NAD83 / Kentucky North",
    26980: "NAD83 / Kentucky South",
    26981: "NAD83 / Louisiana North",
    26982: "NAD83 / Louisiana South",
    26983: "NAD83 / Maine East",
    26984: "NAD83 / Maine West",
    26985: "NAD83 / Maryland",
    26986: "NAD83 / Massachusetts Mainland",
    26987: "NAD83 / Massachusetts Island",
    26988: "NAD83 / Michigan North",
    26989: "NAD83 / Michigan Central",
    26990: "NAD83 / Michigan South",
    26991: "NAD83 / Minnesota North",
    26992: "NAD83 / Minnesota Central",
    26993: "NAD83 / Minnesota South",
    26994: "NAD83 / Mississippi East",
    26995: "NAD83 / Mississippi West",
    26996: "NAD83 / Missouri East",
    26997: "NAD83 / Missouri Central",
    26998: "NAD83 / Missouri West",
    27037: "Nahrwan 1967 / UTM zone 37N",
    27038: "Nahrwan 1967 / UTM zone 38N",
    27039: "Nahrwan 1967 / UTM zone 39N",
    27040: "Nahrwan 1967 / UTM zone 40N",
    27120: "Naparima 1972 / UTM zone 20N",
    27200: "NZGD49 / New Zealand Map Grid",
    27205: "NZGD49 / Mount Eden Circuit",
    27206: "NZGD49 / Bay of Plenty Circuit",
    27207: "NZGD49 / Poverty Bay Circuit",
    27208: "NZGD49 / Hawkes Bay Circuit",
    27209: "NZGD49 / Taranaki Circuit",
    27210: "NZGD49 / Tuhirangi Circuit",
    27211: "NZGD49 / Wanganui Circuit",
    27212: "NZGD49 / Wairarapa Circuit",
    27213: "NZGD49 / Wellington Circuit",
    27214: "NZGD49 / Collingwood Circuit",
    27215: "NZGD49 / Nelson Circuit",
    27216: "NZGD49 / Karamea Circuit",
    27217: "NZGD49 / Buller Circuit",
    27218: "NZGD49 / Grey Circuit",
    27219: "NZGD49 / Amuri Circuit",
    27220: "NZGD49 / Marlborough Circuit",
    27221: "NZGD49 / Hokitika Circuit",
    27222: "NZGD49 / Okarito Circuit",
    27223: "NZGD49 / Jacksons Bay Circuit",
    27224: "NZGD49 / Mount Pleasant Circuit",
    27225: "NZGD49 / Gawler Circuit",
    27226: "NZGD49 / Timaru Circuit",
    27227: "NZGD49 / Lindis Peak Circuit",
    27228: "NZGD49 / Mount Nicholas Circuit",
    27229: "NZGD49 / Mount York Circuit",
    27230: "NZGD49 / Observation Point Circuit",
    27231: "NZGD49 / North Taieri Circuit",
    27232: "NZGD49 / Bluff Circuit",
    27258: "NZGD49 / UTM zone 58S",
    27259: "NZGD49 / UTM zone 59S",
    27260: "NZGD49 / UTM zone 60S",
    27291: "NZGD49 / North Island Grid",
    27292: "NZGD49 / South Island Grid",
    27391: "NGO 1948 (Oslo) / NGO zone I",
    27392: "NGO 1948 (Oslo) / NGO zone II",
    27393: "NGO 1948 (Oslo) / NGO zone III",
    27394: "NGO 1948 (Oslo) / NGO zone IV",
    27395: "NGO 1948 (Oslo) / NGO zone V",
    27396: "NGO 1948 (Oslo) / NGO zone VI",
    27397: "NGO 1948 (Oslo) / NGO zone VII",
    27398: "NGO 1948 (Oslo) / NGO zone VIII",
    27429: "Datum 73 / UTM zone 29N",
    27492: "Datum 73 / Modified Portuguese Grid",
    27493: "Datum 73 / Modified Portuguese Grid",
    27500: "ATF (Paris) / Nord de Guerre",
    27561: "NTF (Paris) / Lambert Nord France",
    27562: "NTF (Paris) / Lambert Centre France",
    27563: "NTF (Paris) / Lambert Sud France",
    27564: "NTF (Paris) / Lambert Corse",
    27571: "NTF (Paris) / Lambert zone I",
    27572: "NTF (Paris) / Lambert zone II",
    27573: "NTF (Paris) / Lambert zone III",
    27574: "NTF (Paris) / Lambert zone IV",
    27581: "NTF (Paris) / France I",
    27582: "NTF (Paris) / France II",
    27583: "NTF (Paris) / France III",
    27584: "NTF (Paris) / France IV",
    27591: "NTF (Paris) / Nord France",
    27592: "NTF (Paris) / Centre France",
    27593: "NTF (Paris) / Sud France",
    27594: "NTF (Paris) / Corse",
    27700: "OSGB 1936 / British National Grid",
    28191: "Palestine 1923 / Palestine Grid",
    28192: "Palestine 1923 / Palestine Belt",
    28193: "Palestine 1923 / Israeli CS Grid",
    28232: "Pointe Noire / UTM zone 32S",
    28348: "GDA94 / MGA zone 48",
    28349: "GDA94 / MGA zone 49",
    28350: "GDA94 / MGA zone 50",
    28351: "GDA94 / MGA zone 51",
    28352: "GDA94 / MGA zone 52",
    28353: "GDA94 / MGA zone 53",
    28354: "GDA94 / MGA zone 54",
    28355: "GDA94 / MGA zone 55",
    28356: "GDA94 / MGA zone 56",
    28357: "GDA94 / MGA zone 57",
    28358: "GDA94 / MGA zone 58",
    28402: "Pulkovo 1942 / Gauss-Kruger zone 2",
    28403: "Pulkovo 1942 / Gauss-Kruger zone 3",
    28404: "Pulkovo 1942 / Gauss-Kruger zone 4",
    28405: "Pulkovo 1942 / Gauss-Kruger zone 5",
    28406: "Pulkovo 1942 / Gauss-Kruger zone 6",
    28407: "Pulkovo 1942 / Gauss-Kruger zone 7",
    28408: "Pulkovo 1942 / Gauss-Kruger zone 8",
    28409: "Pulkovo 1942 / Gauss-Kruger zone 9",
    28410: "Pulkovo 1942 / Gauss-Kruger zone 10",
    28411: "Pulkovo 1942 / Gauss-Kruger zone 11",
    28412: "Pulkovo 1942 / Gauss-Kruger zone 12",
    28413: "Pulkovo 1942 / Gauss-Kruger zone 13",
    28414: "Pulkovo 1942 / Gauss-Kruger zone 14",
    28415: "Pulkovo 1942 / Gauss-Kruger zone 15",
    28416: "Pulkovo 1942 / Gauss-Kruger zone 16",
    28417: "Pulkovo 1942 / Gauss-Kruger zone 17",
    28418: "Pulkovo 1942 / Gauss-Kruger zone 18",
    28419: "Pulkovo 1942 / Gauss-Kruger zone 19",
    28420: "Pulkovo 1942 / Gauss-Kruger zone 20",
    28421: "Pulkovo 1942 / Gauss-Kruger zone 21",
    28422: "Pulkovo 1942 / Gauss-Kruger zone 22",
    28423: "Pulkovo 1942 / Gauss-Kruger zone 23",
    28424: "Pulkovo 1942 / Gauss-Kruger zone 24",
    28425: "Pulkovo 1942 / Gauss-Kruger zone 25",
    28426: "Pulkovo 1942 / Gauss-Kruger zone 26",
    28427: "Pulkovo 1942 / Gauss-Kruger zone 27",
    28428: "Pulkovo 1942 / Gauss-Kruger zone 28",
    28429: "Pulkovo 1942 / Gauss-Kruger zone 29",
    28430: "Pulkovo 1942 / Gauss-Kruger zone 30",
    28431: "Pulkovo 1942 / Gauss-Kruger zone 31",
    28432: "Pulkovo 1942 / Gauss-Kruger zone 32",
    28462: "Pulkovo 1942 / Gauss-Kruger 2N",
    28463: "Pulkovo 1942 / Gauss-Kruger 3N",
    28464: "Pulkovo 1942 / Gauss-Kruger 4N",
    28465: "Pulkovo 1942 / Gauss-Kruger 5N",
    28466: "Pulkovo 1942 / Gauss-Kruger 6N",
    28467: "Pulkovo 1942 / Gauss-Kruger 7N",
    28468: "Pulkovo 1942 / Gauss-Kruger 8N",
    28469: "Pulkovo 1942 / Gauss-Kruger 9N",
    28470: "Pulkovo 1942 / Gauss-Kruger 10N",
    28471: "Pulkovo 1942 / Gauss-Kruger 11N",
    28472: "Pulkovo 1942 / Gauss-Kruger 12N",
    28473: "Pulkovo 1942 / Gauss-Kruger 13N",
    28474: "Pulkovo 1942 / Gauss-Kruger 14N",
    28475: "Pulkovo 1942 / Gauss-Kruger 15N",
    28476: "Pulkovo 1942 / Gauss-Kruger 16N",
    28477: "Pulkovo 1942 / Gauss-Kruger 17N",
    28478: "Pulkovo 1942 / Gauss-Kruger 18N",
    28479: "Pulkovo 1942 / Gauss-Kruger 19N",
    28480: "Pulkovo 1942 / Gauss-Kruger 20N",
    28481: "Pulkovo 1942 / Gauss-Kruger 21N",
    28482: "Pulkovo 1942 / Gauss-Kruger 22N",
    28483: "Pulkovo 1942 / Gauss-Kruger 23N",
    28484: "Pulkovo 1942 / Gauss-Kruger 24N",
    28485: "Pulkovo 1942 / Gauss-Kruger 25N",
    28486: "Pulkovo 1942 / Gauss-Kruger 26N",
    28487: "Pulkovo 1942 / Gauss-Kruger 27N",
    28488: "Pulkovo 1942 / Gauss-Kruger 28N",
    28489: "Pulkovo 1942 / Gauss-Kruger 29N",
    28490: "Pulkovo 1942 / Gauss-Kruger 30N",
    28491: "Pulkovo 1942 / Gauss-Kruger 31N",
    28492: "Pulkovo 1942 / Gauss-Kruger 32N",
    28600: "Qatar 1974 / Qatar National Grid",
    28991: "Amersfoort / RD Old",
    28992: "Amersfoort / RD New",
    29100: "SAD69 / Brazil Polyconic",
    29101: "SAD69 / Brazil Polyconic",
    29118: "SAD69 / UTM zone 18N",
    29119: "SAD69 / UTM zone 19N",
    29120: "SAD69 / UTM zone 20N",
    29121: "SAD69 / UTM zone 21N",
    29122: "SAD69 / UTM zone 22N",
    29168: "SAD69 / UTM zone 18N",
    29169: "SAD69 / UTM zone 19N",
    29170: "SAD69 / UTM zone 20N",
    29171: "SAD69 / UTM zone 21N",
    29172: "SAD69 / UTM zone 22N",
    29177: "SAD69 / UTM zone 17S",
    29178: "SAD69 / UTM zone 18S",
    29179: "SAD69 / UTM zone 19S",
    29180: "SAD69 / UTM zone 20S",
    29181: "SAD69 / UTM zone 21S",
    29182: "SAD69 / UTM zone 22S",
    29183: "SAD69 / UTM zone 23S",
    29184: "SAD69 / UTM zone 24S",
    29185: "SAD69 / UTM zone 25S",
    29187: "SAD69 / UTM zone 17S",
    29188: "SAD69 / UTM zone 18S",
    29189: "SAD69 / UTM zone 19S",
    29190: "SAD69 / UTM zone 20S",
    29191: "SAD69 / UTM zone 21S",
    29192: "SAD69 / UTM zone 22S",
    29193: "SAD69 / UTM zone 23S",
    29194: "SAD69 / UTM zone 24S",
    29195: "SAD69 / UTM zone 25S",
    29220: "Sapper Hill 1943 / UTM zone 20S",
    29221: "Sapper Hill 1943 / UTM zone 21S",
    29333: "Schwarzeck / UTM zone 33S",
    29371: "Schwarzeck / Lo22/11",
    29373: "Schwarzeck / Lo22/13",
    29375: "Schwarzeck / Lo22/15",
    29377: "Schwarzeck / Lo22/17",
    29379: "Schwarzeck / Lo22/19",
    29381: "Schwarzeck / Lo22/21",
    29383: "Schwarzeck / Lo22/23",
    29385: "Schwarzeck / Lo22/25",
    29635: "Sudan / UTM zone 35N",
    29636: "Sudan / UTM zone 36N",
    29700: "Tananarive (Paris) / Laborde Grid",
    29701: "Tananarive (Paris) / Laborde Grid",
    29702: "Tananarive (Paris) / Laborde Grid approximation",
    29738: "Tananarive / UTM zone 38S",
    29739: "Tananarive / UTM zone 39S",
    29849: "Timbalai 1948 / UTM zone 49N",
    29850: "Timbalai 1948 / UTM zone 50N",
    29871: "Timbalai 1948 / RSO Borneo (ch)",
    29872: "Timbalai 1948 / RSO Borneo (ft)",
    29873: "Timbalai 1948 / RSO Borneo (m)",
    29900: "TM65 / Irish National Grid",
    29901: "OSNI 1952 / Irish National Grid",
    29902: "TM65 / Irish Grid",
    29903: "TM75 / Irish Grid",
    30161: "Tokyo / Japan Plane Rectangular CS I",
    30162: "Tokyo / Japan Plane Rectangular CS II",
    30163: "Tokyo / Japan Plane Rectangular CS III",
    30164: "Tokyo / Japan Plane Rectangular CS IV",
    30165: "Tokyo / Japan Plane Rectangular CS V",
    30166: "Tokyo / Japan Plane Rectangular CS VI",
    30167: "Tokyo / Japan Plane Rectangular CS VII",
    30168: "Tokyo / Japan Plane Rectangular CS VIII",
    30169: "Tokyo / Japan Plane Rectangular CS IX",
    30170: "Tokyo / Japan Plane Rectangular CS X",
    30171: "Tokyo / Japan Plane Rectangular CS XI",
    30172: "Tokyo / Japan Plane Rectangular CS XII",
    30173: "Tokyo / Japan Plane Rectangular CS XIII",
    30174: "Tokyo / Japan Plane Rectangular CS XIV",
    30175: "Tokyo / Japan Plane Rectangular CS XV",
    30176: "Tokyo / Japan Plane Rectangular CS XVI",
    30177: "Tokyo / Japan Plane Rectangular CS XVII",
    30178: "Tokyo / Japan Plane Rectangular CS XVIII",
    30179: "Tokyo / Japan Plane Rectangular CS XIX",
    30200: "Trinidad 1903 / Trinidad Grid",
    30339: "TC(1948) / UTM zone 39N",
    30340: "TC(1948) / UTM zone 40N",
    30491: "Voirol 1875 / Nord Algerie (ancienne)",
    30492: "Voirol 1875 / Sud Algerie (ancienne)",
    30493: "Voirol 1879 / Nord Algerie (ancienne)",
    30494: "Voirol 1879 / Sud Algerie (ancienne)",
    30729: "Nord Sahara 1959 / UTM zone 29N",
    30730: "Nord Sahara 1959 / UTM zone 30N",
    30731: "Nord Sahara 1959 / UTM zone 31N",
    30732: "Nord Sahara 1959 / UTM zone 32N",
    30791: "Nord Sahara 1959 / Nord Algerie",
    30792: "Nord Sahara 1959 / Sud Algerie",
    30800: "RT38 2.5 gon W",
    31028: "Yoff / UTM zone 28N",
    31121: "Zanderij / UTM zone 21N",
    31154: "Zanderij / TM 54 NW",
    31170: "Zanderij / Suriname Old TM",
    31171: "Zanderij / Suriname TM",
    31251: "MGI (Ferro) / Austria GK West Zone",
    31252: "MGI (Ferro) / Austria GK Central Zone",
    31253: "MGI (Ferro) / Austria GK East Zone",
    31254: "MGI / Austria GK West",
    31255: "MGI / Austria GK Central",
    31256: "MGI / Austria GK East",
    31257: "MGI / Austria GK M28",
    31258: "MGI / Austria GK M31",
    31259: "MGI / Austria GK M34",
    31265: "MGI / 3-degree Gauss zone 5",
    31266: "MGI / 3-degree Gauss zone 6",
    31267: "MGI / 3-degree Gauss zone 7",
    31268: "MGI / 3-degree Gauss zone 8",
    31275: "MGI / Balkans zone 5",
    31276: "MGI / Balkans zone 6",
    31277: "MGI / Balkans zone 7",
    31278: "MGI / Balkans zone 8",
    31279: "MGI / Balkans zone 8",
    31281: "MGI (Ferro) / Austria West Zone",
    31282: "MGI (Ferro) / Austria Central Zone",
    31283: "MGI (Ferro) / Austria East Zone",
    31284: "MGI / Austria M28",
    31285: "MGI / Austria M31",
    31286: "MGI / Austria M34",
    31287: "MGI / Austria Lambert",
    31288: "MGI (Ferro) / M28",
    31289: "MGI (Ferro) / M31",
    31290: "MGI (Ferro) / M34",
    31291: "MGI (Ferro) / Austria West Zone",
    31292: "MGI (Ferro) / Austria Central Zone",
    31293: "MGI (Ferro) / Austria East Zone",
    31294: "MGI / M28",
    31295: "MGI / M31",
    31296: "MGI / M34",
    31297: "MGI / Austria Lambert",
    31300: "Belge 1972 / Belge Lambert 72",
    31370: "Belge 1972 / Belgian Lambert 72",
    31461: "DHDN / 3-degree Gauss zone 1",
    31462: "DHDN / 3-degree Gauss zone 2",
    31463: "DHDN / 3-degree Gauss zone 3",
    31464: "DHDN / 3-degree Gauss zone 4",
    31465: "DHDN / 3-degree Gauss zone 5",
    31466: "DHDN / 3-degree Gauss-Kruger zone 2",
    31467: "DHDN / 3-degree Gauss-Kruger zone 3",
    31468: "DHDN / 3-degree Gauss-Kruger zone 4",
    31469: "DHDN / 3-degree Gauss-Kruger zone 5",
    31528: "Conakry 1905 / UTM zone 28N",
    31529: "Conakry 1905 / UTM zone 29N",
    31600: "Dealul Piscului 1930 / Stereo 33",
    31700: "Dealul Piscului 1970/ Stereo 70",
    31838: "NGN / UTM zone 38N",
    31839: "NGN / UTM zone 39N",
    31900: "KUDAMS / KTM",
    31901: "KUDAMS / KTM",
    31965: "SIRGAS 2000 / UTM zone 11N",
    31966: "SIRGAS 2000 / UTM zone 12N",
    31967: "SIRGAS 2000 / UTM zone 13N",
    31968: "SIRGAS 2000 / UTM zone 14N",
    31969: "SIRGAS 2000 / UTM zone 15N",
    31970: "SIRGAS 2000 / UTM zone 16N",
    31971: "SIRGAS 2000 / UTM zone 17N",
    31972: "SIRGAS 2000 / UTM zone 18N",
    31973: "SIRGAS 2000 / UTM zone 19N",
    31974: "SIRGAS 2000 / UTM zone 20N",
    31975: "SIRGAS 2000 / UTM zone 21N",
    31976: "SIRGAS 2000 / UTM zone 22N",
    31977: "SIRGAS 2000 / UTM zone 17S",
    31978: "SIRGAS 2000 / UTM zone 18S",
    31979: "SIRGAS 2000 / UTM zone 19S",
    31980: "SIRGAS 2000 / UTM zone 20S",
    31981: "SIRGAS 2000 / UTM zone 21S",
    31982: "SIRGAS 2000 / UTM zone 22S",
    31983: "SIRGAS 2000 / UTM zone 23S",
    31984: "SIRGAS 2000 / UTM zone 24S",
    31985: "SIRGAS 2000 / UTM zone 25S",
    31986: "SIRGAS 1995 / UTM zone 17N",
    31987: "SIRGAS 1995 / UTM zone 18N",
    31988: "SIRGAS 1995 / UTM zone 19N",
    31989: "SIRGAS 1995 / UTM zone 20N",
    31990: "SIRGAS 1995 / UTM zone 21N",
    31991: "SIRGAS 1995 / UTM zone 22N",
    31992: "SIRGAS 1995 / UTM zone 17S",
    31993: "SIRGAS 1995 / UTM zone 18S",
    31994: "SIRGAS 1995 / UTM zone 19S",
    31995: "SIRGAS 1995 / UTM zone 20S",
    31996: "SIRGAS 1995 / UTM zone 21S",
    31997: "SIRGAS 1995 / UTM zone 22S",
    31998: "SIRGAS 1995 / UTM zone 23S",
    31999: "SIRGAS 1995 / UTM zone 24S",
    32000: "SIRGAS 1995 / UTM zone 25S",
    32001: "NAD27 / Montana North",
    32002: "NAD27 / Montana Central",
    32003: "NAD27 / Montana South",
    32005: "NAD27 / Nebraska North",
    32006: "NAD27 / Nebraska South",
    32007: "NAD27 / Nevada East",
    32008: "NAD27 / Nevada Central",
    32009: "NAD27 / Nevada West",
    32010: "NAD27 / New Hampshire",
    32011: "NAD27 / New Jersey",
    32012: "NAD27 / New Mexico East",
    32013: "NAD27 / New Mexico Central",
    32014: "NAD27 / New Mexico West",
    32015: "NAD27 / New York East",
    32016: "NAD27 / New York Central",
    32017: "NAD27 / New York West",
    32018: "NAD27 / New York Long Island",
    32019: "NAD27 / North Carolina",
    32020: "NAD27 / North Dakota North",
    32021: "NAD27 / North Dakota South",
    32022: "NAD27 / Ohio North",
    32023: "NAD27 / Ohio South",
    32024: "NAD27 / Oklahoma North",
    32025: "NAD27 / Oklahoma South",
    32026: "NAD27 / Oregon North",
    32027: "NAD27 / Oregon South",
    32028: "NAD27 / Pennsylvania North",
    32029: "NAD27 / Pennsylvania South",
    32030: "NAD27 / Rhode Island",
    32031: "NAD27 / South Carolina North",
    32033: "NAD27 / South Carolina South",
    32034: "NAD27 / South Dakota North",
    32035: "NAD27 / South Dakota South",
    32036: "NAD27 / Tennessee",
    32037: "NAD27 / Texas North",
    32038: "NAD27 / Texas North Central",
    32039: "NAD27 / Texas Central",
    32040: "NAD27 / Texas South Central",
    32041: "NAD27 / Texas South",
    32042: "NAD27 / Utah North",
    32043: "NAD27 / Utah Central",
    32044: "NAD27 / Utah South",
    32045: "NAD27 / Vermont",
    32046: "NAD27 / Virginia North",
    32047: "NAD27 / Virginia South",
    32048: "NAD27 / Washington North",
    32049: "NAD27 / Washington South",
    32050: "NAD27 / West Virginia North",
    32051: "NAD27 / West Virginia South",
    32052: "NAD27 / Wisconsin North",
    32053: "NAD27 / Wisconsin Central",
    32054: "NAD27 / Wisconsin South",
    32055: "NAD27 / Wyoming East",
    32056: "NAD27 / Wyoming East Central",
    32057: "NAD27 / Wyoming West Central",
    32058: "NAD27 / Wyoming West",
    32061: "NAD27 / Guatemala Norte",
    32062: "NAD27 / Guatemala Sur",
    32064: "NAD27 / BLM 14N (ftUS)",
    32065: "NAD27 / BLM 15N (ftUS)",
    32066: "NAD27 / BLM 16N (ftUS)",
    32067: "NAD27 / BLM 17N (ftUS)",
    32074: "NAD27 / BLM 14N (feet)",
    32075: "NAD27 / BLM 15N (feet)",
    32076: "NAD27 / BLM 16N (feet)",
    32077: "NAD27 / BLM 17N (feet)",
    32081: "NAD27 / MTM zone 1",
    32082: "NAD27 / MTM zone 2",
    32083: "NAD27 / MTM zone 3",
    32084: "NAD27 / MTM zone 4",
    32085: "NAD27 / MTM zone 5",
    32086: "NAD27 / MTM zone 6",
    32098: "NAD27 / Quebec Lambert",
    32099: "NAD27 / Louisiana Offshore",
    32100: "NAD83 / Montana",
    32104: "NAD83 / Nebraska",
    32107: "NAD83 / Nevada East",
    32108: "NAD83 / Nevada Central",
    32109: "NAD83 / Nevada West",
    32110: "NAD83 / New Hampshire",
    32111: "NAD83 / New Jersey",
    32112: "NAD83 / New Mexico East",
    32113: "NAD83 / New Mexico Central",
    32114: "NAD83 / New Mexico West",
    32115: "NAD83 / New York East",
    32116: "NAD83 / New York Central",
    32117: "NAD83 / New York West",
    32118: "NAD83 / New York Long Island",
    32119: "NAD83 / North Carolina",
    32120: "NAD83 / North Dakota North",
    32121: "NAD83 / North Dakota South",
    32122: "NAD83 / Ohio North",
    32123: "NAD83 / Ohio South",
    32124: "NAD83 / Oklahoma North",
    32125: "NAD83 / Oklahoma South",
    32126: "NAD83 / Oregon North",
    32127: "NAD83 / Oregon South",
    32128: "NAD83 / Pennsylvania North",
    32129: "NAD83 / Pennsylvania South",
    32130: "NAD83 / Rhode Island",
    32133: "NAD83 / South Carolina",
    32134: "NAD83 / South Dakota North",
    32135: "NAD83 / South Dakota South",
    32136: "NAD83 / Tennessee",
    32137: "NAD83 / Texas North",
    32138: "NAD83 / Texas North Central",
    32139: "NAD83 / Texas Central",
    32140: "NAD83 / Texas South Central",
    32141: "NAD83 / Texas South",
    32142: "NAD83 / Utah North",
    32143: "NAD83 / Utah Central",
    32144: "NAD83 / Utah South",
    32145: "NAD83 / Vermont",
    32146: "NAD83 / Virginia North",
    32147: "NAD83 / Virginia South",
    32148: "NAD83 / Washington North",
    32149: "NAD83 / Washington South",
    32150: "NAD83 / West Virginia North",
    32151: "NAD83 / West Virginia South",
    32152: "NAD83 / Wisconsin North",
    32153: "NAD83 / Wisconsin Central",
    32154: "NAD83 / Wisconsin South",
    32155: "NAD83 / Wyoming East",
    32156: "NAD83 / Wyoming East Central",
    32157: "NAD83 / Wyoming West Central",
    32158: "NAD83 / Wyoming West",
    32161: "NAD83 / Puerto Rico & Virgin Is.",
    32164: "NAD83 / BLM 14N (ftUS)",
    32165: "NAD83 / BLM 15N (ftUS)",
    32166: "NAD83 / BLM 16N (ftUS)",
    32167: "NAD83 / BLM 17N (ftUS)",
    32180: "NAD83 / SCoPQ zone 2",
    32181: "NAD83 / MTM zone 1",
    32182: "NAD83 / MTM zone 2",
    32183: "NAD83 / MTM zone 3",
    32184: "NAD83 / MTM zone 4",
    32185: "NAD83 / MTM zone 5",
    32186: "NAD83 / MTM zone 6",
    32187: "NAD83 / MTM zone 7",
    32188: "NAD83 / MTM zone 8",
    32189: "NAD83 / MTM zone 9",
    32190: "NAD83 / MTM zone 10",
    32191: "NAD83 / MTM zone 11",
    32192: "NAD83 / MTM zone 12",
    32193: "NAD83 / MTM zone 13",
    32194: "NAD83 / MTM zone 14",
    32195: "NAD83 / MTM zone 15",
    32196: "NAD83 / MTM zone 16",
    32197: "NAD83 / MTM zone 17",
    32198: "NAD83 / Quebec Lambert",
    32199: "NAD83 / Louisiana Offshore",
    32201: "WGS 72 / UTM zone 1N",
    32202: "WGS 72 / UTM zone 2N",
    32203: "WGS 72 / UTM zone 3N",
    32204: "WGS 72 / UTM zone 4N",
    32205: "WGS 72 / UTM zone 5N",
    32206: "WGS 72 / UTM zone 6N",
    32207: "WGS 72 / UTM zone 7N",
    32208: "WGS 72 / UTM zone 8N",
    32209: "WGS 72 / UTM zone 9N",
    32210: "WGS 72 / UTM zone 10N",
    32211: "WGS 72 / UTM zone 11N",
    32212: "WGS 72 / UTM zone 12N",
    32213: "WGS 72 / UTM zone 13N",
    32214: "WGS 72 / UTM zone 14N",
    32215: "WGS 72 / UTM zone 15N",
    32216: "WGS 72 / UTM zone 16N",
    32217: "WGS 72 / UTM zone 17N",
    32218: "WGS 72 / UTM zone 18N",
    32219: "WGS 72 / UTM zone 19N",
    32220: "WGS 72 / UTM zone 20N",
    32221: "WGS 72 / UTM zone 21N",
    32222: "WGS 72 / UTM zone 22N",
    32223: "WGS 72 / UTM zone 23N",
    32224: "WGS 72 / UTM zone 24N",
    32225: "WGS 72 / UTM zone 25N",
    32226: "WGS 72 / UTM zone 26N",
    32227: "WGS 72 / UTM zone 27N",
    32228: "WGS 72 / UTM zone 28N",
    32229: "WGS 72 / UTM zone 29N",
    32230: "WGS 72 / UTM zone 30N",
    32231: "WGS 72 / UTM zone 31N",
    32232: "WGS 72 / UTM zone 32N",
    32233: "WGS 72 / UTM zone 33N",
    32234: "WGS 72 / UTM zone 34N",
    32235: "WGS 72 / UTM zone 35N",
    32236: "WGS 72 / UTM zone 36N",
    32237: "WGS 72 / UTM zone 37N",
    32238: "WGS 72 / UTM zone 38N",
    32239: "WGS 72 / UTM zone 39N",
    32240: "WGS 72 / UTM zone 40N",
    32241: "WGS 72 / UTM zone 41N",
    32242: "WGS 72 / UTM zone 42N",
    32243: "WGS 72 / UTM zone 43N",
    32244: "WGS 72 / UTM zone 44N",
    32245: "WGS 72 / UTM zone 45N",
    32246: "WGS 72 / UTM zone 46N",
    32247: "WGS 72 / UTM zone 47N",
    32248: "WGS 72 / UTM zone 48N",
    32249: "WGS 72 / UTM zone 49N",
    32250: "WGS 72 / UTM zone 50N",
    32251: "WGS 72 / UTM zone 51N",
    32252: "WGS 72 / UTM zone 52N",
    32253: "WGS 72 / UTM zone 53N",
    32254: "WGS 72 / UTM zone 54N",
    32255: "WGS 72 / UTM zone 55N",
    32256: "WGS 72 / UTM zone 56N",
    32257: "WGS 72 / UTM zone 57N",
    32258: "WGS 72 / UTM zone 58N",
    32259: "WGS 72 / UTM zone 59N",
    32260: "WGS 72 / UTM zone 60N",
    32301: "WGS 72 / UTM zone 1S",
    32302: "WGS 72 / UTM zone 2S",
    32303: "WGS 72 / UTM zone 3S",
    32304: "WGS 72 / UTM zone 4S",
    32305: "WGS 72 / UTM zone 5S",
    32306: "WGS 72 / UTM zone 6S",
    32307: "WGS 72 / UTM zone 7S",
    32308: "WGS 72 / UTM zone 8S",
    32309: "WGS 72 / UTM zone 9S",
    32310: "WGS 72 / UTM zone 10S",
    32311: "WGS 72 / UTM zone 11S",
    32312: "WGS 72 / UTM zone 12S",
    32313: "WGS 72 / UTM zone 13S",
    32314: "WGS 72 / UTM zone 14S",
    32315: "WGS 72 / UTM zone 15S",
    32316: "WGS 72 / UTM zone 16S",
    32317: "WGS 72 / UTM zone 17S",
    32318: "WGS 72 / UTM zone 18S",
    32319: "WGS 72 / UTM zone 19S",
    32320: "WGS 72 / UTM zone 20S",
    32321: "WGS 72 / UTM zone 21S",
    32322: "WGS 72 / UTM zone 22S",
    32323: "WGS 72 / UTM zone 23S",
    32324: "WGS 72 / UTM zone 24S",
    32325: "WGS 72 / UTM zone 25S",
    32326: "WGS 72 / UTM zone 26S",
    32327: "WGS 72 / UTM zone 27S",
    32328: "WGS 72 / UTM zone 28S",
    32329: "WGS 72 / UTM zone 29S",
    32330: "WGS 72 / UTM zone 30S",
    32331: "WGS 72 / UTM zone 31S",
    32332: "WGS 72 / UTM zone 32S",
    32333: "WGS 72 / UTM zone 33S",
    32334: "WGS 72 / UTM zone 34S",
    32335: "WGS 72 / UTM zone 35S",
    32336: "WGS 72 / UTM zone 36S",
    32337: "WGS 72 / UTM zone 37S",
    32338: "WGS 72 / UTM zone 38S",
    32339: "WGS 72 / UTM zone 39S",
    32340: "WGS 72 / UTM zone 40S",
    32341: "WGS 72 / UTM zone 41S",
    32342: "WGS 72 / UTM zone 42S",
    32343: "WGS 72 / UTM zone 43S",
    32344: "WGS 72 / UTM zone 44S",
    32345: "WGS 72 / UTM zone 45S",
    32346: "WGS 72 / UTM zone 46S",
    32347: "WGS 72 / UTM zone 47S",
    32348: "WGS 72 / UTM zone 48S",
    32349: "WGS 72 / UTM zone 49S",
    32350: "WGS 72 / UTM zone 50S",
    32351: "WGS 72 / UTM zone 51S",
    32352: "WGS 72 / UTM zone 52S",
    32353: "WGS 72 / UTM zone 53S",
    32354: "WGS 72 / UTM zone 54S",
    32355: "WGS 72 / UTM zone 55S",
    32356: "WGS 72 / UTM zone 56S",
    32357: "WGS 72 / UTM zone 57S",
    32358: "WGS 72 / UTM zone 58S",
    32359: "WGS 72 / UTM zone 59S",
    32360: "WGS 72 / UTM zone 60S",
    32401: "WGS 72BE / UTM zone 1N",
    32402: "WGS 72BE / UTM zone 2N",
    32403: "WGS 72BE / UTM zone 3N",
    32404: "WGS 72BE / UTM zone 4N",
    32405: "WGS 72BE / UTM zone 5N",
    32406: "WGS 72BE / UTM zone 6N",
    32407: "WGS 72BE / UTM zone 7N",
    32408: "WGS 72BE / UTM zone 8N",
    32409: "WGS 72BE / UTM zone 9N",
    32410: "WGS 72BE / UTM zone 10N",
    32411: "WGS 72BE / UTM zone 11N",
    32412: "WGS 72BE / UTM zone 12N",
    32413: "WGS 72BE / UTM zone 13N",
    32414: "WGS 72BE / UTM zone 14N",
    32415: "WGS 72BE / UTM zone 15N",
    32416: "WGS 72BE / UTM zone 16N",
    32417: "WGS 72BE / UTM zone 17N",
    32418: "WGS 72BE / UTM zone 18N",
    32419: "WGS 72BE / UTM zone 19N",
    32420: "WGS 72BE / UTM zone 20N",
    32421: "WGS 72BE / UTM zone 21N",
    32422: "WGS 72BE / UTM zone 22N",
    32423: "WGS 72BE / UTM zone 23N",
    32424: "WGS 72BE / UTM zone 24N",
    32425: "WGS 72BE / UTM zone 25N",
    32426: "WGS 72BE / UTM zone 26N",
    32427: "WGS 72BE / UTM zone 27N",
    32428: "WGS 72BE / UTM zone 28N",
    32429: "WGS 72BE / UTM zone 29N",
    32430: "WGS 72BE / UTM zone 30N",
    32431: "WGS 72BE / UTM zone 31N",
    32432: "WGS 72BE / UTM zone 32N",
    32433: "WGS 72BE / UTM zone 33N",
    32434: "WGS 72BE / UTM zone 34N",
    32435: "WGS 72BE / UTM zone 35N",
    32436: "WGS 72BE / UTM zone 36N",
    32437: "WGS 72BE / UTM zone 37N",
    32438: "WGS 72BE / UTM zone 38N",
    32439: "WGS 72BE / UTM zone 39N",
    32440: "WGS 72BE / UTM zone 40N",
    32441: "WGS 72BE / UTM zone 41N",
    32442: "WGS 72BE / UTM zone 42N",
    32443: "WGS 72BE / UTM zone 43N",
    32444: "WGS 72BE / UTM zone 44N",
    32445: "WGS 72BE / UTM zone 45N",
    32446: "WGS 72BE / UTM zone 46N",
    32447: "WGS 72BE / UTM zone 47N",
    32448: "WGS 72BE / UTM zone 48N",
    32449: "WGS 72BE / UTM zone 49N",
    32450: "WGS 72BE / UTM zone 50N",
    32451: "WGS 72BE / UTM zone 51N",
    32452: "WGS 72BE / UTM zone 52N",
    32453: "WGS 72BE / UTM zone 53N",
    32454: "WGS 72BE / UTM zone 54N",
    32455: "WGS 72BE / UTM zone 55N",
    32456: "WGS 72BE / UTM zone 56N",
    32457: "WGS 72BE / UTM zone 57N",
    32458: "WGS 72BE / UTM zone 58N",
    32459: "WGS 72BE / UTM zone 59N",
    32460: "WGS 72BE / UTM zone 60N",
    32501: "WGS 72BE / UTM zone 1S",
    32502: "WGS 72BE / UTM zone 2S",
    32503: "WGS 72BE / UTM zone 3S",
    32504: "WGS 72BE / UTM zone 4S",
    32505: "WGS 72BE / UTM zone 5S",
    32506: "WGS 72BE / UTM zone 6S",
    32507: "WGS 72BE / UTM zone 7S",
    32508: "WGS 72BE / UTM zone 8S",
    32509: "WGS 72BE / UTM zone 9S",
    32510: "WGS 72BE / UTM zone 10S",
    32511: "WGS 72BE / UTM zone 11S",
    32512: "WGS 72BE / UTM zone 12S",
    32513: "WGS 72BE / UTM zone 13S",
    32514: "WGS 72BE / UTM zone 14S",
    32515: "WGS 72BE / UTM zone 15S",
    32516: "WGS 72BE / UTM zone 16S",
    32517: "WGS 72BE / UTM zone 17S",
    32518: "WGS 72BE / UTM zone 18S",
    32519: "WGS 72BE / UTM zone 19S",
    32520: "WGS 72BE / UTM zone 20S",
    32521: "WGS 72BE / UTM zone 21S",
    32522: "WGS 72BE / UTM zone 22S",
    32523: "WGS 72BE / UTM zone 23S",
    32524: "WGS 72BE / UTM zone 24S",
    32525: "WGS 72BE / UTM zone 25S",
    32526: "WGS 72BE / UTM zone 26S",
    32527: "WGS 72BE / UTM zone 27S",
    32528: "WGS 72BE / UTM zone 28S",
    32529: "WGS 72BE / UTM zone 29S",
    32530: "WGS 72BE / UTM zone 30S",
    32531: "WGS 72BE / UTM zone 31S",
    32532: "WGS 72BE / UTM zone 32S",
    32533: "WGS 72BE / UTM zone 33S",
    32534: "WGS 72BE / UTM zone 34S",
    32535: "WGS 72BE / UTM zone 35S",
    32536: "WGS 72BE / UTM zone 36S",
    32537: "WGS 72BE / UTM zone 37S",
    32538: "WGS 72BE / UTM zone 38S",
    32539: "WGS 72BE / UTM zone 39S",
    32540: "WGS 72BE / UTM zone 40S",
    32541: "WGS 72BE / UTM zone 41S",
    32542: "WGS 72BE / UTM zone 42S",
    32543: "WGS 72BE / UTM zone 43S",
    32544: "WGS 72BE / UTM zone 44S",
    32545: "WGS 72BE / UTM zone 45S",
    32546: "WGS 72BE / UTM zone 46S",
    32547: "WGS 72BE / UTM zone 47S",
    32548: "WGS 72BE / UTM zone 48S",
    32549: "WGS 72BE / UTM zone 49S",
    32550: "WGS 72BE / UTM zone 50S",
    32551: "WGS 72BE / UTM zone 51S",
    32552: "WGS 72BE / UTM zone 52S",
    32553: "WGS 72BE / UTM zone 53S",
    32554: "WGS 72BE / UTM zone 54S",
    32555: "WGS 72BE / UTM zone 55S",
    32556: "WGS 72BE / UTM zone 56S",
    32557: "WGS 72BE / UTM zone 57S",
    32558: "WGS 72BE / UTM zone 58S",
    32559: "WGS 72BE / UTM zone 59S",
    32560: "WGS 72BE / UTM zone 60S",
    32600: "WGS 84 / UTM grid system (northern hemisphere)",
    32601: "WGS 84 / UTM zone 1N",
    32602: "WGS 84 / UTM zone 2N",
    32603: "WGS 84 / UTM zone 3N",
    32604: "WGS 84 / UTM zone 4N",
    32605: "WGS 84 / UTM zone 5N",
    32606: "WGS 84 / UTM zone 6N",
    32607: "WGS 84 / UTM zone 7N",
    32608: "WGS 84 / UTM zone 8N",
    32609: "WGS 84 / UTM zone 9N",
    32610: "WGS 84 / UTM zone 10N",
    32611: "WGS 84 / UTM zone 11N",
    32612: "WGS 84 / UTM zone 12N",
    32613: "WGS 84 / UTM zone 13N",
    32614: "WGS 84 / UTM zone 14N",
    32615: "WGS 84 / UTM zone 15N",
    32616: "WGS 84 / UTM zone 16N",
    32617: "WGS 84 / UTM zone 17N",
    32618: "WGS 84 / UTM zone 18N",
    32619: "WGS 84 / UTM zone 19N",
    32620: "WGS 84 / UTM zone 20N",
    32621: "WGS 84 / UTM zone 21N",
    32622: "WGS 84 / UTM zone 22N",
    32623: "WGS 84 / UTM zone 23N",
    32624: "WGS 84 / UTM zone 24N",
    32625: "WGS 84 / UTM zone 25N",
    32626: "WGS 84 / UTM zone 26N",
    32627: "WGS 84 / UTM zone 27N",
    32628: "WGS 84 / UTM zone 28N",
    32629: "WGS 84 / UTM zone 29N",
    32630: "WGS 84 / UTM zone 30N",
    32631: "WGS 84 / UTM zone 31N",
    32632: "WGS 84 / UTM zone 32N",
    32633: "WGS 84 / UTM zone 33N",
    32634: "WGS 84 / UTM zone 34N",
    32635: "WGS 84 / UTM zone 35N",
    32636: "WGS 84 / UTM zone 36N",
    32637: "WGS 84 / UTM zone 37N",
    32638: "WGS 84 / UTM zone 38N",
    32639: "WGS 84 / UTM zone 39N",
    32640: "WGS 84 / UTM zone 40N",
    32641: "WGS 84 / UTM zone 41N",
    32642: "WGS 84 / UTM zone 42N",
    32643: "WGS 84 / UTM zone 43N",
    32644: "WGS 84 / UTM zone 44N",
    32645: "WGS 84 / UTM zone 45N",
    32646: "WGS 84 / UTM zone 46N",
    32647: "WGS 84 / UTM zone 47N",
    32648: "WGS 84 / UTM zone 48N",
    32649: "WGS 84 / UTM zone 49N",
    32650: "WGS 84 / UTM zone 50N",
    32651: "WGS 84 / UTM zone 51N",
    32652: "WGS 84 / UTM zone 52N",
    32653: "WGS 84 / UTM zone 53N",
    32654: "WGS 84 / UTM zone 54N",
    32655: "WGS 84 / UTM zone 55N",
    32656: "WGS 84 / UTM zone 56N",
    32657: "WGS 84 / UTM zone 57N",
    32658: "WGS 84 / UTM zone 58N",
    32659: "WGS 84 / UTM zone 59N",
    32660: "WGS 84 / UTM zone 60N",
    32661: "WGS 84 / UPS North (N,E)",
    32662: "WGS 84 / Plate Carree",
    32663: "WGS 84 / World Equidistant Cylindrical",
    32664: "WGS 84 / BLM 14N (ftUS)",
    32665: "WGS 84 / BLM 15N (ftUS)",
    32666: "WGS 84 / BLM 16N (ftUS)",
    32667: "WGS 84 / BLM 17N (ftUS)",
    32700: "WGS 84 / UTM grid system (southern hemisphere)",
    32701: "WGS 84 / UTM zone 1S",
    32702: "WGS 84 / UTM zone 2S",
    32703: "WGS 84 / UTM zone 3S",
    32704: "WGS 84 / UTM zone 4S",
    32705: "WGS 84 / UTM zone 5S",
    32706: "WGS 84 / UTM zone 6S",
    32707: "WGS 84 / UTM zone 7S",
    32708: "WGS 84 / UTM zone 8S",
    32709: "WGS 84 / UTM zone 9S",
    32710: "WGS 84 / UTM zone 10S",
    32711: "WGS 84 / UTM zone 11S",
    32712: "WGS 84 / UTM zone 12S",
    32713: "WGS 84 / UTM zone 13S",
    32714: "WGS 84 / UTM zone 14S",
    32715: "WGS 84 / UTM zone 15S",
    32716: "WGS 84 / UTM zone 16S",
    32717: "WGS 84 / UTM zone 17S",
    32718: "WGS 84 / UTM zone 18S",
    32719: "WGS 84 / UTM zone 19S",
    32720: "WGS 84 / UTM zone 20S",
    32721: "WGS 84 / UTM zone 21S",
    32722: "WGS 84 / UTM zone 22S",
    32723: "WGS 84 / UTM zone 23S",
    32724: "WGS 84 / UTM zone 24S",
    32725: "WGS 84 / UTM zone 25S",
    32726: "WGS 84 / UTM zone 26S",
    32727: "WGS 84 / UTM zone 27S",
    32728: "WGS 84 / UTM zone 28S",
    32729: "WGS 84 / UTM zone 29S",
    32730: "WGS 84 / UTM zone 30S",
    32731: "WGS 84 / UTM zone 31S",
    32732: "WGS 84 / UTM zone 32S",
    32733: "WGS 84 / UTM zone 33S",
    32734: "WGS 84 / UTM zone 34S",
    32735: "WGS 84 / UTM zone 35S",
    32736: "WGS 84 / UTM zone 36S",
    32737: "WGS 84 / UTM zone 37S",
    32738: "WGS 84 / UTM zone 38S",
    32739: "WGS 84 / UTM zone 39S",
    32740: "WGS 84 / UTM zone 40S",
    32741: "WGS 84 / UTM zone 41S",
    32742: "WGS 84 / UTM zone 42S",
    32743: "WGS 84 / UTM zone 43S",
    32744: "WGS 84 / UTM zone 44S",
    32745: "WGS 84 / UTM zone 45S",
    32746: "WGS 84 / UTM zone 46S",
    32747: "WGS 84 / UTM zone 47S",
    32748: "WGS 84 / UTM zone 48S",
    32749: "WGS 84 / UTM zone 49S",
    32750: "WGS 84 / UTM zone 50S",
    32751: "WGS 84 / UTM zone 51S",
    32752: "WGS 84 / UTM zone 52S",
    32753: "WGS 84 / UTM zone 53S",
    32754: "WGS 84 / UTM zone 54S",
    32755: "WGS 84 / UTM zone 55S",
    32756: "WGS 84 / UTM zone 56S",
    32757: "WGS 84 / UTM zone 57S",
    32758: "WGS 84 / UTM zone 58S",
    32759: "WGS 84 / UTM zone 59S",
    32760: "WGS 84 / UTM zone 60S",
    32761: "WGS 84 / UPS South (N,E)",
    32766: "WGS 84 / TM 36 SE",
    32767: "User-defined"
}


ProjectionGeoKey = {
    10101: "Proj_Alabama_CS27_East",
    10102: "Proj_Alabama_CS27_West",
    10131: "Proj_Alabama_CS83_East",
    10132: "Proj_Alabama_CS83_West",
    10201: "Proj_Arizona_Coordinate_System_east",
    10202: "Proj_Arizona_Coordinate_System_Central",
    10203: "Proj_Arizona_Coordinate_System_west",
    10231: "Proj_Arizona_CS83_east",
    10232: "Proj_Arizona_CS83_Central",
    10233: "Proj_Arizona_CS83_west",
    10301: "Proj_Arkansas_CS27_North",
    10302: "Proj_Arkansas_CS27_South",
    10331: "Proj_Arkansas_CS83_North",
    10332: "Proj_Arkansas_CS83_South",
    10401: "Proj_California_CS27_I",
    10402: "Proj_California_CS27_II",
    10403: "Proj_California_CS27_III",
    10404: "Proj_California_CS27_IV",
    10405: "Proj_California_CS27_V",
    10406: "Proj_California_CS27_VI",
    10407: "Proj_California_CS27_VII",
    10431: "Proj_California_CS83_1",
    10432: "Proj_California_CS83_2",
    10433: "Proj_California_CS83_3",
    10434: "Proj_California_CS83_4",
    10435: "Proj_California_CS83_5",
    10436: "Proj_California_CS83_6",
    10501: "Proj_Colorado_CS27_North",
    10502: "Proj_Colorado_CS27_Central",
    10503: "Proj_Colorado_CS27_South",
    10531: "Proj_Colorado_CS83_North",
    10532: "Proj_Colorado_CS83_Central",
    10533: "Proj_Colorado_CS83_South",
    10600: "Proj_Connecticut_CS27",
    10630: "Proj_Connecticut_CS83",
    10700: "Proj_Delaware_CS27",
    10730: "Proj_Delaware_CS83",
    10901: "Proj_Florida_CS27_East",
    10902: "Proj_Florida_CS27_West",
    10903: "Proj_Florida_CS27_North",
    10931: "Proj_Florida_CS83_East",
    10932: "Proj_Florida_CS83_West",
    10933: "Proj_Florida_CS83_North",
    11001: "Proj_Georgia_CS27_East",
    11002: "Proj_Georgia_CS27_West",
    11031: "Proj_Georgia_CS83_East",
    11032: "Proj_Georgia_CS83_West",
    11101: "Proj_Idaho_CS27_East",
    11102: "Proj_Idaho_CS27_Central",
    11103: "Proj_Idaho_CS27_West",
    11131: "Proj_Idaho_CS83_East",
    11132: "Proj_Idaho_CS83_Central",
    11133: "Proj_Idaho_CS83_West",
    11201: "Proj_Illinois_CS27_East",
    11202: "Proj_Illinois_CS27_West",
    11231: "Proj_Illinois_CS83_East",
    11232: "Proj_Illinois_CS83_West",
    11301: "Proj_Indiana_CS27_East",
    11302: "Proj_Indiana_CS27_West",
    11331: "Proj_Indiana_CS83_East",
    11332: "Proj_Indiana_CS83_West",
    11401: "Proj_Iowa_CS27_North",
    11402: "Proj_Iowa_CS27_South",
    11431: "Proj_Iowa_CS83_North",
    11432: "Proj_Iowa_CS83_South",
    11501: "Proj_Kansas_CS27_North",
    11502: "Proj_Kansas_CS27_South",
    11531: "Proj_Kansas_CS83_North",
    11532: "Proj_Kansas_CS83_South",
    11601: "Proj_Kentucky_CS27_North",
    11602: "Proj_Kentucky_CS27_South",
    11631: "Proj_Kentucky_CS83_North",
    11632: "Proj_Kentucky_CS83_South",
    11701: "Proj_Louisiana_CS27_North",
    11702: "Proj_Louisiana_CS27_South",
    11731: "Proj_Louisiana_CS83_North",
    11732: "Proj_Louisiana_CS83_South",
    11801: "Proj_Maine_CS27_East",
    11802: "Proj_Maine_CS27_West",
    11831: "Proj_Maine_CS83_East",
    11832: "Proj_Maine_CS83_West",
    11900: "Proj_Maryland_CS27",
    11930: "Proj_Maryland_CS83",
    12001: "Proj_Massachusetts_CS27_Mainland",
    12002: "Proj_Massachusetts_CS27_Island",
    12031: "Proj_Massachusetts_CS83_Mainland",
    12032: "Proj_Massachusetts_CS83_Island",
    12101: "Proj_Michigan_State_Plane_East",
    12102: "Proj_Michigan_State_Plane_Old_Central",
    12103: "Proj_Michigan_State_Plane_West",
    12111: "Proj_Michigan_CS27_North",
    12112: "Proj_Michigan_CS27_Central",
    12113: "Proj_Michigan_CS27_South",
    12141: "Proj_Michigan_CS83_North",
    12142: "Proj_Michigan_CS83_Central",
    12143: "Proj_Michigan_CS83_South",
    12201: "Proj_Minnesota_CS27_North",
    12202: "Proj_Minnesota_CS27_Central",
    12203: "Proj_Minnesota_CS27_South",
    12231: "Proj_Minnesota_CS83_North",
    12232: "Proj_Minnesota_CS83_Central",
    12233: "Proj_Minnesota_CS83_South",
    12301: "Proj_Mississippi_CS27_East",
    12302: "Proj_Mississippi_CS27_West",
    12331: "Proj_Mississippi_CS83_East",
    12332: "Proj_Mississippi_CS83_West",
    12401: "Proj_Missouri_CS27_East",
    12402: "Proj_Missouri_CS27_Central",
    12403: "Proj_Missouri_CS27_West",
    12431: "Proj_Missouri_CS83_East",
    12432: "Proj_Missouri_CS83_Central",
    12433: "Proj_Missouri_CS83_West",
    12501: "Proj_Montana_CS27_North",
    12502: "Proj_Montana_CS27_Central",
    12503: "Proj_Montana_CS27_South",
    12530: "Proj_Montana_CS83",
    12601: "Proj_Nebraska_CS27_North",
    12602: "Proj_Nebraska_CS27_South",
    12630: "Proj_Nebraska_CS83",
    12701: "Proj_Nevada_CS27_East",
    12702: "Proj_Nevada_CS27_Central",
    12703: "Proj_Nevada_CS27_West",
    12731: "Proj_Nevada_CS83_East",
    12732: "Proj_Nevada_CS83_Central",
    12733: "Proj_Nevada_CS83_West",
    12800: "Proj_New_Hampshire_CS27",
    12830: "Proj_New_Hampshire_CS83",
    12900: "Proj_New_Jersey_CS27",
    12930: "Proj_New_Jersey_CS83",
    13001: "Proj_New_Mexico_CS27_East",
    13002: "Proj_New_Mexico_CS27_Central",
    13003: "Proj_New_Mexico_CS27_West",
    13031: "Proj_New_Mexico_CS83_East",
    13032: "Proj_New_Mexico_CS83_Central",
    13033: "Proj_New_Mexico_CS83_West",
    13101: "Proj_New_York_CS27_East",
    13102: "Proj_New_York_CS27_Central",
    13103: "Proj_New_York_CS27_West",
    13104: "Proj_New_York_CS27_Long_Island",
    13131: "Proj_New_York_CS83_East",
    13132: "Proj_New_York_CS83_Central",
    13133: "Proj_New_York_CS83_West",
    13134: "Proj_New_York_CS83_Long_Island",
    13200: "Proj_North_Carolina_CS27",
    13230: "Proj_North_Carolina_CS83",
    13301: "Proj_North_Dakota_CS27_North",
    13302: "Proj_North_Dakota_CS27_South",
    13331: "Proj_North_Dakota_CS83_North",
    13332: "Proj_North_Dakota_CS83_South",
    13401: "Proj_Ohio_CS27_North",
    13402: "Proj_Ohio_CS27_South",
    13431: "Proj_Ohio_CS83_North",
    13432: "Proj_Ohio_CS83_South",
    13501: "Proj_Oklahoma_CS27_North",
    13502: "Proj_Oklahoma_CS27_South",
    13531: "Proj_Oklahoma_CS83_North",
    13532: "Proj_Oklahoma_CS83_South",
    13601: "Proj_Oregon_CS27_North",
    13602: "Proj_Oregon_CS27_South",
    13631: "Proj_Oregon_CS83_North",
    13632: "Proj_Oregon_CS83_South",
    13701: "Proj_Pennsylvania_CS27_North",
    13702: "Proj_Pennsylvania_CS27_South",
    13731: "Proj_Pennsylvania_CS83_North",
    13732: "Proj_Pennsylvania_CS83_South",
    13800: "Proj_Rhode_Island_CS27",
    13830: "Proj_Rhode_Island_CS83",
    13901: "Proj_South_Carolina_CS27_North",
    13902: "Proj_South_Carolina_CS27_South",
    13930: "Proj_South_Carolina_CS83",
    14001: "Proj_South_Dakota_CS27_North",
    14002: "Proj_South_Dakota_CS27_South",
    14031: "Proj_South_Dakota_CS83_North",
    14032: "Proj_South_Dakota_CS83_South",
    14100: "Proj_Tennessee_CS27",
    14130: "Proj_Tennessee_CS83",
    14201: "Proj_Texas_CS27_North",
    14202: "Proj_Texas_CS27_North_Central",
    14203: "Proj_Texas_CS27_Central",
    14204: "Proj_Texas_CS27_South_Central",
    14205: "Proj_Texas_CS27_South",
    14231: "Proj_Texas_CS83_North",
    14232: "Proj_Texas_CS83_North_Central",
    14233: "Proj_Texas_CS83_Central",
    14234: "Proj_Texas_CS83_South_Central",
    14235: "Proj_Texas_CS83_South",
    14301: "Proj_Utah_CS27_North",
    14302: "Proj_Utah_CS27_Central",
    14303: "Proj_Utah_CS27_South",
    14331: "Proj_Utah_CS83_North",
    14332: "Proj_Utah_CS83_Central",
    14333: "Proj_Utah_CS83_South",
    14400: "Proj_Vermont_CS27",
    14430: "Proj_Vermont_CS83",
    14501: "Proj_Virginia_CS27_North",
    14502: "Proj_Virginia_CS27_South",
    14531: "Proj_Virginia_CS83_North",
    14532: "Proj_Virginia_CS83_South",
    14601: "Proj_Washington_CS27_North",
    14602: "Proj_Washington_CS27_South",
    14631: "Proj_Washington_CS83_North",
    14632: "Proj_Washington_CS83_South",
    14701: "Proj_West_Virginia_CS27_North",
    14702: "Proj_West_Virginia_CS27_South",
    14731: "Proj_West_Virginia_CS83_North",
    14732: "Proj_West_Virginia_CS83_South",
    14801: "Proj_Wisconsin_CS27_North",
    14802: "Proj_Wisconsin_CS27_Central",
    14803: "Proj_Wisconsin_CS27_South",
    14831: "Proj_Wisconsin_CS83_North",
    14832: "Proj_Wisconsin_CS83_Central",
    14833: "Proj_Wisconsin_CS83_South",
    14901: "Proj_Wyoming_CS27_East",
    14902: "Proj_Wyoming_CS27_East_Central",
    14903: "Proj_Wyoming_CS27_West_Central",
    14904: "Proj_Wyoming_CS27_West",
    14931: "Proj_Wyoming_CS83_East",
    14932: "Proj_Wyoming_CS83_East_Central",
    14933: "Proj_Wyoming_CS83_West_Central",
    14934: "Proj_Wyoming_CS83_West",
    15001: "Proj_Alaska_CS27_1",
    15002: "Proj_Alaska_CS27_2",
    15003: "Proj_Alaska_CS27_3",
    15004: "Proj_Alaska_CS27_4",
    15005: "Proj_Alaska_CS27_5",
    15006: "Proj_Alaska_CS27_6",
    15007: "Proj_Alaska_CS27_7",
    15008: "Proj_Alaska_CS27_8",
    15009: "Proj_Alaska_CS27_9",
    15010: "Proj_Alaska_CS27_10",
    15031: "Proj_Alaska_CS83_1",
    15032: "Proj_Alaska_CS83_2",
    15033: "Proj_Alaska_CS83_3",
    15034: "Proj_Alaska_CS83_4",
    15035: "Proj_Alaska_CS83_5",
    15036: "Proj_Alaska_CS83_6",
    15037: "Proj_Alaska_CS83_7",
    15038: "Proj_Alaska_CS83_8",
    15039: "Proj_Alaska_CS83_9",
    15040: "Proj_Alaska_CS83_10",
    15101: "Proj_Hawaii_CS27_1",
    15102: "Proj_Hawaii_CS27_2",
    15103: "Proj_Hawaii_CS27_3",
    15104: "Proj_Hawaii_CS27_4",
    15105: "Proj_Hawaii_CS27_5",
    15131: "Proj_Hawaii_CS83_1",
    15132: "Proj_Hawaii_CS83_2",
    15133: "Proj_Hawaii_CS83_3",
    15134: "Proj_Hawaii_CS83_4",
    15135: "Proj_Hawaii_CS83_5",
    15201: "Proj_Puerto_Rico_CS27",
    15202: "Proj_St_Croix",
    15230: "Proj_Puerto_Rico_Virgin_Is",
    15914: "Proj_BLM_14N_feet",
    15915: "Proj_BLM_15N_feet",
    15916: "Proj_BLM_16N_feet",
    15917: "Proj_BLM_17N_feet",
    17348: "Proj_Map_Grid_of_Australia_48",
    17349: "Proj_Map_Grid_of_Australia_49",
    17350: "Proj_Map_Grid_of_Australia_50",
    17351: "Proj_Map_Grid_of_Australia_51",
    17352: "Proj_Map_Grid_of_Australia_52",
    17353: "Proj_Map_Grid_of_Australia_53",
    17354: "Proj_Map_Grid_of_Australia_54",
    17355: "Proj_Map_Grid_of_Australia_55",
    17356: "Proj_Map_Grid_of_Australia_56",
    17357: "Proj_Map_Grid_of_Australia_57",
    17358: "Proj_Map_Grid_of_Australia_58",
    17448: "Proj_Australian_Map_Grid_48",
    17449: "Proj_Australian_Map_Grid_49",
    17450: "Proj_Australian_Map_Grid_50",
    17451: "Proj_Australian_Map_Grid_51",
    17452: "Proj_Australian_Map_Grid_52",
    17453: "Proj_Australian_Map_Grid_53",
    17454: "Proj_Australian_Map_Grid_54",
    17455: "Proj_Australian_Map_Grid_55",
    17456: "Proj_Australian_Map_Grid_56",
    17457: "Proj_Australian_Map_Grid_57",
    17458: "Proj_Australian_Map_Grid_58",
    18031: "Proj_Argentina_1",
    18032: "Proj_Argentina_2",
    18033: "Proj_Argentina_3",
    18034: "Proj_Argentina_4",
    18035: "Proj_Argentina_5",
    18036: "Proj_Argentina_6",
    18037: "Proj_Argentina_7",
    18051: "Proj_Colombia_3W",
    18052: "Proj_Colombia_Bogota",
    18053: "Proj_Colombia_3E",
    18054: "Proj_Colombia_6E",
    18072: "Proj_Egypt_Red_Belt",
    18073: "Proj_Egypt_Purple_Belt",
    18074: "Proj_Extended_Purple_Belt",
    18141: "Proj_New_Zealand_North_Island_Nat_Grid",
    18142: "Proj_New_Zealand_South_Island_Nat_Grid",
    19900: "Proj_Bahrain_Grid",
    19905: "Proj_Netherlands_E_Indies_Equatorial",
    19912: "Proj_RSO_Borneo",
    32767: "User-defined"
}

InteropIndex = {
    b'R03' : "R03 - DCF option file (Adobe RGB)",
    b'R98' : "R98 - DCF basic file (sRGB)",
    b'THM' : "THM - DCF thumbnail file",
    b'R03\x00' : "R03 - DCF option file (Adobe RGB)",
    b'R98\x00' : "R98 - DCF basic file (sRGB)",
    b'THM\x00' : "THM - DCF thumbnail file"
}
