"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstanceSecurityIps = exports.DBInstanceSecurityIpsProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "DBInstanceSecurityIpsProperty", { enumerable: true, get: function () { return rds_generated_1.RosDBInstanceSecurityIps; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::DBInstanceSecurityIps`
 */
class DBInstanceSecurityIps extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::DBInstanceSecurityIps`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstanceSecurityIps = new rds_generated_1.RosDBInstanceSecurityIps(this, id, {
            dbInstanceIpArrayAttribute: props.dbInstanceIpArrayAttribute,
            dbInstanceId: props.dbInstanceId,
            dbInstanceIpArrayName: props.dbInstanceIpArrayName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstanceSecurityIps;
        this.attrSecurityIps = rosDBInstanceSecurityIps.attrSecurityIps;
    }
}
exports.DBInstanceSecurityIps = DBInstanceSecurityIps;
//# sourceMappingURL=data:application/json;base64,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