from setuptools import setup
from setuptools import find_packages

setup(
    name="logodetect",
    version="1.1.1",
    description="One-shot logo detection for videos and images.",
    long_description="One-shot logo detection for videos and images.",
    url="https://github.com/Heldenkombinat/logodetect",
    download_url="https://github.com/Heldenkombinat/logodetect/tarball/1.1.0",
    author="Jorge Davila Chacon",
    author_email="jorge@heldenkombinat.com",
    install_requires=[
        "click>=7.1.1",
        "Cython>=0.29.15",
        "Flask>=1.1.1",
        "Flask-Cors>=3.0.9",
        "gunicorn>=20.0.4",
        "imgaug>=0.4.0",
        "matplotlib>=2.2.5",
        "moviepy>=1.0.1",
        "numpy>=1.18.2",
        "opencv-python>=4.2.0.32",
        "pandas>=1.0.3",
        "pytest>=6.2.4",
        "scikit-image>=0.16.2",
        "scikit-learn>=0.22.1",
        "scipy>=1.4.1",
        "torch>=1.9.0",
        "torchvision>=0.10.0",
        "tqdm>=4.42.1",
    ],
    extras_require={
        "tests": ["pytest", "pytest-pep8", "pytest-cov", "mock", "pylint", "autopep8"],
        "dev": ["black", "pre-commit", "flask", "gunicorn"],
    },
    entry_points={"console_scripts": ["logodetect=logodetect.cli:cli"]},
    packages=find_packages(),
    license="GNU AGPLv3",
    zip_safe=False,
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Environment :: Console",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
    ],
)
