"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chain = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const parallel_1 = require("./states/parallel");
/**
 * A collection of states to chain onto
 *
 * A Chain has a start and zero or more chainable ends. If there are
 * zero ends, calling next() on the Chain will fail.
 */
class Chain {
    constructor(startState, endStates, lastAdded) {
        this.lastAdded = lastAdded;
        this.id = lastAdded.id;
        this.startState = startState;
        this.endStates = endStates;
    }
    /**
     * Begin a new Chain from one chainable
     */
    static start(state) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_IChainable(state);
        return new Chain(state.startState, state.endStates, state);
    }
    /**
     * Make a Chain with the start from one chain and the ends from another
     */
    static sequence(start, next) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_IChainable(start);
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_IChainable(next);
        return new Chain(start.startState, next.endStates, next);
    }
    /**
     * Make a Chain with specific start and end states, and a last-added Chainable
     */
    static custom(startState, endStates, lastAdded) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_State(startState);
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_IChainable(lastAdded);
        return new Chain(startState, endStates, lastAdded);
    }
    /**
     * Continue normal execution with the given state
     */
    next(next) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_IChainable(next);
        if (this.endStates.length === 0) {
            throw new Error(`Cannot add to chain: last state in chain (${this.lastAdded.id}) does not allow it`);
        }
        for (const endState of this.endStates) {
            endState.next(next);
        }
        return new Chain(this.startState, next.endStates, next);
    }
    /**
     * Return a single state that encompasses all states in the chain
     *
     * This can be used to add error handling to a sequence of states.
     *
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     */
    toSingleState(id, props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_ParallelProps(props);
        return new parallel_1.Parallel(this.startState, id, props).branch(this);
    }
}
exports.Chain = Chain;
_a = JSII_RTTI_SYMBOL_1;
Chain[_a] = { fqn: "@aws-cdk/aws-stepfunctions.Chain", version: "1.148.0" };
//# sourceMappingURL=data:application/json;base64,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