"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DropSpamReceiptRule = exports.ReceiptRule = exports.TlsPolicy = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const ses_generated_1 = require("./ses.generated");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * The type of TLS policy for a receipt rule.
 */
var TlsPolicy;
(function (TlsPolicy) {
    /**
     * Do not check for TLS.
     */
    TlsPolicy["OPTIONAL"] = "Optional";
    /**
     * Bounce emails that are not received over TLS.
     */
    TlsPolicy["REQUIRE"] = "Require";
})(TlsPolicy = exports.TlsPolicy || (exports.TlsPolicy = {}));
/**
 * A new receipt rule.
 */
class ReceiptRule extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.receiptRuleName,
        });
        this.actions = new Array();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_ReceiptRuleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ReceiptRule);
            }
            throw error;
        }
        const resource = new ses_generated_1.CfnReceiptRule(this, 'Resource', {
            after: props.after?.receiptRuleName,
            rule: {
                actions: core_1.Lazy.any({ produce: () => this.renderActions() }),
                enabled: props.enabled ?? true,
                name: this.physicalName,
                recipients: props.recipients,
                scanEnabled: props.scanEnabled,
                tlsPolicy: props.tlsPolicy,
            },
            ruleSetName: props.ruleSet.receiptRuleSetName,
        });
        this.receiptRuleName = resource.ref;
        for (const action of props.actions || []) {
            this.addAction(action);
        }
    }
    static fromReceiptRuleName(scope, id, receiptRuleName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.receiptRuleName = receiptRuleName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Adds an action to this receipt rule.
     */
    addAction(action) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_IReceiptRuleAction(action);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addAction);
            }
            throw error;
        }
        this.actions.push(action.bind(this));
    }
    renderActions() {
        if (this.actions.length === 0) {
            return undefined;
        }
        return this.actions;
    }
}
exports.ReceiptRule = ReceiptRule;
_a = JSII_RTTI_SYMBOL_1;
ReceiptRule[_a] = { fqn: "@aws-cdk/aws-ses.ReceiptRule", version: "1.190.0" };
/**
 * A rule added at the top of the rule set to drop spam/virus.
 *
 * @see https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda-example-functions.html
 */
class DropSpamReceiptRule extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_DropSpamReceiptRuleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DropSpamReceiptRule);
            }
            throw error;
        }
        const fn = new lambda.SingletonFunction(this, 'Function', {
            runtime: lambda.Runtime.NODEJS_14_X,
            handler: 'index.handler',
            code: lambda.Code.fromAsset(path.join(__dirname, 'drop-spam-handler')),
            uuid: '224e77f9-a32e-4b4d-ac32-983477abba16',
        });
        fn.addPermission('AllowSes', {
            action: 'lambda:InvokeFunction',
            principal: new iam.ServicePrincipal('ses.amazonaws.com'),
            sourceAccount: core_1.Aws.ACCOUNT_ID,
        });
        this.rule = new ReceiptRule(this, 'Rule', {
            actions: [
                {
                    bind: () => ({
                        lambdaAction: {
                            functionArn: fn.functionArn,
                            invocationType: 'RequestResponse',
                        },
                    }),
                },
            ],
            scanEnabled: true,
            ruleSet: props.ruleSet,
        });
    }
}
exports.DropSpamReceiptRule = DropSpamReceiptRule;
_b = JSII_RTTI_SYMBOL_1;
DropSpamReceiptRule[_b] = { fqn: "@aws-cdk/aws-ses.DropSpamReceiptRule", version: "1.190.0" };
//# sourceMappingURL=data:application/json;base64,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