"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateTestDistro = void 0;
const core_1 = require("@aws-solutions-constructs/core");
const cloudfront = require("aws-cdk-lib/aws-cloudfront");
const origins = require("aws-cdk-lib/aws-cloudfront-origins");
function CreateTestDistro(stack, id) {
    const newDistro = new cloudfront.Distribution(stack, id, {
        defaultBehavior: {
            origin: new origins.OriginGroup({
                primaryOrigin: new origins.HttpOrigin("www.example.com"),
                fallbackOrigin: new origins.HttpOrigin("admin.example.com"),
                // optional, defaults to: 500, 502, 503 and 504
                fallbackStatusCodes: [404],
            }),
        },
    });
    core_1.addCfnSuppressRules(newDistro, [{ id: "W10", reason: "Test Resource" }]);
    core_1.addCfnSuppressRules(newDistro, [{ id: "W70", reason: "Test Resource" }]);
    return newDistro;
}
exports.CreateTestDistro = CreateTestDistro;
//# sourceMappingURL=data:application/json;base64,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