# -*- coding: utf-8 -*-
"""Command line interface for Axonius API Client."""
from ..context import CONTEXT_SETTINGS, click
from ..options import add_options
from .grp_common import get_handler as handler
from .grp_options import GET as OPTIONS

METHOD = "get"


@click.command(name=METHOD, context_settings=CONTEXT_SETTINGS)
@add_options(OPTIONS)
@click.pass_context
def cmd(ctx, url, key, secret, **kwargs):
    """Get connections for an adapter."""
    handler(ctx=ctx, url=url, key=key, secret=secret, **kwargs)


# -*- coding: utf-8 -*-
# """Command line interface for Axonius API Client."""
# import click

# from ... import constants, tools
# from .. import context, options
# from . import grp_common

# HIDDEN = ["secret", "key", "password"]


# @click.command(name="add", context_settings=context.CONTEXT_SETTINGS)
# # @options.OPT_URL
# # @options.OPT_KEY
# # @options.OPT_SECRET
# # @options.OPT_EXPORT_FILE
# # @options.OPT_EXPORT_PATH
# # @options.OPT_EXPORT_FORMAT
# # @options.OPT_EXPORT_OVERWRITE
# # @options.OPT_EXPORT_DELIM
# # @options.OPT_INCLUDE_SETTINGS
# @click.option(
#     "--adapter",
#     "-a",
#     "adapter",
#     help="The name of the adapter to add the connection to.",
#     required=True,
#     show_envvar=True,
# )
# @click.option(
#     "--node",
#     "-n",
#     "node",
#     help="The name of the node running --adapter to add the connection to.",
#     default=constants.DEFAULT_NODE,
#     show_envvar=True,
#     show_default=True,
# )
# @click.option(
#     "--config",
#     "-c",
#     "config",
#     help="Configuration keys in the form of key=value.",
#     type=context.SplitEquals(),
#     multiple=True,
#     show_envvar=True,
# )
# @click.option(
#     "--skip",
#     "-sk",
#     "skips",
#     help="Regexes of configuration keys to not prompt for.",
#     multiple=True,
#     show_envvar=True,
# )
# @click.option(
#     "--hidden",
#     "hiddens",
#     help="Regexes of configuration keys to hide input of when prompting.",
#     default=HIDDEN,
#     multiple=True,
#     show_envvar=True,
#     show_default=True,
# )
# @click.option(
#     "--no-prompt-opt",
#     "-npo",
#     "prompt_opt",
#     help="Prompt for optional items that are not supplied.",
#     is_flag=True,
#     default=True,
#     show_envvar=True,
# )
# @click.option(
#     "--show-config",
#     "-sc",
#     "show_config",
#     help="Print the configuration items and exit.",
#     type=click.Choice(["text", "json"]),
#     default=None,
#     show_envvar=True,
# )
# @click.pass_context
# def cmd(
#     ctx,
#     url,
#     key,
#     secret,
#     export_format,
#     export_file,
#     export_path,
#     export_overwrite,
#     export_delim,
#     adapter,
#     node,
#     config,
#     skips,
#     hiddens,
#     prompt_opt,
#     include_settings,
#     show_config,
# ):
#     """Add an adapter connection."""
#     client = ctx.obj.start_client(url=url, key=key, secret=secret)

#     with ctx.obj.exc_wrap(wraperror=ctx.obj.wraperror):
#         adapter = client.adapters.get_single(adapter=adapter, node=node)

#     config = dict(config)
#     skips = [x.lower().strip() for x in skips]
#     hiddens = [x.lower().strip() for x in hiddens]

#     schemas = adapter["cnx_settings"].values()

#     # solve 3.5/2.x no dictionary sort
#     schemas = sorted(schemas, key=lambda x: x["idx"])

#     schemas = sorted(schemas, key=lambda x: x["required"], reverse=True)

#     schemas = [
#         grp_common.fixup_schema(schema=schema, hiddens=hiddens) for schema in schemas
#     ]

#     if show_config:
#         if show_config == "text":
#             for schema in schemas:
#                 grp_common.show_schema(
#                     ctx=ctx, schema=schema, hiddens=hiddens, err=False,
#                 )
#         elif show_config == "json":
#             click.secho(message=tools.json_dump(schemas), err=False)
#         ctx.exit(0)

#     for schema in schemas:
#         try:
#             config[schema["name"]] = grp_common.handle_schema(
#                 ctx=ctx,
#                 config=config,
#                 schema=schema,
#                 hiddens=hiddens,
#                 prompt_opt=prompt_opt,
#                 skips=skips,
#             )
#         except grp_common.SkipItem:
#             continue

#     with ctx.obj.exc_wrap(wraperror=ctx.obj.wraperror):
#         cnx = client.adapters.cnx.add(adapter=adapter, config=config, error=False)

#     action = "adding"
#     had_error, had_cnx_error = grp_common.handle_response(
#         ctx=ctx, cnx=cnx, action=action, cnx_error=True
#     )

#     formatters = {"json": serial.to_json, "csv": grp_common.to_csv}

#     ctx.obj.handle_export(
#         raw_data=cnx,
#         formatters=formatters,
#         export_format=export_format,
#         export_file=export_file,
#         export_path=export_path,
#         export_overwrite=export_overwrite,
#         joiner=export_delim,
#         include_settings=include_settings,
#     )

#     ctx.exit(int(had_error or had_cnx_error))
