# Contributing to pai-thin-client

All types of contributions are encouraged and valued. See the [Table of Contents](#table-of-contents) for different ways to help and details about how this project handles them. Please make sure to read the relevant section before making your contribution. It will make it a lot easier for us maintainers and smooth out the experience for all involved. The community looks forward to your contributions.



## Table of Contents

- [I Have a Question](#i-have-a-question)
- [I Want To Contribute](#i-want-to-contribute)
- [Reporting Bugs](#reporting-bugs)
- [Suggesting Enhancements](#suggesting-enhancements)
- [Your First Code Contribution](#your-first-code-contribution)
- [Improving The Documentation](#improving-the-documentation)
- [Commit Messages](#commit-messages)



## I Have a Question

> If you want to ask a question, we assume that you have read the available [Documentation](https://docs.private-ai.com).

Before you ask a question, it is best to search for existing [Issues](https://github.com/privateai/pai-thin-client/issues) that might help you. In case you have found a suitable issue and still need clarification, you can write your question in this issue. It is also advisable to search the internet for answers first.

If you then still feel the need to ask a question and need clarification, we recommend the following:

- Open an [Issue](https://github.com/privateai/pai-thin-client/issues/new).
- Provide as much context as you can about what you're running into.
- Provide the version of the thin client, container or API endpoint, and python you are using.
- Provide any relevant sample code, sample request, and response logs.

We will then take care of the issue as soon as possible.



## I Want To Contribute

> ### Legal Notice 
> When contributing to this project, you must agree that you have authored 100% of the content, that you have the necessary rights to the content and that the content you contribute may be provided under the project license.

### Reporting Bugs


#### Before Submitting a Bug Report

A good bug report shouldn't leave others needing to chase you up for more information. Therefore, we ask you to investigate carefully, collect information and describe the issue in detail in your report. Please complete the following steps in advance to help us fix any potential bug as fast as possible.

- Make sure that you are using the latest version.
- Determine if your bug is really a bug and not an error on your side e.g. using incompatible environment components/versions (Make sure that you have read the [documentation](https://docs.private-ai.com). If you are looking for support, you might want to check [this section](#i-have-a-question)).
- To see if other users have experienced (and potentially already solved) the same issue you are having, check if there is not already a bug report existing for your bug or error in the [bug tracker](https://github.com/privateai/pai-thin-client/issues?q=label%3Abug).
- Collect information about the bug:
- Stack trace and/or error log
- Thin client version
- Container version (or API endpoint)
- Version of the interpreter, compiler, SDK, runtime environment, package manager, depending on what seems relevant.
- Possibly your input and the output
- Can you reliably reproduce the issue? And can you also reproduce it with older versions?


#### How Do I Submit a Good Bug Report?

> You must never report security related issues, vulnerabilities or bugs including sensitive information to the issue tracker, or elsewhere in public. Instead sensitive bugs must be sent by email to [support@private-ai.com](mailto:support@private-ai.com).

We use GitHub issues to track bugs and errors. If you run into an issue with the project:

- Open an [Issue](https://github.com/privateai/pai-thin-client/issues/new). (Since we can't be sure at this point whether it is a bug or not, we ask you not to talk about a bug yet and not to label the issue.)
- Explain the behavior you would expect and the actual behavior.
- Please provide as much context as possible and describe the *reproduction steps* that someone else can follow to recreate the issue on their own. This usually includes your code. For good bug reports you should isolate the problem and create a reduced test case.
- Provide the information you collected in the previous section.

Once it's filed:

- The project team will label the issue accordingly.
- A team member will try to reproduce the issue with your provided steps. If there are no reproduction steps or no obvious way to reproduce the issue, the team will ask you for those steps and mark the issue as `needs-repro`. Bugs with the `needs-repro` tag will not be addressed until they are reproduced.
- If the team is able to reproduce the issue, it will be marked `needs-fix`, as well as possibly other tags (such as `critical`), and the issue will be left to be [implemented by someone](#your-first-code-contribution).



### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for CONTRIBUTING.md, **including completely new features and minor improvements to existing functionality**. Following these guidelines will help maintainers and the community to understand your suggestion and find related suggestions.


#### Before Submitting an Enhancement

- Make sure that you are using the latest version.
- Read the [documentation](https://docs.private-ai.com) carefully and find out if the functionality is already covered, maybe by an individual configuration.
- Perform a [search](https://github.com/privateai/pai-thin-client/issues) to see if the enhancement has already been suggested. If it has, add a comment to the existing issue instead of opening a new one.
- Find out whether your idea fits with the scope and aims of the project. It's up to you to make a strong case to convince the project's developers of the merits of this feature. Keep in mind that we want features that will be useful to the majority of our users and not just a small subset. If you're just targeting a minority of users, consider writing an add-on/plugin library.


#### How Do I Submit a Good Enhancement Suggestion?

Enhancement suggestions are tracked as [GitHub issues](https://github.com/privateai/pai-thin-client/issues).

- Use a **clear and descriptive title** for the issue to identify the suggestion.
- Provide a **step-by-step description of the suggested enhancement** in as many details as possible.
- **Describe the current behavior** and **explain which behavior you expected to see instead** and why. At this point you can also tell which alternatives do not work for you.
- You may want to **include screenshots and animated GIFs** which help you demonstrate the steps or point out the part which the suggestion is related to. You can use [this tool](https://www.cockos.com/licecap/) to record GIFs on macOS and Windows or [this tool](https://github.com/colinkeenan/silentcast) on Linux. 
- **Explain why this enhancement would be useful** to most CONTRIBUTING.md users. You may also want to point out the other projects that solved it better and which could serve as inspiration.



### Your First Code Contribution

Follow the steps below to setup you development environment

- Install the latest version of python 3.10. We recommend using a python environment manager such as [pyenv](https://github.com/pyenv/pyenv).
- Clone the repository to your local computer.
- Install the required development dependencies with the command `pip install -r requirements.dev.txt`.
- Install the pre-commit hook with the command `pre-commit install`.
- Run the tests by copying `./src/privateai_client/tests/.env.example` to `./src/privateai_client/tests/.env`, updating it with your test environment, and running the command `pytest`.


### Improving The Documentation

- Update the [README.md](./README.md) if there are new features or enhancements to existing features, especially if there are changes to the interface.
- Update the [CONTRIBUTING.md](./CONTRIBUTING.md) if there are changes to the build, test, issue, or feature processes.
- Update the [CHANGELOG.md](./CHANGELOG.md) with a list of Added, Changed, or Fixed items.

### Commit Messages

- Organize your commits into actions that complete a single task. For example, a commit that adds a new feature, a new integration test for the feature, and updates documentation is fine, but a bug fix for a separate issue should be in a separate commit.
- Commit messages should be prefixed with Added, Changed, or Fixed to simplify the change log.

### Releases

Follow the steps below to release a new version (maintainers only)

- Update the `__about__.py` [file](./src/privateai_client/__about__.py) with the latest version of the container.
- Check that [CHANGELOG.md](./CHANGELOG.md) has all the commits since the previous release.
- Update [CHANGELOG.md](./CHANGELOG.md) with a new section for the release version.

## Attribution
This guide is based on the **contributing.md**. [Make your own](https://contributing.md/)!
