"""Configuration for the pytest test suite."""
import pytest
from click.testing import CliRunner
from pdm import Core


@pytest.fixture(scope="session")
def main():
    return Core()


@pytest.fixture(scope="session")
def invoke(main):
    runner = CliRunner(mix_stderr=False)

    def caller(args, *, raising=True, **extras):
        result = runner.invoke(
            main, args, prog_name="pdm", catch_exceptions=not raising, **extras
        )
        if result.exit_code != 0 and raising:
            raise RuntimeError(
                f"Calling command {args} failed with exit code: {result.exit_code}"
            )
        return result

    return caller
