# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tada', 'tada.util']

package_data = \
{'': ['*']}

install_requires = \
['colorama',
 'hypothesis',
 'hypothesis-jsonschema',
 'markdown-include>=0.6.0,<0.7.0',
 'matplotlib>=3.3.0,<4.0.0',
 'mkdocs-git-revision-date-plugin>=0.3.1,<0.4.0',
 'mkdocs-material>=6.1.6,<7.0.0',
 'mkdocs>=1.1.2,<2.0.0',
 'pandas',
 'ptable',
 'pyperf']

entry_points = \
{'console_scripts': ['tada = tada:main']}

setup_kwargs = {
    'name': 'tada-predict',
    'version': '1.0.4',
    'description': 'Predict the likely worst-case order-of-growth function for an arbitrary Python function.',
    'long_description': "# Tada!: auTomAtic orDer-of-growth Analysis\n\n[![Build Status](https://api.travis-ci.org/Tada-Project/tada.svg?branch=master)](https://travis-ci.org/Tada-Project/tada) [![codecov.io](https://codecov.io/github/Tada-Project/tada/coverage.svg?branch=master)](http://codecov.io/github/Tada-Project/tada?branch=master) [![made-with-python](https://img.shields.io/badge/Made%20with-Python-orange.svg)](https://www.python.org/)\n\nTada is a tool that systematically runs a doubling experiment to ascertain the\nlikely worst-case order-of-growth function for an arbitrary Python function.\nThis documentation provides a brief overview about how to run the tool, its\nprovided test suite, and more.\n\n**Documentation**: https://tada-predict.netlify.app\n\n## Install Tada\n\n- Operating system: Linux · macOS/OS X · Windows\n- Python version: Python 3.6+\n- Dependency Management: [Pipenv](https://github.com/pypa/pipenv) · [Poetry](https://github.com/python-poetry/poetry)\n\n### Install Tada with pip\n\nInstall Tada with [pip](https://pip.pypa.io/en/stable/):\n\n```shell\npip install tada-predict\n```\n\n### Install through Github Repo\n\nAlternatively, you can also install Tada manually by cloning the repository and\ninstalling the dependencies through either [Pipenv](https://github.com/pypa/pipenv)\nor [Poetry](https://github.com/python-poetry/poetry). This is also the common\nway if you want to make changes to the code base.\n\nFirst, you can clone this repository with the following command:\n\n```shell\ngit clone git@github.com:Tada-Project/tada.git\n```\n\n#### Poetry\n\nIf you would like to install dependencies through `poetry`, you would first need\nto install `poetry` on your local machine like this:\n\n```shell\npip install poetry\n```\n\nOnce you have installed `poetry`, you can then install the dependencies for\nTada with the following command.\n\n```shell\npoetry install\n```\n\nYou can also activate the `poetry` shell by running this command:\n\n```shell\npoetry shell\n```\n\n#### Pipenv\n\nSimilarly, you can run the following command to install `pipenv` on your local\nmachine:\n\n```shell\npip install pipenv\n```\n\nTo install dependencies with `pipenv`, you can just run:\n\n```shell\npipenv install --no-dev\n```\n\nYou can activate the `pipenv` shell with this command:\n\n```shell\npipenv shell\n```\n\n### Run Command\n\nTo run Tada, you can just type the following command with the arguments into the\nterminal window within your preferred virtual environment:\n\n```shell\ntada [-h] --directory DIRECTORY --module MODULE --function FUNCTION --types TYPES [TYPES ...]\n```\n\nYou can learn about Tada's checks and defaults by typing `tada -h` in your\nterminal window and then reviewing the following output.\n\n```shell\nusage: tada [-h] --directory DIRECTORY [DIRECTORY ...]\n            --module [MODULE [MODULE ...]\n            --function FUNCTION [FUNCTION ...]\n            --types TYPES [TYPES ...]\n            [--data_directory DATA_DIRECTORY]\n            [--data_module DATA_MODULE]\n            [--data_function DATA_FUNCTION] [--schema SCHEMA]\n            [--startsize STARTSIZE] [--steps STEPS]\n            [--runningtime RUNNINGTIME] [--expect EXPECT]\n            [--backfill] [--indicator INDICATOR]\n            [--maxsize MAXSIZE] [--sorted] [--log] [--md]\n            [--contrast] [--level LEVEL]\n            [--position] POSITION [POSITION ...]]\n\noptional arguments:\n  -h, --help\n        show this help message and exit\n  --directory DIRECTORY [DIRECTORY ...]\n        Path to the package directory with functions to\n        analyze (default: None)\n  --module MODULE [MODULE ...]\n        Module name with functions to analyze (default: None)\n  --function FUNCTION [FUNCTION ...]\n        Name of the function to analyze (default: None)\n  --types TYPES [TYPES ...]\n        Data generation type: hypothesis or parameter types\n        of the function (default: None)\n  --data_directory DATA_DIRECTORY\n        Path to the package directory with function to\n        generate data (default: None)\n  --data_module DATA_MODULE\n        Module name with functions to generate data\n        (default: None)\n  --data_function DATA_FUNCTION\n        Name of the data generation function (default: None)\n  --schema SCHEMA\n        The path to the JSON schema that describes the data\n        format (default: None)\n  --startsize STARTSIZE\n        Starting size of the doubling experiment (default: 1)\n  --steps STEPS\n        Maximum rounds of the doubling experiment\n        (default: 10)\n  --runningtime RUNNINGTIME\n        Maximum running time of the doubling experiment\n        (default: 200)\n  --expect EXPECT\n        Expected Growth Ratio: O(1) | O(logn) | O(n) |\n        O(nlogn) | O(n^2) | O(n^3) | O(c^n). By using this\n        argument, the experiment result will be stored in a\n        csv file (default: None)\n  --backfill\n        Enable backfill to shrink experiments size according\n        to the Predicted True Value (default: False)\n  --indicator INDICATOR\n        Indicator value (default: 0.1)\n  --maxsize MAXSIZE\n        Maximum size of the doubling experiment\n        (default: 1500)\n  --sorted\n        Enable input data to be sorted (default: False)\n  --log\n        Show log/debug/diagnostic output (default: False)\n  --md\n        Show results table in markdown format (default: False)\n  --contrast\n        Show contrast result table. Only works with multiple\n        experiments (default: False)\n  --viz\n        Visualize a simple graph for the result\n        (default: False)\n  --level LEVEL\n        The level of nested data structure to apply doubling\n        experiment (default: 1)\n  --position POSITION [POSITION ...]\n        The position of input data to double in the\n        multivariable doubling experiment. Must be the last\n        argument (default: [0])\n\nSample usage:\n  tada --directory /path/to/project_directory\n       --module module_name.file_name --function function_name\n       --types hypothesis\n```\n\n#### Running within Tada Repo\n\nIf you are running within the Tada repository, then you could also easily run\nTada within the shell activated by the dependency management tool you previously\ninstalled like this:\n\n```shell\npython tada/tada_a_bigoh.py [-h] --directory DIRECTORY --module MODULE \\\n      --function FUNCTION --types TYPES [TYPES ...]\n```\n\nIt is worth noting that when the provided experiment function is relied on an\nexternal Python library, it is likely that Tada might not have this dependency,\nand thus, it might cause an error when running the experiment. You can simply\nresolve this issue by installing the required dependencies through your chosen\ndependency management tool like this:\n\n- With `pipenv`: `pipenv install <library-name>`\n- With `poetry`: `poetry add <library-name>`\n\n## Quick Start Example\n\nWe have provided some code examples in [Speed-Surprises](https://github.com/Tada-Project/speed-surprises)\nfor you to run Tada in conjunction and experience how Tada automatically suggests\nthe likely worst-case order-of-growth function for various types of Python function.\nYou can follow the instructions in [Speed-Surprises](https://github.com/Tada-Project/speed-surprises)\nto clone the repository and install the dependencies.\n\nAfter successfully setting up the repository on your local machine, you can\nthen run the following command to conduct an experiment for `insertion_sort`\nwithin the `speed-surprises` repository:\n\n```shell\ntada --directory . --module speedsurprises.lists.sorting \\\n     --function insertion_sort --types hypothesis \\\n     --schema speedsurprises/jsonschema/single_int_list.json\n```\n\nWithin a minute or so, you will be able to inspect an output similar to the\nfollowing with a results table provided at the end of the experiment.\n\n```shell\n        Tada!: auTomAtic orDer-of-growth Analysis!\n          https://github.com/Tada-Project/tada/\n        For Help Information Type: python tada -h\n\nStart running experiment insertion_sort for size 1 →\n\n\n→ Done running experiment insertion_sort for size 1\n.\n.\n.\n→ Done running experiment insertion_sort for size 64\n\n+-----------------------------------------------------------------------------+\n|             insertion_sort: O(n) linear or O(nlogn) linearithmic            |\n+------+------------------------+------------------------+--------------------+\n| Size |          Mean          |         Median         |       Ratio        |\n+------+------------------------+------------------------+--------------------+\n|  1   | 4.882118635177613e-07  | 4.6806960487365676e-07 |         0          |\n|  2   | 7.456634746551513e-07  | 7.133920059204101e-07  | 1.527335835885569  |\n|  4   |  9.27755012257894e-07  | 9.209306488037112e-07  | 1.2442006934655812 |\n|  8   | 1.3545460286458332e-06 | 1.3353490028381343e-06 | 1.4600255571233727 |\n|  16  | 2.2379635269165037e-06 | 2.2146971740722657e-06 | 1.6521871384125948 |\n|  32  | 3.9610248652140306e-06 | 3.913619827270508e-06  | 1.7699237800678478 |\n|  64  | 7.2769234293619794e-06 | 7.211799896240237e-06  | 1.837131468996415  |\n+------+------------------------+------------------------+--------------------+\nO(n) linear or O(nlogn) linearithmic\n```\n\nYou can find more information about Tada usage, including experiment data\ngeneration and using different flags and arguments to configure your Tada\nexperiment through our [documentation](https://tada-predict.netlify.app/using-tada/)\nhere.\n\n## Add New Features to Tada\n\nYou can follow these steps to add a new feature if you are already a\ncollaborator on the project. First, you should create and publish your new branch\nvia the following command. Substitute the name of your feature/branch for the word\n`feature-name`.\n\n- `git checkout -b feature-name`\n- `git checkout master`\n- `git push -u origin feature-name`\n\nTo install development dependencies, type the following commands in the terminal:\n\n```bash\npoetry install\n```\n\nYou can activate the shell with the following command:\n\n```shell\npoetry shell\n```\n\nFinally, you should open a pull request on the GitHub repository for the new\nbranch that you have created. This pull request should describe the new feature\nthat you are adding and give examples of how to run it on the command line.\nOf course, if you are not a collaborator on this project, then you will need to\nfork the repository, add your new feature, document and test it as appropriate,\nand then create a pull request similarly.\n\nWe highly recommend you to provide tests along with the feature that you\nimplemented and you should not break the existing test cases or features.\n\n### Test Tada\n\nTo run the test suite for Tada's functions within the shell by typing the\nfollowing in your terminal window:\n\n```shell\npytest tests\n```\n\nIf you want to collect the coverage of the provided test suite, then you can\nrun:\n\n```shell\npytest --cov-config pytest.cov --cov\n```\n\nIf you want to collect the coverage of the provided test suite and see what\nlines of code are not covered, then you can run:\n\n```shell\npytest --cov-config pytest.cov --cov --cov-report term-missing\n```\n\n## Problems or Praise\n\nIf you have any problems with installing or using the Tada or its provided test\nsuite, then please create an issue associated with this Git repository using the\n[Issues](https://github.com/Tada-Project/tada/issues) link at the top of this site. The contributors to Tada will do all that\nthey can to resolve your issue and ensure that all of its features and the test\nsuite work well in your development environment.\n",
    'author': 'Enpu You',
    'author_email': 'youe2@allegheny.edu',
    'maintainer': 'Enpu You',
    'maintainer_email': 'youe2@allegheny.edu',
    'url': 'https://tada-predict.netlify.app',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
