/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.color;

import java.awt.Color;
import net.sourceforge.plantuml.ugraphic.color.HUSLColorConverter;

public class ColorUtils {
    public static int getGrayScale(Color color) {
        return ColorUtils.getGrayScale(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int getGrayScale(int red, int green, int blue) {
        return ColorUtils.getGrayScaleInternal(red, green, blue) / 1000;
    }

    public static int distance(Color c1, Color c2) {
        int diffRed = Math.abs(c1.getRed() - c2.getRed());
        int diffGreen = Math.abs(c1.getGreen() - c2.getGreen());
        int diffBlue = Math.abs(c1.getBlue() - c2.getBlue());
        return ColorUtils.getGrayScaleInternal(diffRed, diffGreen, diffBlue);
    }

    private static int getGrayScaleInternal(int red, int green, int blue) {
        return red * 299 + green * 587 + blue * 114;
    }

    public static int getGrayScale(int rgb) {
        int red = (rgb & 0xFF0000) >> 16;
        int green = (rgb & 0xFF00) >> 8;
        int blue = rgb & 0xFF;
        return ColorUtils.getGrayScale(red, green, blue);
    }

    public static Color getGrayScaleColor(Color color) {
        int grayScale = ColorUtils.getGrayScale(color);
        return new Color(grayScale, grayScale, grayScale);
    }

    public static Color getGrayScaleColorReverse(Color color) {
        int grayScale = 255 - ColorUtils.getGrayScale(color);
        return new Color(grayScale, grayScale, grayScale);
    }

    public static Color reverseHsluv(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        double[] hsluv = HUSLColorConverter.rgbToHsluv(new double[]{(double)red / 256.0, (double)green / 256.0, (double)blue / 256.0});
        double h = hsluv[0];
        double s = hsluv[1];
        double l = (hsluv[2] + 50.0) % 100.0;
        l += 0.25 * (50.0 - l);
        double[] rgb = HUSLColorConverter.hsluvToRgb(new double[]{h, s, l});
        int red2 = ColorUtils.to255(rgb[0]);
        int green2 = ColorUtils.to255(rgb[1]);
        int blue2 = ColorUtils.to255(rgb[2]);
        return new Color(red2, green2, blue2);
    }

    public static Color grayToColor(double coef, Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        double[] hsluv = HUSLColorConverter.rgbToHsluv(new double[]{(double)red / 256.0, (double)green / 256.0, (double)blue / 256.0});
        double h = hsluv[0];
        double s = hsluv[1];
        double l = hsluv[2];
        l += (100.0 - l) * coef;
        double[] rgb = HUSLColorConverter.hsluvToRgb(new double[]{h, s, l});
        int red2 = ColorUtils.to255(rgb[0]);
        int green2 = ColorUtils.to255(rgb[1]);
        int blue2 = ColorUtils.to255(rgb[2]);
        return new Color(red2, green2, blue2);
    }

    public static Color getReversed(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        double[] hsluv = HUSLColorConverter.rgbToHsluv(new double[]{(double)red / 256.0, (double)green / 256.0, (double)blue / 256.0});
        double h = hsluv[0];
        double s = hsluv[1];
        double l = hsluv[2];
        if (s > 40.0 && s < 60.0) {
            if (l > 50.0) {
                l -= 50.0;
            } else if (l < 50.0) {
                l += 50.0;
            }
        } else {
            l = 100.0 - l;
        }
        double[] rgb = HUSLColorConverter.hsluvToRgb(new double[]{h, s, l});
        int red2 = ColorUtils.to255(rgb[0]);
        int green2 = ColorUtils.to255(rgb[1]);
        int blue2 = ColorUtils.to255(rgb[2]);
        return new Color(red2, green2, blue2);
    }

    private static int to255(double value) {
        int result = (int)(255.0 * value);
        if (result < 0) {
            return 0;
        }
        if (result > 255) {
            return 255;
        }
        return result;
    }
}

