/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.stdlib;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;
import net.sourceforge.plantuml.ugraphic.color.HColors;
import net.sourceforge.plantuml.ugraphic.color.HSLColor;

public class HslColor
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%hsl_color", 3);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 3 || nbArg == 4;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, LineLocation location, List<TValue> values, Map<String, TValue> named) throws EaterException, EaterExceptionLocated {
        int h = values.get(0).toInt();
        int s = values.get(1).toInt();
        int l = values.get(2).toInt();
        if (values.size() == 3) {
            HSLColor color = new HSLColor(h, s, l);
            Color rgb = color.getRGB();
            return TValue.fromString(HColors.simple(rgb).asString());
        }
        int a = values.get(3).toInt();
        HSLColor color = new HSLColor(h, s, l, (float)((double)a / 100.0));
        Color rgb = color.getRGB();
        return TValue.fromString(HColors.simple(rgb).asString());
    }
}

