/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextBlockCucaJSon
extends AbstractTextBlock
implements WithPorts {
    private final ISkinParam skinParam;
    private final FontConfiguration fontConfiguration;
    private final JsonValue json;
    private TextBlockJson jsonTextBlock;
    private double mainTotalWidth;
    private final LineBreakStrategy wordWrap;

    public TextBlockCucaJSon(FontConfiguration fontConfiguration, ISkinParam skinParam, JsonValue json, LineBreakStrategy wordWrap) {
        this.skinParam = skinParam;
        this.json = json;
        this.fontConfiguration = fontConfiguration;
        this.wordWrap = wordWrap;
    }

    private TextBlockJson getJsonTextBlock() {
        if (this.jsonTextBlock == null) {
            this.jsonTextBlock = new TextBlockJson(this.json, 0.0);
        }
        this.jsonTextBlock.jsonTotalWidth = this.mainTotalWidth;
        return this.jsonTextBlock;
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        return new Ports();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.getJsonTextBlock().calculateDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.getJsonTextBlock().drawU(ug);
    }

    private TextBlock getTextBlockValue(JsonValue value, double width2) {
        if (value.isString() || value.isNull() || value.isTrue() || value.isFalse() || value.isNumber()) {
            String tmp = value.isString() ? value.asString() : value.toString();
            return this.getTextBlock(tmp);
        }
        if (value.isArray()) {
            return new TextBlockArray(value.asArray(), width2);
        }
        if (value.isObject()) {
            return new TextBlockJson(value, width2);
        }
        String tmp = value.getClass().getSimpleName();
        return this.getTextBlock(tmp);
    }

    private TextBlock getTextBlock(String key) {
        Display display = Display.getWithNewlines(key);
        TextBlock result = display.create0(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam, this.wordWrap, CreoleMode.FULL, null, null);
        result = TextBlockUtils.withMargin(result, 5.0, 2.0);
        return result;
    }

    private FontConfiguration getFontConfiguration() {
        return this.fontConfiguration;
    }

    public void setTotalWidth(double totalWidth) {
        this.mainTotalWidth = totalWidth;
    }

    class TextBlockJson
    extends AbstractTextBlock {
        private final JsonObject obj;
        private double jsonTotalWidth;

        public TextBlockJson(JsonValue json, double totalWidth) {
            this.obj = json.asObject();
            this.jsonTotalWidth = totalWidth;
        }

        @Override
        public XDimension2D calculateDimension(StringBounder stringBounder) {
            return new XDimension2D(this.getWidth1(stringBounder) + this.getWidth2(stringBounder), this.getHeight(stringBounder));
        }

        private double getWidth1(StringBounder stringBounder) {
            double result = 0.0;
            for (JsonObject.Member s : this.obj) {
                TextBlock tb1 = TextBlockCucaJSon.this.getTextBlock(s.getName());
                result = Math.max(result, tb1.calculateDimension(stringBounder).getWidth());
            }
            return result;
        }

        private double getWidth2(StringBounder stringBounder) {
            double result = 0.0;
            for (JsonObject.Member s : this.obj) {
                TextBlock tb2 = TextBlockCucaJSon.this.getTextBlockValue(s.getValue(), this.jsonTotalWidth);
                result = Math.max(result, tb2.calculateDimension(stringBounder).getWidth());
            }
            return result;
        }

        private double getHeight(StringBounder stringBounder) {
            double result = 0.0;
            for (JsonObject.Member s : this.obj) {
                TextBlock tb1 = TextBlockCucaJSon.this.getTextBlock(s.getName());
                TextBlock tb2 = TextBlockCucaJSon.this.getTextBlockValue(s.getValue(), this.jsonTotalWidth);
                XDimension2D dim1 = tb1.calculateDimension(stringBounder);
                XDimension2D dim2 = tb2.calculateDimension(stringBounder);
                result += Math.max(dim1.getHeight(), dim2.getHeight());
            }
            return result;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            double width1 = this.getWidth1(stringBounder);
            double height = this.getHeight(stringBounder);
            ug.apply(UTranslate.dx(width1)).draw(ULine.vline(height));
            ULine hline = ULine.hline(this.jsonTotalWidth);
            for (JsonObject.Member s : this.obj) {
                TextBlock tb1 = TextBlockCucaJSon.this.getTextBlock(s.getName());
                TextBlock tb2 = TextBlockCucaJSon.this.getTextBlockValue(s.getValue(), this.jsonTotalWidth - width1);
                XDimension2D dim1 = tb1.calculateDimension(stringBounder);
                XDimension2D dim2 = tb2.calculateDimension(stringBounder);
                ug.draw(hline);
                tb1.drawU(ug);
                tb2.drawU(ug.apply(UTranslate.dx(width1)));
                ug = ug.apply(UTranslate.dy(Math.max(dim1.getHeight(), dim2.getHeight())));
            }
        }
    }

    class TextBlockArray
    extends AbstractTextBlock {
        private final JsonArray array;
        private final double arrayTotalWidth;

        public TextBlockArray(JsonArray array, double totalWidth) {
            this.array = array;
            this.arrayTotalWidth = totalWidth;
        }

        @Override
        public XDimension2D calculateDimension(StringBounder stringBounder) {
            XDimension2D result = new XDimension2D(0.0, 0.0);
            for (JsonValue element : this.array) {
                TextBlock tb = TextBlockCucaJSon.this.getTextBlockValue(element, this.arrayTotalWidth);
                XDimension2D dim = tb.calculateDimension(stringBounder);
                result = result.mergeTB(dim);
            }
            return result;
        }

        @Override
        public void drawU(UGraphic ug) {
            ULine hline = ULine.hline(this.arrayTotalWidth);
            int nb = 0;
            for (JsonValue element : this.array) {
                TextBlock tb = TextBlockCucaJSon.this.getTextBlockValue(element, this.arrayTotalWidth);
                if (nb > 0) {
                    ug.draw(hline);
                }
                ++nb;
                tb.drawU(ug);
                ug = ug.apply(UTranslate.dy(tb.calculateDimension(ug.getStringBounder()).getHeight()));
            }
        }
    }
}

