/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBuilder;
import net.sourceforge.plantuml.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CreoleHorizontalLine
extends AbstractAtom
implements Atom {
    private final FontConfiguration fontConfiguration;
    private final String line;
    private final char style;
    private final ISkinSimple skinParam;
    private static final double defaultThickness = 1.0;

    public static CreoleHorizontalLine create(FontConfiguration fontConfiguration, String line, char style, ISkinSimple skinParam) {
        return new CreoleHorizontalLine(fontConfiguration, line, style, skinParam);
    }

    private CreoleHorizontalLine(FontConfiguration fontConfiguration, String line, char style, ISkinSimple skinParam) {
        this.fontConfiguration = fontConfiguration;
        this.line = line;
        this.style = style;
        this.skinParam = skinParam;
    }

    private UHorizontalLine getHorizontalLine() {
        if (this.line.length() == 0) {
            return UHorizontalLine.infinite(1.0, 0.0, 0.0, this.style);
        }
        TextBlock tb = this.getTitle();
        return UHorizontalLine.infinite(1.0, 0.0, 0.0, tb, this.style);
    }

    private TextBlock getTitle() {
        if (this.line.length() == 0) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        SheetBuilder parser = this.skinParam.sheet(this.fontConfiguration, HorizontalAlignment.LEFT, CreoleMode.FULL);
        Sheet sheet = parser.createSheet(Display.getWithNewlines(this.line));
        SheetBlock1 tb = new SheetBlock1(sheet, LineBreakStrategy.NONE, this.skinParam.getPadding());
        return tb;
    }

    @Override
    public void drawU(UGraphic ug) {
        XDimension2D dim = this.calculateDimension(ug.getStringBounder());
        ug = ug.apply(UTranslate.dy(dim.getHeight() / 2.0));
        ug.draw(this.getHorizontalLine());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        if (this.line.length() == 0) {
            return new XDimension2D(10.0, 10.0);
        }
        TextBlock tb = this.getTitle();
        return tb.calculateDimension(stringBounder);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }
}

