/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.Map;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.error.PSystemErrorUtils;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;

public abstract class PSystemBasicFactory<P extends AbstractPSystem>
extends PSystemAbstractFactory {
    public PSystemBasicFactory(DiagramType diagramType) {
        super(diagramType);
    }

    public PSystemBasicFactory() {
        this(DiagramType.UML);
    }

    public abstract P executeLine(UmlSource var1, P var2, String var3);

    public abstract P initDiagram(UmlSource var1, String var2);

    private boolean isEmptyLine(StringLocated result) {
        return result.getTrimmed().getString().length() == 0;
    }

    @Override
    public final Diagram createSystem(UmlSource source, Map<String, String> skinParam) {
        source = source.removeInitialSkinparam();
        IteratorCounter2 it = source.iterator2();
        StringLocated startLine = (StringLocated)it.next();
        P system = this.initDiagram(source, startLine.getString());
        boolean first = true;
        while (it.hasNext()) {
            StringLocated s = (StringLocated)it.next();
            if (first && s != null && this.isEmptyLine(s)) continue;
            first = false;
            if (StartUtils.isArobaseEndDiagram(s.getString())) {
                if (source.getTotalLineCount() == 2 && !source.isStartDef()) {
                    return this.buildEmptyError(source, s.getLocation(), it.getTrace());
                }
                return system;
            }
            if ((system = this.executeLine(source, system, s.getString())) != null) continue;
            ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", 0, s.getLocation());
            return PSystemErrorUtils.buildV2(source, err, null, it.getTrace());
        }
        return system;
    }
}

