/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.baraye;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.baraye.CucaDiagram;
import net.sourceforge.plantuml.baraye.EntityImp;
import net.sourceforge.plantuml.baraye.IEntity;
import net.sourceforge.plantuml.baraye.IGroup;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.BodierJSon;
import net.sourceforge.plantuml.cucadiagram.BodierMap;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.HideOrShow2;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Stereotag;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.entity.IEntityFactory;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public final class EntityFactory
implements IEntityFactory {
    private final Map<String, ILeaf> leafsByCode;
    private final Map<String, IGroup> groupsByCode;
    public final Map<Ident, ILeaf> leafs2 = new LinkedHashMap<Ident, ILeaf>();
    public final Map<Ident, IGroup> groups2 = new LinkedHashMap<Ident, IGroup>();
    private final List<Link> links = new ArrayList<Link>();
    private int rawLayout;
    private final IGroup rootGroup = new GroupRoot(this);
    private final List<HideOrShow2> hides2;
    private final List<HideOrShow2> removed;
    public final CucaDiagram namespaceSeparator;
    private Map<IGroup, ILeaf> emptyGroupsAsNode = new HashMap<IGroup, ILeaf>();
    private final Collection<Ident> hiddenBecauseOfIntrication = new ArrayList<Ident>();

    public ILeaf getLeafForEmptyGroup(IGroup g) {
        return this.emptyGroupsAsNode.get(g);
    }

    public ILeaf createLeafForEmptyGroup(IGroup g, ISkinParam skinParam) {
        ILeaf folder = this.createLeaf(g.getIdent(), g.getCode(), g.getDisplay(), LeafType.EMPTY_PACKAGE, g.getParentContainer(), null, this.namespaceSeparator.getNamespaceSeparator());
        ((EntityImp)folder).setOriginalGroup(g);
        USymbol symbol = g.getUSymbol();
        folder.setUSymbol(symbol);
        folder.setStereotype(g.getStereotype());
        folder.setColors(g.getColors());
        if (g.getUrl99() != null) {
            folder.addUrl(g.getUrl99());
        }
        for (Stereotag tag : g.stereotags()) {
            folder.addStereotag(tag);
        }
        this.emptyGroupsAsNode.put(g, folder);
        return folder;
    }

    public Display getIntricatedDisplay(Ident ident) {
        HashSet<Ident> known = new HashSet<Ident>(this.groups2.keySet());
        known.removeAll(this.hiddenBecauseOfIntrication);
        String sep = this.namespaceSeparator.getNamespaceSeparator();
        if (sep == null) {
            sep = ".";
        }
        for (int check = ident.size() - 1; check > 0; --check) {
            if (!known.contains(ident.getPrefix(check))) continue;
            return Display.getWithNewlines(ident.getSuffix(check).toString(sep)).withCreoleMode(CreoleMode.SIMPLE_LINE);
        }
        return Display.getWithNewlines(ident.toString(sep)).withCreoleMode(CreoleMode.SIMPLE_LINE);
    }

    public IGroup isIntricated(IGroup parent) {
        int leafs = parent.getLeafsDirect().size();
        Collection<IGroup> children = parent.getChildren();
        if (leafs == 0 && children.size() == 1) {
            IGroup g = children.iterator().next();
            if (g.getLeafsDirect().size() == 0 && g.getChildren().size() == 0 && g.getGroupType() == GroupType.PACKAGE) {
                return null;
            }
            for (Link link : this.getLinks()) {
                if (!link.contains(parent)) continue;
                return null;
            }
            ((EntityImp)g).setIntricated(true);
            this.hiddenBecauseOfIntrication.add(parent.getIdent());
            return g;
        }
        return null;
    }

    public EntityFactory(List<HideOrShow2> hides2, List<HideOrShow2> removed, CucaDiagram namespaceSeparator) {
        this.hides2 = hides2;
        this.removed = removed;
        this.namespaceSeparator = namespaceSeparator;
        this.leafsByCode = new LinkedHashMap<String, ILeaf>();
        this.groupsByCode = new LinkedHashMap<String, IGroup>();
    }

    public boolean isHidden(ILeaf leaf) {
        IEntity other = this.isNoteWithSingleLinkAttachedTo(leaf);
        if (other instanceof ILeaf) {
            return this.isHidden((ILeaf)other);
        }
        boolean hidden = false;
        for (HideOrShow2 hide : this.hides2) {
            hidden = hide.apply(hidden, leaf);
        }
        return hidden;
    }

    @Override
    public boolean isRemoved(Stereotype stereotype) {
        boolean result = false;
        for (HideOrShow2 hide : this.removed) {
            result = hide.apply(result, stereotype);
        }
        return result;
    }

    public boolean isRemoved(ILeaf leaf) {
        IEntity other = this.isNoteWithSingleLinkAttachedTo(leaf);
        if (other instanceof ILeaf) {
            return this.isRemoved((ILeaf)other);
        }
        boolean result = false;
        for (HideOrShow2 hide : this.removed) {
            result = hide.apply(result, leaf);
        }
        return result;
    }

    private IEntity isNoteWithSingleLinkAttachedTo(ILeaf leaf) {
        if (leaf.getLeafType() != LeafType.NOTE) {
            return null;
        }
        IEntity result = null;
        for (Link link : this.getLinks()) {
            if (link.getType().isInvisible() || !link.contains(leaf)) continue;
            if (result != null) {
                return result;
            }
            result = link.getOther(leaf);
        }
        return result;
    }

    public boolean isRemovedIgnoreUnlinked(ILeaf leaf) {
        boolean result = false;
        for (HideOrShow2 hide : this.removed) {
            if (hide.isAboutUnlinked()) continue;
            result = hide.apply(result, leaf);
        }
        return result;
    }

    public ILeaf createLeaf(Ident ident, Code code, Display display, LeafType entityType, IGroup parentContainer, Set<VisibilityModifier> hides, String namespaceSeparator) {
        Bodier bodier = Objects.requireNonNull(entityType) == LeafType.MAP ? new BodierMap() : (Objects.requireNonNull(entityType) == LeafType.JSON ? new BodierJSon() : BodyFactory.createLeaf(entityType, hides));
        EntityImp result = new EntityImp(ident, code, this, bodier, parentContainer, entityType, namespaceSeparator, this.rawLayout);
        bodier.setLeaf(result);
        result.setDisplay(display);
        return result;
    }

    public IGroup createGroup(Ident ident, Code code, Display display, Code namespace, GroupType groupType, IGroup parentContainer, Set<VisibilityModifier> hides, String namespaceSeparator) {
        Objects.requireNonNull(groupType);
        for (Map.Entry<Ident, IGroup> ent : this.groups2.entrySet()) {
            if (!ent.getKey().equals(ident)) continue;
            return ent.getValue();
        }
        Bodier bodier = BodyFactory.createGroup(hides);
        EntityImp result = new EntityImp(ident, code, this, bodier, parentContainer, groupType, namespace, namespaceSeparator, this.rawLayout);
        if (!Display.isNull(display)) {
            result.setDisplay(display);
        }
        return result;
    }

    public void addLeaf(ILeaf entity) {
        if (!this.namespaceSeparator.V1972()) {
            this.leafsByCode.put(entity.getCodeGetName(), entity);
        }
        this.leafs2.put(entity.getIdent(), entity);
        if (this.namespaceSeparator.V1972()) {
            this.ensureParentIsCreated(entity.getIdent());
        }
    }

    public void addGroup(IGroup group) {
        if (!this.namespaceSeparator.V1972()) {
            this.groupsByCode.put(group.getCodeGetName(), group);
        }
        this.groups2.put(group.getIdent(), group);
        if (this.namespaceSeparator.V1972()) {
            this.ensureParentIsCreated(group.getIdent());
        }
    }

    private void ensureParentIsCreated(Ident ident) {
        if (this.groups2.get(ident.parent()) != null) {
            return;
        }
        this.getParentContainer(ident, null);
    }

    public void removeGroup(String name) {
        IEntity removed2;
        if (this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        IEntity removed = Objects.requireNonNull(this.groupsByCode.remove(name));
        if (removed != (removed2 = (IEntity)this.groups2.remove(removed.getIdent()))) {
            EntityFactory.bigError();
        }
    }

    public void removeGroup(Ident ident) {
        Objects.requireNonNull(this.groups2.remove(Objects.requireNonNull(ident)));
    }

    public static void bigError() {
    }

    public void removeLeaf(String name) {
        IEntity removed2;
        if (this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        IEntity removed = Objects.requireNonNull(this.leafsByCode.remove(Objects.requireNonNull(name)));
        if (removed != (removed2 = (IEntity)this.leafs2.remove(removed.getIdent()))) {
            EntityFactory.bigError();
        }
    }

    public void removeLeaf(Ident ident) {
        IEntity removed = this.leafs2.remove(Objects.requireNonNull(ident));
        if (removed == null) {
            System.err.println("leafs2=" + this.leafs2.keySet());
            throw new IllegalArgumentException(ident.toString());
        }
    }

    private void removeLeaf1972(ILeaf leaf) {
        boolean removed = this.leafs2.values().remove(leaf);
        if (!removed) {
            System.err.println("leafs2=" + this.leafs2.keySet());
            throw new IllegalArgumentException(leaf.toString());
        }
    }

    public IGroup muteToGroup(String name, Code namespace, GroupType type, IGroup parent) {
        if (this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        ILeaf leaf = this.leafsByCode.get(name);
        ((EntityImp)leaf).muteToGroup(namespace, type, parent);
        IGroup result = (IGroup)((Object)leaf);
        this.removeLeaf(name);
        return result;
    }

    public IGroup muteToGroup1972(Ident ident, Code namespace, GroupType type, IGroup parent) {
        if (!this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        ILeaf leaf = this.namespaceSeparator.getNamespaceSeparator() == null ? this.getLeafVerySmart(ident) : this.leafs2.get(ident);
        ((EntityImp)leaf).muteToGroup(namespace, type, parent);
        IGroup result = (IGroup)((Object)leaf);
        this.removeLeaf1972(leaf);
        return result;
    }

    public IGroup getRootGroup() {
        return this.rootGroup;
    }

    public final ILeaf getLeafStrict(Ident ident) {
        return this.leafs2.get(ident);
    }

    public final ILeaf getLeafSmart(Ident ident) {
        if (!this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        ILeaf result = this.leafs2.get(ident);
        if (result == null && ident.size() == 1) {
            for (Map.Entry<Ident, ILeaf> ent : this.leafs2.entrySet()) {
                if (!ent.getKey().getLast().equals(ident.getLast())) continue;
                return ent.getValue();
            }
        }
        return result;
    }

    public final ILeaf getLeafVerySmart(Ident ident) {
        if (!this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        ILeaf result = this.leafs2.get(ident);
        if (result == null) {
            for (Map.Entry<Ident, ILeaf> ent : this.leafs2.entrySet()) {
                if (!ent.getKey().getLast().equals(ident.getLast())) continue;
                return ent.getValue();
            }
        }
        return result;
    }

    public Ident buildFullyQualified(Ident currentPath, Ident id) {
        if (!currentPath.equals(id) && (this.leafs2.containsKey(id) || this.groups2.containsKey(id))) {
            return id;
        }
        if (id.size() > 1) {
            return id;
        }
        return currentPath.add(id);
    }

    public final IGroup getGroupStrict(Ident ident) {
        if (this.namespaceSeparator.getNamespaceSeparator() == null) {
            return this.getGroupVerySmart(ident);
        }
        IGroup result = this.groups2.get(ident);
        return result;
    }

    public final IGroup getGroupVerySmart(Ident ident) {
        IGroup result = this.groups2.get(ident);
        if (result == null) {
            for (Map.Entry<Ident, IGroup> ent : this.groups2.entrySet()) {
                if (!ent.getKey().getLast().equals(ident.getLast())) continue;
                return ent.getValue();
            }
        }
        return result;
    }

    public final ILeaf getLeaf(Code code) {
        if (this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        ILeaf result = this.leafsByCode.get(code.getName());
        if (result != null && result != this.leafs2.get(result.getIdent())) {
            EntityFactory.bigError();
        }
        return result;
    }

    public final IGroup getGroup(Code code) {
        if (this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        IGroup result = this.groupsByCode.get(code.getName());
        if (result != null && result != this.groups2.get(result.getIdent())) {
            EntityFactory.bigError();
        }
        return result;
    }

    @Override
    public final Collection<ILeaf> leafs() {
        if (this.namespaceSeparator.V1972()) {
            return this.leafs2();
        }
        Collection<ILeaf> result = Collections.unmodifiableCollection(this.leafsByCode.values());
        if (!new ArrayList<ILeaf>(result).equals(new ArrayList<ILeaf>(this.leafs2()))) {
            EntityFactory.bigError();
        }
        return result;
    }

    public final Collection<IGroup> groups() {
        if (this.namespaceSeparator.V1972()) {
            return this.groups2();
        }
        Collection<IGroup> result = Collections.unmodifiableCollection(this.groupsByCode.values());
        if (!new ArrayList<IGroup>(result).equals(new ArrayList<IGroup>(this.groups2()))) {
            EntityFactory.bigError();
        }
        return result;
    }

    public final Collection<IGroup> groups2() {
        Collection<IGroup> result = Collections.unmodifiableCollection(this.groups2.values());
        return Collections.unmodifiableCollection(result);
    }

    public final Collection<ILeaf> leafs2() {
        Collection<ILeaf> result = Collections.unmodifiableCollection(this.leafs2.values());
        return Collections.unmodifiableCollection(result);
    }

    public void incRawLayout() {
        ++this.rawLayout;
    }

    public final List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public void addLink(Link link) {
        if (link.isSingle() && this.containsSimilarLink(link)) {
            return;
        }
        this.links.add(link);
    }

    private boolean containsSimilarLink(Link other) {
        for (Link link : this.links) {
            if (!other.sameConnections(link)) continue;
            return true;
        }
        return false;
    }

    public void removeLink(Link link) {
        boolean ok = this.links.remove(link);
        if (!ok) {
            throw new IllegalArgumentException();
        }
    }

    public IGroup getParentContainer(Ident ident, IGroup parentContainer) {
        if (this.namespaceSeparator.V1972()) {
            Ident parent = ident.parent();
            if (parent.isRoot()) {
                return this.rootGroup;
            }
            IGroup result = this.getGroupStrict(parent);
            if (result != null) {
                return result;
            }
            Display display = Display.getWithNewlines(parent.getName());
            result = this.createGroup(parent, parent, display, null, GroupType.PACKAGE, null, Collections.emptySet(), this.namespaceSeparator.getNamespaceSeparator());
            this.addGroup(result);
            return result;
        }
        return Objects.requireNonNull(parentContainer);
    }

    public CucaDiagram getDiagram() {
        return this.namespaceSeparator;
    }
}

