from karp5.errors import KarpException

""" Class for exceptions generated by the parser modules
"""


class QueryError(KarpException):
    def __init__(self, message, debug_msg=None, status_code=None, payload=None):
        super().__init__(
            "malformed query: " + message,
            status_code=status_code,
            payload=payload,
            debug_msg=debug_msg,
            user_msg=message,
        )

    def to_dict(self):
        rv = dict(self.payload or ())
        rv["message"] = self.message
        return rv


class AuthenticationError(KarpException):
    def __init__(self, message, status_code=None, payload=None):
        super().__init__(
            "Authentication Exception: " + message, status_code=status_code or 401, payload=payload,
        )

    def to_dict(self):
        rv = dict(self.payload or ())
        rv["message"] = self.message
        return rv


class BulkifyError(KarpException):
    def __init__(self, message, bulk_info):
        super().__init__(f"Bulkify error: {message}\nbulk_info = {bulk_info}")
