# Generated by Django 4.0.6 on 2022-07-31 20:47

import django.db.models.deletion
from django.db import migrations, models
from wagtail import VERSION as WAGTAIL_VERSION


class Migration(migrations.Migration):

    initial = True

    if WAGTAIL_VERSION >= (3, 0):
        dependencies = [
            ("wagtailcore", "0069_log_entry_jsonfield"),
            ("wagtaildocs", "0012_uploadeddocument"),
        ]
    else:
        dependencies = [
            ("wagtailcore", "0066_collection_management_permissions"),
            ("wagtaildocs", "0012_uploadeddocument"),
        ]

    operations = [
        migrations.CreateModel(
            name="TestPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "qr_code_svg",
                    models.TextField(
                        blank=True,
                        help_text="The QR code SVG sample.",
                        null=True,
                        verbose_name="QR Code SVG",
                    ),
                ),
                (
                    "qr_code_eps_email",
                    models.EmailField(
                        blank=True,
                        help_text="The email address will not be saved to the database and is used only once to send the EPS file.",  # noqa: E501
                        max_length=254,
                        null=True,
                        verbose_name="QR Code EPS Email",
                    ),
                ),
                (
                    "qr_code_usage",
                    models.IntegerField(
                        default=0,
                        help_text="The number of times the QR code has been used.",
                        verbose_name="QR Code Usage Count",
                    ),
                ),
                (
                    "qr_code_eps",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="wagtaildocs.document",
                        verbose_name="QR Code EPS",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("wagtailcore.page", models.Model),
        ),
    ]
