# Onliner Parser

## Возможности
- Парсинг категорий продуктов
- Импорт полученной информации в csv или xlsx

------------

## Установка и настройка
1. Клонируйте репозиторий
`git clone https://github.com/devShev/onliner-parser.git`

2.  Выберите необходимую категорию в браузере

	![](https://i.ibb.co/1qq9wtS/image.png)

3. Копируем URL в адресной строке браузера

	![](https://i.ibb.co/09Q0xmh/image.png)

4.  Переходим в файл app.py и вставляем наш URL, получается следующий код
```python
url = 'url'

parser = CatalogParser(url)
parser.parse()

saver = SaveManager(Product, parser.get_data())
saver.save()
```


***Настройка завершена***

------------

## Методы парсера:
### parse()
- Собрать информамцию с каталога

### get_data()
- Вернуть полученную информацию в виде списка объектов

## Методы Менеджера сохранения:

### save(filename: str, save_format: str)
- Сохранить полученную информацию в файл
- filename - необязательный параметр, имя создаваемого файла (по-стандарту - products)
- save_format - необязательный параметр, формат файла (csv / xlsx) (по-стандарту - csv)
 
### save_xlsx(filename: str)
- Сохранить полученную информацию в формате xlsx (excel)
- filename - необязательный параметр, имя создаваемого файла (по-стандарту - products)

### save_csv(filename: str)
- Сохранить полученную информацию в формате csv
- filename - необязательный параметр, имя создаваемого файла (по-стандарту - products)

### set_directory_name(name: str)
- Установить название директории куда сохраняются файлы (по-стандарту - data)
- name - обязательный параметр, название директории
