# -*- coding: utf-8 -*-

"""
whatsappcloudapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from whatsappcloudapi.decorators import lazy_property
from whatsappcloudapi.configuration import Configuration
from whatsappcloudapi.configuration import Environment
from whatsappcloudapi.http.auth.o_auth_2 import OAuth2
from whatsappcloudapi.controllers.business_profiles_controller\
    import BusinessProfilesController
from whatsappcloudapi.controllers.messages_controller import MessagesController
from whatsappcloudapi.controllers.media_controller import MediaController
from whatsappcloudapi.controllers.phone_numbers_controller\
    import PhoneNumbersController
from whatsappcloudapi.controllers.registration_controller\
    import RegistrationController
from whatsappcloudapi.controllers.two_step_verification_controller\
    import TwoStepVerificationController


class WhatsappcloudapiClient(object):

    @lazy_property
    def business_profiles(self):
        return BusinessProfilesController(self.config, self.auth_managers)

    @lazy_property
    def messages(self):
        return MessagesController(self.config, self.auth_managers)

    @lazy_property
    def media(self):
        return MediaController(self.config, self.auth_managers)

    @lazy_property
    def phone_numbers(self):
        return PhoneNumbersController(self.config, self.auth_managers)

    @lazy_property
    def registration(self):
        return RegistrationController(self.config, self.auth_managers)

    @lazy_property
    def two_step_verification(self):
        return TwoStepVerificationController(self.config, self.auth_managers)

    def __init__(self, http_client_instance=None,
                 override_http_client_configuration=False, http_call_back=None,
                 timeout=60, max_retries=0, backoff_factor=2,
                 retry_statuses=[408, 413, 429, 500, 502, 503, 504, 521, 522, 524],
                 retry_methods=['GET', 'PUT'],
                 environment=Environment.PRODUCTION, version='v13.0',
                 access_token='', config=None):
        if config is None:
            self.config = Configuration(
                                         http_client_instance=http_client_instance,
                                         override_http_client_configuration=override_http_client_configuration,
                                         http_call_back=http_call_back,
                                         timeout=timeout,
                                         max_retries=max_retries,
                                         backoff_factor=backoff_factor,
                                         retry_statuses=retry_statuses,
                                         retry_methods=retry_methods,
                                         environment=environment,
                                         version=version,
                                         access_token=access_token)
        else:
            self.config = config
        self.initialize_auth_managers(self.config)

    def initialize_auth_managers(self, config):
        self.auth_managers = { key: None for key in ['global']}
        self.auth_managers['global'] = OAuth2(config.access_token)
        return self.auth_managers
